/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ProfileView";
    private JLDataView dataViewY;
    private JLDataView dataViewZ;
    private JLChart chartY;
    private JLChart chartZ;
    public static ProfileView view;
    private Composite swtAwtComponentY;
    private Composite swtAwtComponentZ;
    public SampleController controller = SampleController.getController();
    private Frame chartFrameY;
    private Frame chartFrameZ;
    private Display display;
    Logger logger;
    private JApplet chartContainerY;
    private JApplet chartContainerZ;

    public void createPartControl(Composite parent) {
        view = this;
        this.display = parent.getDisplay();
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        this.logger = FableLogger.getLogger(ProfileView.class);
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponentY = new Composite(parent, 0x1040000);
        this.swtAwtComponentY.setLayout((Layout)new GridLayout());
        this.swtAwtComponentY.setLayoutData((Object)new GridData(1808));
        this.chartFrameY = SWT_AWT.new_Frame((Composite)this.swtAwtComponentY);
        this.chartContainerY = new JApplet();
        this.chartFrameY.add(this.chartContainerY);
        this.swtAwtComponentZ = new Composite(parent, 0x1040000);
        this.swtAwtComponentZ.setLayout((Layout)new GridLayout());
        this.swtAwtComponentZ.setLayoutData((Object)new GridData(1808));
        this.chartFrameZ = SWT_AWT.new_Frame((Composite)this.swtAwtComponentZ);
        this.chartContainerZ = new JApplet();
        this.chartFrameZ.add(this.chartContainerZ);
    }

    public void createChart() {
        this.chartY = new JLChart();
        this.chartY.setHeader("Y Profile");
        this.chartY.setHeaderFont(new Font("Dialog", 1, 18));
        this.chartY.getY1Axis().setName("intensity");
        this.chartY.getY1Axis().setAutoScale(true);
        this.chartY.getXAxis().setAutoScale(true);
        this.chartY.getXAxis().setName("pixel");
        this.chartY.getXAxis().setGridVisible(true);
        this.chartY.getXAxis().setSubGridVisible(true);
        this.chartY.getXAxis().setAnnotation(2);
        this.chartY.getY1Axis().setGridVisible(true);
        this.chartY.getY1Axis().setSubGridVisible(true);
        this.chartContainerY.add((Component)this.chartY);
        this.dataViewY = new JLDataView();
        this.dataViewY.setName("intensity");
        this.chartY.getY1Axis().addDataView(this.dataViewY);
        this.chartZ = new JLChart();
        this.chartZ.setHeader("Z Profile");
        this.chartZ.setHeaderFont(new Font("Dialog", 1, 18));
        this.chartZ.getY1Axis().setName("intensity");
        this.chartZ.getY1Axis().setAutoScale(true);
        this.chartZ.getXAxis().setAutoScale(true);
        this.chartZ.getXAxis().setName("pixel");
        this.chartZ.getXAxis().setGridVisible(true);
        this.chartZ.getXAxis().setSubGridVisible(true);
        this.chartZ.getXAxis().setAnnotation(2);
        this.chartZ.getY1Axis().setGridVisible(true);
        this.chartZ.getY1Axis().setSubGridVisible(true);
        this.chartContainerZ.add((Component)this.chartZ);
        this.dataViewZ = new JLDataView();
        this.dataViewZ.setName("intensity");
        this.chartZ.getY1Axis().addDataView(this.dataViewZ);
    }

    public void setData(String title, int[] pixel_y, float[] profile_y, int[] pixel_z, float[] profile_z) {
        double[] y_x = new double[pixel_y.length];
        double[] y_y = new double[pixel_y.length];
        int i = 0;
        while (i < pixel_y.length) {
            y_x[i] = pixel_y[i];
            y_y[i] = profile_y[i];
            ++i;
        }
        this.dataViewY.setData(y_x, y_y);
        this.chartY.setHeader("Y " + title);
        Dimension chartSizeY = this.chartContainerY.getSize();
        this.chartY.setSize(chartSizeY);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfileView.this.chartContainerY.repaint();
            }
        });
        double[] z_x = new double[pixel_z.length];
        double[] z_y = new double[pixel_z.length];
        int i2 = 0;
        while (i2 < pixel_z.length) {
            z_x[i2] = pixel_z[i2];
            z_y[i2] = profile_z[i2];
            ++i2;
        }
        this.dataViewZ.setData(z_x, z_y);
        this.chartZ.setHeader("Z " + title);
        Dimension chartSizeZ = this.chartContainerZ.getSize();
        this.chartZ.setSize(chartSizeZ);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfileView.this.chartContainerZ.repaint();
            }
        });
    }
}

