/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.jep.FableJep;
import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FabioFile;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.PaletteUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.imageviewer.views.ImageView";
    public static ImageView view;
    ImageViewType viewType = ImageViewType.IMAGE_VIEW;
    private SampleController controller = SampleController.getController();
    private Display display;
    private FabioFile fabioFile = null;
    String fileName = "";
    String fileNameSaved = "";
    Canvas imageCanvas;
    Rectangle rect;
    Shell shell;
    Label statusLine;
    ImageData imageData;
    Image image = null;
    float[] imageAsFloat = null;
    float[] savedImageAsFloat = null;
    float[] imageDiffAsFloat = null;
    private boolean imageChanged = true;
    float[] peaks;
    int imageWidth;
    int imageHeight;
    int imageYOrig = 0;
    int imageZOrig = 0;
    GC imageCanvasGC;
    int xCanvas;
    int yCanvas;
    double xScale;
    double yScale;
    int imageTopLeftY = 0;
    int imageTopLeftZ = 0;
    boolean imageTopLeftisOrigin = true;
    ZoomSelection zoomSelection = ZoomSelection.AREA;
    Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    Boolean selectingOn = false;
    Boolean selectOn = false;
    Boolean peaksOn = false;
    Boolean autoscale = true;
    Boolean newSelection = true;
    int linePeakWidth = 3;
    Label autoscaleLabel;
    Button autoscaleButton;
    Button peaksButton;
    Button updateButton;
    Button imageCopyButton;
    Button imageSaveButton;
    Button imageDiffButton;
    Button imageNextButton;
    Button imagePreviousButton;
    Button imageFirstButton;
    Button imageLastButton;
    Button imagePauseButton;
    Button imagePlayButton;
    float minimum;
    float maximum;
    float mean;
    float currentMinimum;
    float currentMaximum;
    Label incrementLabel;
    Label minimumLabel;
    Label maximumLabel;
    Label statusLabel;
    Spinner widthSpinner;
    Text minimumText;
    Text maximumText;
    Text fileNumberText;
    Label selectLabel;
    Label lutLabel;
    Combo flipCombo;
    Combo selectCombo;
    Combo lutCombo;
    PaletteData palette = null;
    PaletteData grayScalePalette;
    PaletteData colorPalette;
    PaletteData rainbow1Palette;
    PaletteData rainbow2Palette;
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;
    boolean listening = true;
    private Logger logger;
    public static int secondaryId;
    protected boolean imageDiffOn = false;
    int xSelectionStart;
    int ySelectionStart;
    NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    boolean jobRunning = false;
    private boolean advancePlay = false;
    private boolean play = false;
    int currentFileIndex = 0;
    int playStep = 1;
    int playWait = 3000;
    Thread playThread = null;
    private int[] lineCoords = new int[5];
    private int[] areaCoords = new int[4];

    static {
        secondaryId = 2;
    }

    public void createPartControl(Composite parent) {
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        });
        this.logger = FableLogger.getLogger(ImageView.class);
        this.logger.setLevel(Level.ERROR);
        this.display = parent.getDisplay();
        this.shell = this.display.getActiveShell();
        view = this;
        this.rect = parent.getClientArea();
        GridLayout parentField = new GridLayout();
        parentField.numColumns = 1;
        parent.setLayout((Layout)parentField);
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.grayScalePalette = PaletteUtils.makeGrayScalePalette();
        this.colorPalette = PaletteUtils.makeColorPalette();
        this.rainbow1Palette = PaletteUtils.makeRainbow1Palette();
        this.rainbow2Palette = PaletteUtils.makeRainbow2Palette();
        this.palette = this.rainbow1Palette;
        GridLayout grid5Cols = new GridLayout();
        grid5Cols.numColumns = 5;
        grid5Cols.makeColumnsEqualWidth = true;
        Composite controlComposite = new Composite(parent, 0);
        controlComposite.setLayout((Layout)grid5Cols);
        controlComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.flipCombo = new Combo(controlComposite, 0);
        this.flipCombo.setItems(new String[]{"br=(0,0)", "tl=(0,0)"});
        this.flipCombo.setLayoutData((Object)new GridData(1808));
        this.flipCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.flipCombo.getSelectionIndex() == 0) {
                    ImageView.this.imageTopLeftY = ImageView.this.imageWidth;
                    ImageView.this.imageTopLeftZ = ImageView.this.imageHeight;
                    ImageView.this.imageTopLeftisOrigin = false;
                    ImageView.this.flipCombo.setToolTipText("bottom right=(0,0)");
                    ImageView.this.displayImage();
                } else {
                    ImageView.this.imageTopLeftY = 0;
                    ImageView.this.imageTopLeftZ = 0;
                    ImageView.this.imageTopLeftisOrigin = true;
                    ImageView.this.flipCombo.setToolTipText("top left=(0,0)");
                    ImageView.this.displayImage();
                }
            }
        });
        this.flipCombo.select(0);
        this.flipCombo.setToolTipText("bottom right=(0,0)");
        this.imageTopLeftisOrigin = false;
        this.lutCombo = new Combo(controlComposite, 0);
        this.lutCombo.setItems(new String[]{"grayscale", "color", "rainbow1", "rainbow2"});
        this.lutCombo.setLayoutData((Object)new GridData(1808));
        this.lutCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.lutCombo.getSelectionIndex() == 0) {
                    ImageView.this.palette = ImageView.this.grayScalePalette;
                    ImageView.this.displayImage();
                } else if (ImageView.this.lutCombo.getSelectionIndex() == 1) {
                    ImageView.this.palette = ImageView.this.colorPalette;
                    ImageView.this.displayImage();
                } else if (ImageView.this.lutCombo.getSelectionIndex() == 2) {
                    ImageView.this.palette = ImageView.this.rainbow1Palette;
                    ImageView.this.displayImage();
                } else {
                    ImageView.this.palette = ImageView.this.rainbow2Palette;
                    ImageView.this.displayImage();
                }
            }
        });
        this.lutCombo.select(2);
        this.lutCombo.setToolTipText("lookup table");
        this.zoomSelection = ZoomSelection.AREA;
        this.peaksButton = new Button(controlComposite, 0x1000020);
        this.peaksButton.setText("Width");
        this.peaksButton.setLayoutData((Object)new GridData(1808));
        this.peaksButton.setToolTipText("display peaks");
        this.peaksButton.setSelection(false);
        this.peaksButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.peaksButton.getSelection()) {
                    ImageView.this.peaksOn = true;
                    ImageView.this.displayImage();
                    ImageView.this.showPeaks();
                } else {
                    ImageView.this.peaksOn = false;
                    ImageView.this.displayImage();
                }
            }
        });
        this.widthSpinner = new Spinner(controlComposite, 0);
        this.widthSpinner.setToolTipText("line width or peak plot radius");
        this.widthSpinner.setLayoutData((Object)new GridData(1808));
        this.widthSpinner.setDigits(0);
        this.widthSpinner.setIncrement(1);
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.setMaximum(256);
        this.widthSpinner.setSelection(3);
        this.widthSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ImageView.this.linePeakWidth = ImageView.this.widthSpinner.getSelection();
                ImageView.this.updateButton.notifyListeners(13, new Event());
            }
        });
        this.autoscaleButton = new Button(controlComposite, 0x1000020);
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setLayoutData((Object)new GridData(1808));
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.autoscaleButton.getSelection()) {
                    ImageView.this.autoscale = true;
                    ImageView.this.updateButton.setEnabled(false);
                    if (!ImageView.this.imageDiffOn && ImageView.this.fabioFile != null) {
                        try {
                            ImageView.this.minimum = ImageView.this.fabioFile.getMinimum();
                            ImageView.this.mean = ImageView.this.fabioFile.getMean();
                            ImageView.this.maximum = ImageView.this.minimum + 2.0f * (ImageView.this.mean - ImageView.this.minimum);
                        }
                        catch (JepException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ImageView.this.minimumText.setEnabled(false);
                    ImageView.this.maximumText.setEnabled(false);
                    ImageView.this.minimumText.setText(Float.toString(ImageView.this.minimum));
                    ImageView.this.maximumText.setText(Float.toString(ImageView.this.maximum));
                    ImageView.this.currentMinimum = ImageView.this.minimum;
                    ImageView.this.currentMaximum = ImageView.this.maximum;
                    ImageView.this.updateButton.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.minimumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.maximumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.displayImage();
                } else {
                    ImageView.this.autoscale = false;
                    ImageView.this.updateButton.setEnabled(true);
                    ImageView.this.minimumText.setEnabled(true);
                    ImageView.this.maximumText.setEnabled(true);
                    try {
                        ImageView.this.currentMinimum = ImageView.this.decimalFormat.parse(ImageView.this.minimumText.getText()).floatValue();
                        ImageView.this.currentMaximum = ImageView.this.decimalFormat.parse(ImageView.this.maximumText.getText()).floatValue();
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    ImageView.this.updateButton.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.minimumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.maximumText.setBackground(ImageView.this.display.getSystemColor(1));
                }
            }
        });
        this.minimumLabel = new Label(controlComposite, 0);
        this.minimumLabel.setText("Minimum");
        this.minimumLabel.setLayoutData((Object)new GridData(1808));
        this.minimumText = new Text(controlComposite, 0);
        this.minimumText.setLayoutData((Object)new GridData(1808));
        this.minimumText.setText("0");
        this.minimumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageView.this.currentMinimum = ImageView.this.decimalFormat.parse(ImageView.this.minimumText.getText()).floatValue();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                ImageView.this.displayImage();
            }
        });
        this.minimumText.setEnabled(false);
        this.maximumLabel = new Label(controlComposite, 0);
        this.maximumLabel.setText("Maximum");
        this.maximumLabel.setLayoutData((Object)new GridData(1808));
        this.maximumText = new Text(controlComposite, 0);
        this.maximumText.setLayoutData((Object)new GridData(1808));
        this.maximumText.setText("0");
        this.maximumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageView.this.currentMaximum = ImageView.this.decimalFormat.parse(ImageView.this.maximumText.getText()).floatValue();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                ImageView.this.displayImage();
            }
        });
        this.maximumText.setEnabled(false);
        this.updateButton = new Button(controlComposite, 8);
        this.updateButton.setText("Update");
        this.updateButton.setToolTipText("update scale and redraw image");
        this.updateButton.setLayoutData((Object)new GridData(1808));
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageView.this.updateButton.setBackground(ImageView.this.display.getSystemColor(1));
                ImageView.this.statusLabel.setText("scale updated");
                ImageView.this.displayImage();
            }
        });
        this.updateButton.setEnabled(false);
        this.updateButton.setForeground(this.display.getSystemColor(1));
        GridLayout grid2Cols = new GridLayout();
        grid2Cols.numColumns = 2;
        Composite canvasComposite = new Composite(parent, 0);
        canvasComposite.setLayout((Layout)grid2Cols);
        canvasComposite.setLayoutData((Object)new GridData(1808));
        this.imageCanvas = new Canvas(canvasComposite, 0);
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xCanvas = bounds.width;
        this.yCanvas = bounds.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageView.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle bounds = ImageView.this.imageCanvas.getBounds();
                event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                if (ImageView.this.image != null) {
                    if (ImageView.this.xCanvas != bounds.width || ImageView.this.yCanvas != bounds.height) {
                        double imageXScale = ImageView.this.xScale;
                        double imageYScale = ImageView.this.yScale;
                        ImageView.this.loadImage(ImageView.this.imageData);
                        ImageView.this.drawImage();
                        ImageView.this.selectedArea.width = (int)Math.round((double)ImageView.this.selectedArea.width * (imageXScale /= ImageView.this.xScale));
                        ImageView.this.selectedArea.height = (int)Math.round((double)ImageView.this.selectedArea.height * (imageYScale /= ImageView.this.yScale));
                        ImageView.this.selectedArea.x = (int)Math.round((double)ImageView.this.selectedArea.x * imageXScale);
                        ImageView.this.selectedArea.y = (int)Math.round((double)ImageView.this.selectedArea.y * imageYScale);
                        ImageView.this.showSelection();
                    } else {
                        GC gc = event.gc;
                        gc.drawImage(ImageView.this.image, 0, 0);
                        ImageView.this.showSelection();
                    }
                    ImageView.this.showPeaks();
                    ImageView.this.xCanvas = bounds.width;
                    ImageView.this.yCanvas = bounds.height;
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageView.this.image != null) {
                    ImageView.this.showPixelAtCursor(event.x, event.y);
                    if (ImageView.this.selectingOn.booleanValue() && ImageView.this.viewType == ImageViewType.IMAGE_VIEW) {
                        int width = event.x - ImageView.this.xSelectionStart;
                        int height = event.y - ImageView.this.ySelectionStart;
                        ImageView.this.imageCanvasGC.setForeground(ImageView.this.display.getSystemColor(1));
                        ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                        if (ImageView.this.zoomSelection == ZoomSelection.AREA || ImageView.this.zoomSelection == ZoomSelection.PROFILE || ImageView.this.zoomSelection == ZoomSelection.RELIEF || ImageView.this.zoomSelection == ZoomSelection.ROCKINGCURVE) {
                            Rectangle selectedRectangle = new Rectangle(ImageView.this.xSelectionStart, ImageView.this.ySelectionStart, width, height);
                            ImageView.this.imageCanvasGC.setLineWidth(1);
                            ImageView.this.imageCanvasGC.drawRectangle(selectedRectangle);
                        } else if (ImageView.this.zoomSelection == ZoomSelection.LINE) {
                            ImageView.this.imageCanvasGC.setLineWidth(ImageView.this.linePeakWidth);
                            ImageView.this.imageCanvasGC.setXORMode(true);
                            ImageView.this.imageCanvasGC.drawLine(ImageView.this.xSelectionStart, ImageView.this.ySelectionStart, event.x, event.y);
                            ImageView.this.imageCanvasGC.setXORMode(false);
                        }
                    }
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                if (ImageView.this.selectingOn.booleanValue()) {
                    ImageView.this.imageCanvas.getBounds();
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ImageView.this.selectingOn.booleanValue()) {
                    ImageView.this.imageCanvas.getBounds();
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.selectingOn = false;
                }
            }

            public void mouseDown(MouseEvent event) {
                if (ImageView.this.image != null) {
                    ImageView.this.selectingOn = true;
                    ImageView.this.xSelectionStart = event.x;
                    ImageView.this.ySelectionStart = event.y;
                }
            }

            public void mouseUp(MouseEvent event) {
                if (ImageView.this.image != null && (ImageView.this.xSelectionStart != event.x || ImageView.this.ySelectionStart != event.y)) {
                    ImageView.this.selectedArea.x = ImageView.this.xSelectionStart;
                    ImageView.this.selectedArea.y = ImageView.this.ySelectionStart;
                    ImageView.this.selectedArea.width = event.x - ImageView.this.selectedArea.x;
                    ImageView.this.selectedArea.height = event.y - ImageView.this.selectedArea.y;
                    ImageView.this.imageCanvasGC.setForeground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.imageChanged = true;
                    ImageView.this.newSelection = true;
                    ImageView.this.showSelection();
                }
                ImageView.this.selectingOn = false;
            }
        });
        this.createDropTarget();
        Composite statusGroup = new Composite(parent, 0);
        GridLayout statusGridLayout = new GridLayout();
        statusGridLayout.numColumns = 8;
        statusGroup.setLayout((Layout)statusGridLayout);
        statusGroup.setLayoutData((Object)new GridData(768));
        this.statusLabel = new Label(statusGroup, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.fileNumberText = new Text(statusGroup, 2048);
        this.fileNumberText.setToolTipText("go to image number");
        this.fileNumberText.setEnabled(true);
        this.fileNumberText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                int size;
                int fileIndex = Integer.parseInt(ImageView.this.fileNumberText.getText());
                if (fileIndex > (size = ImageView.this.controller.getCurrentsample().getFilteredfiles().size())) {
                    fileIndex = size - 1;
                }
                ImageView.this.controller.setCurrentFileIndex(fileIndex);
            }
        });
        this.imageFirstButton = new Button(statusGroup, 8);
        this.imageFirstButton.setText("<<");
        this.imageFirstButton.setToolTipText("go to first image");
        this.imageFirstButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(-1, 300);
                } else {
                    ImageView.this.controller.setCurrentFileIndex(0);
                }
            }
        });
        this.imagePreviousButton = new Button(statusGroup, 8);
        this.imagePreviousButton.setText("<");
        this.imagePreviousButton.setToolTipText("go to previous image");
        this.imagePreviousButton.setEnabled(true);
        this.imagePreviousButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(-1, 3000);
                } else {
                    int fileIndex = ImageView.this.controller.getCurrentFileIndex() - 1;
                    if (fileIndex >= 0) {
                        ImageView.this.controller.setCurrentFileIndex(fileIndex);
                    } else {
                        ImageView.this.controller.setCurrentFileIndex(ImageView.this.controller.getCurrentsample().getFilteredfiles().size() - 1);
                    }
                }
            }
        });
        this.imagePauseButton = new Button(statusGroup, 8);
        this.imagePauseButton.setText("||");
        this.imagePauseButton.setToolTipText("pause");
        this.imagePauseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageView.this.play = false;
            }
        });
        this.imageNextButton = new Button(statusGroup, 8);
        this.imageNextButton.setText(">");
        this.imageNextButton.setToolTipText("go to next image");
        this.imageNextButton.setEnabled(true);
        this.imageNextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(1, 3000);
                } else {
                    int fileIndex = ImageView.this.controller.getCurrentFileIndex() + 1;
                    if (fileIndex >= ImageView.this.controller.getCurrentsample().getFilteredfiles().size()) {
                        fileIndex = 0;
                    }
                    ImageView.this.controller.setCurrentFileIndex(fileIndex);
                }
            }
        });
        this.imageLastButton = new Button(statusGroup, 8);
        this.imageLastButton.setText(">>");
        this.imageLastButton.setToolTipText("go to last image");
        this.imageLastButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(1, 300);
                } else {
                    int lastFileIndex = ImageView.this.controller.getCurrentsample().getFilteredfiles().size();
                    ImageView.this.controller.setCurrentFileIndex(lastFileIndex - 1);
                }
            }
        });
        this.imagePlayButton = new Button(statusGroup, 32);
        this.imagePlayButton.setText("");
        this.imagePlayButton.setToolTipText("play");
        this.imagePlayButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.imagePlayButton.getSelection()) {
                    ImageView.this.advancePlay = true;
                } else {
                    ImageView.this.advancePlay = false;
                    ImageView.this.play = false;
                }
            }
        });
    }

    public void selectZoom(ZoomSelection zoomselect) {
        this.zoomSelection = zoomselect;
        this.selectingOn = false;
        this.selectOn = false;
    }

    public void setViewType(ImageViewType viewtype) {
        this.viewType = viewtype;
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String text;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data).startsWith("samplefile")) {
                    ImageView.this.fabioFile = null;
                    FabioFile _fabioFile = ImageView.this.controller.getCurrentFile();
                    ImageView.this.loadFile(_fabioFile);
                    ImageView.this.displayImage();
                    ImageView.this.fileNumberText.setText(Integer.toString(ImageView.this.controller.getCurrentFileIndex()));
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public void showSelection() {
        if (this.viewType != ImageViewType.IMAGE_ZOOM && (this.selectingOn.booleanValue() || this.selectOn.booleanValue())) {
            if (this.zoomSelection == ZoomSelection.AREA || this.zoomSelection == ZoomSelection.RELIEF || this.zoomSelection == ZoomSelection.ROCKINGCURVE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                if (this.imageChanged) {
                    this.showSelectedArea();
                }
                this.selectOn = true;
            } else if (this.zoomSelection == ZoomSelection.LINE) {
                this.imageCanvasGC.setXORMode(true);
                this.imageCanvasGC.setLineWidth(this.linePeakWidth);
                this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.setXORMode(false);
                if (this.imageChanged) {
                    this.showSelectedLine();
                }
                this.selectOn = true;
            } else if (this.zoomSelection == ZoomSelection.PROFILE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                if (this.imageChanged) {
                    this.showProfile();
                }
                this.selectOn = true;
            }
            this.newSelection = false;
        }
    }

    public void showPeaks() {
        if (this.peaks != null) {
            this.imageCanvasGC.setForeground(this.display.getSystemColor(3));
            int i = 0;
            while (i < this.peaks.length / 2) {
                int z;
                int y;
                if (!this.imageTopLeftisOrigin) {
                    y = (int)((double)((float)this.imageTopLeftY - this.peaks[i * 2] - (float)this.imageYOrig) / this.xScale);
                    z = (int)((double)((float)this.imageTopLeftZ - this.peaks[i * 2 + 1] - (float)this.imageZOrig) / this.yScale);
                } else {
                    y = (int)((double)(this.peaks[i * 2] - (float)this.imageYOrig) / this.xScale);
                    z = (int)((double)(this.peaks[i * 2 + 1] - (float)this.imageZOrig) / this.yScale);
                }
                Rectangle rect = new Rectangle(y -= this.linePeakWidth / 2, z -= this.linePeakWidth / 2, this.linePeakWidth, this.linePeakWidth);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    void showPixelAtCursor(int my, int mz) {
        int z;
        int y;
        if (!this.imageTopLeftisOrigin) {
            y = this.imageTopLeftY - (int)((double)(my - this.imageData.x) * this.xScale);
            z = this.imageTopLeftZ - (int)((double)(mz - this.imageData.y) * this.yScale);
        } else {
            y = (int)((double)(my - this.imageData.x) * this.xScale);
            z = (int)((double)(mz - this.imageData.y) * this.yScale);
        }
        if (y >= 0 && y < this.imageWidth && z >= 0 && z < this.imageHeight) {
            float pixel = 0.0f;
            if (!this.imageDiffOn) {
                if (this.imageAsFloat != null) {
                    pixel = this.imageAsFloat[z * this.imageWidth + y];
                }
            } else if (this.imageDiffAsFloat != null) {
                pixel = this.imageDiffAsFloat[z * this.imageWidth + y];
            }
            this.statusLabel.setText("y = " + (y += this.imageYOrig) + " , z = " + (z += this.imageZOrig) + " , value = " + pixel);
        }
    }

    void showSelectedArea() {
        int temp;
        int z2;
        int y2;
        int z1;
        int y1;
        if (!this.imageTopLeftisOrigin) {
            y1 = this.imageTopLeftY - (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = this.imageTopLeftY - (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        } else {
            y1 = (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        }
        this.areaCoords[0] = y1;
        this.areaCoords[1] = z1;
        this.areaCoords[2] = y2;
        this.areaCoords[3] = z2;
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 > z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.imageWidth) {
            y1 = this.imageWidth - 1;
        }
        if (y2 <= y1) {
            y2 = y1 + 1;
        }
        if (y2 >= this.imageWidth) {
            y2 = this.imageWidth - 1;
        }
        if (z1 < 0) {
            z1 = 0;
        }
        if (z1 >= this.imageHeight) {
            z1 = this.imageHeight - 1;
        }
        if (z2 <= z1) {
            z2 = z1 + 1;
        }
        if (z2 >= this.imageHeight) {
            z2 = this.imageHeight - 1;
        }
        try {
            int zoomWidth = y2 - y1;
            int zoomHeight = z2 - z1;
            float[] zoomAreaAsFloat = new float[zoomWidth * zoomHeight];
            float areaMinimum = Float.MAX_VALUE;
            float areaMaximum = Float.MIN_VALUE;
            float areaMean = 0.0f;
            float areaSum = 0.0f;
            int i = 0;
            while (i < zoomWidth) {
                int j = 0;
                while (j < zoomHeight) {
                    zoomAreaAsFloat[i + j * zoomWidth] = !this.imageDiffOn ? this.imageAsFloat[y1 + i + (z1 + j) * this.imageWidth] : this.imageDiffAsFloat[y1 + i + (z1 + j) * this.imageWidth];
                    if (zoomAreaAsFloat[i + j * zoomWidth] < areaMinimum) {
                        areaMinimum = zoomAreaAsFloat[i + j * zoomWidth];
                    }
                    if (zoomAreaAsFloat[i + j * zoomWidth] > areaMaximum) {
                        areaMaximum = zoomAreaAsFloat[i + j * zoomWidth];
                    }
                    areaSum += zoomAreaAsFloat[i + j * zoomWidth];
                    ++j;
                }
                areaMean = areaSum / (float)(zoomWidth * zoomHeight);
                ++i;
            }
            if (this.zoomSelection == ZoomSelection.AREA) {
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID, "100", 1);
                }
                this.zoomAreaView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(ID, "100").getView(true);
                this.zoomAreaView.setImageAsFloat(zoomAreaAsFloat, zoomWidth, zoomHeight, areaMinimum, areaMaximum, areaMean, y1 + this.imageYOrig, z1 + this.imageZOrig, this.fileName);
                this.zoomAreaView.setPartName("Zoom area " + this.fileName);
                this.zoomAreaView.stopListening();
                this.zoomAreaView.setViewType(ImageViewType.IMAGE_ZOOM);
            } else if (this.zoomSelection == ZoomSelection.RELIEF) {
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ReliefView", "0", 1);
                }
                this.zoomReliefView = (ReliefView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ReliefView", "0").getView(true);
                if (this.zoomReliefView != null) {
                    this.zoomReliefView.setImageAsFloat(zoomAreaAsFloat, zoomWidth, zoomHeight, areaMinimum, areaMaximum, areaMean, this.fileName);
                }
            } else if (this.zoomSelection == ZoomSelection.ROCKINGCURVE) {
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.RockingCurveView", "0", 1);
                }
                this.zoomRockingCurveView = (RockingCurveView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.RockingCurveView", "0").getView(true);
                if (this.zoomRockingCurveView != null) {
                    this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.fileName, SampleController.getController().getCurrentFileIndex(), y1, z1, y2, z2);
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void showSelectedLine() {
        int temp;
        int z2;
        int y2;
        int z1;
        int y1;
        if (!this.imageTopLeftisOrigin) {
            y1 = this.imageTopLeftY - (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = this.imageTopLeftY - (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        } else {
            y1 = (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        }
        this.lineCoords[0] = y1;
        this.lineCoords[1] = z1;
        this.lineCoords[2] = y2;
        this.lineCoords[3] = z2;
        if (Math.abs(y2 - y1) > Math.abs(z2 - z1)) {
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                temp = z1;
                z1 = z2;
                z2 = temp;
            }
        } else if (z1 > z2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y1 >= this.imageWidth) {
            y1 = this.imageWidth - 1;
        }
        if (y2 >= this.imageWidth) {
            y2 = this.imageWidth - 1;
        }
        if (z1 < 0) {
            z1 = 0;
        }
        if (z2 < 0) {
            z2 = 0;
        }
        if (z1 >= this.imageHeight) {
            z1 = this.imageHeight - 1;
        }
        if (z2 >= this.imageHeight) {
            z2 = this.imageHeight - 1;
        }
        try {
            float[] intensity;
            int[] pixels;
            String yTitle;
            String xTitle;
            float slope = 0.0f;
            if (y2 - y1 > z2 - z1) {
                this.lineCoords[4] = (int)((double)this.linePeakWidth * this.yScale);
                xTitle = "Pixels in Y";
                yTitle = "Intensity in Z";
                pixels = new int[y2 - y1];
                intensity = new float[y2 - y1];
                if (y2 - y1 != 0) {
                    slope = (float)(z2 - z1) / (float)(y2 - y1);
                }
                int i = 0;
                while (i < y2 - y1) {
                    int jMax;
                    pixels[i] = y1 + i;
                    int y = (int)((float)z1 + slope * (float)i);
                    int x = y1 + i;
                    int jMin = y - (int)((double)this.linePeakWidth * this.yScale / 2.0);
                    if (jMin < 0) {
                        jMin = 0;
                    }
                    if ((jMax = y + (int)((double)this.linePeakWidth * this.yScale / 2.0) + 1) > this.imageHeight) {
                        jMax = this.imageHeight;
                    }
                    float jWidth = jMax - jMin;
                    intensity[i] = 0.0f;
                    int j = jMin;
                    while (j < jMax) {
                        if (!this.imageDiffOn) {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageAsFloat[x + j * this.imageWidth];
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageDiffAsFloat[x + j * this.imageWidth];
                        }
                        ++j;
                    }
                    intensity[i] = intensity[i] / (jWidth + 1.0f);
                    ++i;
                }
            } else {
                this.lineCoords[4] = (int)((double)this.linePeakWidth * this.xScale);
                xTitle = "Pixels in Z";
                yTitle = "Intensity in Y";
                pixels = new int[z2 - z1];
                intensity = new float[z2 - z1];
                if (z2 - z1 != 0) {
                    slope = (float)(y2 - y1) / (float)(z2 - z1);
                }
                int i = 0;
                while (i < z2 - z1) {
                    int jMax;
                    pixels[i] = z1 + i;
                    int y = (int)((float)y1 + slope * (float)i);
                    int x = z1 + i;
                    int jMin = y - (int)((double)this.linePeakWidth * this.xScale / 2.0);
                    if (jMin < 0) {
                        jMin = 0;
                    }
                    if ((jMax = y + (int)((double)this.linePeakWidth * this.xScale / 2.0) + 1) > this.imageWidth) {
                        jMax = this.imageWidth;
                    }
                    float jWidth = jMax - jMin;
                    intensity[i] = 0.0f;
                    int j = jMin;
                    while (j < jMax) {
                        if (!this.imageDiffOn) {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageAsFloat[j + x * this.imageWidth];
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageDiffAsFloat[j + x * this.imageWidth];
                        }
                        ++j;
                    }
                    intensity[i] = intensity[i] / (jWidth + 1.0f);
                    ++i;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", "0", 1);
            }
            this.lineView = (LineView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView", "0").getView(true);
            if (this.lineView != null) {
                this.lineView.setData(this.fileName, xTitle, pixels, yTitle, intensity);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void showProfile() {
        int temp;
        int z2;
        int y2;
        int z1;
        int y1;
        if (!this.imageTopLeftisOrigin) {
            y1 = this.imageTopLeftY - (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = this.imageTopLeftY - (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = this.imageTopLeftZ - (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        } else {
            y1 = (int)((double)(this.selectedArea.x - this.imageData.x) * this.xScale);
            z1 = (int)((double)(this.selectedArea.y - this.imageData.y) * this.yScale);
            y2 = (int)((double)(this.selectedArea.x + this.selectedArea.width - this.imageData.x) * this.xScale);
            z2 = (int)((double)(this.selectedArea.y + this.selectedArea.height - this.imageData.y) * this.yScale);
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 > z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.imageWidth) {
            y1 = this.imageWidth - 1;
        }
        if (y2 <= y1) {
            y2 = y1 + 1;
        }
        if (y2 >= this.imageWidth) {
            y2 = this.imageWidth - 1;
        }
        if (z1 < 0) {
            z1 = 0;
        }
        if (z1 >= this.imageHeight) {
            z1 = this.imageHeight - 1;
        }
        if (z2 < 0) {
            z2 = 0;
        }
        if (z2 >= this.imageHeight) {
            z2 = this.imageHeight - 1;
        }
        try {
            int j;
            int[] pixels_y = new int[y2 - y1];
            float[] intensity_y = new float[y2 - y1];
            int i = 0;
            while (i < y2 - y1) {
                int x;
                pixels_y[i] = x = y1 + i;
                intensity_y[i] = 0.0f;
                j = z1;
                while (j < z2) {
                    if (!this.imageDiffOn) {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.imageAsFloat[x + j * this.imageWidth];
                    } else {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.imageDiffAsFloat[x + j * this.imageWidth];
                    }
                    ++j;
                }
                ++i;
            }
            int[] pixels_z = new int[z2 - z1];
            float[] intensity_z = new float[z2 - z1];
            i = 0;
            while (i < z2 - z1) {
                int y;
                pixels_z[i] = y = z1 + i;
                intensity_z[i] = 0.0f;
                j = y1;
                while (j < y2) {
                    if (!this.imageDiffOn) {
                        int n = i;
                        intensity_z[n] = intensity_z[n] + this.imageAsFloat[j + y * this.imageWidth];
                    } else {
                        int n = i;
                        intensity_z[n] = intensity_z[n] + this.imageDiffAsFloat[j + y * this.imageWidth];
                    }
                    ++j;
                }
                ++i;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", "0", 1);
            }
            this.profileView = (ProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView", "0").getView(true);
            this.profileView.setData(this.fileName, pixels_y, intensity_y, pixels_z, intensity_z);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void setImageAsFloat(float[] areaAsFloat, int width, int height, float _minimum, float _maximum, float _mean, int yorig, int zorig, String _fileName) {
        this.imageAsFloat = areaAsFloat;
        this.imageChanged = true;
        if (this.imageWidth != width || this.imageHeight != height) {
            Rectangle bounds = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        this.imageWidth = width;
        this.imageHeight = height;
        this.minimum = _minimum;
        this.maximum = _maximum;
        this.mean = _mean;
        this.maximum = _mean + 2.0f * (_mean - this.minimum);
        if (this.maximum - this.minimum < 0.01f) {
            this.maximum = this.minimum + 0.01f;
        }
        this.imageYOrig = yorig;
        this.imageZOrig = zorig;
        this.fileName = _fileName;
        this.displayImage();
    }

    public void stopListening() {
        if (this.listening) {
            this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void loadFile(FabioFile _fabioFile) {
        if (_fabioFile != this.fabioFile) {
            this.peaks = null;
            this.fabioFile = _fabioFile;
            this.fileName = this.fabioFile.getFileName();
            this.statusLabel.setText("loading file " + this.fabioFile.getFileName() + " ... ");
            try {
                this.imageAsFloat = this.fabioFile.getImageAsFloat();
                this.imageChanged = true;
                if (this.imageWidth != this.fabioFile.getWidth() || this.imageHeight != this.fabioFile.getHeight()) {
                    Rectangle bounds = this.imageCanvas.getBounds();
                    this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
                }
                this.imageWidth = this.fabioFile.getWidth();
                this.imageHeight = this.fabioFile.getHeight();
                this.minimum = this.fabioFile.getMinimum();
                this.maximum = this.fabioFile.getMaximum();
                this.mean = this.fabioFile.getMean();
                this.maximum = this.minimum + 2.0f * (this.mean - this.minimum);
                if (this.maximum - this.minimum < 0.01f) {
                    this.maximum = this.minimum + 0.01f;
                }
                this.updateStatusLabel("loading file " + this.fabioFile.getFileName() + " ... took " + this.fabioFile.getTimeToReadImage() + " ms");
                if (this.imageDiffOn) {
                    long start = System.currentTimeMillis();
                    if (this.imageDiffAsFloat == null) {
                        this.imageDiffAsFloat = new float[this.imageAsFloat.length];
                    } else if (this.imageDiffAsFloat.length != this.imageAsFloat.length) {
                        this.imageDiffAsFloat = new float[this.imageAsFloat.length];
                    }
                    this.minimum = Float.MAX_VALUE;
                    this.maximum = Float.MIN_VALUE;
                    float sum = 0.0f;
                    int i = 0;
                    while (i < this.imageAsFloat.length) {
                        this.imageDiffAsFloat[i] = this.imageAsFloat[i] - this.savedImageAsFloat[i];
                        if (this.imageDiffAsFloat[i] < this.minimum) {
                            this.minimum = this.imageDiffAsFloat[i];
                        } else if (this.imageDiffAsFloat[i] > this.maximum) {
                            this.maximum = this.imageDiffAsFloat[i];
                        }
                        sum += this.imageDiffAsFloat[i];
                        ++i;
                    }
                    this.maximum = this.mean = sum / (float)this.imageDiffAsFloat.length;
                    if (this.minimum == this.maximum) {
                        this.maximum = this.minimum + 1.0f;
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    this.updateStatusLabel(String.valueOf(this.fileName) + " - minus - " + this.fileNameSaved + " took " + elapsed + " ms");
                    this.setPartName("Difference " + this.fabioFile.getFileName());
                } else {
                    this.setPartName("Image " + this.fabioFile.getFileName());
                }
            }
            catch (JepException e) {
                e.printStackTrace();
            }
        }
    }

    void updateStatusLabel(String _status) {
        final String status = _status;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageView.this.statusLabel.setText(status);
            }
        });
    }

    public void setPeaks(float[] _peaks) {
        this.peaks = _peaks;
    }

    public void displayImage() {
        if (this.imageAsFloat != null) {
            if (this.autoscale.booleanValue()) {
                this.currentMinimum = this.minimum;
                this.currentMaximum = this.maximum;
                this.minimumText.setText(Float.toString(this.minimum));
                this.maximumText.setText(Float.toString(this.maximum));
            } else {
                try {
                    this.currentMinimum = this.decimalFormat.parse(this.minimumText.getText()).floatValue();
                    this.currentMaximum = this.decimalFormat.parse(this.maximumText.getText()).floatValue();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.updateButton.setBackground(this.display.getSystemColor(1));
            this.updateButton.setForeground(this.display.getSystemColor(2));
            if (this.currentMinimum - this.currentMaximum == 0.0f) {
                this.currentMinimum = this.currentMaximum + 0.01f;
            } else {
                if (!this.imageTopLeftisOrigin) {
                    this.imageTopLeftY = this.imageWidth;
                    this.imageTopLeftZ = this.imageHeight;
                } else {
                    this.imageTopLeftY = 0;
                    this.imageTopLeftZ = 0;
                }
                if (!this.imageDiffOn || this.imageDiffAsFloat == null) {
                    byte[] scaledImageAsByte = this.scaleImageAsByte(this.imageAsFloat, this.currentMinimum, this.currentMaximum);
                    this.imageData = new ImageData(this.imageWidth, this.imageHeight, 8, this.palette, 1, scaledImageAsByte);
                } else {
                    byte[] scaledImageAsByte = this.scaleImageAsByte(this.imageDiffAsFloat, this.currentMinimum, this.currentMaximum);
                    this.imageData = new ImageData(this.imageWidth, this.imageHeight, 8, this.palette, 1, scaledImageAsByte);
                }
                this.loadImage(this.imageData);
                this.drawImage();
            }
            if (this.selectOn.booleanValue()) {
                this.showSelection();
            }
            if (this.peaksOn.booleanValue()) {
                this.showPeaks();
            }
            this.imageChanged = false;
        }
    }

    public Image loadImage(ImageData data) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xScale = (double)this.imageWidth / (double)bounds.width;
        this.yScale = (double)this.imageHeight / (double)bounds.height;
        if (this.xScale > this.yScale) {
            this.yScale = this.xScale;
        } else {
            this.xScale = this.yScale;
        }
        if ((double)this.imageWidth / this.xScale < 1.0) {
            this.xScale = (double)this.imageWidth / (double)bounds.width;
        }
        if ((double)this.imageHeight / this.yScale < 1.0) {
            this.yScale = (double)this.imageHeight / (double)bounds.height;
        }
        int xscaledTo = (int)((double)this.imageWidth / this.xScale);
        int yscaledTo = (int)((double)this.imageHeight / this.yScale);
        this.image = new Image((Device)this.display, data.scaledTo(xscaledTo, yscaledTo));
        return this.image;
    }

    public void setFocus() {
    }

    void drawImage() {
        this.imageCanvasGC.drawImage(this.image, 0, 0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getProperty().equals("CurrentFile")) {
            Object val = evt.getNewValue();
            final Vector fabioFiles = this.controller.getCurrentsample().getFilteredfiles();
            int index = fabioFiles.indexOf(val);
            if (index >= 0 && index < fabioFiles.size() && !this.jobRunning) {
                final int fileReadFrom = index - 3;
                final int fileReadTo = index + 3;
                this.jobRunning = true;
                Job job = new Job("Read files ahead "){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Read files ahead", 7);
                        try {
                            FableJep fableJep = new FableJep();
                            int i = fileReadFrom;
                            while (i <= fileReadTo) {
                                if (i >= 0 && i < fabioFiles.size()) {
                                    ((FabioFile)fabioFiles.get(i)).readImageAsFloat(fableJep);
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            fableJep.getJep().close();
                        }
                        catch (JepException e1) {
                            e1.printStackTrace();
                        }
                        monitor.done();
                        ImageView.this.jobRunning = false;
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            FabioFile _fabioFile = (FabioFile)val;
            this.loadFile(_fabioFile);
            this.displayImage();
            this.fileNumberText.setText(Integer.toString(this.controller.getCurrentFileIndex()));
        }
    }

    public void dispose() {
        this.imageCanvas.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public byte[] scaleImageAsByte(float[] _imageAsFloat, float _minimum, float _maximum) {
        float scale_8bit = 255.0f / (_maximum - _minimum);
        byte[] scaledImageAsByte = new byte[this.imageAsFloat.length];
        float maxPixel = _maximum - _minimum;
        int i = 0;
        while (i < _imageAsFloat.length) {
            float scaled_pixel = _imageAsFloat[i] < _minimum ? 0.0f : (_imageAsFloat[i] > _maximum ? maxPixel : _imageAsFloat[i] - _minimum);
            scaled_pixel *= scale_8bit;
            if (this.imageTopLeftisOrigin) {
                scaledImageAsByte[i] = (byte)(0xFF & (int)scaled_pixel);
            } else {
                scaledImageAsByte[_imageAsFloat.length - i - 1] = (byte)(0xFF & (int)scaled_pixel);
            }
            ++i;
        }
        return scaledImageAsByte;
    }

    public void colorPeaks(float[] peakToColor) {
        this.showPeaks();
        if (peakToColor != null) {
            this.imageCanvasGC.setForeground(this.display.getSystemColor(5));
            int i = 0;
            while (i < peakToColor.length / 2) {
                int z;
                int y;
                if (!this.imageTopLeftisOrigin) {
                    y = (int)((double)((float)this.imageTopLeftY - peakToColor[i * 2] - (float)this.imageYOrig) / this.xScale);
                    z = (int)((double)((float)this.imageTopLeftZ - peakToColor[i * 2 + 1] - (float)this.imageZOrig) / this.yScale);
                } else {
                    y = (int)((double)(peakToColor[i * 2] - (float)this.imageYOrig) / this.xScale);
                    z = (int)((double)(peakToColor[i * 2 + 1] - (float)this.imageZOrig) / this.yScale);
                }
                Rectangle rect = new Rectangle(y -= this.linePeakWidth / 2, z -= this.linePeakWidth / 2, this.linePeakWidth, this.linePeakWidth);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    public void initWithShowPeaks() {
        this.peaksButton.setSelection(true);
        this.peaksButton.notifyListeners(13, new Event());
    }

    public void startPlay(int step, int wait) {
        this.play = true;
        this.playStep = step;
        this.playWait = wait;
        if (this.playThread == null) {
            this.playThread = this.PlayThread();
            this.playThread.start();
        }
    }

    public Thread PlayThread() {
        return new Thread(){

            @Override
            public void run() {
                ImageView.this.currentFileIndex = ImageView.this.controller.getCurrentFileIndex();
                while (ImageView.this.play) {
                    try {
                        ImageView.this.currentFileIndex += ImageView.this.playStep;
                        if (ImageView.this.currentFileIndex >= ImageView.this.controller.getCurrentsample().getFilteredfiles().size()) {
                            ImageView.this.currentFileIndex = 0;
                        } else if (ImageView.this.currentFileIndex < 0) {
                            ImageView.this.currentFileIndex = ImageView.this.controller.getCurrentsample().getFilteredfiles().size() - 1;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ImageView.this.controller.setCurrentFileIndex((this).ImageView.this.currentFileIndex);
                            }
                        });
                        Thread.sleep(ImageView.this.playWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ImageView.this.playThread = null;
            }
        };
    }

    public void setName(String string) {
        this.setPartName(string);
    }

    public void initPalette(int index) {
        this.lutCombo.select(index);
        switch (index) {
            case 0: {
                this.palette = this.grayScalePalette;
                break;
            }
            case 1: {
                this.palette = this.colorPalette;
                break;
            }
            case 2: {
                this.palette = this.rainbow1Palette;
                break;
            }
            case 3: {
                this.palette = this.rainbow2Palette;
                break;
            }
            default: {
                this.palette = this.rainbow1Palette;
            }
        }
    }
}

