/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenFileAction
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.imageviewer.actions.OpenFileAction";
    private String initialDirData = "";

    public void run(IAction action) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell(), 2);
            this.initialDirData = SampleNavigatorView.getInitialDirectory();
            dlg.setFilterPath(this.initialDirData);
            String selectedDirectory = dlg.open();
            int index = selectedDirectory.lastIndexOf(System.getProperty("file.separator"));
            if (index > 0) {
                selectedDirectory = selectedDirectory.substring(0, index);
            }
            String[] files = dlg.getFileNames();
            if (selectedDirectory != null && files != null) {
                try {
                    activeWindow.getWorkbench().showPerspective("fable.imageviewer.perspective", activeWindow);
                    SampleNavigatorView sampleView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
                    sampleView.addFiles(files, selectedDirectory);
                }
                catch (WorkbenchException workbenchException) {
                    MessageDialog.openError((Shell)activeWindow.getShell(), (String)"ImageViewer", (String)"ImageViewer cannot be opened");
                }
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

