/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.ControlField;
import fable.framework.toolbox.TypedText;
import org.eclipse.swt.widgets.Composite;

public class IntegerText
extends TypedText {
    protected Integer _fieldValue;
    protected Integer _MinValue;
    protected Integer _MaxValue;
    protected boolean _bMaxIsIncluded = false;
    protected boolean _bMinIsIncluded = false;

    public IntegerText(Composite parent, int style) {
        super(parent, style);
    }

    public IntegerText(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    public IntegerText(Composite parent, int style, String LabelText, int minValue, int maxValue) {
        this(parent, style, LabelText);
        this.setMinValue(minValue, true);
        this.setMaxValue(maxValue, true);
    }

    public void setMaxValue(int maxValue, boolean bIsInclude) {
        this._bMaxIsIncluded = bIsInclude;
        this._MaxValue = new Integer(maxValue);
    }

    public void setMinValue(int minValue, boolean bIsInclude) {
        this._bMinIsIncluded = bIsInclude;
        this._MinValue = new Integer(minValue);
    }

    @Override
    protected boolean checkValue(String str) {
        boolean bok = true;
        if (str != null && !str.equals("")) {
            this._errorMessage = "Field should contain an integer value ";
            bok = ControlField.isInteger(str);
            if (bok) {
                this._fieldValue = Integer.valueOf(str);
                if (this._MaxValue != null && this._MinValue != null) {
                    if (this._bMinIsIncluded && this._bMaxIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + "between " + this._MinValue + " and " + this._MaxValue;
                    } else if (!this._bMinIsIncluded && this._bMaxIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue + " and less or equal to " + this._MaxValue;
                    } else if (this._bMinIsIncluded && !this._bMaxIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this._MinValue + " and less than " + this._MaxValue;
                    } else if (!this._bMinIsIncluded && !this._bMaxIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0 && Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue + " and less than " + this._MaxValue;
                    }
                } else if (this._MinValue != null && this._MaxValue == null) {
                    if (this._bMinIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) >= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this._MinValue;
                    } else {
                        bok = Float.compare(this._fieldValue.intValue(), this._MinValue.floatValue()) > 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this._MinValue;
                    }
                } else if (this._MinValue == null && this._MaxValue != null) {
                    if (this._bMaxIsIncluded) {
                        bok = Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " and less or equal to " + this._MaxValue;
                    } else {
                        bok = Float.compare(this._fieldValue.intValue(), this._MaxValue.floatValue()) < 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " less than " + this._MaxValue;
                    }
                }
            }
        } else if (this._isRequiredField) {
            bok = false;
        }
        return bok;
    }

    @Override
    protected String getErrorFormatDescription() {
        return this._errorMessage;
    }
}

