/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import jep.JepException;
import org.junit.Assert;
import org.junit.Test;

public class CompressFile {
    public static void compress(String entryfile, String outputFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(outputFile);
        GZIPOutputStream zout = new GZIPOutputStream(fout);
        FileInputStream fin = new FileInputStream(entryfile);
        try {
            System.out.println("Compressing " + entryfile);
            int c = fin.read();
            while (c != -1) {
                zout.write(c);
                c = fin.read();
            }
        }
        finally {
            fin.close();
        }
        zout.close();
    }

    @Test
    public void testcompressFile() {
        try {
            CompressFile.compress("d:\\My Documents\\ANTC_quench_2_\\ANTC_quench_2_3537.cor", "d:\\\\My Documents\\\\ANTC_quench_2_\\\\ANTC_quench_2_3537.cor.gzip");
        }
        catch (IOException e) {
            Assert.fail((String)("An error occured while testing java zip compression : " + e.getMessage()));
        }
    }

    @Test
    public void testReadCompressedFile() {
        try {
            FabioFile f = new FabioFile("d:\\\\My Documents\\\\ANTC_quench_2_\\\\ANTC_quench_2_3537.edf");
            System.out.println("Try to read");
            f.readImage();
            System.out.println("end reading");
        }
        catch (FabioFileException e) {
            Assert.fail((String)"Fabio is unable to load this file");
            Assert.fail((String)e.getMessage());
        }
        catch (JepException e) {
            Assert.fail((String)"Fabio is unable to read this file");
            Assert.fail((String)e.getMessage());
        }
    }
}

