/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.view.Grains3DView;
import fable.grainspotter.view.OutputView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class GrainSpotter {
    private GrainspotterIniInput input;
    private String grainspotterCommand = "GrainSpotter";
    private String grainspotterPath = ".";
    private GrainSpotterThread grainspotterThread;
    private Process grainspotterProcess;
    public static ReadGveThread readgveThread;
    public static ArrayList<double[]> gveXYZ;
    private static GrainSpotter grainspotter;
    public ArrayList<int[]> grainGvectors = new ArrayList();
    private Runtime runtime;
    private String pathSeparator = System.getProperty("file.separator");
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    protected IProgressMonitor grainspotterMonitor;
    private String gvectorFile;

    static {
        gveXYZ = new ArrayList();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    private GrainSpotter() {
        this.grainspotterThread = new GrainSpotterThread();
        readgveThread = new ReadGveThread();
    }

    public void run() {
        this.fireStateChange("running");
        new Thread(readgveThread).start();
        Job job = new Job("Running GrainSpotter " + this.input.getInputFile().iniFileName){

            protected IStatus run(IProgressMonitor monitor) {
                GrainSpotter.this.grainspotterMonitor = monitor;
                GrainSpotter.this.grainspotterMonitor.beginTask("Running GrainSpotter " + ((GrainSpotter)GrainSpotter.this).input.getInputFile().iniFileName + " ... ", 100);
                GrainSpotter.this.grainspotterMonitor.subTask("Building lookuptables");
                GrainSpotter.this.grainspotterMonitor.worked(1);
                GrainSpotter.this.grainspotterThread.run();
                GrainSpotter.this.grainspotterMonitor.done();
                GrainSpotter.this.fireStateChange("running");
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void stop() {
        this.fireStateChange("stopped");
        this.grainspotterProcess.destroy();
        final Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activeWindow.getShell().setCursor(arrowCursor);
                }
            });
        }
    }

    public void fireStateChange(String _change) {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "grainspotter", null, (Object)_change));
        }
    }

    public boolean gsCommandCanRun() {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(this.grainspotterCommand);
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to execute the GrainSpotter command = " + this.grainspotterCommand + " !");
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (execute) permissions");
            return false;
        }
        return true;
    }

    public String[] makeGSBatchCommand() {
        String[] gsRunCommand = new String[3];
        String os = System.getProperty("os.name");
        File gsCommandFile = new File(this.grainspotterCommand);
        if (!gsCommandFile.exists()) {
            FableMessageConsole.console.displayError("The GrainSpotter command = " + this.grainspotterCommand + ", does not exist !");
            FableMessageConsole.console.displayError("Check the path is correct and the command exists (hint: use Edit -> Preferences to select the grainspotter command");
            return null;
        }
        try {
            if (os.toLowerCase().contains("windows")) {
                BufferedWriter gsBatch = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat"));
                if (this.input.getInputFile().iniFilePath.length() >= 2) {
                    gsBatch.write(this.input.getInputFile().iniFilePath.substring(0, 2));
                }
                gsBatch.newLine();
                gsBatch.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                gsBatch.newLine();
                gsBatch.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName);
                gsBatch.close();
                gsRunCommand[0] = "cmd.exe";
                gsRunCommand[1] = "/C";
                gsRunCommand[2] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat";
            } else {
                BufferedWriter gsBatch = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash"));
                gsBatch.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                gsBatch.newLine();
                gsBatch.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName + ".tmp");
                gsBatch.newLine();
                gsBatch.write("rm " + this.input.getInputFile().iniFileName + ".tmp");
                gsBatch.close();
                gsRunCommand[0] = "/bin/bash";
                gsRunCommand[1] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash";
                gsRunCommand[2] = " ";
            }
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to create grainspotter batch file in directory : " + this.input.getInputFile().iniFilePath);
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (write) permissions");
            return null;
        }
        return gsRunCommand;
    }

    public String getGrainspotterCommand() {
        return this.grainspotterCommand;
    }

    public void setGrainspotterCommand(String grainspotterCommand) {
        this.grainspotterCommand = grainspotterCommand;
    }

    public void setgVectorFile(String fileName) {
        this.gvectorFile = fileName;
    }

    public double[] getGrainGveXYZ(int grain) {
        if (gveXYZ.size() == 0 && FableMessageConsole.console != null) {
            FableMessageConsole.console.displayError("Error no g-vectors found, please load a gve file or run grainspotter");
        }
        int[] gVectorIds = this.grainGvectors.get(grain);
        double[] xyzs = new double[gVectorIds.length * 3];
        int _i = 0;
        while (_i < gVectorIds.length) {
            double[] xyz = gveXYZ.get(gVectorIds[_i]);
            xyzs[_i * 3] = xyz[0];
            xyzs[_i * 3 + 1] = xyz[1];
            xyzs[_i * 3 + 2] = xyz[2];
            ++_i;
        }
        return xyzs;
    }

    public String getGrainspotterPath() {
        return this.grainspotterPath;
    }

    public void setGrainspotterPath(String grainspotterPath) {
        this.grainspotterPath = grainspotterPath;
    }

    public String getIniFilePath() {
        return this.input.getInputFile().iniFilePath;
    }

    public void setIniFilePath(String iniFilePath) {
        this.input.getInputFile().iniFilePath = iniFilePath;
        if (this.input.getInputFile().gveFilePath.equals("")) {
            this.setGveFilePath(iniFilePath);
        }
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(iniFilePath);
        }
    }

    public String getGveFilePath() {
        return this.input.getInputFile().gveFilePath;
    }

    public void setGveFilePath(String gveFilePath) {
        this.input.getInputFile().gveFilePath = gveFilePath;
    }

    public String getLogFilePath() {
        return this.input.getInputFile().logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.input.getInputFile().logFilePath = logFilePath;
    }

    public String getIniFileName() {
        return String.valueOf(this.input.getInputFile().iniFilePath) + this.pathSeparator + this.input.getInputFile().iniFileName;
    }

    public void setIniFileName(String _iniFileName) {
        if (_iniFileName.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().iniFilePath = _iniFileName.substring(_iniFileName.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().iniFilePath = _iniFileName.substring(0, _iniFileName.lastIndexOf(this.pathSeparator) + 1);
        } else {
            this.input.getInputFile().iniFileName = _iniFileName;
        }
    }

    public void setLogFileName(String _logFileName) {
        if (_logFileName.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().logFileName = _logFileName.substring(_logFileName.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().logFilePath = _logFileName.substring(0, _logFileName.lastIndexOf(this.pathSeparator));
        } else {
            this.input.getInputFile().logFilePath = this.input.getInputFile().iniFilePath;
            this.input.getInputFile().logFileName = _logFileName;
        }
    }

    public String getLogFileName() {
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(this.input.getInputFile().iniFilePath);
        }
        return String.valueOf(this.input.getInputFile().logFilePath) + this.pathSeparator + this.input.getInputFile().logFileName;
    }

    public static GrainSpotter getInstance() {
        if (grainspotter == null) {
            grainspotter = new GrainSpotter();
        }
        return grainspotter;
    }

    public GrainspotterIniInput getInput() {
        return this.input;
    }

    public void setInput(GrainspotterIniInput input) {
        this.input = input;
    }

    public void setGveFileName(String fileName) {
    }

    class GrainSpotterThread
    implements Runnable {
        String outputMessage;

        GrainSpotterThread() {
        }

        @Override
        public void run() {
            boolean grainspotterRan;
            block7: {
                grainspotterRan = false;
                try {
                    String[] gsRunCommand;
                    GrainSpotter.this.runtime = Runtime.getRuntime();
                    if (GrainSpotter.this.gsCommandCanRun() && (gsRunCommand = GrainSpotter.this.makeGSBatchCommand()) != null) {
                        GrainSpotter.this.grainspotterProcess = GrainSpotter.this.runtime.exec(gsRunCommand);
                        StreamReaderThread outThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getInputStream());
                        StreamReaderThread errThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getErrorStream());
                        outThread.start();
                        errThread.start();
                        GrainSpotter.this.grainspotterProcess.waitFor();
                        grainspotterRan = true;
                        outThread.join();
                        errThread.join();
                    }
                    GrainSpotter.this.fireStateChange("stopped");
                }
                catch (IOException e) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError(e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    if (FableMessageConsole.console == null) break block7;
                    FableMessageConsole.console.displayError(e.getMessage());
                }
            }
            if (!Display.getDefault().isDisposed() && grainspotterRan) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage activePage;
                        IWorkbenchWindow activeWindow;
                        Object viewPart = null;
                        try {
                            activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            activePage = activeWindow.getActivePage();
                            activePage.showView("fable.grainspotter.view.outputview");
                        }
                        catch (PartInitException e) {
                            FableMessageConsole.console.displayError("Exception occurred showing OutputView: " + (Object)((Object)e) + "\n" + e.getMessage());
                            e.printStackTrace();
                        }
                        if (viewPart instanceof ErrorViewPart) {
                            FableMessageConsole.console.displayError("Error showing OutputView");
                            return;
                        }
                        OutputView.view.loadLogFile(((GrainSpotter)((GrainSpotterThread)GrainSpotterThread.this).GrainSpotter.this).input.getInputFile().logFileName);
                        if (((GrainSpotterThread)GrainSpotterThread.this).GrainSpotter.this.grainGvectors.size() <= 0) {
                            FableMessageConsole.console.displayError("No grains found in log file (hint: check the input parameters are right e.g. space group)");
                        } else {
                            viewPart = null;
                            try {
                                activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                activePage = activeWindow.getActivePage();
                                activePage.showView("fable.grainspotter.grains3dview");
                            }
                            catch (PartInitException e) {
                                FableMessageConsole.console.displayError("Exception occurred showing Grains3DView: " + (Object)((Object)e) + "\n" + e.getMessage());
                                e.printStackTrace();
                            }
                            if (viewPart instanceof ErrorViewPart) {
                                FableMessageConsole.console.displayError("Error showing Grains3DView");
                                return;
                            }
                            int grains = ((GrainSpotterThread)GrainSpotterThread.this).GrainSpotter.this.grainGvectors.size();
                            Grains3DView.setGrains(grains);
                            Grains3DView.plotGrain(0);
                        }
                    }
                });
            }
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);
                        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        activeWindow.getShell().setCursor(arrowCursor);
                    }
                });
            }
        }
    }

    class ReadGveThread
    implements Runnable {
        String outputMessage;
        private int nHashs = 0;
        private int nGvectors = 0;

        ReadGveThread() {
        }

        @Override
        public void run() {
            block9: {
                gveXYZ.clear();
                this.nGvectors = 0;
                this.nHashs = 0;
                boolean regexmatched = false;
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayIn("Start reading gve file " + GrainSpotter.this.gvectorFile);
                }
                Pattern pattern = Pattern.compile("(.*?xr\\s+yr\\s+zr.*?$)||(.*?gx\\s+gy\\s+gz.*?$)");
                try {
                    String line;
                    File f = new File(GrainSpotter.this.gvectorFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    while ((line = reader.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        Matcher matcher = pattern.matcher(line);
                        if (matcher.matches()) {
                            regexmatched = true;
                        }
                        if (!regexmatched || matcher.matches()) continue;
                        double[] xyz = new double[3];
                        ++this.nGvectors;
                        try {
                            String[] outTokens = line.split("\\s+");
                            xyz[0] = Double.valueOf(outTokens[0]);
                            xyz[1] = Double.valueOf(outTokens[1]);
                            xyz[2] = Double.valueOf(outTokens[2]);
                            gveXYZ.add(xyz);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("A problem occured while parsing gve at line:" + line);
                            if (FableMessageConsole.console == null) continue;
                            FableMessageConsole.console.displayError("An error occured while parsing file " + f.getName() + " at line " + line);
                        }
                    }
                    reader.close();
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayIn("Finished reading gve file " + GrainSpotter.this.gvectorFile + " found " + this.nGvectors + " vectors");
                    }
                }
                catch (IOException iOException) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error while opening or reading gve file = " + ((GrainSpotter)GrainSpotter.this).input.getInputFile().gveFilePath + GrainSpotter.this.pathSeparator + GrainSpotter.this.gvectorFile);
                    }
                    if (FableMessageConsole.console == null) break block9;
                    FableMessageConsole.console.displayError("Make sure the path and file name are correct and verify the contents");
                }
            }
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        @Override
        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int percentage = 0;
                int workdone = 0;
                int ngrains_found = 0;
                while ((this.outputMessage = outputread.readLine()) != null) {
                    if (this.outputMessage.indexOf("ngrain") != -1) {
                        ++ngrains_found;
                    }
                    if (this.outputMessage.indexOf("completed") != -1 && GrainSpotter.this.grainspotterMonitor != null) {
                        int percentageIndex = this.outputMessage.indexOf("%");
                        String percentageString = this.outputMessage.charAt(percentageIndex - 2) == ' ' ? this.outputMessage.substring(percentageIndex - 1, percentageIndex) : this.outputMessage.substring(percentageIndex - 2, percentageIndex);
                        percentage = Integer.parseInt(percentageString);
                        GrainSpotter.this.grainspotterMonitor.subTask("Looking for grains - " + ngrains_found + " grains found so far");
                        GrainSpotter.this.grainspotterMonitor.worked(percentage - workdone);
                        workdone = percentage;
                    }
                    if (Display.getDefault().isDisposed()) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FableMessageConsole.console.displayOut(StreamReaderThread.this.outputMessage);
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

