/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.Sample;
import fable.framework.views.FableMessageConsole;
import fable.imageviewer.views.ImageView;
import fable.peaksearch.Activator;
import fable.peaksearch.object.Peak;
import fable.peaksearch.object.PeakSearchSpt;
import fable.peaksearch.object.Peaksearch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class PeaksSptView
extends ViewPart
implements IPropertyChangeListener {
    private static final String ID = "fable.peaksearch.PeaksSptView";
    public static PeaksSptView view;
    private Table table;
    private TableViewer tableHeaderSpt;
    private String sptFile;
    private Vector<PeakSearchSpt> filePeaks;
    private PeakSearchSpt currentPeaks = null;
    private SashForm sash;
    private Display display;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private Logger logger;
    private TabFolder folder;
    private TabItem tableItem;
    private TabItem imageViewerItem;
    private ImageView imageView;
    private SampleController controller;
    private ImageDescriptor check_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/check.gif");
    private ImageDescriptor uncheck_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/uncheck.gif");
    private Listener sortListener;
    String[] titles = new String[]{"#", "Number_of_pixels", "Average_counts", "f", "s", "fc", "sc", "sig_f", "sig_s", "cov_fs"};
    Text directoryTextField;
    String currentDirectory = "";
    FableMessageConsole console;
    private IMemento memento = null;
    private Sample currentSample;
    private FabioFile currentFile;

    public void createPartControl(Composite parent) {
        this.controller = SampleController.getController();
        this.sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = PeaksSptView.this.table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = PeaksSptView.this.table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    PeaksSptView.this.table.setSortColumn(currentColumn);
                    dir = 1024;
                }
                TableColumn[] cols = PeaksSptView.this.table.getColumns();
                PeaksSptView.this.table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int index = 0;
                int x = 0;
                while (index == 0 && x < cols.length) {
                    if (cols[x].getText().equals(column.getText())) {
                        index = x;
                    }
                    ++x;
                }
                PeaksSptView.this.currentPeaks.setComparator(column.getText(), dir);
                PeaksSptView.this.table.setSortDirection(dir);
                PeaksSptView.this.table.setSortColumn(column);
                PeaksSptView.this.populatePeaksTable();
            }
        };
        this.logger = Logger.getLogger(Peaksearch.class);
        view = this;
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.filePeaks = new Vector();
        this.display = parent.getDisplay();
        parent.setLayout((Layout)new GridLayout(3, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableHeaderSpt);
        this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        boolean bok = false;
        int i = 0;
        while (!bok && i < ConsolePlugin.getDefault().getConsoleManager().getConsoles().length) {
            if (ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i] instanceof FableMessageConsole) {
                bok = true;
                this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i];
            }
            ++i;
        }
        if (this.console == null) {
            this.console = new FableMessageConsole("Peaksearch console");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
        GridData gdExplorer = new GridData(4, 4, true, true);
        gdExplorer.horizontalAlignment = 4;
        gdExplorer.verticalAlignment = 4;
        gdExplorer.horizontalSpan = 3;
        new Label(parent, 0).setText("File directory");
        this.directoryTextField = new Text(parent, 2048);
        this.directoryTextField.setLayoutData((Object)new GridData(4, 2, true, false));
        this.directoryTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    PeaksSptView.this.currentDirectory = PeaksSptView.this.directoryTextField.getText();
                    PeaksSptView.this.tableHeaderSpt.getTable().notifyListeners(13, new Event());
                }
            }
        });
        Button browse = new Button(parent, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dlg.setFilterPath(PeaksSptView.this.currentDirectory);
                String returnString = dlg.open();
                if (returnString != null) {
                    PeaksSptView.this.currentDirectory = String.valueOf(returnString) + System.getProperty("file.separator");
                    if (!PeaksSptView.this.currentDirectory.equals("")) {
                        PeaksSptView.this.directoryTextField.setText(PeaksSptView.this.currentDirectory);
                        PeaksSptView.this.currentSample.getFabioFiles().removeAllElements();
                        PeaksSptView.this.loadFabiofiles();
                        PeaksSptView.this.currentFile = PeaksSptView.this.controller.getCurrentFile();
                        PeaksSptView.this.tableHeaderSpt.getTable().notifyListeners(13, new Event());
                    }
                }
            }
        });
        this.sash = new SashForm(parent, 256);
        this.sash.setLayoutData((Object)gdExplorer);
        this.createleftTable();
        this.createTable();
        this.sash.setWeights(new int[]{20, 50});
        if (this.memento != null) {
            this.currentDirectory = this.memento.getString("path");
        }
    }

    public void dispose() {
        if (this.controller != null) {
            this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void loadFabiofiles() {
        if (this.currentSample.getFabioFiles() != null) {
            this.currentSample.removeFiles();
        }
        String filename = null;
        int i = 0;
        while (i < this.filePeaks.size()) {
            try {
                filename = this.filePeaks.elementAt(i).getFileName();
                this.currentSample.addFabioFile(filename);
            }
            catch (FabioFileException fabioFileException) {
                this.console.displayError("Image " + filename + " not found. Please " + "set the correct directory in the field.");
            }
            ++i;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("path", this.currentDirectory);
    }

    public final void loadSptFile(String sname) {
        this.sptFile = sname;
        if (this.sptFile != null) {
            int index = this.sptFile.lastIndexOf(System.getProperty("file.separator"));
            if (index + 1 <= this.sptFile.length()) {
                ++index;
            }
            String name = this.sptFile.substring(index);
            this.setPartName("2D peaks: " + name);
            this.currentDirectory = this.sptFile.substring(0, index);
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    if (PeaksSptView.this.currentDirectory != null) {
                        PeaksSptView.this.directoryTextField.setText(PeaksSptView.this.currentDirectory);
                    }
                }
            });
        }
        this.filePeaks.removeAllElements();
        Job job = new Job("Loading " + this.sptFile){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    monitor.beginTask("Please, wait while loading peaks in table....", -1);
                    FileInputStream inputFileReader = new FileInputStream(PeaksSptView.this.sptFile);
                    long elapsed = System.currentTimeMillis();
                    Scanner scanner = new Scanner(inputFileReader);
                    try {
                        Pattern p = Pattern.compile("#\\s+File\\s+");
                        scanner.useDelimiter(p);
                        Pattern skip = Pattern.compile("[\t\r\n]*");
                        scanner.skip(skip);
                        while (scanner.hasNextLine()) {
                            try {
                                long blockElapse = System.currentTimeMillis();
                                String line = scanner.next();
                                Scanner getFileNameScan = new Scanner(line);
                                getFileNameScan.useDelimiter("[\n\r]+");
                                String filename = getFileNameScan.next();
                                getFileNameScan.close();
                                PeakSearchSpt peak = new PeakSearchSpt(filename);
                                PeaksSptView.this.currentPeaks = peak;
                                PeaksSptView.this.currentPeaks.addPropertyChangeListener(view);
                                PeaksSptView.this.filePeaks.add(peak);
                                peak.setKeys(PeaksSptView.this.titles);
                                peak.setNbPeaks(PeaksSptView.this.getNnPeaksInfo(line));
                                peak.setPeaks(PeaksSptView.this.getBlockPeaks(line));
                                blockElapse = System.currentTimeMillis() - blockElapse;
                                if (!monitor.isCanceled()) continue;
                                scanner.close();
                                try {
                                    inputFileReader.close();
                                }
                                catch (IOException e) {
                                    PeaksSptView.this.logger.error((Object)e.getMessage());
                                }
                                return Status.CANCEL_STATUS;
                            }
                            catch (NoSuchElementException noSuchElementException) {}
                        }
                        elapsed = System.currentTimeMillis() - elapsed;
                        PeaksSptView.this.populateLeftTable();
                        scanner.close();
                        try {
                            inputFileReader.close();
                        }
                        catch (IOException e) {
                            PeaksSptView.this.logger.error((Object)e.getMessage());
                        }
                        if (PeaksSptView.this.filePeaks != null && PeaksSptView.this.filePeaks.size() > 0 && !PeaksSptView.this.display.isDisposed()) {
                            PeaksSptView.this.display.asyncExec(new Runnable(){

                                public void run() {
                                    PeaksSptView.this.currentSample = new Sample(PeaksSptView.this.sptFile, PeaksSptView.this.sptFile);
                                    PeaksSptView.this.controller.addSample(PeaksSptView.this.currentSample);
                                    PeaksSptView.this.currentSample.setShowInNavigator(false);
                                    PeaksSptView.this.loadFabiofiles();
                                    try {
                                        PeaksSptView.this.imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "right", 1);
                                        PeaksSptView.this.imageView.initWithShowPeaks();
                                        PeaksSptView.this.controller.addPropertyChangeListener((IPropertyChangeListener)PeaksSptView.this.imageView);
                                        PeaksSptView.this.tableHeaderSpt.getTable().setSelection(0);
                                        PeaksSptView.this.controller.setCurrentFileIndex(0);
                                        PeaksSptView.this.currentFile = PeaksSptView.this.controller.getCurrentFile();
                                        PeaksSptView.this.tableHeaderSpt.getTable().notifyListeners(13, new Event());
                                    }
                                    catch (PartInitException e) {
                                        PeaksSptView.this.logger.error((Object)e.getMessage());
                                    }
                                }
                            });
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        scanner.close();
                        try {
                            inputFileReader.close();
                        }
                        catch (IOException e) {
                            PeaksSptView.this.logger.error((Object)e.getMessage());
                        }
                        FableMessageConsole.console.displayIn("Peaks cannot be retrieve in this file. Make sure you have chosen spt file.");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FableMessageConsole.console.displayIn("File " + PeaksSptView.this.sptFile + " not found.");
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private int getNnPeaksInfo(String line) {
        String np;
        String[] nbP;
        int nbPeaks = 0;
        String[] split = line.split("(#\\s+npks\\s+=)");
        if (split.length > 1 && (nbP = (np = split[1]).split("\\n")).length > 0) {
            try {
                String s = nbP[0].trim();
                nbPeaks = Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return nbPeaks;
    }

    private String getBlockPeaks(String line) {
        String blockcontainingAllPeaks;
        Scanner scanner;
        block5: {
            scanner = null;
            blockcontainingAllPeaks = "";
            try {
                scanner = new Scanner(line);
                Pattern p = Pattern.compile("(#(.+)\\r*\\n)+");
                scanner.useDelimiter(p);
                if (scanner.hasNext()) {
                    scanner.next();
                    if (scanner.hasNext()) {
                        blockcontainingAllPeaks = scanner.next();
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (scanner == null) break block5;
                scanner.close();
            }
        }
        if (scanner != null) {
            scanner.close();
        }
        return blockcontainingAllPeaks;
    }

    private void populatePeaksTable() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PeaksSptView.this.currentPeaks.parse();
                PeaksSptView.this.table.clearAll();
                PeaksSptView.this.table.removeAll();
                int nItem = 0;
                nItem = PeaksSptView.this.currentPeaks.getNbPeaks();
                PeaksSptView.this.table.setItemCount(nItem);
            }
        });
    }

    public void setFocus() {
        this.controller.setCurrentSample(this.currentSample);
        this.tableHeaderSpt.getTable().notifyListeners(13, new Event());
    }

    public void addImageView(final PeakSearchSpt peak) {
        Job addimageJob = new Job("Loading image"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Load image " + peak.getFileName(), -1);
                if (peak != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                if (PeaksSptView.this.imageView != null) {
                                    FabioFile fabio = peak.getFabio();
                                    if (fabio == null) {
                                        fabio = new FabioFile(String.valueOf((this).PeaksSptView.this.currentDirectory) + peak.getFileName());
                                        peak.setFabioFile(fabio);
                                    }
                                    fabio.setFullFileName(String.valueOf((this).PeaksSptView.this.currentDirectory) + peak.getFileName());
                                    File jFile = new File(String.valueOf((this).PeaksSptView.this.currentDirectory) + peak.getFileName());
                                    if (jFile.exists()) {
                                        PeaksSptView.this.imageView.loadFile(fabio);
                                        float[] vals = peak.getTabChildren();
                                        if (vals != null) {
                                            PeaksSptView.this.imageView.setPeaks(vals);
                                            PeaksSptView.this.imageView.displayImage();
                                        }
                                    } else {
                                        (this).PeaksSptView.this.console.displayIn("Image file " + jFile + " not found.");
                                    }
                                }
                            }
                            catch (FabioFileException e1) {
                                (this).PeaksSptView.this.console.displayIn("Image file " + (this).PeaksSptView.this.currentDirectory + peak.getFileName() + " not found. Please change directory.");
                                PeaksSptView.this.logger.error((Object)(String.valueOf(e1.getMessage()) + " " + (this).PeaksSptView.this.currentDirectory + peak.getFileName()));
                            }
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        addimageJob.setUser(true);
        addimageJob.schedule();
    }

    public void createleftTable() {
        this.tableHeaderSpt = new TableViewer((Composite)this.sash);
        this.tableHeaderSpt.setContentProvider((IContentProvider)new TableSptContentProvider());
        this.tableHeaderSpt.setLabelProvider((IBaseLabelProvider)new TableSptLabelProvider(){});
        this.tableHeaderSpt.setUseHashlookup(true);
        this.tableHeaderSpt.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PeaksSptView.this.showImage();
                PeaksSptView.this.controller.setCurrentFileIndex(PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex());
                PeaksSptView.this.updateFileTable();
            }
        });
    }

    private void updateFileTable() {
        Table leftT = this.tableHeaderSpt.getTable();
        String[] LeftColumn = new String[]{"File", "NbPeaks"};
        int i = 0;
        while (i < LeftColumn.length) {
            TableColumn tbl = new TableColumn(leftT, 16384);
            tbl.setText(LeftColumn[i]);
            ++i;
        }
        i = 0;
        while (i < LeftColumn.length) {
            leftT.getColumn(i).pack();
            ++i;
        }
        leftT.setLinesVisible(false);
        leftT.setHeaderVisible(true);
    }

    public void populateLeftTable() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PeaksSptView.this.tableHeaderSpt.getTable().removeAll();
                PeaksSptView.this.tableHeaderSpt.getTable().clearAll();
                PeaksSptView.this.tableHeaderSpt.setInput((Object)"root");
                int i = 0;
                while (i < PeaksSptView.this.tableHeaderSpt.getTable().getColumnCount()) {
                    PeaksSptView.this.tableHeaderSpt.getTable().getColumn(i).pack();
                    ++i;
                }
            }
        });
    }

    public void createTable() {
        this.table = new Table((Composite)this.sash, 268503074);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.titles[i]);
            column.addListener(13, this.sortListener);
            ++i;
        }
        i = 0;
        while (i < this.titles.length) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3 && PeaksSptView.this.table.getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemAdd = new MenuItem(menu, 8);
                    mitemAdd.setText("Check");
                    final Image imgCheck = PeaksSptView.this.check_imageDescriptor.createImage();
                    final Image imgunCheck = PeaksSptView.this.uncheck_imageDescriptor.createImage();
                    mitemAdd.setImage(imgCheck);
                    mitemAdd.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int i = 0;
                            while (i < PeaksSptView.this.table.getSelectionCount()) {
                                PeaksSptView.this.table.getItem(PeaksSptView.this.table.getSelectionIndices()[i]).setChecked(true);
                                ++i;
                            }
                            PeaksSptView.this.table.notifyListeners(32, new Event());
                        }
                    });
                    MenuItem mitemUncheck = new MenuItem(menu, 8);
                    mitemUncheck.setText("Uncheck");
                    mitemUncheck.setImage(imgunCheck);
                    mitemUncheck.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int i = 0;
                            while (i < PeaksSptView.this.table.getSelectionCount()) {
                                PeaksSptView.this.table.getItem(PeaksSptView.this.table.getSelectionIndices()[i]).setChecked(false);
                                ++i;
                            }
                            PeaksSptView.this.table.notifyListeners(32, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (imgCheck != null) {
                                imgCheck.dispose();
                            }
                            if (imgunCheck != null) {
                                imgunCheck.dispose();
                            }
                        }
                    });
                    menu.dispose();
                }
            }
        });
        Listener checkSelection = new Listener(){

            public void handleEvent(Event event) {
                TableItem it = null;
                int nPeaksToDisplay = 0;
                TableItem[] tableItem = PeaksSptView.this.tableHeaderSpt.getTable().getSelection();
                if (tableItem != null && tableItem.length > 0) {
                    PeaksSptView.this.currentPeaks = (PeakSearchSpt)tableItem[0].getData();
                }
                Vector<Peak> peaksToColor = new Vector<Peak>();
                it = (TableItem)event.item;
                if (event.detail == 32) {
                    PeaksSptView.this.table.setSelection(it);
                }
                int sel = 0;
                while (sel < PeaksSptView.this.table.getSelectionCount()) {
                    it = PeaksSptView.this.table.getSelection()[sel];
                    Peak square = (Peak)it.getData("peak");
                    if (square != null) {
                        square.show(it.getChecked());
                    }
                    if (it.getData().equals(PeaksSptView.this.currentPeaks) && it.getChecked()) {
                        ++nPeaksToDisplay;
                        peaksToColor.add(square);
                    }
                    ++sel;
                }
                try {
                    PeaksSptView.this.imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "right", 1);
                    PeaksSptView.this.imageView.initPalette(0);
                    if (PeaksSptView.this.imageView != null) {
                        float[] coloredPeak = new float[nPeaksToDisplay * 2];
                        int k = 0;
                        int ip = 0;
                        while (ip < peaksToColor.size()) {
                            int j = k + 1;
                            coloredPeak[k] = Float.valueOf(((Peak)peaksToColor.elementAt(ip)).getS()).floatValue();
                            coloredPeak[j] = Float.valueOf(((Peak)peaksToColor.elementAt(ip)).getF()).floatValue();
                            k += 2;
                            ++ip;
                        }
                        float[] vals = PeaksSptView.this.currentPeaks.getTabChildren();
                        if (vals != null) {
                            PeaksSptView.this.imageView.setPeaks(vals);
                            if (nPeaksToDisplay == 0) {
                                PeaksSptView.this.imageView.showPeaks();
                                PeaksSptView.this.imageView.displayImage();
                            } else {
                                PeaksSptView.this.imageView.colorPeaks(coloredPeak);
                            }
                        }
                    }
                }
                catch (PartInitException e1) {
                    PeaksSptView.this.logger.error((Object)e1.getMessage());
                }
            }
        };
        this.table.addListener(13, checkSelection);
        this.table.addListener(32, checkSelection);
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int j = event.index;
                int i = PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex();
                if (i < 0) {
                    i = 0;
                }
                PeakSearchSpt ps = (PeakSearchSpt)PeaksSptView.this.filePeaks.elementAt(i);
                Color curColor = j % 2 == 0 ? Display.getCurrent().getSystemColor(1) : PeaksSptView.this.light_blue;
                Vector<Peak> v_peaks = ps.getSortedpeaks();
                if (j < v_peaks.size()) {
                    Peak p = v_peaks.elementAt(j);
                    item.setChecked(p.isVisible());
                    item.setData(PeaksSptView.this.filePeaks.elementAt(i));
                    item.setData("Default_Color", (Object)curColor);
                    item.setData("peak", (Object)p);
                    item.setData("peaks_indice", (Object)i);
                    item.setBackground(curColor);
                    item.setText(p.getValues());
                }
            }
        });
    }

    public void showImage() {
        if (this.tableHeaderSpt != null && this.tableHeaderSpt.getSelection() instanceof IStructuredSelection) {
            int index = 0;
            IStructuredSelection selection = (IStructuredSelection)this.tableHeaderSpt.getSelection();
            if (selection != null && !selection.isEmpty()) {
                PeakSearchSpt domain = (PeakSearchSpt)selection.getFirstElement();
                this.table.setTopIndex(index);
                this.currentPeaks = domain;
                if (this.currentPeaks.getChildren().size() == 0) {
                    this.currentPeaks.parse();
                } else {
                    this.populatePeaksTable();
                }
                this.addImageView(domain);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() != null) {
            if (event.getProperty().equals("addPeaks")) {
                this.populatePeaksTable();
            } else if (event.getProperty().equals("CurrentFile")) {
                int index = this.tableHeaderSpt.getTable().getSelectionIndex();
                int selection = this.controller.getCurrentFileIndex();
                if (this.currentSample != null && this.controller.getCurrentsample() == this.currentSample) {
                    int nbItems;
                    this.currentFile = this.currentSample.getCurrentFabioFile();
                    if (index != selection && (nbItems = this.tableHeaderSpt.getTable().getItemCount()) > 0 && selection < nbItems) {
                        this.tableHeaderSpt.getTable().setSelection(selection);
                        this.showImage();
                    }
                }
            }
        }
    }

    public static String getID() {
        return ID;
    }

    class PeakLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private ImageDescriptor IDgreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot.gif");
        private ImageDescriptor IDred = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/darkred.gif");
        private ImageDescriptor IDbigGreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot_big.gif");
        private Image imggreen = this.IDgreen.createImage();
        private Image bigGreen = this.IDbigGreen.createImage();
        private Image red = this.IDred.createImage();

        public String getColumnText(Object obj, int index) {
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            if (((PeakSearchSpt)obj).getNbPeaks() <= 100) {
                return this.imggreen;
            }
            if (((PeakSearchSpt)obj).getNbPeaks() <= 1000) {
                return this.bigGreen;
            }
            return this.red;
        }

        public void dispose() {
            if (this.imggreen != null) {
                this.imggreen.dispose();
            }
            if (this.bigGreen != null) {
                this.bigGreen.dispose();
            }
            if (this.red != null) {
                this.red.dispose();
            }
            if (PeaksSptView.this.light_blue != null) {
                PeaksSptView.this.light_blue.dispose();
            }
        }
    }

    class PeaksTreeContentProvider
    implements ITreeContentProvider {
        PeaksTreeContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return PeaksSptView.this.filePeaks.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableSptContentProvider
    implements IStructuredContentProvider {
        TableSptContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PeaksSptView.this.filePeaks.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableSptLabelProvider
    implements ITableLabelProvider {
        private ImageDescriptor IDgreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot.gif");
        private ImageDescriptor IDred = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/darkred.gif");
        private ImageDescriptor IDbigGreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot_big.gif");
        private Image imggreen = this.IDgreen.createImage();
        private Image bigGreen = this.IDbigGreen.createImage();
        private Image red = this.IDred.createImage();

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PeakSearchSpt && columnIndex == 0) {
                PeakSearchSpt p = (PeakSearchSpt)element;
                if (p.getNbPeaks() <= 100) {
                    return this.imggreen;
                }
                if (p.getNbPeaks() <= 1000) {
                    return this.bigGreen;
                }
                return this.red;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof PeakSearchSpt) {
                PeakSearchSpt p = (PeakSearchSpt)element;
                switch (columnIndex) {
                    case 0: {
                        text = p.getFileName();
                        break;
                    }
                    case 1: {
                        text = String.valueOf(p.getNbPeaks());
                        break;
                    }
                    case 2: {
                        text = String.valueOf(p.getTreshold());
                        break;
                    }
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.imggreen != null) {
                this.imggreen.dispose();
            }
            if (this.bigGreen != null) {
                this.bigGreen.dispose();
            }
            if (this.red != null) {
                this.red.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

