/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.splashHandlers;

import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class InteractiveSplashHandler
extends AbstractSplashHandler {
    private static final int F_LABEL_HORIZONTAL_INDENT = 0;
    private static final int F_BUTTON_WIDTH_HINT = 80;
    private static final int F_TEXT_WIDTH_HINT = 175;
    private static final int F_COLUMN_COUNT = 3;
    private Composite fCompositeLogin = null;
    private Text fIniFileName = null;
    private Button fButtonOK = null;
    private Button fButtonCancel = null;
    private boolean fAuthenticated = false;
    private static final String ID = "fable.peaksearch.splashHandlers.interactive";

    public void init(Shell splash) {
        super.init(splash);
        this.configureUISplash();
        this.createUI();
        this.createUIListeners();
        splash.layout(true);
        this.doEventLoop();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!this.fAuthenticated) {
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
    }

    private void createUIListeners() {
        this.createUIListenersButtonOK();
        this.createUIListenersButtonCancel();
    }

    private void createUIListenersButtonCancel() {
        this.fButtonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonCancelWidgetSelected();
            }
        });
    }

    private void handleButtonCancelWidgetSelected() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    private void createUIListenersButtonOK() {
        this.fButtonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonOKWidgetSelected();
            }
        });
    }

    private void handleButtonOKWidgetSelected() {
        String fileName = this.fIniFileName.getText();
        if (fileName.length() > 0) {
            this.fAuthenticated = true;
            try {
                Peaksearch.getPeaksearch(fileName);
            }
            catch (PeaksearchException e) {
                this.fAuthenticated = false;
                MessageDialog.openError((Shell)this.getSplash(), (String)"PeakSearch error", (String)e.getMessage());
            }
            catch (JepException e) {
                this.fAuthenticated = false;
                MessageDialog.openError((Shell)this.getSplash(), (String)"PeakSearch error", (String)e.getMessage());
            }
        } else {
            MessageDialog.openInformation((Shell)this.getSplash(), (String)"Default option files", (String)"Default options file peaksearch.xml will be loaded");
        }
    }

    private void createUI() {
        this.createUICompositeLogin();
        this.createUICompositeBlank();
        this.createUILabelFile();
        this.createUIIniFile();
        this.createUILabelBlank();
        this.createUIButtonOK();
        this.createUIButtonCancel();
    }

    private void createUIButtonCancel() {
        this.fButtonCancel = new Button(this.fCompositeLogin, 8);
        this.fButtonCancel.setText("Cancel");
        GridData data = new GridData(128, 0, false, false);
        data.widthHint = 80;
        data.verticalIndent = 10;
        this.fButtonCancel.setLayoutData((Object)data);
    }

    private void createUIButtonOK() {
        this.fButtonOK = new Button(this.fCompositeLogin, 8);
        this.fButtonOK.setText("OK");
        GridData data = new GridData(128, 0, false, false);
        data.widthHint = 80;
        data.verticalIndent = 10;
        this.fButtonOK.setLayoutData((Object)data);
    }

    private void createUILabelBlank() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setVisible(false);
    }

    private void createUIIniFile() {
        int style = 2048;
        this.fIniFileName = new Text(this.fCompositeLogin, style);
        GridData data = new GridData(0, 0, false, false);
        data.widthHint = 175;
        data.horizontalSpan = 1;
        this.fIniFileName.setLayoutData((Object)data);
        this.fIniFileName.setText("./xmlContent/peaksearch.xml");
        Button browse = new Button(this.fCompositeLogin, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(InteractiveSplashHandler.this.getSplash());
                String selection = dlg.open();
                if (selection != null) {
                    InteractiveSplashHandler.this.fIniFileName.setText(selection);
                }
            }
        });
    }

    private void createUILabelFile() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setText("&option file(xml file format):");
        GridData data = new GridData();
        data.horizontalIndent = 0;
        label.setLayoutData((Object)data);
    }

    private void createUICompositeBlank() {
        Composite spanner = new Composite(this.fCompositeLogin, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        spanner.setLayoutData((Object)data);
    }

    private void createUICompositeLogin() {
        this.fCompositeLogin = new Composite((Composite)this.getSplash(), 2048);
        GridLayout layout = new GridLayout(3, false);
        this.fCompositeLogin.setLayout((Layout)layout);
    }

    private void configureUISplash() {
        FillLayout layout = new FillLayout();
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }
}

