/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.jep.FableJep;
import fable.framework.jep.StdoutRead;
import fable.framework.toolbox.Sample;
import fable.framework.views.FableMessageConsole;
import fable.framework.xmlparser.object.FableXmlContentHandler;
import fable.framework.xmlparser.object.Xmloption;
import fable.peaksearch.Activator;
import fable.peaksearch.object.PeaksearchException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Peaksearch {
    private Vector<Xmloption> options;
    private Vector<Sample> samples;
    private Sample sample;
    private static Logger logger;
    private FableXmlContentHandler xmlContentHandler;
    private XMLReader saxReader;
    private static Peaksearch peaksearch;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ArrayList<String> listKillFile = new ArrayList();
    private static String iniFile;
    private Job job;
    private ArrayList<PeaksearchThread> peaksearchersRunning;
    private boolean forceQuit = false;
    private IProgressMonitor peaksearchProgressMonitor;

    static {
        peaksearch = null;
        iniFile = "";
    }

    public static Peaksearch getPeaksearch() throws PeaksearchException, JepException {
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    public static Peaksearch getPeaksearch(String ini) throws PeaksearchException, JepException {
        iniFile = ini;
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    private Peaksearch() throws PeaksearchException, JepException {
        logger = Logger.getLogger(Peaksearch.class);
        logger.info((Object)"Create peaksearch");
        FableJep.getFableJep();
        this.xmlContentHandler = new FableXmlContentHandler();
        iniFile = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch");
        this.parse();
        this.peaksearchersRunning = new ArrayList();
    }

    private void parse() throws PeaksearchException {
        if (this.saxReader == null) {
            try {
                this.saxReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                logger.error((Object)e.getMessage());
                throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", e.getMessage());
            }
        }
        try {
            this.saxReader.setContentHandler((ContentHandler)this.xmlContentHandler);
            this.saxReader.parse(new InputSource("file:" + iniFile));
            this.setOptions(this.xmlContentHandler.getOptions());
            this.fireIniFile();
        }
        catch (IOException e) {
            logger.error((Object)"xml file not found");
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", e.getMessage());
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage());
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", e.getMessage());
        }
    }

    public void loadIniFile(String ini) throws PeaksearchException {
        iniFile = ini;
        logger.info((Object)("loadIniFile" + ini));
        this.parse();
    }

    public Vector<Xmloption> getOptions() {
        return this.options;
    }

    public Sample getSample(int index) {
        Sample s = null;
        if (this.samples != null) {
            this.samples.elementAt(index);
        }
        return s;
    }

    public Vector<Sample> getSamples() {
        return this.samples;
    }

    public void setIniFile(String fileName) {
        iniFile = fileName;
        this.fireGetOptions();
    }

    public void setOptions(Vector<Xmloption> opt) {
        this.options = opt;
    }

    public void setSamples(Vector<Sample> s) {
        this.samples = s;
    }

    public void run() {
        this.forceQuit = false;
        this.job = new Job("Peaksearch"){

            protected IStatus run(IProgressMonitor monitor) {
                int size = 0;
                if (Peaksearch.this.samples != null) {
                    size = Peaksearch.this.samples.size();
                }
                if (size > 0 && !Peaksearch.this.forceQuit) {
                    Peaksearch.this.firePeakSearchRuns();
                    int i = 0;
                    i = 0;
                    while (i < size && !Peaksearch.this.forceQuit) {
                        Peaksearch.this.sample = Peaksearch.this.getSamples().elementAt(i);
                        Peaksearch.this.peaksearchProgressMonitor = monitor;
                        Peaksearch.this.peaksearchProgressMonitor.beginTask("Search for peaks in sample " + Peaksearch.this.sample.get_name(), -1);
                        Peaksearch.this.peaksearchersRunning.add(new PeaksearchThread(Peaksearch.this.sample));
                        ((PeaksearchThread)Peaksearch.this.peaksearchersRunning.get(i)).run();
                        if (Peaksearch.this.peaksearchProgressMonitor.isCanceled()) {
                            Peaksearch.this.forceQuit = true;
                            Peaksearch.this.firePeakSearchStops();
                            Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                } else {
                    Peaksearch.this.firePeakSearchRuns();
                    new PeaksearchThread().run();
                }
                Peaksearch.this.firePeakSearchStops();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(false);
        if (this.samples == null) {
            logger.error((Object)"Peaksearch can not be launched : There are no samples");
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Peaksearch can not be launched : There are no samples");
                }
            });
            this.firePeakSearchStops();
            return;
        }
        this.peaksearchersRunning.removeAll(this.peaksearchersRunning);
        this.listKillFile.removeAll(this.listKillFile);
        this.job.schedule();
    }

    public void forceQuit() {
        this.forceQuit = true;
        for (String file : this.listKillFile) {
            File f = new File(file);
            try {
                if (f.createNewFile()) {
                    logger.debug((Object)("Force peaksearch to exit with killFile = " + file));
                } else {
                    logger.debug((Object)("file " + file + " already exists "));
                }
                this.peaksearchProgressMonitor.setCanceled(true);
                this.job.done(Status.CANCEL_STATUS);
            }
            catch (IOException iOException) {
                logger.debug((Object)"The system can't create this file to kill peaksearch");
            }
        }
        this.peaksearchProgressMonitor.setCanceled(true);
    }

    public boolean isRunning() {
        if (this.job == null) {
            return false;
        }
        return this.job.getState() == 4;
    }

    public boolean hasBeenCanceled() {
        return this.forceQuit;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireGetOptions() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "save_ini", null, (Object)iniFile));
        }
    }

    public void firePeakSearchRuns() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "run", (Object)false, (Object)true));
        }
    }

    public void fireIniFile() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "load_ini", (Object)false, (Object)true));
        }
    }

    public void fireLaunchPeaksearch() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "start", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchStops() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "stop", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchforceQuit() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "quit", (Object)false, (Object)false));
        }
    }

    class PeaksearchThread
    implements Runnable {
        private Sample sample = null;
        private FableJep peaksearchJep = null;
        private StdoutRead stdout;
        private boolean stop = false;
        private String killFile;

        public PeaksearchThread(Sample s) {
            this.sample = s;
        }

        public PeaksearchThread() {
        }

        private boolean init() {
            boolean breturn = true;
            try {
                this.peaksearchJep = new FableJep();
                try {
                    File stdoutFilename = File.createTempFile("peaksearcher", ".stdout");
                    stdoutFilename.deleteOnExit();
                    logger.debug((Object)("tempFile = " + stdoutFilename.getAbsolutePath()));
                    this.peaksearchJep.redirectStdout(stdoutFilename.getAbsolutePath());
                    this.stdout = new StdoutRead(stdoutFilename.getAbsolutePath());
                    this.stdout.start();
                    String dir = stdoutFilename.getPath();
                    int index = dir.lastIndexOf(stdoutFilename.getName());
                    if (index > 0 && index < dir.length()) {
                        dir = dir.substring(0, index);
                    }
                    this.killFile = String.valueOf(dir) + "killPeaksearcher." + new Date().getTime();
                    Peaksearch.this.listKillFile.add(this.killFile);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                    FableMessageConsole.console.displayIn("Fable is unable to get peaksearch output for sample  " + this.sample.get_name() + "  because an error occured");
                    breturn = false;
                }
            }
            catch (JepException jepException) {
                FableMessageConsole.console.displayIn("Fable is unable to run peaksearch for sample  " + this.sample.get_name() + "  because an error occured");
            }
            return breturn;
        }

        public void run() {
            block13: {
                if (!this.stop) {
                    if (this.init()) {
                        try {
                            this.getDefaultPythonOptions();
                        }
                        catch (JepException e2) {
                            this.catchJepException(e2);
                        }
                        if (this.sample != null) {
                            try {
                                String currentDirectory = this.sample.get_directoryPath().replaceAll("\\\\", "/");
                                if (this.peaksearchJep == null) break block13;
                                FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
                                this.peaksearchJep.eval("os.chdir(\"" + currentDirectory + "\")");
                                try {
                                    Display.getDefault().syncExec(new Runnable(){

                                        public void run() {
                                            FableMessageConsole.console.displayOut("Peaksearching on " + PeaksearchThread.this.sample.get_name());
                                        }
                                    });
                                    this.transferOptionsJavaToPython(this.sample);
                                    this.stdout.stopped = true;
                                    this.stop = true;
                                }
                                catch (PeaksearchException e) {
                                    this.stdout.stopped = true;
                                    this.stop = true;
                                    logger.error((Object)("Peaksearch can not be launched : " + e.getMessage()));
                                }
                            }
                            catch (JepException e1) {
                                this.catchJepException(e1);
                            }
                        } else {
                            try {
                                this.transferOptionsJavaToPython();
                            }
                            catch (PeaksearchException e) {
                                this.stdout.stopped = true;
                                this.stop = true;
                                logger.error((Object)("Peaksearch can not be launched : " + e.getMessage()));
                            }
                        }
                    } else {
                        this.stdout.stopped = true;
                        this.stop = true;
                    }
                }
            }
            this.stop = true;
        }

        private void catchJepException(JepException e1) {
            this.stdout.stopped = true;
            this.stop = true;
            Peaksearch.this.firePeakSearchStops();
            logger.error((Object)("InterruptedException inthread peaksearch :" + e1.getMessage()));
            Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
        }

        public boolean isEnded() {
            return this.stop;
        }

        private void getDefaultPythonOptions() throws JepException {
            try {
                FableJep.jepImportSpecificDefinition((Jep)this.peaksearchJep.getJep(), (String)"ImageD11", (String)"peaksearcher");
                this.peaksearchJep.eval("class o:\n    def add_option(self, *a, **k):\n        setattr(self, k[\"dest\"], k[\"default\"])\n");
                this.peaksearchJep.eval("option_holder = o()");
                this.peaksearchJep.eval("peaksearcher.get_options( option_holder )");
                this.peaksearchJep.flushStdout();
            }
            catch (JepException e) {
                logger.error((Object)e.getMessage());
            }
        }

        public void notifyEndToPeaksearch() {
            logger.debug((Object)("killFile = " + this.killFile));
            new File(this.killFile);
            this.stop = true;
        }

        private void transferOptionsJavaToPython(Sample mySample) throws PeaksearchException {
            String shortOutputName = null;
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                if (opt.getOption().equals("stem")) {
                    logger.info((Object)("we are peaksearching for these files stem = " + mySample.getStem()));
                    opt.setValue(mySample.getStem());
                } else if (opt.getOption().equals("first")) {
                    opt.setValue(String.valueOf(mySample.getFirst()));
                } else if (opt.getOption().equals("format")) {
                    opt.setValue(String.valueOf(mySample.getFileFormat()));
                } else if (opt.getOption().equals("last")) {
                    opt.setValue(String.valueOf(mySample.getLast()));
                } else if (opt.getOption().equals("outfile")) {
                    shortOutputName = mySample.getPeaksearchoutStem();
                    if (shortOutputName != null) {
                        opt.setValue(String.valueOf(shortOutputName) + ".spt");
                    }
                    shortOutputName = opt.getValue();
                } else if (opt.getOption().equals("ndigits")) {
                    opt.setValue(String.valueOf(mySample.getNDigits()));
                }
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException e) {
                    logger.error((Object)("JepException in thread peaksearch  while trying peaksearch_driver( option_holder , () ): for stem " + mySample.get_name() + " ;\\n" + e.getMessage()));
                    final String name = mySample.get_name();
                    final String message = e.getMessage();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Peaksearch", (String)("Peaksearch failed for " + name + ". \n" + message));
                        }
                    });
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", e.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Peaksearch have been stopped by user.");
            }
        }

        private void transferOptionsJavaToPython() throws PeaksearchException {
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException e) {
                    logger.error((Object)"JepException in thread peaksearch  while trying peaksearch_driver( option_holder , () ): for stem ");
                    final String message = e.getMessage();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Peaksearch", (String)("Peaksearch failed. \n" + message));
                        }
                    });
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", e.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Peaksearch have been stopped by user.");
            }
        }

        private void setKillFile() {
            if (this.killFile != null && !Peaksearch.this.forceQuit) {
                try {
                    this.peaksearchJep.set("killfile", this.killFile);
                    this.peaksearchJep.eval("option_holder.killfile=killfile");
                }
                catch (JepException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }

        private void optionDriver() throws JepException {
            this.peaksearchJep.eval("peaksearcher.peaksearch_driver( option_holder , () )");
            this.peaksearchJep.flushStdout();
        }

        private void optionHolder(Xmloption opt) throws PeaksearchException {
            logger.info((Object)(String.valueOf(opt.getDest()) + " " + opt.getOption() + " get value: " + opt.getValue() + " and type " + opt.getType()));
            if (opt.getValue() != null && !opt.getValue().equals("")) {
                try {
                    this.peaksearchJep.eval("option_holder." + opt.toString());
                    logger.info((Object)("option_holder." + opt.toString()));
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Peaksearch", (String)("Peaksearch can not run :" + e.getMessage()));
                        }
                    });
                    logger.error((Object)("JepException in thread peaksearch :" + e.getMessage()));
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", e.getMessage());
                }
            }
            try {
                this.peaksearchJep.flushStdout();
            }
            catch (JepException e) {
                logger.error((Object)e.getMessage());
            }
            FableMessageConsole.console.displayOut("opt:" + opt.getOption() + "=" + opt.getValue());
        }
    }
}

