/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class HttpClientConnection {
    public static final int HTTP_DEFAULTPORT = 80;
    private String hostname;
    private int port = 80;
    private Socket socket;
    private int timeout = 30000;
    private boolean keepAlive = true;
    private boolean chunkedTransfer;
    private int remainingChunkLength;
    private boolean finalChunkSeen;
    private String contentType;
    private OutputStream out;
    private InputStream in;
    private int responseCode;
    private byte[] asciiBuffer = new byte[1024];
    private char[] headerLine = new char[80];
    private String userAgentId = "Not Mozilla, but RemoteTea v1.0.3";
    private static final int HTTP_DEAD = 0;
    private static final int HTTP_IDLE = 1;
    private static final int HTTP_SENDING = 2;
    private static final int HTTP_RECEIVING = 3;
    private int mode = 1;
    private int remainingContentLength;
    public static final byte[] CRLF = new byte[]{13, 10};
    private boolean useProxy = false;
    private String cachedProxyHost;
    private int cachedProxyPort;

    public HttpClientConnection(String string) {
        this(string, 80);
    }

    public HttpClientConnection(String string, int n) {
        this.hostname = string;
        this.port = n;
        this.mode = 0;
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            this.out = null;
            this.in = null;
        }
        this.mode = 0;
    }

    public void beginPostRequest(String string, String string2, int n) throws IOException {
        this.connect();
        this.remainingContentLength = n;
        this.mode = 2;
        this.socket.setSoTimeout(this.timeout);
        if (this.useProxy) {
            this.writeln("POST http://" + this.hostname + string + " HTTP/1.1");
        } else {
            this.writeln("POST " + string + " HTTP/1.1");
        }
        if (!this.useProxy) {
            this.writeln("Host: " + this.hostname);
        }
        this.writeln("User-Agent: " + this.userAgentId);
        if (this.useProxy) {
            this.writeln("Proxy-Connection: keep-alive");
        } else {
            this.writeln("Connection: keep-alive");
        }
        this.writeln("Cache-Control: no-cache, no-store, private");
        this.writeln("Pragma: no-cache");
        this.writeln("Content-Type: " + string2);
        if (n <= 0) {
            throw new ProtocolException("ONC/RPC HTTP-tunnel POST needs content length to keep the connection alive");
        }
        this.writeln("Content-Length: " + n);
        this.writeln("");
    }

    public void writeContentBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode != 2) {
            throw new ProtocolException("ONC/RPC HTTP tunnel not in sending mode");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.remainingContentLength >= 0) {
            this.remainingContentLength -= n2;
            if (this.remainingContentLength < 0) {
                this.close();
                throw new ProtocolException("ONC/RPC HTTP tunnel received too much content");
            }
        }
        try {
            this.out.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void endPostRequest() throws IOException {
        if (this.remainingContentLength > 0) {
            this.close();
            throw new ProtocolException("ONC/RPC HTTP tunnel received not enough content");
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        this.mode = 1;
    }

    protected void handleOption(String string, String string2) {
        if ("Content-Length".equalsIgnoreCase(string)) {
            try {
                this.remainingContentLength = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("Content-Type".equalsIgnoreCase(string)) {
            this.contentType = string2;
        } else if ("Proxy-Connection".equalsIgnoreCase(string)) {
            if (this.useProxy) {
                this.keepAlive = "Keep-Alive".equalsIgnoreCase(string2);
            }
        } else if ("Connection".equalsIgnoreCase(string)) {
            if (!this.useProxy) {
                this.keepAlive = "Keep-Alive".equalsIgnoreCase(string2);
            }
        } else if ("Transfer-Encoding".equalsIgnoreCase(string)) {
            this.chunkedTransfer = "chunked".equalsIgnoreCase(string2);
        }
    }

    private int readHeaders() throws IOException {
        int n;
        String[] stringArray;
        this.keepAlive = false;
        this.remainingContentLength = 0;
        this.chunkedTransfer = false;
        this.remainingChunkLength = 0;
        this.contentType = null;
        do {
            int n2;
            if (!this.readHeaderLine(stringArray = new String[1]) || !stringArray[0].startsWith("HTTP/")) {
                throw new IOException("Invalid HTTP header");
            }
            String string = stringArray[0];
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) != ' '; ++n2) {
            }
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            try {
                this.responseCode = 300;
                this.responseCode = n = Integer.parseInt(string.substring(n2, n2 + 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid HTTP header");
            }
        } while (this.responseCode == 100);
        stringArray = new String[2];
        while (this.readHeaderLine(stringArray)) {
            this.handleOption(stringArray[0], stringArray[1]);
        }
        if (this.remainingContentLength <= 0) {
            this.keepAlive = false;
            this.remainingContentLength = -1;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readHeaderLine(String[] stringArray) throws IOException {
        int n;
        int n2 = this.headerLine.length;
        int n3 = 0;
        boolean bl = stringArray.length > 1;
        int n4 = -1;
        block5: while ((n = this.in.read()) >= 0) {
            switch (n) {
                case 58: {
                    if (n4 >= 0) break;
                    n4 = n3;
                    break;
                }
                case 9: {
                    n = 32;
                    break;
                }
                case 10: 
                case 13: {
                    this.in.mark(1);
                    int n5 = this.in.read();
                    if (n == 13 && n5 == 10) {
                        this.in.mark(1);
                        n5 = this.in.read();
                        if (n5 != 32 && n5 != 9) {
                            this.in.reset();
                            break block5;
                        }
                    } else {
                        this.in.reset();
                    }
                    n = 32;
                }
            }
            if (n3 >= n2) {
                char[] cArray = new char[n2 * 2];
                System.arraycopy(this.headerLine, 0, cArray, 0, n2);
                this.headerLine = cArray;
                n2 *= 2;
            }
            this.headerLine[n3++] = (char)n;
        }
        if (n3 == 0) {
            return false;
        }
        while (--n3 > 0 && this.headerLine[n3] <= ' ') {
        }
        ++n3;
        if (!bl) {
            stringArray[0] = new String(this.headerLine, 0, n3);
            return true;
        }
        if (n4 <= 0) {
            stringArray[0] = new String(this.headerLine, 0, n3);
            stringArray[1] = null;
            return true;
        }
        stringArray[0] = new String(this.headerLine, 0, n4);
        while (++n4 < n3 && this.headerLine[n4] <= ' ') {
        }
        stringArray[1] = new String(this.headerLine, n4, n3 - n4);
        return true;
    }

    private String readLine() throws IOException {
        int n;
        int n2 = this.headerLine.length;
        int n3 = 0;
        block3: while ((n = this.in.read()) >= 0) {
            switch (n) {
                case 10: 
                case 13: {
                    this.in.mark(1);
                    int n4 = this.in.read();
                    if (n == 13 && n4 == 10) break block3;
                    this.in.reset();
                    n = 32;
                }
                default: {
                    if (n3 >= n2) {
                        char[] cArray = new char[n2 * 2];
                        System.arraycopy(this.headerLine, 0, cArray, 0, n2);
                        this.headerLine = cArray;
                        n2 *= 2;
                    }
                    this.headerLine[n3++] = (char)n;
                    continue block3;
                }
            }
        }
        return new String(this.headerLine, 0, n3);
    }

    public int beginDecoding() throws IOException {
        this.mode = 3;
        this.finalChunkSeen = false;
        this.readHeaders();
        switch (this.responseCode) {
            case 200: {
                break;
            }
            default: {
                this.endDecoding();
            }
        }
        return this.responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int readContentBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.mode != 3) {
            throw new ProtocolException("ONC/RPC HTTP tunnel not in receiving mode");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.remainingContentLength >= 0 && this.remainingContentLength < n2) {
            this.close();
            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
        }
        if (this.chunkedTransfer) {
            try {
                while (true) {
                    if (this.remainingChunkLength <= 0) {
                        if (this.finalChunkSeen) {
                            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                        }
                        String string = this.readLine();
                        try {
                            this.remainingChunkLength = Integer.parseInt(string.trim(), 16);
                            if (this.remainingChunkLength < 0) {
                                throw new NumberFormatException("must not be negative");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ProtocolException("HTTP chunking transfer protocol violation: invalid chunk length \"" + string + "\"");
                        }
                        if (this.remainingChunkLength == 0) {
                            this.finalChunkSeen = true;
                            return n3;
                        }
                    }
                    while (this.remainingChunkLength > 0) {
                        int n4 = n2 <= this.remainingChunkLength ? n2 : this.remainingChunkLength;
                        int n5 = this.in.read(byArray, n, n4);
                        if (n5 < 0) {
                            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                        }
                        n += n5;
                        n3 += n5;
                        this.remainingChunkLength -= n5;
                        if ((n2 -= n5) > 0) continue;
                        if (this.remainingChunkLength <= 0) {
                            this.readLine();
                        }
                        return n3;
                    }
                    this.readLine();
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        try {
            try {
                while (n2 > 0) {
                    int n6 = this.in.read(byArray, n, n2);
                    if (n6 < 0) {
                        if (this.remainingContentLength < 0) break;
                        throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                    }
                    n3 += n6;
                    n += n6;
                    n2 -= n6;
                }
                Object var10_12 = null;
                if (this.remainingContentLength >= 0) {
                    this.remainingContentLength -= n3;
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.remainingContentLength >= 0) {
                this.remainingContentLength -= n3;
            }
            throw throwable;
        }
        return n3;
    }

    public int getRemainingContentLength() {
        return this.remainingContentLength;
    }

    public void endDecoding() throws IOException {
        if (this.chunkedTransfer) {
            if (this.keepAlive && !this.finalChunkSeen) {
                try {
                    long l;
                    while (this.remainingChunkLength > 0) {
                        l = this.in.skip(this.remainingChunkLength);
                        if (l < 0L) {
                            throw new IOException("Could not skip chunk");
                        }
                        this.remainingChunkLength = (int)((long)this.remainingChunkLength - l);
                    }
                    while (!this.finalChunkSeen) {
                        String string = this.readLine();
                        int n = Integer.parseInt(string, 16);
                        if (n < 0) {
                            throw new NumberFormatException("must not be negative");
                        }
                        if (n == 0) break;
                        while (n > 0) {
                            l = this.in.skip(this.remainingChunkLength);
                            if (l < 0L) {
                                throw new IOException("Could not skip chunk");
                            }
                            n = (int)((long)n - l);
                        }
                        this.readLine();
                    }
                }
                catch (Exception exception) {
                    this.close();
                }
            }
        } else if (this.keepAlive) {
            if (this.remainingContentLength > 0) {
                while (this.remainingContentLength > 0) {
                    long l = this.in.skip(this.remainingContentLength);
                    if (l < 0L) {
                        this.close();
                        break;
                    }
                    this.remainingContentLength = (int)((long)this.remainingContentLength - l);
                }
            } else if (this.remainingContentLength < 0) {
                this.close();
            }
        }
        if (this.mode != 0) {
            if (!this.keepAlive) {
                this.close();
            } else {
                this.mode = 1;
            }
        }
    }

    public void setTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("timeouts must be positive.");
        }
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    private void connect() throws IOException {
        SecurityManager securityManager;
        if (this.socket != null) {
            if (this.keepAlive) {
                return;
            }
            this.close();
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(this.hostname, this.port);
        }
        if (this.cachedProxyHost != null) {
            this.socket = new Socket(this.cachedProxyHost, this.cachedProxyPort);
            this.useProxy = true;
        } else {
            final String string = this.getProxyHost();
            if (string != null) {
                final int n = this.getProxyPort();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            HttpClientConnection.this.socket = new Socket(string, n);
                            HttpClientConnection.this.useProxy = true;
                            HttpClientConnection.this.cachedProxyHost = string;
                            HttpClientConnection.this.cachedProxyPort = n;
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.useProxy = false;
                    this.socket = new Socket(InetAddress.getByName(this.hostname), this.port);
                }
            } else {
                this.useProxy = false;
                this.socket = new Socket(InetAddress.getByName(this.hostname), this.port);
            }
        }
        this.socket.setTcpNoDelay(true);
        this.out = new BufferedOutputStream(this.socket.getOutputStream(), 4096);
        this.in = new BufferedInputStream(this.socket.getInputStream(), 4096);
        this.keepAlive = true;
    }

    private void write(String string) throws IOException {
        int n;
        int n2 = 0;
        int n3 = this.asciiBuffer.length;
        for (int i = string.length(); i > 0; i -= n) {
            n = i > n3 ? n3 : i;
            for (int j = 0; j < n; ++j) {
                this.asciiBuffer[j] = (byte)string.charAt(n2++);
            }
            this.out.write(this.asciiBuffer, 0, n);
        }
    }

    private void writeln(String string) throws IOException {
        this.write(string);
        this.out.write(CRLF);
    }

    private String getProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("http.proxyHost"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("proxyHost"));
        }
        return string;
    }

    private int getProxyPort() {
        String string = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("http.proxyPort"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("proxyPort"));
        }
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 80;
    }

    class GetPropertyPrivilegedAction
    implements PrivilegedAction {
        private String property;
        private String defaultValue;

        public GetPropertyPrivilegedAction(String string) {
            this.property = string;
        }

        public GetPropertyPrivilegedAction(String string, String string2) {
            this.property = string;
            this.defaultValue = string2;
        }

        public Object run() {
            return System.getProperty(this.property, this.defaultValue);
        }
    }
}

