/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;

public class OncRpcClientAuthUnix
extends OncRpcClientAuth {
    private int stamp = (int)(System.currentTimeMillis() / 1000L);
    private String machinename;
    private int uid;
    private int gid;
    private int[] gids;
    private byte[] shorthandCred;
    public static final int[] NO_GIDS = new int[0];

    public OncRpcClientAuthUnix(String string, int n, int n2, int[] nArray) {
        this.machinename = string;
        this.uid = n;
        this.gid = n2;
        this.gids = nArray;
    }

    public OncRpcClientAuthUnix(String string, int n, int n2) {
        this(string, n, n2, NO_GIDS);
    }

    protected void xdrEncodeCredVerf(XdrEncodingStream xdrEncodingStream) throws OncRpcException, IOException {
        if (this.shorthandCred == null) {
            if (this.gids.length > 16 || this.machinename.length() > 255) {
                throw new OncRpcAuthenticationException(7);
            }
            xdrEncodingStream.xdrEncodeInt(1);
            int n = 4 + (this.machinename.length() + 7 & 0xFFFFFFFC) + 4 + 4 + this.gids.length * 4 + 4;
            if (n > 400) {
                throw new OncRpcAuthenticationException(7);
            }
            xdrEncodingStream.xdrEncodeInt(n);
            xdrEncodingStream.xdrEncodeInt(this.stamp);
            xdrEncodingStream.xdrEncodeString(this.machinename);
            xdrEncodingStream.xdrEncodeInt(this.uid);
            xdrEncodingStream.xdrEncodeInt(this.gid);
            xdrEncodingStream.xdrEncodeIntVector(this.gids);
        } else {
            xdrEncodingStream.xdrEncodeInt(2);
            xdrEncodingStream.xdrEncodeDynamicOpaque(this.shorthandCred);
        }
        xdrEncodingStream.xdrEncodeInt(0);
        xdrEncodingStream.xdrEncodeInt(0);
    }

    protected void xdrDecodeVerf(XdrDecodingStream xdrDecodingStream) throws OncRpcException, IOException {
        switch (xdrDecodingStream.xdrDecodeInt()) {
            case 0: {
                if (xdrDecodingStream.xdrDecodeInt() == 0) break;
                throw new OncRpcAuthenticationException(7);
            }
            case 2: {
                this.shorthandCred = xdrDecodingStream.xdrDecodeDynamicOpaque();
                if (this.shorthandCred.length <= 400) break;
                throw new OncRpcAuthenticationException(7);
            }
            default: {
                throw new OncRpcAuthenticationException(6);
            }
        }
    }

    protected boolean canRefreshCred() {
        if (this.shorthandCred == null) {
            return false;
        }
        this.shorthandCred = null;
        this.stamp = (int)(System.currentTimeMillis() / 1000L);
        return true;
    }

    public void setStamp(int n) {
        this.stamp = n;
    }

    public int getStamp() {
        return this.stamp;
    }

    public void setMachinename(String string) {
        this.machinename = string;
    }

    public String getMachinename() {
        return this.machinename;
    }

    public void setUid(int n) {
        this.uid = n;
    }

    public int getUid() {
        return this.uid;
    }

    public void setGid(int n) {
        this.gid = n;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGids(int[] nArray) {
        this.gids = nArray;
    }

    public int[] getGids() {
        return this.gids;
    }
}

