/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database.tools;

import fable.framework.database.DerbyDatabase;
import fable.framework.views.FableIOConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class DerbyDumbConsole {
    FableIOConsole sqlConsole;
    RunConsoleThread runConsoleThread = new RunConsoleThread();
    Connection conn = null;

    public DerbyDumbConsole() {
        this.sqlConsole = new FableIOConsole("SQL Console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.sqlConsole});
    }

    public void run() {
        new Thread(this.runConsoleThread).start();
    }

    void executeQuery(String query) {
        if (DerbyDatabase.getDatabase() == null) {
            this.sqlConsole.displayOut("Database is disabled, please enable it in Edit->Preferences->Database and restart application\n");
        } else {
            this.sqlConsole.displayOut("Execute query " + query + "\n");
            try {
                Statement s = this.conn.createStatement();
                ResultSet rs = s.executeQuery(query);
                ResultSetMetaData meta = rs.getMetaData();
                int iColumnCount = meta.getColumnCount();
                this.sqlConsole.displayOut("Results of query " + query + "\n");
                int i = 1;
                while (i <= iColumnCount) {
                    this.sqlConsole.displayOut(String.valueOf(meta.getColumnLabel(i)) + "\t\t");
                    ++i;
                }
                this.sqlConsole.displayOut("\n-------------------------------------------------\n");
                while (rs.next()) {
                    i = 1;
                    while (i <= iColumnCount) {
                        String value = rs.getString(i);
                        this.sqlConsole.displayOut(String.valueOf(value) + "\t\t");
                        ++i;
                    }
                    this.sqlConsole.displayOut("\n");
                }
                rs.close();
                s.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    class RunConsoleThread
    implements Runnable {
        final Runtime runtime = Runtime.getRuntime();
        String outputMessage;

        RunConsoleThread() {
        }

        @Override
        public void run() {
            DerbyDumbConsole.this.conn = DerbyDatabase.getConnection();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)DerbyDumbConsole.this.sqlConsole.getInputStream()));
                String str = "";
                while (str != null) {
                    DerbyDumbConsole.this.sqlConsole.displayOut("sql > ");
                    str = in.readLine();
                    if (str == null) continue;
                    DerbyDumbConsole.this.sqlConsole.displayOut(String.valueOf(str) + "\n");
                    DerbyDumbConsole.this.executeQuery(str);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        @Override
        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int ch;
                while ((ch = outputread.read()) != -1) {
                    DerbyDumbConsole.this.sqlConsole.displayOut(String.valueOf((char)ch));
                }
            }
            catch (IOException iOException) {}
            System.out.println("exit StreamReaderThread() ...");
        }
    }

    public class StreamWriterThread
    extends Thread {
        byte inMessage;
        OutputStream outStream;
        String newline = System.getProperty("line.separator");

        public StreamWriterThread(OutputStream out) {
            this.outStream = out;
        }

        @Override
        public void run() {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)DerbyDumbConsole.this.sqlConsole.getInputStream()));
                String str = "";
                while (str != null) {
                    str = in.readLine();
                    if (str == null) continue;
                    this.outStream.write(str.getBytes());
                    this.outStream.write(this.newline.getBytes());
                    this.outStream.flush();
                }
            }
            catch (IOException iOException) {}
            System.out.println("exit StreamWriterThread() ...");
        }
    }
}

