/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import org.jmol.i18n.GT;

public class Splash
extends Window {
    private Image splashImage;
    private int imgWidth;
    private int imgHeight;
    private static final int BORDERSIZE = 10;
    private static final Color BORDERCOLOR = Color.blue;
    private String status = GT._("Loading...");
    private int textY;
    private int statusTop;
    private static final int STATUSSIZE = 10;
    private static final Color TEXTCOLOR = Color.white;

    public Splash(Frame frame, ImageIcon imageIcon) {
        super(new Frame());
        this.splashImage = imageIcon.getImage();
        this.imgWidth = this.splashImage.getWidth(this);
        this.imgHeight = this.splashImage.getHeight(this);
        this.showSplashScreen();
        frame.addWindowListener(new WindowListener());
    }

    public void showSplashScreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setBackground(BORDERCOLOR);
        int n = this.imgWidth + 20;
        int n2 = this.imgHeight + 20 + 10;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.setBounds(n3, n4, n, n2);
        this.statusTop = 10 + this.imgHeight;
        this.textY = 20 + this.imgHeight + 1;
        this.show();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.splashImage, 10, 10, this.imgWidth, this.imgHeight, this);
        graphics.setColor(BORDERCOLOR);
        graphics.fillRect(10, this.statusTop, this.imgWidth, this.textY);
        graphics.setColor(TEXTCOLOR);
        graphics.drawString(this.status, 10, this.textY);
    }

    public void showStatus(String string) {
        if (string != null) {
            this.status = string;
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(BORDERCOLOR);
            graphics.fillRect(10, this.statusTop, this.imgWidth + 10, this.textY);
            graphics.setColor(TEXTCOLOR);
            graphics.drawString(this.status, 10, this.textY);
        }
    }

    class WindowListener
    extends WindowAdapter {
        WindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            Splash.this.setVisible(false);
            Splash.this.dispose();
        }
    }
}

