/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.views;

import fable.framework.contentProvider.SampleTableContentProvider;
import fable.framework.labelProvider.SampleTablelabelProvider;
import fable.framework.toolbox.Experiment;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.ISampleListener;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.SampleEvent;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import java.util.ArrayList;
import java.util.Vector;
import jep.JepException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FableSampleLoaderView
extends ViewPart {
    public static final String ID = "fable.framework.views.FableSampleLoaderView";
    public static FableSampleLoaderView view;
    private Table table;
    private String[] files;
    private String fileDescription;
    private int numberFiles;
    private Color descriptionColor;
    private String[] selectedFiles;
    private Button selectFilesButton;
    private Shell shell;
    private Display display;
    private StringText stextSampleDirectory;
    String experimentName = "Experiment";
    String sampleName = "Sample";
    String sSampleDirectory;
    private ArrayList<IPropertyChangeListener> array = new ArrayList();
    private ImageDescriptor GifDelete = AbstractUIPlugin.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/delete.gif");
    private ImageDescriptor GifRemove = AbstractUIPlugin.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/subtract.gif");
    private ImageDescriptor GifAdd = AbstractUIPlugin.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/add.gif");
    private Button btnRemoveSelect;
    private Button btnRemoveSample;
    private Sample sample;
    private List listKeys;
    private Button addKeyInTab;
    private Button removeKeyInTable;
    private Vector<String> titles = new Vector();
    private Listener sortListener;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    final Color light_Red = new Color((Device)Display.getCurrent(), 249, 172, 168);
    final Color light_Green = new Color((Device)Display.getCurrent(), 168, 249, 200);
    private TableColumn columnSelected;
    public Text stextExperiment;
    public Text stextSample;
    final Image imgDelete = this.GifDelete.createImage();
    final Image imgadd = this.GifAdd.createImage();
    final Image imgRemove = this.GifRemove.createImage();
    private SampleListener sampleListener;
    private int columnIndexSelected = -1;
    private Vector<Sample> listOfSamples = new Vector();
    private TableViewer sampleTable;
    private SashForm sash;
    private Button chkProcessPrevious;
    private FabioFile f_fabio;
    private int currSelection = 0;

    public FableSampleLoaderView() {
        this.sampleListener = new SampleListener();
        this.sortListener = new Listener(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleEvent(Event e) {
                sortColumn = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getSortColumn();
                currentColumn = (TableColumn)e.widget;
                dir = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    FableSampleLoaderView.access$0(FableSampleLoaderView.this).setSortColumn(currentColumn);
                    dir = 128;
                }
                cols = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getColumns();
                items = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItems();
                column = (TableColumn)e.widget;
                FableSampleLoaderView.access$1(FableSampleLoaderView.this, (TableColumn)e.widget);
                index = 0;
                x = 0;
                while (index == 0 && x < cols.length) {
                    if (cols[x].getText().equals(column.getText())) {
                        index = x;
                        FableSampleLoaderView.access$2(FableSampleLoaderView.this, index);
                    }
                    ++x;
                }
                direction = dir;
                i = 1;
                while (i < items.length) {
                    value1 = items[i].getText(index);
                    j = 1;
                    block4: while (j < i) {
                        block16: {
                            block17: {
                                value2 = items[j].getText(index);
                                try {
                                    block18: {
                                        fValue1 = Float.parseFloat(value1);
                                        fValue2 = Float.parseFloat(value2);
                                        if (direction != 128) break block18;
                                        if (!(fValue1 < fValue2)) break block16;
                                        values = new String[cols.length];
                                        n = 0;
                                        if (true) ** GOTO lbl68
                                    }
                                    if (fValue1 > fValue2) {
                                        values = new String[cols.length];
                                        n = 0;
                                        while (true) {
                                            if (n >= cols.length) {
                                                items[i].dispose();
                                                item = new TableItem(FableSampleLoaderView.access$0(FableSampleLoaderView.this), 0, j);
                                                item.setText(values);
                                                items = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItems();
                                                break block4;
                                            }
                                            values[n] = items[i].getText(n);
                                            ++n;
                                        }
                                    }
                                    break block16;
                                }
                                catch (NumberFormatException v0) {
                                    if (direction != 128) break block17;
                                    if (value1.compareTo(value2) >= 0) break block16;
                                    values = new String[cols.length];
                                    n = 0;
                                    if (true) ** GOTO lbl77
                                }
                            }
                            if (value1.compareTo(value2) <= 0) break block16;
                            values = new String[cols.length];
                            n = 0;
                            if (true) ** GOTO lbl86
                        }
                        ++j;
                        continue;
                        do {
                            values[n] = items[i].getText(n);
                            ++n;
lbl68:
                            // 2 sources

                        } while (n < cols.length);
                        items[i].dispose();
                        item = new TableItem(FableSampleLoaderView.access$0(FableSampleLoaderView.this), 0, j);
                        item.setText(values);
                        items = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItems();
                        break;
                        do {
                            values[n] = items[i].getText(n);
                            ++n;
lbl77:
                            // 2 sources

                        } while (n < cols.length);
                        items[i].dispose();
                        item = new TableItem(FableSampleLoaderView.access$0(FableSampleLoaderView.this), 0, j);
                        item.setText(values);
                        items = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItems();
                        break;
                        do {
                            values[n] = items[i].getText(n);
                            ++n;
lbl86:
                            // 2 sources

                        } while (n < cols.length);
                        items[i].dispose();
                        item = new TableItem(FableSampleLoaderView.access$0(FableSampleLoaderView.this), 0, j);
                        item.setText(values);
                        items = FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItems();
                        break;
                    }
                    ++i;
                }
                FableSampleLoaderView.access$0(FableSampleLoaderView.this).setSortDirection(dir);
                FableSampleLoaderView.access$0(FableSampleLoaderView.this).setSortColumn(column);
                n = 0;
                while (n < FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItemCount()) {
                    FableSampleLoaderView.access$0(FableSampleLoaderView.this).getItem(n).setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : FableSampleLoaderView.this.light_blue);
                    ++n;
                }
                if (FableSampleLoaderView.access$3(FableSampleLoaderView.this) > 1) {
                    FableSampleLoaderView.access$4(FableSampleLoaderView.this).setEnabled(true);
                    return;
                }
                FableSampleLoaderView.access$4(FableSampleLoaderView.this).setEnabled(false);
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        this.display = Display.getCurrent();
        view = this;
        view.setContentDescription("Select sample here");
        this.titles.add(0, "#");
        this.titles.add(1, "Name");
        GridLayout gdL = new GridLayout(1, true);
        parent.setLayout((Layout)gdL);
        this.createInfoExperiment(parent);
        this.createTabListe(parent);
    }

    private void createInfoExperiment(Composite parent) {
        Group experimentInfo = LookAndFeel.getGroup(parent, "Image files to process", 4, 1);
        GridData gd3 = new GridData(4, 16, true, false);
        gd3.horizontalSpan = 3;
        this.stextSampleDirectory = new StringText((Composite)experimentInfo, 4, "Directory");
        this.stextSampleDirectory.set_isRequiredField(true);
        this.stextSampleDirectory.setLayoutData(gd3);
        this.selectFilesButton = new Button((Composite)experimentInfo, 28);
        this.selectFilesButton.setText("Select files...");
        this.selectFilesButton.setEnabled(true);
        this.selectFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("ProcessingView :click on selectFilesButton");
                if (FableSampleLoaderView.this.selectedFiles != null) {
                    FableSampleLoaderView.this.clearAll();
                    FableSampleLoaderView.this.removeAllColumnsAdded();
                    FableSampleLoaderView.this.loadSamples(FableSampleLoaderView.this.selectedFiles);
                    FableSampleLoaderView.this.populateTreeSample();
                    if (FableSampleLoaderView.this.listOfSamples != null && FableSampleLoaderView.this.listOfSamples.size() > 0) {
                        FableSampleLoaderView.this.sample = (Sample)FableSampleLoaderView.this.listOfSamples.elementAt(0);
                        if (FableSampleLoaderView.this.sampleTable.getTable().getItemCount() > 0) {
                            FableSampleLoaderView.this.sampleTable.getTable().setSelection(FableSampleLoaderView.this.sampleTable.getTable().getItem(0));
                            FableSampleLoaderView.this.sampleTable.getTable().notifyListeners(13, new Event());
                        }
                    }
                }
            }
        });
        Label lblExperiment = new Label((Composite)experimentInfo, 0);
        lblExperiment.setText("Experiment:");
        this.stextExperiment = new Text((Composite)experimentInfo, 786440);
        GridData gd1 = new GridData(4, 0, true, false);
        this.stextExperiment.setLayoutData((Object)gd1);
        this.stextExperiment.setBackground(Display.getCurrent().getSystemColor(22));
        this.stextExperiment.setForeground(Display.getCurrent().getSystemColor(16));
        Label lblsSampName = new Label((Composite)experimentInfo, 0);
        lblsSampName.setText("Sample:");
        GridData gd2sTextSample = new GridData(4, 16, true, false);
        this.stextSample = new Text((Composite)experimentInfo, 786440);
        this.stextSample.setLayoutData((Object)gd2sTextSample);
        this.stextSample.setBackground(Display.getCurrent().getSystemColor(22));
        this.stextSample.setForeground(Display.getCurrent().getSystemColor(16));
    }

    private void createTabListe(Composite parent) {
        Group grpListe = LookAndFeel.getGroup(parent, "Files", 4, 1);
        GridData gd2 = new GridData(4, 4, true, true);
        grpListe.setLayoutData((Object)gd2);
        Label lblKey = new Label((Composite)grpListe, 0);
        lblKey.setText("Header Key");
        this.listKeys = new List((Composite)grpListe, 2560);
        GridData gdlist = new GridData(4, 2, true, false);
        gdlist.verticalSpan = 1;
        gdlist.horizontalSpan = 1;
        int listHeigth = this.listKeys.getItemHeight() * 4;
        Rectangle trim = this.listKeys.computeTrim(0, 0, 0, listHeigth);
        gdlist.heightHint = trim.height;
        this.listKeys.setLayoutData((Object)gdlist);
        this.listKeys.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int index = ((List)e.getSource()).getSelectionIndex();
                if (index == -1) {
                    index = 0;
                }
                FableSampleLoaderView.this.addKeyInTab.notifyListeners(13, new Event());
            }
        });
        this.addKeyInTab = new Button((Composite)grpListe, 8);
        this.addKeyInTab.setImage(this.imgadd);
        this.addKeyInTab.setLayoutData((Object)new GridData(1, 2, false, false));
        this.addKeyInTab.setToolTipText("Add selected key in table");
        this.addKeyInTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FableSampleLoaderView.this.addColumn();
                }
                catch (JepException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.addKeyInTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FableSampleLoaderView.this.imgadd != null) {
                    FableSampleLoaderView.this.imgadd.dispose();
                }
            }
        });
        this.removeKeyInTable = new Button((Composite)grpListe, 8);
        this.removeKeyInTable.setImage(this.imgRemove);
        this.removeKeyInTable.setLayoutData((Object)new GridData(1, 2, false, false));
        this.removeKeyInTable.setToolTipText("Remove selected column");
        this.removeKeyInTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FableSampleLoaderView.this.removeColumn();
            }
        });
        this.removeKeyInTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FableSampleLoaderView.this.imgRemove != null) {
                    FableSampleLoaderView.this.imgRemove.dispose();
                }
            }
        });
        this.removeKeyInTable.setEnabled(false);
        this.sash = new SashForm((Composite)grpListe, 256);
        GridData gdExplorer = new GridData(4, 4, true, true);
        gdExplorer.horizontalAlignment = 4;
        gdExplorer.verticalAlignment = 4;
        gdExplorer.horizontalSpan = 4;
        this.sash.setLayoutData((Object)gdExplorer);
        GridData gdTree = new GridData(4, 4, true, true);
        gdTree.horizontalSpan = 1;
        this.sampleTable = new TableViewer((Composite)this.sash, 2048);
        this.sampleTable.setContentProvider((IContentProvider)new SampleTableContentProvider());
        this.sampleTable.setLabelProvider((IBaseLabelProvider)new SampleTablelabelProvider());
        this.sampleTable.getTable().setHeaderVisible(true);
        this.sampleTable.getTable().setLinesVisible(true);
        this.sampleTable.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemAdd = new MenuItem(menu, 8);
                    mitemAdd.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            FableSampleLoaderView.this.btnRemoveSample.notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.sampleTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = ((Table)e.widget).getSelection();
                if (ti != null && ti.length > 0) {
                    FableSampleLoaderView.this.sample = (Sample)ti[0].getData();
                    System.out.println("Selected sample name : " + FableSampleLoaderView.this.sample.getDirectoryName());
                    if (FableSampleLoaderView.this.sample.hasFile()) {
                        FableSampleLoaderView.this.populateFileTable("Files to process (entire directory)", FableSampleLoaderView.this.sample.getFiles());
                        System.out.println("Header key for this sample" + FableSampleLoaderView.this.sample.getDirectoryName() + " has been loaded in the list");
                    } else {
                        FableSampleLoaderView.this.populateFileTable("No files to process found in sample", null);
                    }
                    FableSampleLoaderView.this.populateCombo();
                }
            }
        });
        this.table = new Table((Composite)this.sash, 268503042);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd4 = new GridData(4, 4, true, true);
        gd4.horizontalSpan = 3;
        gd4.verticalIndent = 10;
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3 && FableSampleLoaderView.this.table.getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemAdd = new MenuItem(menu, 8);
                    mitemAdd.setText("Remove from list");
                    mitemAdd.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            FableSampleLoaderView.this.btnRemoveSelect.notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("setInfo");
                FableSampleLoaderView.this.f_fabio = (FabioFile)e.widget.getData();
                FableSampleLoaderView.this.fireCurrentFileHasChanged();
            }
        });
        this.initColumn();
        this.descriptionColor = Display.getCurrent().getSystemColor(1);
        this.btnRemoveSample = new Button((Composite)grpListe, 8);
        GridData gdBtn_s = new GridData(1, 0, true, false);
        gdBtn_s.horizontalSpan = 3;
        this.btnRemoveSample.setLayoutData((Object)gdBtn_s);
        this.btnRemoveSample.setImage(this.imgDelete);
        this.btnRemoveSample.setText("Remove sample");
        this.btnRemoveSample.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FableSampleLoaderView.this.imgDelete != null) {
                    FableSampleLoaderView.this.imgDelete.dispose();
                }
            }
        });
        this.btnRemoveSample.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FableSampleLoaderView.this.removeSelectedSample(FableSampleLoaderView.this.sample);
                if (FableSampleLoaderView.this.sampleTable.getTable().getItemCount() > 0) {
                    FableSampleLoaderView.this.sampleTable.getTable().setSelection(FableSampleLoaderView.this.sampleTable.getTable().getItem(FableSampleLoaderView.this.currSelection));
                    FableSampleLoaderView.this.sampleTable.getTable().notifyListeners(13, new Event());
                } else {
                    FableSampleLoaderView.this.clearFiles();
                }
            }
        });
        this.btnRemoveSelect = new Button((Composite)grpListe, 8);
        GridData gdBtn = new GridData(0x1000008, 0, true, false);
        gdBtn.horizontalSpan = 1;
        this.btnRemoveSelect.setLayoutData((Object)gdBtn);
        this.btnRemoveSelect.setImage(this.imgDelete);
        this.btnRemoveSelect.setText("Remove files");
        this.btnRemoveSelect.setToolTipText("Remove selected files");
        this.btnRemoveSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FableSampleLoaderView.this.removeSelectedFiles();
                FableSampleLoaderView.this.sampleTable.getTable().setSelection(FableSampleLoaderView.this.sampleTable.getTable().getItem(FableSampleLoaderView.this.currSelection));
                FableSampleLoaderView.this.sampleTable.getTable().notifyListeners(13, new Event());
            }
        });
        this.btnRemoveSelect.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FableSampleLoaderView.this.imgDelete != null) {
                    FableSampleLoaderView.this.imgDelete.dispose();
                }
            }
        });
        this.sash.setWeights(new int[]{20, 50});
    }

    private void removeColumn() {
        if (this.columnSelected != null && this.columnIndexSelected > 1 && this.columnIndexSelected < this.table.getColumnCount()) {
            this.columnSelected.dispose();
            this.titles.removeElementAt(this.columnIndexSelected);
            int i = 0;
            while (i < this.titles.size()) {
                this.table.getColumn(i).pack();
                ++i;
            }
        }
    }

    private void removeAllColumnsAdded() {
        int j = 2;
        while (this.table.getColumnCount() > 2) {
            this.table.getColumn(j).dispose();
            this.titles.removeElementAt(j);
        }
        int i = 0;
        while (i < this.titles.size()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void addColumn() throws JepException {
        int index = this.listKeys.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        String newHeader = this.listKeys.getItem(index);
        this.titles.add(newHeader);
        TableColumn column = new TableColumn(this.table, this.table.getStyle());
        column.setText(this.titles.lastElement());
        column.addListener(13, this.sortListener);
        int col = this.titles.size() - 1;
        int i = 0;
        while (i < this.sample.getFiles().length) {
            TableItem item = this.table.getItemCount() > i + 1 ? this.table.getItem(i + 1) : new TableItem(this.table, 0);
            try {
                item.setText(col, this.sample.getFabioFiles().elementAt(i).getValue(this.titles.lastElement()));
            }
            catch (FabioFileException fabioFileException) {
                System.out.println("Error while populate table ");
            }
            ++i;
        }
        this.populateFileTable("Files selected", this.sample.getFiles());
        i = 0;
        while (i < this.titles.size()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void initColumn() {
        int i = 0;
        while (i < this.titles.size()) {
            int style = 0;
            TableColumn column = new TableColumn(this.table, style);
            column.setText(this.titles.elementAt(i));
            column.addListener(13, this.sortListener);
            ++i;
        }
        new TableItem(this.table, 0);
        this.clearFiles();
        i = 0;
        while (i < this.titles.size()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.setSortColumn(this.table.getColumn(1));
        this.table.setSortDirection(1024);
    }

    private void populateCombo() {
        this.listKeys.removeAll();
        if (this.sample.hasFile()) {
            this.listKeys.setEnabled(true);
            this.addKeyInTab.setEnabled(true);
            try {
                String[] list = this.sample.getFabioFiles().elementAt(0).getKeys();
                ToolBox.quicksort(list, 0, list.length);
                this.listKeys.setData("HEADER_KEYS", (Object)list);
                int i = 0;
                while (i < list.length) {
                    this.listKeys.add(list[i]);
                    ++i;
                }
                this.listKeys.select(0);
            }
            catch (FabioFileException e) {
                e.printStackTrace();
            }
            catch (JepException e) {
                e.printStackTrace();
            }
        } else {
            this.listKeys.setEnabled(false);
            this.addKeyInTab.setEnabled(false);
        }
    }

    public static FableSampleLoaderView getDefault() {
        return view;
    }

    public void setFocus() {
    }

    private void populateTreeSample() {
        new Experiment();
        this.sampleTable.setInput((Object)new Experiment(this.listOfSamples));
    }

    public void setSelectedFiles(String[] newFiles) {
        this.descriptionColor = this.light_Green;
        if (newFiles != null && newFiles.length > 0) {
            this.populateFileTable("files selected", newFiles);
        }
    }

    public void setProcessingFiles(String[] newFiles) {
        this.descriptionColor = this.light_Red;
        if (newFiles != null) {
            this.populateFileTable("files being processed", newFiles);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.array.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.array.remove(listener);
    }

    private void fireExperimentInfoChange() {
        this.stextExperiment.setText(this.experimentName);
        this.stextSample.setText(this.sampleName);
        for (IPropertyChangeListener element : this.array) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_selectedFiles", null, (Object)this.selectedFiles));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_directory", null, (Object)this.stextSampleDirectory.getText()));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_sample", null, (Object)this.sampleName));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_experiment", null, (Object)this.experimentName));
        }
    }

    private void fireSelectedFilesHasChange() {
        for (IPropertyChangeListener element : this.array) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_selectedFiles", null, (Object)this.selectedFiles));
        }
    }

    private void fireCurrentFileHasChanged() {
        for (IPropertyChangeListener element : this.array) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_currentFabioFile", null, (Object)this.selectedFiles));
        }
    }

    private void populateFileTable(String description, String[] newFiles) {
        this.fileDescription = description;
        this.files = newFiles;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int i;
                FableSampleLoaderView.this.table.removeAll();
                TableItem item = FableSampleLoaderView.this.table.getItemCount() > 0 ? FableSampleLoaderView.this.table.getItem(0) : new TableItem(FableSampleLoaderView.this.table, 0);
                item.setText(1, FableSampleLoaderView.this.fileDescription);
                item.setBackground(FableSampleLoaderView.this.descriptionColor);
                if (FableSampleLoaderView.this.files != null) {
                    item.setText(0, Integer.toString(FableSampleLoaderView.this.files.length));
                    i = 0;
                    while (i < FableSampleLoaderView.this.files.length) {
                        item = FableSampleLoaderView.this.table.getItemCount() > i + 1 ? FableSampleLoaderView.this.table.getItem(i + 1) : new TableItem(FableSampleLoaderView.this.table, 0);
                        item.setText(0, Integer.toString(i + 1));
                        String[] split = FableSampleLoaderView.this.files[i].split("/");
                        String myname = FableSampleLoaderView.this.files[i];
                        if (split.length > 1) {
                            myname = split[split.length - 1];
                        }
                        item.setText(1, myname);
                        try {
                            FabioFile fabio = FableSampleLoaderView.this.sample.getFabioFiles().elementAt(i);
                            item.setData((Object)fabio);
                            int j = 2;
                            while (j < FableSampleLoaderView.this.titles.size()) {
                                try {
                                    item.setText(j, fabio.getValue((String)FableSampleLoaderView.this.titles.elementAt(j)));
                                }
                                catch (FabioFileException fabioFileException) {
                                    item.setText(j, "NA");
                                    System.out.println("Error while populate table");
                                }
                                ++j;
                            }
                            item.setBackground(i % 2 == 0 ? Display.getCurrent().getSystemColor(1) : FableSampleLoaderView.this.light_blue);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            System.out.println("Error while populate table ");
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < FableSampleLoaderView.this.table.getColumnCount()) {
                    FableSampleLoaderView.this.table.getColumn(i).pack();
                    ++i;
                }
            }
        });
    }

    public void setDescription(int number, String description, final int backgroundColor) {
        if (backgroundColor == 3) {
            this.descriptionColor = this.light_Red;
        } else if (backgroundColor == 5) {
            this.descriptionColor = this.light_Green;
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FableSampleLoaderView.this.descriptionColor = Display.getCurrent().getSystemColor(backgroundColor);
                }
            });
        }
        this.setDescription(number, description);
    }

    public void setDescription(int number, String description) {
        this.numberFiles = number;
        this.fileDescription = description;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem item = FableSampleLoaderView.this.table.getItemCount() > 0 ? FableSampleLoaderView.this.table.getItem(0) : new TableItem(FableSampleLoaderView.this.table, 0);
                item.setText(0, Integer.toString(FableSampleLoaderView.this.numberFiles));
                item.setText(1, FableSampleLoaderView.this.fileDescription);
                item.setBackground(FableSampleLoaderView.this.descriptionColor);
            }
        });
    }

    public void clearFiles() {
        this.fileDescription = "please select file(s) or start online mode";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FableSampleLoaderView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                FableSampleLoaderView.this.table.removeAll();
                TableItem item = FableSampleLoaderView.this.table.getItemCount() > 0 ? FableSampleLoaderView.this.table.getItem(0) : new TableItem(FableSampleLoaderView.this.table, 0);
                item.setText(0, "0");
                item.setText(1, FableSampleLoaderView.this.fileDescription);
            }
        });
    }

    private void resetExperimentInfos() {
        this.sample = null;
        this.stextSample.setText("");
        this.stextExperiment.setText("");
        this.resetCombo();
        this.removeAllColumnsAdded();
    }

    private void resetCombo() {
        this.listKeys.removeAll();
    }

    private void removeSelectedSample(Sample s) {
        this.currSelection = this.listOfSamples.indexOf(s);
        this.listOfSamples.remove(s);
        this.populateTreeSample();
    }

    private void removeSelectedFiles() {
        this.fileDescription = "selected files";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FableSampleLoaderView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                int[] selectionIndices = FableSampleLoaderView.this.table.getSelectionIndices();
                Vector<String> newSelection = new Vector<String>();
                int i = 1;
                while (i < FableSampleLoaderView.this.table.getItemCount()) {
                    boolean bFound = false;
                    int j = 0;
                    while (!bFound && j < selectionIndices.length) {
                        if (selectionIndices[j] != 0 && selectionIndices[j] == i) {
                            bFound = true;
                            FabioFile fabio = (FabioFile)FableSampleLoaderView.this.table.getItem(i).getData();
                            FableSampleLoaderView.this.sample.removeFabioFile(fabio);
                        }
                        ++j;
                    }
                    if (!bFound) {
                        newSelection.add(FableSampleLoaderView.this.table.getItem(i).getText(1));
                    }
                    ++i;
                }
                if (newSelection != null && newSelection.size() >= 0) {
                    FableSampleLoaderView.this.selectedFiles = new String[newSelection.size()];
                    i = 0;
                    while (i < newSelection.size()) {
                        ((FableSampleLoaderView)FableSampleLoaderView.this).selectedFiles[i] = (String)newSelection.elementAt(i);
                        ++i;
                    }
                    FableSampleLoaderView.this.sample.setFiles(FableSampleLoaderView.this.selectedFiles);
                }
                if (FableSampleLoaderView.this.selectedFiles.length == 0) {
                    FableSampleLoaderView.this.clearFiles();
                    FableSampleLoaderView.this.resetExperimentInfos();
                    FableSampleLoaderView.this.removeSelectedSample(FableSampleLoaderView.this.sample);
                } else {
                    FableSampleLoaderView.this.currSelection = FableSampleLoaderView.this.listOfSamples.indexOf(FableSampleLoaderView.this.sample);
                }
                FableSampleLoaderView.this.setSelectedFiles(FableSampleLoaderView.this.selectedFiles);
                FableSampleLoaderView.this.table.deselectAll();
            }
        });
    }

    private void clearAll() {
        if (this.listOfSamples != null) {
            this.listOfSamples.removeAllElements();
        }
        this.sampleTable.getTable().removeAll();
        this.sampleTable.getTable().clearAll();
        this.table.removeAll();
        this.table.clearAll();
        this.resetExperimentInfos();
    }

    private void enableGroupExperiment(final boolean bEnable) {
        if (!this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (bEnable) {
                        FableSampleLoaderView.this.stextSampleDirectory.setBackground(FableSampleLoaderView.this.display.getSystemColor(1));
                    } else {
                        FableSampleLoaderView.this.stextSampleDirectory.setBackground(FableSampleLoaderView.this.display.getSystemColor(22));
                    }
                    FableSampleLoaderView.this.stextSampleDirectory.setEnabled(bEnable);
                    FableSampleLoaderView.this.selectFilesButton.setEnabled(bEnable);
                    FableSampleLoaderView.this.btnRemoveSelect.setEnabled(bEnable);
                    FableSampleLoaderView.this.btnRemoveSample.setEnabled(bEnable);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("SpdView_showRequired")) {
            this.stextSampleDirectory.showrequired();
        }
    }

    public String[] loadSample(String dir) {
        String[] rFile = null;
        if (dir != null && !dir.equals("")) {
            String[] split = dir.split("[\\\\/]");
            if (split.length > 1) {
                this.experimentName = split[split.length - 2];
                this.sampleName = split[split.length - 1];
            } else {
                this.sampleName = split[split.length - 1];
                this.experimentName = "NA";
            }
            String ProcessedFileRegex = String.valueOf(this.sampleName) + "(\\d+)?\\.edf" + "|" + this.sampleName + "\\.(\\d+)?";
            rFile = ToolBox.getFileNamesByEntireRegex(dir, ProcessedFileRegex, true);
            String sep = System.getProperty("file.separator");
            int i = 0;
            while (i < rFile.length) {
                rFile[i] = String.valueOf(dir) + sep + rFile[i];
                ++i;
            }
        }
        return rFile;
    }

    private void setExperimentAndSampleName(String directory) {
        String[] split = directory.split("[\\\\/]");
        int len = split.length;
        if (split != null) {
            switch (len) {
                case 0: {
                    this.experimentName = directory;
                    this.sampleName = directory;
                    break;
                }
                case 1: {
                    this.experimentName = split[0];
                    this.sampleName = split[0];
                    break;
                }
                default: {
                    this.experimentName = split[len - 2];
                    this.sampleName = split[len - 1];
                    break;
                }
            }
        } else {
            this.experimentName = directory;
            this.sampleName = directory;
        }
    }

    private void loadSamples(String[] fileOrDirectory) {
        Sample singleSample = null;
        int fileSize = 0;
        Vector<String> listFiles = null;
        String sep = System.getProperty("file.separator");
        if (this.listOfSamples == null) {
            this.listOfSamples = new Vector();
        } else {
            this.listOfSamples.removeAllElements();
        }
        int i = 0;
        while (i < fileOrDirectory.length) {
            int lastIndexOfSep = fileOrDirectory[i].lastIndexOf(sep);
            int len = fileOrDirectory[i].length();
            fileOrDirectory[i].substring(lastIndexOfSep + 1, len);
            if (ToolBox.checkIfIsDirectory(fileOrDirectory[i])) {
                this.setExperimentAndSampleName(fileOrDirectory[i]);
                try {
                    Sample spl = new Sample(this.experimentName, this.sampleName, fileOrDirectory[i], this.loadSample(fileOrDirectory[i]));
                    this.listOfSamples.add(spl);
                    System.out.println("Create a new Sample for " + fileOrDirectory[i]);
                }
                catch (FabioFileException e) {
                    e.printStackTrace();
                }
            } else {
                if (singleSample == null) {
                    int lastdirIndex = fileOrDirectory[i].lastIndexOf(sep);
                    this.setExperimentAndSampleName(fileOrDirectory[i].substring(0, lastdirIndex));
                    singleSample = new Sample(this.experimentName, this.sampleName, fileOrDirectory[i].substring(0, lastdirIndex));
                    listFiles = new Vector<String>();
                    this.listOfSamples.insertElementAt(singleSample, 0);
                }
                ++fileSize;
                listFiles.add(fileOrDirectory[i]);
            }
            ++i;
        }
        if (listFiles != null) {
            String[] files = new String[listFiles.size()];
            int j = 0;
            while (j < listFiles.size()) {
                files[j] = (String)listFiles.elementAt(j);
                ++j;
            }
            try {
                singleSample.addFabioFiles(files);
            }
            catch (FabioFileException fabioFileException) {
                System.out.println("An error occured while loading files for fabio for this sample " + singleSample.getDirectoryName());
            }
        }
    }

    private void buildSampleName(String filePath) {
        this.sampleName = filePath.substring(0, filePath.indexOf(".") - 4);
    }

    static /* synthetic */ void access$1(FableSampleLoaderView fableSampleLoaderView, TableColumn tableColumn) {
        fableSampleLoaderView.columnSelected = tableColumn;
    }

    static /* synthetic */ void access$2(FableSampleLoaderView fableSampleLoaderView, int n) {
        fableSampleLoaderView.columnIndexSelected = n;
    }

    static /* synthetic */ int access$3(FableSampleLoaderView fableSampleLoaderView) {
        return fableSampleLoaderView.columnIndexSelected;
    }

    static /* synthetic */ Button access$4(FableSampleLoaderView fableSampleLoaderView) {
        return fableSampleLoaderView.removeKeyInTable;
    }

    class SampleListener
    implements ISampleListener {
        SampleListener() {
        }

        @Override
        public void newImages(SampleEvent se) {
            FableSampleLoaderView.this.setProcessingFiles(((Sample)se.getSource()).getFiles());
        }

        @Override
        public void newSample(SampleEvent se) {
        }

        @Override
        public void sampleHasChanged(SampleEvent se) {
        }
    }
}

