/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.ExceptionMessageDialog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SWTUtils {
    public static final String LS = System.getProperty("line.separator");

    public void errMsg(String msg) {
        SWTUtils.errMsg(null, msg);
    }

    public static void errMsg(Shell shell, String msg) {
        MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
    }

    public static void errMsgAsync(String msg) {
        SWTUtils.errMsgAsync(null, msg);
    }

    public static void errMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
            }
        });
    }

    public void warnMsg(String msg) {
        SWTUtils.warnMsg(null, msg);
    }

    public static void warnMsg(Shell shell, String msg) {
        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)msg);
    }

    public static void warnMsgAsync(String msg) {
        SWTUtils.warnMsgAsync(null, msg);
    }

    public static void warnMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)msg);
            }
        });
    }

    public void infoMsg(String msg) {
        SWTUtils.infoMsg(null, msg);
    }

    public static void infoMsg(Shell shell, String msg) {
        MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
    }

    public static void infoMsgAsync(String msg) {
        SWTUtils.infoMsgAsync(null, msg);
    }

    public static void infoMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
            }
        });
    }

    public void excMsg(String msg, Exception ex) {
        SWTUtils.excMsg(null, msg, ex);
    }

    public static void excMsg(Shell shell, String msg, Exception ex) {
        String fullMsg = String.valueOf(msg) + LS + LS + "Exception: " + ex + LS + "Message: " + ex.getMessage();
        MessageDialog.openError((Shell)shell, (String)"Exception", (String)fullMsg);
    }

    public static void excMsgAsync(String msg, Exception ex) {
        SWTUtils.excMsgAsync(null, msg, ex);
    }

    public static void excMsgAsync(final Shell shell, String msg, Exception ex) {
        final String fullMsg = String.valueOf(msg) + LS + LS + "Exception: " + ex + LS + "Message: " + ex.getMessage();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Exception", (String)fullMsg);
            }
        });
    }

    public void excTraceMsg(String msg, Exception ex) {
        SWTUtils.excTraceMsg(null, msg, ex);
    }

    public static void excTraceMsg(Shell shell, String msg, Exception ex) {
        ExceptionMessageDialog.openException(shell, "Exception", msg, ex);
    }

    public static void excTraceMsgAsync(String msg, Exception ex) {
        SWTUtils.excTraceMsgAsync(null, msg, ex);
    }

    public static void excTraceMsgAsync(final Shell shell, final String msg, final Exception ex) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExceptionMessageDialog.openException(shell, "Exception", msg, ex);
            }
        });
    }

    public static String convertText(String string) {
        String delimiter = Text.DELIMITER;
        if (delimiter.equals(LS)) {
            return string;
        }
        String out = "";
        char lf = '\n';
        char cr = '\r';
        char prev = '\u0000';
        int len = string.length();
        int i = 0;
        while (i < len) {
            char chr = string.charAt(i);
            char val = chr;
            out = val != lf ? String.valueOf(out) + chr : (i > 0 ? ((prev = string.charAt(i - 1)) == cr ? String.valueOf(out) + chr : String.valueOf(out) + delimiter) : String.valueOf(out) + delimiter);
            ++i;
        }
        return out;
    }

    public void createFileFromIFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            IPath path = fileHandle.getFullPath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int numSegments = path.segmentCount();
            if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                int i = numSegments - 2;
                while (i > 0) {
                    IFolder folder = root.getFolder(path.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, monitor);
                    }
                    --i;
                }
            }
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void enableControlTree(Control control, boolean enabled) {
        if (control == null) {
            return;
        }
        if (control instanceof Composite) {
            Control[] controls;
            Composite composite = (Composite)control;
            Control[] controlArray = controls = composite.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control1 = controlArray[n2];
                SWTUtils.enableControlTree(control1, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }
}

