/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerRepository;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.console.ConsolePlugin;

public class TestMenu {
    static MenuManager createTestMenu() {
        MenuManager testMenu = new MenuManager("Test");
        testMenu.add((IAction)TestMenu.createExceptionTestAction());
        testMenu.add((IAction)TestMenu.createLoggingTestAction());
        if (testMenu.getItems().length > 0) {
            return testMenu;
        }
        return null;
    }

    private static Action createConsoleTestAction() {
        ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println("Exist: FableMessageConsole.console: " + FableMessageConsole.console);
        final FableMessageConsole console1 = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        System.out.println("getConsoles[0]: console1: " + console1);
        final FableMessageConsole console2 = new FableMessageConsole("Console 2");
        System.out.println("Created: console2: " + console2);
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println();
        Action action = new Action("Test Console"){

            public void run() {
                String msg = "FableMessageConsole: " + FableMessageConsole.console;
                System.out.println(msg);
                FableMessageConsole.console.displayInfo(msg);
                msg = "console1: " + console1;
                System.out.println(msg);
                console1.displayInfo(msg);
                msg = "console2: " + console2;
                System.out.println(msg);
                console2.displayInfo(msg);
            }
        };
        return action;
    }

    private static Action createExceptionTestAction() {
        Action action = new Action("Test Exception Messages"){

            public void run() {
                try {
                    Double.parseDouble("garbage");
                }
                catch (NumberFormatException ex) {
                    SWTUtils.excTraceMsgAsync((String)"This operation has encountered an error", (Exception)ex);
                    SWTUtils.excMsgAsync((String)"This operation has encountered an error", (Exception)ex);
                    SWTUtils.errMsgAsync((String)("This operation has encountered an error\n" + ex + "\n" + ex.getMessage()));
                }
            }
        };
        return action;
    }

    private static Action createLoggingTestAction() {
        Action action = new Action("Test Logging"){

            public void run() {
                Logger logger = FableLogger.getLogger();
                System.out.println("\nMain Logger");
                URL url = logger.getClass().getResource("/log4j.properties");
                this.printLoggerInfo(logger);
                System.out.println("Properties URL=" + url);
                System.out.println("  path=" + url.getPath());
                System.out.println("  file=" + url.getFile());
                System.out.println("  protocol=" + url.getProtocol());
                System.out.println("  contents=");
                try {
                    InputStream is = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    System.out.println("-------------------------------------");
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                    System.out.println("-------------------------------------");
                }
                catch (IOException iOException) {
                    System.err.println("Cannot open input stream for " + url);
                }
                String[] props = new String[]{"log4j.rootLogger", "log4j.appender.default", "log4j.appender.default.layout", "log4j.appender.default.layout.ConversionPattern"};
                int i = 0;
                while (i < props.length) {
                    String val = System.getProperty(props[i], "Not found");
                    System.out.println(String.valueOf(props[i]) + "=" + val);
                    ++i;
                }
                System.out.println("\nTests");
                logger.info((Object)"Info test fable logger");
                logger.warn((Object)"Warning test fable logger");
                logger.error((Object)"Error test fable logger");
                System.out.printf("\nClass Logger (%s)\n", ((Object)((Object)this)).getClass().toString());
                logger = FableLogger.getLogger(((Object)((Object)this)).getClass());
                this.printLoggerInfo(logger);
                System.out.println("\nTests");
                logger.info((Object)"Info test fable class logger");
                logger.warn((Object)"Warning test fable class logger");
                logger.error((Object)"Error test fable class logger");
                logger = Logger.getRootLogger();
                System.out.printf("\nRoot Logger\n", new Object[0]);
                this.printLoggerInfo(logger);
            }

            private void printLoggerInfo(Logger logger) {
                System.out.println("logger=" + logger);
                System.out.println("name=" + logger.getName());
                System.out.println("level=" + logger.getLevel());
                System.out.println("effectiveLevel=" + logger.getEffectiveLevel());
                System.out.println("Appenders for " + logger.getName());
                Enumeration e = logger.getAllAppenders();
                while (e.hasMoreElements()) {
                    Appender appender = (Appender)e.nextElement();
                    System.out.println("  name=" + appender.getName());
                    System.out.println("  class=" + appender.getClass());
                    Layout layout = appender.getLayout();
                    System.out.println("    layout class=" + layout.getClass());
                    System.out.println("    layout content type=" + layout.getContentType());
                    System.out.println("    layout header=" + layout.getHeader());
                    System.out.println("    layout footer=" + layout.getFooter());
                    if (!(layout instanceof PatternLayout)) continue;
                    System.out.println("    layout conversion pattern=" + ((PatternLayout)layout).getConversionPattern());
                }
                System.out.println("Repository");
                LoggerRepository repos = logger.getLoggerRepository();
                System.out.println("threshold=" + repos.getThreshold());
                System.out.println("Current loggers");
                e = repos.getCurrentLoggers();
                while (e.hasMoreElements()) {
                    Logger l = (Logger)e.nextElement();
                    System.out.println("  " + l.getName());
                }
            }
        };
        return action;
    }
}

