package fable.framework.navigator.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

import fable.framework.navigator.Activator;
import fable.framework.internal.*;


/***
 * 
 * @author SUCHET
 * This is the default extension for fabio files.
 *     'edf'    : ['edf'],
 *     'cor'    : ['edf'],
 *     'pnm'    : ['pnm'],
 *     'pgm'    : ['pnm'],
 *     'pbm'    : ['pnm'],
 *     'tif'    : ['tif'],
 *     'tiff'   : ['tif'],
 *     'img'    : ['adsc','OXD'],
 *     'mccd'   : ['marccd'],
 *     'mar2300': ['mar345'],
 *     'sfrm'   : ['bruker100'],
 *     'msk'    : ['fit2dmask'],
 *     
 *              
 *
 */
public class SampleNavigatorPreferencesInitializer extends
		AbstractPreferenceInitializer {
	IEclipsePreferences default_pref = new DefaultScope().getNode(Activator.PLUGIN_ID);
	
	public SampleNavigatorPreferencesInitializer() {
		super();
	}

	@Override
	public void initializeDefaultPreferences() {
		Preferences preferences = Activator.getDefault().getPluginPreferences();
		preferences.setDefault(SampleNavigatorPreferences.FILE_TYPE, default_pref.get(SampleNavigatorPreferences.FILE_TYPE, IVarKeys.FABIO_TYPES));
		preferences.setDefault(SampleNavigatorPreferences.STEM_NAME, default_pref.get(SampleNavigatorPreferences.STEM_NAME, ""));
		preferences.setDefault(SampleNavigatorPreferences.FIX_COLUMN_SIZE, default_pref.getBoolean(SampleNavigatorPreferences.FIX_COLUMN_SIZE, false));

	}

}
