import sys
import numpy as N

from Fabric import integrateclass
from optparse import OptionParser


def get_options(parser):
    parser.add_option("-n", "--stem", action="store",
                      dest="stem", type="string",
                      help="Stem of the harvest files")
    parser.add_option("-D", "--dir", action="store",
                      dest="direc", type="string",default='.',
                      help="directory of the harvest files")
    parser.add_option("-g", "--grain", action="store",
                      dest="grainno", type="int",default=0,
                      help="Grain number")
    parser.add_option("-r", "--reflection", action="store",
                      dest="reflno", type="int",default=0,
                      help="Reflection number")
    parser.add_option("-f", "--filter_lp", action="store",
                      dest="LP_lim", type="float",default=N.inf,
                      help="Filter out reflections with a higher LP factor")
    parser.add_option("-d", "--debug", action="store_true",
                      dest="debug",default =False,
                      help="Run in debug mode")
    options , args = parser.parse_args()
    return options

def run(options):
    if options.stem == None:
        raise ValueError, "\nNo stem (part of file name before the file number) provided [-n stem]\n"

    int = integrateclass.integrate(direc=options.direc,stem=options.stem,grainno=options.grainno)
    int.read_data()
    int.run()
    int.filter(LP_limit=options.LP_lim)
    int.save()
