package fable.framework.xmlparser.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.FloatTextAppender;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.xmlparser.Activator;
import fable.framework.xmlparser.internal.IOptions;
import fable.framework.xmlparser.internal.IVarKeys;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;

/**
 * This class is used in a view to build fields based on Xmloptions vector. Use
 * create to build fields in a dynamical way in the createPartContent of your
 * view part.<br>
 * <br>
 * A field is an instance of TypedText. TypedText has ControlDecorations and can
 * be checked for validity. The fields support Drag&Drop. These are the fields.
 * <ul>
 * <li>XML_OPTION_FILE</li>
 * <li>XML_OPTION_INT</li>
 * <li>XML_OPTION_FLOAT</li>
 * <li>XML_OPTION_STRING</li>
 * <li>XML_OPTION_OUTFILE</li>
 * <li>XML_OPTION_OUTSTEM</li>
 * <li>XML_OPTION_WORKDIR</li>
 * </ul>
 * The Controls that are not TypedText are:
 * <ul>
 * <li>XML_OPTION_CHECK</li>
 * <li>XML_OPTION_CHOICE</li>
 * </ul>
 * The "vary" attribute is not currently used.<br>
 * <br>
 * 
 * Comment: The use of the options as currently implemented is flawed. The
 * current XML file is a configuration file which not only has the value and the
 * default value, but also GUI information about what type of Control to use,
 * help text, and more. The user needs to save this file to save his input
 * values. However, the only information that needs to be saved for the user is
 * the values, not the defaults and configuration. The configuration is only of
 * interest to the GUI and all of the information besides the values should be
 * somewhere else. This represents a bad example of mixing up the model (values)
 * and the view (the configuration).<br>
 * <br>
 * 
 * Comment: In addition when storing the options, the default values are set to
 * the current values. This causes any previous defaults to be lost. On reading
 * the file, the current values are set to the default values, not the values.
 * The net result is that only the default values are important and the
 * distinction between those and the values is lost. The defaults should
 * probably be obtained from peaksearch.py, and the values should be treated as
 * the defaults are now; that is, the data that is saved and restored.<br>
 * <br>
 * 
 * Comment: A vector of options, Vector<Xmloption> options, appears here and
 * independently in Peaksearch. It would be better practice to have only one
 * copy of this vector instead of transfering values back and forth.<br>
 * <br>
 * 
 * @author SUCHET
 * @date 20/12/2007
 */

public class Options implements IOptions, IPropertyChangeListener {
	/**
	 * This is a regular expression for String fields and file path : that means
	 * no punctuation allowed except file separator : and / or \.
	 */
	final static String ALPHANUM_FILESPARATOR = "[\\p{Punct}&&[^_/:\\\\]]";
	/** This is the main container that will contains all fields. */
	private Composite mainComposite;
	/***/
	private Vector<Group> listGroup;
	/** a vector with options. */
	private Vector<Xmloption> options;

	/** This is <code>ImageDescriptor</code> for stop button. */
	private ImageDescriptor imagePause = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/stop.gif");
	/** This is <code>ImageDescriptor</code> for launch button. */
	private ImageDescriptor imagePlay = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/e_forward.gif");
	/** This is <code>ImageDescriptor</code> for revert button. */
	private ImageDescriptor imageRevert = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/revert.gif");

	/** Image play when program is not running. */
	final Image imgplay = imagePlay.createImage();
	/** Image pause for button once program is running. */
	final Image imgPause = imagePause.createImage();
	/** Image revert for revert button. */
	final Image imgRevert = imageRevert.createImage();

	private ArrayList<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
	/** This is run button */
	private Button btnRun;
	/** The current field (instanceof TypedText) that has an error. */
	private TypedText currentErrorField = null;
	/**
	 * The current path used in FileDialog's and DirectoryDialog's. Is typically
	 * is reset to the last directory used. It could be initialized to user.dir.
	 * or null. If initialized to null, then the OS will use what it remembers,
	 * probably no worse.
	 */
	// private String currentPath = System.getProperty("user.dir");
	private String currentPath = null;
	private DropTargetListener dropTargetListener;
	private boolean isRunning = false;

	/**
	 * Constructor.
	 * 
	 * @param parent
	 * @param options
	 * @throws XmlParserException
	 */
	public Options(Composite parent, Vector<Xmloption> options)
			throws XmlParserException {
		this.options = options;

		// Create a drop target listener
		dropTargetListener = new DropTargetListener() {
			public void dragEnter(DropTargetEvent event) {
				if (event.detail == DND.DROP_DEFAULT) {
					if ((event.operations & DND.DROP_COPY) != 0) {
						event.detail = DND.DROP_COPY;
					} else {
						event.detail = DND.DROP_NONE;
					}
				}
			}

			public void dragLeave(DropTargetEvent event) {

			}

			public void dragOperationChanged(DropTargetEvent event) {

			}

			public void dragOver(DropTargetEvent event) {
				// Provides visual feedback
				event.feedback = DND.FEEDBACK_SELECT | DND.FEEDBACK_SCROLL;
			}

			public void drop(DropTargetEvent event) {
				// if any text was dropped
				if (TextTransfer.getInstance().isSupportedType(
						event.currentDataType)) {
					// get the drop data
					DropTarget target = (DropTarget) event.widget;
					// Adapt text with drag and drop of ImageViewer
					TypedText txt = (TypedText) target.getControl();
					String data = (String) event.data;
					String[] split = data.split("\\s+");
					String draggedText = "";
					if (split.length > 2) {
						draggedText = split[2];
					}
					Xmloption option = (Xmloption) txt.getData();
					if (option != null) {
						String name = option.getOption();
						if (name.equals(IVarKeys.XML_STEM)) {
							draggedText = ToolBox.getStem(draggedText);
						} else if (name.equals(IVarKeys.XML_FILEFORMAT)) {
							draggedText = "."
									+ ToolBox.getFileType(draggedText);
						} else if (name.equals(IVarKeys.XML_FIRST_FILE)
								|| name.equals(IVarKeys.XML_LAST_FILE)) {
							draggedText = ToolBox.getFileNumber(draggedText);
						}
					}
					txt.set_Text(draggedText);
					fireFieldModified(
							((Xmloption) (txt.getData())).getOption(), txt
									.getText());
				}
			}

			public void dropAccept(DropTargetEvent event) {

			}
		};

		// Create the controls
		createControls(parent);

		// Set the values in the options
		setOptions();

		// Set enabled/disabled fields
		updateControls(mainComposite.getChildren());
	}

	/**************************************************************************/
	// Controls
	/**************************************************************************/

	/**
	 * Checks TypedText children of the specified parent for validity and
	 * recurses for other Composite children (includes Group). Otherwise returns
	 * the specified bok. This logic of specifying the bok as input should be
	 * reexamined (or explained).<br>
	 * <br>
	 * Change 01/21/2009:<br>
	 * If user has created a directory for example, a field that was in error
	 * should not be an error. So I change:<br>
	 * <code>((TypedText) element[i]).is_bValide()</code><br>
	 * for:<br>
	 * <code>((TypedText) element[i]).checkValue(((TypedText) element[i]).getText()</code>
	 * 
	 * @param parent
	 *            The parent of field to check.
	 * @param bok
	 *            Input value that is returned if no children of the parent are
	 *            Compositie or TypedText.
	 * @return true if all fields are valid. That means required fields are
	 *         filled and typed fields have right values.
	 */
	public boolean checkFields(Composite parent, boolean bok) {
		// TODO This function should just determine bok, not have it be given as
		// an input.
		currentErrorField = null;
		Control[] element = parent.getChildren();
		for (int i = 0; bok && i < element.length; i++) {
			if (element[i] instanceof Composite) {
				if (element[i] instanceof TypedText
						&& !((TypedText) element[i])
								.checkValue(((TypedText) element[i]).getText())
						&& ((TypedText) element[i]).getTextField().isEnabled()) {
					bok = false;
					currentErrorField = (TypedText) element[i];
					currentErrorField.showDecoration();
					// currentErrorField.showError();
					// currentErrorField.showrequired();
				} else if (element[i] instanceof Composite) {
					bok = checkFields((Composite) element[i], bok);
				}
			}
		}
		return bok;
	}

	/**************************************************************************/
	// Widgets instantiation
	/**************************************************************************/

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#create(org.eclipse.swt.widgets
	 * .Composite)
	 */
	public void createControls(Composite parent) throws XmlParserException {
		mainComposite = new Composite(parent, SWT.FILL | SWT.RESIZE);
		GridLayout layout = new GridLayout(1, false);
		// Save some real estate
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		mainComposite.setLayout(layout);

		// END OF SCROLLING CODE

		/********************************************************************/
		listGroup = new Vector<Group>();
		// HashMap<String, Group> hashGroup = new HashMap<String, Group>();
		/********************************************************/
		/*
		 * Group vary = new Group(mainComposite, SWT.FILL );
		 * 
		 * vary.setLayout(new GridLayout(3, false)); GridData gd1 = new
		 * GridData( SWT.FILL, SWT.RESIZE, true, false);
		 * 
		 * vary.setLayoutData(gd1); vary.setText("Variable options");
		 * 
		 * Group common = new Group(mainComposite, SWT.FILL); GridData gd2 = new
		 * GridData( SWT.FILL, SWT.RESIZE, true, false);
		 * 
		 * common.setLayout(new GridLayout(3, false));
		 * common.setLayoutData(gd2); common.setText("Common options");
		 */
		Group global = new Group(mainComposite, SWT.FILL);
		GridData gd2 = new GridData(SWT.LEFT, SWT.RESIZE, true, false);
		global.setLayout(new GridLayout(3, false));
		global.setLayoutData(gd2);
		global.setText("PeakSearch Options");

		// Create the controls for each option
		if (options != null) {
			for (Xmloption opt : options) {
				createControlsForOption(global, opt);
			}
		}

		// Create the buttons at the bottom.
		// KE: Formerly these buttons were created then set to be not visible.
		// They are now created in createButtons, and we don't call it.
		// TODO Either don't create these buttons or remove the code
		// if (false) {
		// createButtons();
		// }

		// Update
		updateControls(null);
	}

	/**
	 * Creates the controls for the given option depending on its type. Sets the
	 * widget data to be the option, and sets widget properties for "default"
	 * and "action". Sets the current displayed value to be the default value.
	 * 
	 * @param group
	 *            The parent group.
	 * @param opt
	 *            The option for which to create the controls.
	 * @throws XmlParserException
	 */
	private void createControlsForOption(Group group, Xmloption opt)
			throws XmlParserException {
		/*
		 * String groupName = opt.getGroup();
		 * if(!hashGroup.containsKey(groupName)){ Group group = new
		 * Group(mainComposite, SWT.FILL); GridData gdGroup = new GridData(
		 * SWT.FILL, SWT.RESIZE, true, false); group.setLayout(new GridLayout(3,
		 * false)); group.setLayoutData(gdGroup); group.setText(groupName);
		 * hashGroup.put(groupName, group); }
		 */
		/*
		 * group = hashGroup.get(groupName); if(opt.vary()){ group=vary; }else{
		 * group=common; }
		 */
		String type = opt.getType();
		// String help = opt.getHelp();
		String name = opt.getOption();
		String labelName = String.valueOf(name.toLowerCase().charAt(0))
				.toUpperCase()
				+ name.toLowerCase().substring(1, name.length());

		if (type.equals(IVarKeys.XML_OPTION_FILE)
				|| type.equals(IVarKeys.XML_OPTION_STRING)
				|| type.equals(IVarKeys.XML_OPTION_INT)
				|| type.equals(IVarKeys.XML_OPTION_FLOAT)
				|| type.equals(IVarKeys.XML_OPTION_OUTFILE)
				|| type.equals(IVarKeys.XML_OPTION_OUTSTEM)
				|| type.equals(IVarKeys.XML_OPTION_WORKDIR)) {
			// Create the label
			Label label = new Label(group, SWT.None);
			label.setText(labelName);

			// Create the appropriate TypedText or null if not TypedText
			final TypedText txt;
			if (type.equals(IVarKeys.XML_OPTION_FILE)) {
				txt = new FileText(group, SWT.NONE, "");
			} else if (type.equals(IVarKeys.XML_OPTION_STRING)
					|| type.equals(IVarKeys.XML_OPTION_OUTFILE)) {
				txt = new StringText(group, SWT.NONE, "");
			} else if (type.equals(IVarKeys.XML_OPTION_OUTSTEM)) {
				// TODO KE: This disallows things like _ and - and is
				// too restrictive. Probably ALPHANUM_FILESPARATOR could
				// be fixed.
				// txt = new StringText(group, SWT.NONE, "",
				// ALPHANUM_FILESPARATOR, "No punctuation allowed");
				txt = new StringText(group, SWT.NONE, "");
			} else if (type.equals(IVarKeys.XML_OPTION_WORKDIR)) {
				// TODO KE: This disallows things like _ and - and is
				// too restrictive. Probably ALPHANUM_FILESPARATOR could
				// be fixed.
				// txt = new StringText(group, SWT.NONE, "",
				// ALPHANUM_FILESPARATOR, "No punctuation allowed");
				txt = new StringText(group, SWT.NONE, "");
			} else if (type.equals(IVarKeys.XML_OPTION_INT)) {
				txt = new IntegerText(group, SWT.None, "");
			} else if (type.equals(IVarKeys.XML_OPTION_FLOAT)) {
				if (opt.getAction().equals("append")) {
					txt = new FloatTextAppender(group, SWT.None, "", ",");
				} else {
					txt = new FloatText(group, SWT.None, "");
				}
			} else {
				// XML_OPTION_CHECK, XML_OPTION_CHOICE
				txt = null;
			}

			// Handle TypedText
			if (txt != null) {
				txt.setToolTipText(opt.getHelp());
				txt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
						false, 2, 1));

				if (type.equals(IVarKeys.XML_OPTION_FILE)) {
					Button btn_browse = new Button(group, SWT.PUSH);
					((GridData) txt.getLayoutData()).horizontalSpan = 1;
					btn_browse.setLayoutData(new GridData(SWT.BEGINNING,
							SWT.CENTER, false, false, 1, 1));
					btn_browse.setText("Browse...");
					btn_browse.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							FileDialog dlg = new FileDialog(((Button) e.widget)
									.getParent().getShell(), SWT.SIMPLE);
							String filterPath = getFilterPath(txt);
							dlg.setFilterPath(filterPath);
							String sFile = dlg.open();
							if (sFile != null) {
								txt.set_Text(sFile);
								// Reset the currentPath
								setCurrentPath(sFile);
							}
						}
					});
				} else if (type.equals(IVarKeys.XML_OPTION_OUTFILE)) {
					Button btn_browse = new Button(group, SWT.PUSH);
					((GridData) txt.getLayoutData()).horizontalSpan = 1;

					btn_browse.setLayoutData(new GridData(SWT.BEGINNING,
							SWT.CENTER, false, false, 1, 1));
					btn_browse.setText("Directory...");
					btn_browse.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							FileDialog dlg = new FileDialog(((Button) e.widget)
									.getParent().getShell(), SWT.SAVE);
							String filterPath = getFilterPath(txt);
							dlg.setFilterPath(filterPath);
							String fileName = dlg.open();
							boolean done = false;
							if (fileName != null) {
								// Reset the currentPath
								setCurrentPath(fileName);
								File file = new File(fileName);
								if (file.exists()) {
									MessageBox mb = new MessageBox(dlg
											.getParent(), SWT.ICON_WARNING
											| SWT.YES | SWT.NO);
									mb.setMessage(fileName
											+ " already exists. "
											+ "Do you want to overwrite it?");
									done = mb.open() == SWT.YES;
								} else {
									done = true;
								}
								if (done) {
									txt.set_Text(fileName);
									fireFieldModified(((Xmloption) (txt
											.getData())).getOption(), txt
											.getText());
								}
							}
						}
					});
				} else if (type.equals(IVarKeys.XML_OPTION_OUTSTEM)) {
					Button btn_browse = new Button(group, SWT.PUSH);
					((GridData) txt.getLayoutData()).horizontalSpan = 1;
					btn_browse.setLayoutData(new GridData(SWT.BEGINNING,
							SWT.CENTER, false, false, 1, 1));
					btn_browse.setText("Directory...");
					btn_browse.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							DirectoryDialog dlg = new DirectoryDialog(
									((Button) e.widget).getParent().getShell(),
									SWT.SAVE);
							String filterPath = getFilterPath(txt);
							dlg.setFilterPath(filterPath);
							String sdir = dlg.open();
							if (sdir != null) {
								setCurrentPath(sdir);
								String stem = txt.getText();
								int indexOfpath = stem.lastIndexOf(System
										.getProperty("file.separator"));
								if (indexOfpath >= 0) {
									indexOfpath += 1;
									if (indexOfpath < stem.length()) {
										stem = stem.substring(indexOfpath);
									}
								}
								String text = sdir
										+ System.getProperty("file.separator")
										+ stem;
								txt.set_Text(text);
								fireFieldModified(((Xmloption) (txt.getData()))
										.getOption(), txt.getText());
							}
						}
					});
				} else if (type.equals(IVarKeys.XML_OPTION_WORKDIR)) {
					Button btn_browse = new Button(group, SWT.PUSH);
					((GridData) txt.getLayoutData()).horizontalSpan = 1;

					btn_browse.setLayoutData(new GridData(SWT.BEGINNING,
							SWT.CENTER, false, false, 1, 1));
					btn_browse.setText("Directory...");
					btn_browse.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							DirectoryDialog dlg = new DirectoryDialog(
									((Button) e.widget).getParent().getShell(),
									SWT.SAVE);
							String filterPath = getFilterPath(txt);
							dlg.setFilterPath(filterPath);
							String dir = dlg.open();
							if (dir != null) {
								txt.set_Text(dir);
								setCurrentPath(dir);
								fireFieldModified(((Xmloption) (txt.getData()))
										.getOption(), txt.getText());
							}
						}
					});
				}

				// Add drop target and listener
				DropTarget target = new org.eclipse.swt.dnd.DropTarget(txt,
						DND.DROP_COPY | DND.DROP_DEFAULT);
				target.setTransfer(new TextTransfer[] { TextTransfer
						.getInstance() });
				target.addDropListener(dropTargetListener);

				// Set the data and properties
				try {
					// Use the default value here, not the value
					String defVal = opt.getDefaultValue();
					txt.set_Text(defVal);
					txt.setData(opt);
					txt.setData("default", defVal);
					txt.setData("option", opt.getOption());
				} catch (NumberFormatException ex) {
					FableUtils.excNoTraceMsg(this,
							"Error setting TextField data", ex);
				}
				if (opt.isRequired()) {
					txt.set_isRequiredField(true);
				}
				if (!opt.isEnabled()) {
					txt.setEnabled(false);
				}

				/*
				 * txt.getTextField().addFocusListener(new FocusAdapter() {
				 * 
				 * public void focusLost(FocusEvent e) {
				 * 
				 * fireFieldModified(((Xmloption) (txt.getData())) .getOption(),
				 * txt.getText());
				 * 
				 * }; });
				 */
				txt.getTextField().addKeyListener(new KeyAdapter() {
					@Override
					public void keyPressed(KeyEvent e) {
						if (e.keyCode == SWT.CR || e.keyCode == SWT.KEYPAD_CR) {
							fireFieldModified(((Xmloption) (txt.getData()))
									.getOption(), txt.getText());
						}
					}
				});
				txt.getTextField().addModifyListener(new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						fireFieldModified(((Xmloption) (txt.getData()))
								.getOption(), txt.getText());
					}
				});
			}
		} else if (type.equals(IVarKeys.XML_OPTION_CHOICE)) {
			String choices = opt.getChoices().replaceAll("\\(", "").trim();
			String[] listChoice = choices.split("\\)");
			GridData gdForCbo = new GridData(SWT.LEFT, GridData.CENTER, true,
					false, 3, 1);

			// listchoice.length must be greater than 1. If it is < 4, then
			// radio buttons are used, otherwise a combo is used.
			if (listChoice.length < 2) {
				FableUtils.errMsg(this,
						"CHOICE option has fewer than two choices: "
								+ labelName);
			} else if (listChoice.length < 4) {
				// Use a group of radio buttons
				Group radioGroup = new Group(group, SWT.NONE);
				radioGroup.setText(labelName);
				radioGroup.setToolTipText(opt.getHelp());
				radioGroup.setLayout(new GridLayout(listChoice.length, false));
				radioGroup.setLayoutData(gdForCbo);
				for (int nb = 0; nb < listChoice.length; nb++) {
					Button btn_rd = new Button(radioGroup, SWT.RADIO);
					btn_rd.addSelectionListener(new SelectionAdapter() {
						@Override
						public void widgetSelected(SelectionEvent e) {
							// TODO Is this necessary. It isn't used by other
							// controls
							updateControls(null);
							// Xmloption opt = (Xmloption) btn.getData();
							// if (opt != null) {
							// if (btn.getSelection()) {
							// String val = (String) btn.getData(btn
							// .getText());
							// opt.setValue(val);
							// }
							// }
						}
					});
					btn_rd.setLayoutData(new GridData());
					btn_rd.setSelection(opt.getDefaultValue().equals(
							listChoice[nb].replaceAll(" ", "")));
					String[] labelAndValue = listChoice[nb].split(",");
					if (labelAndValue != null && labelAndValue.length == 2) {
						btn_rd.setData("option", opt.getOption());
						btn_rd.setData(opt);
						btn_rd.setData(labelAndValue[0], labelAndValue[1]);
						btn_rd.setData("value", labelAndValue[1]);
						btn_rd.setData("default", opt.getDefaultValue());
						if (opt.getDefaultValue() != null) {
							btn_rd.setSelection(opt.getDefaultValue().equals(
									labelAndValue[1]));
						}
						btn_rd.setText(labelAndValue[0]);
					} else {
						throw new XmlParserException(0, this.getClass()
								.getName(), "create(Composite parent)",
								"Input xml file not properly set for "
										+ labelName);
					}
				}
				radioGroup.setData(opt);
				radioGroup.setData("option", opt.getOption());
			} else {
				// Use a combo (KE: Apparently never used)
				Combo cbo = new Combo(group, SWT.READ_ONLY | SWT.DROP_DOWN);

				cbo.setLayout(new GridLayout(3, true));
				cbo.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false,
						2, 1));
				cbo.setToolTipText(opt.getHelp());
				cbo.setText(labelName);
				for (int nb = 0; nb < listChoice.length; nb++) {
					String[] labelAndValue = listChoice[nb].split(",");
					if (labelAndValue != null && labelAndValue.length == 2) {
						cbo.setData(labelAndValue[0], labelAndValue[1]);
						cbo.setData("value", labelAndValue[1]);
						cbo.add(labelAndValue[0]);
					} else {
						throw new XmlParserException(0, this.getClass()
								.getName(), "create(Composite parent)",
								"Input xml file not properly set for "
										+ labelName);
					}
				}
				cbo.select(cbo.indexOf(opt.getDefaultValue()));
				final String labelNameSave = labelName;
				cbo.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						// TODO Implement this correctly if CHOICE is used
						FableUtils.errMsg(this, "Combo for XML_OPTION_CHOICE "
								+ "is not implemented: " + labelNameSave);
						System.out.println("Test de la selection:"
								+ ((Combo) e.widget).getData(((Combo) e.widget)
										.getText()));
					}
				});
				cbo.setData(opt);
				cbo.setData("option", opt.getOption());
				cbo.setData("default", opt.getDefaultValue());
			}
		} else if (type.equals(IVarKeys.XML_OPTION_CHECK)) {
			final Button bcheck = new Button(group, SWT.CHECK);
			bcheck.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true,
					false, 3, 1));
			bcheck.setText(labelName);
			bcheck.setToolTipText(opt.getHelp());
			bcheck.setData(opt);
			bcheck.setData("option", opt.getOption());
			bcheck.setData("default", opt.getDefaultValue());
			bcheck.setData("value", opt.getDefaultValue());
			opt.setValue(opt.getDefaultValue());
			bcheck.setSelection(opt.getDefaultValue().equals("True"));
			bcheck.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					Xmloption opt = (Xmloption) ((Button) e.getSource())
							.getData();
					if (opt != null) {
						if (((Button) e.getSource()).getSelection()) {
							opt.setValue("True");
						} else {
							opt.setValue("False");
						}
					}
				}
			});
		} else {
			// Fallback case (KE: Apparently not used)
			// DEBUG Not used
			// if (false) {
			// System.out.println("Fallback: " + labelName);
			// }
			Label lbl = new Label(group, SWT.NONE);
			lbl.setText(labelName);

			Composite cmpToAlignToTypeText = new Composite(group, SWT.NONE);
			cmpToAlignToTypeText.setData(opt);
			cmpToAlignToTypeText.setLayout(new GridLayout(3, true));
			cmpToAlignToTypeText.setLayoutData(new GridData(SWT.LEFT,
					GridData.CENTER, true, false, 4, 1));

			/*
			 * lbl.setLayoutData(new GridData(SWT.LEFT , GridData.CENTER, true,
			 * false, 1, 1));
			 */
			/*
			 * GridData gd = new GridData(SWT.FILL , SWT.FILL , true, true);
			 * gd.horizontalSpan=2;
			 */

			final Text txt = new Text(cmpToAlignToTypeText, SWT.BORDER);
			// txt.setBackground(display.getSystemColor(SWT.COLOR_MAGENTA));
			txt.setToolTipText(opt.getHelp());
			txt.setText(opt.getDefaultValue());
			// txt.setLayoutData(new GridLayout(3, true));

			txt.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false,
					1, 1));
			DropTarget target = new org.eclipse.swt.dnd.DropTarget(txt,
					DND.DROP_COPY | DND.DROP_MOVE);
			target
					.setTransfer(new TextTransfer[] { TextTransfer
							.getInstance() });
			target.addDropListener(dropTargetListener);
			txt.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					fireFieldModified(
							((Xmloption) (((Text) e.widget).getData()))
									.getOption(), ((Text) e.widget).getText());
				}
			});
			/*
			 * txt.addFocusListener( new FocusAdapter(){@Override
			 * 
			 * public void focusLost(FocusEvent e) {
			 * 
			 * fireFieldModified(((Xmloption)(
			 * ((Text)e.widget).getData())).getOption(),
			 * ((Text)e.widget).getText());
			 * 
			 * }}); txt.addKeyListener(new KeyAdapter() {
			 * 
			 * @Override public void keyPressed(KeyEvent e) { if (e.keyCode ==
			 * SWT.CR || e.keyCode == SWT.KEYPAD_CR) { fireFieldModified
			 * (((Xmloption)(((Text)e.widget).getData())).
			 * getOption(),((Text)e.widget).getText()); } } });
			 */

			txt.setData(opt);
			txt.setData("option", opt.getOption());
			txt.setData("default", opt.getDefaultValue());
			//
			/*
			 * if(!opt.isEnabled()){ txt.setEnabled(false); }
			 */
		}

		listGroup.add(group);
	}

	// /**
	// * Creates buttons at the bottom.
	// */
	// private void createButtons() {
	// Composite buttonComposite = new Composite(mainComposite, SWT.NONE);
	// /*
	// * cmpToAlignBtn.setBackground(Display.getDefault().getSystemColor(
	// * SWT.COLOR_CYAN));
	// */
	// buttonComposite.setLayout(new FillLayout(SWT.HORIZONTAL));
	// //
	// // cmpToAlignBtn.setLayoutData(new RowLayout());
	// // cmpToAlignBtn.setLayoutData(new GridData( SWT.FILL ,
	// // GridData.CENTER, true, false,1,2));
	//
	// Button bdefault = new Button(buttonComposite, SWT.BORDER);
	// bdefault.setAlignment(SWT.RIGHT);
	// /*
	// * bdefault.setLayoutData(new GridData(SWT.RIGHT_TO_LEFT, SWT.FILL,
	// * true, true, 2,2));
	// */
	// bdefault.setToolTipText("Restore default values");
	// bdefault.setImage(imgRevert);
	// bdefault.addSelectionListener(new SelectionAdapter() {
	// public void widgetSelected(SelectionEvent e) {
	// // Put default values in text fields
	// setDefault(mainComposite.getChildren(), null);
	// }
	// });
	//
	// bdefault.addDisposeListener(new DisposeListener() {
	//
	// public void widgetDisposed(DisposeEvent e) {
	//
	// imgRevert.dispose();
	//
	// }
	// });
	// bdefault.setText("Restore default values");
	//
	// btnRun = new Button(buttonComposite, SWT.BORDER);
	// btnRun.setAlignment(SWT.RIGHT);
	// /*
	// * btn.setLayoutData(new GridData(SWT.RIGHT_TO_LEFT, SWT.FILL, true,
	// * true, 2,2));
	// */
	// btnRun.setToolTipText("Run");
	// btnRun.setText("Run application");
	// btnRun.setImage(imgplay);
	// btnRun.addSelectionListener(new SelectionAdapter() {
	// @Override
	// public void widgetSelected(SelectionEvent e) {
	// if (isRunning) {
	// isRunning = false;
	// setLaunchImage(isRunning);
	// fireButtonStopPushed();
	//
	// } else {
	// isRunning = true;
	// setLaunchImage(isRunning);
	// fireButtonStartPushed();
	// }
	// }
	// });
	// btnRun.addDisposeListener(new DisposeListener() {
	// public void widgetDisposed(DisposeEvent e) {
	// imgplay.dispose();
	// imgPause.dispose();
	// }
	// });
	// // TODO Either don't create these buttons or remove the code
	// btnRun.setVisible(false);
	// bdefault.setVisible(false);
	// }

	/**
	 * Stores default values for all Controls.
	 */
	public void storeDefaultOptions() {
		storeDefaultOptions(mainComposite.getChildren());
	}

	/**
	 * Gets values from the given Controls and sets them in the XmlOption object
	 * as the value. This function is called in response to a "save_ini"
	 * property change event when the user saves the XML options via the
	 * SaveXmlOptions action. Thus, the current values will be saved as the
	 * defaults.
	 * 
	 * @param control
	 *            Array of Controls.
	 * @param opt
	 *            Unneeded parameter. Use null.
	 */
	private void storeDefaultOptions(Control[] control) {
		Xmloption opt;
		for (int i = 0; i < control.length; i++) {
			opt = (Xmloption) control[i].getData();
			if (control[i] instanceof TypedText) {
				opt.putTag("default", ((TypedText) control[i]).getText());
			} else if (control[i] instanceof Composite) {
				// Composites that are not TypedText, includes Group
				storeDefaultOptions(((Composite) control[i]).getChildren());
			} else if (control[i] instanceof Button) {
				Button btn = (Button) control[i];
				if ((btn.getStyle() & SWT.RADIO) != 0) {
					if (btn.getSelection()) {
						opt.putTag("default", (String) btn.getData(btn
								.getText()));
					}
				} else if ((btn.getStyle() & SWT.CHECK) != 0) {
					if (btn.getSelection()) {
						opt.putTag("default", "True");
					} else {
						opt.putTag("default", "False");
					}
				}
			} else if (control[i] instanceof Combo) {
				Combo cb = (Combo) control[i];
				opt.putTag("default", (String) cb.getData(cb.getText()));
			} else if (control[i] instanceof Text) {
				opt.putTag("default", ((Text) control[i]).getText());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see fable.framework.xmlparser.internal.IOptions#setOptions()
	 */
	public void setOptions() {
		setOptions(mainComposite.getChildren());
	}

	/**
	 * Gets values from the given Controls and sets them in the XmlOption object
	 * as the value.
	 * 
	 * @param controls
	 *            Array of Controls.
	 * @param opt
	 */
	private void setOptions(Control[] controls) {
		// parcours les widgets et assigne les valeurs trouvees dans les champs
		// avec les data ?
		// Traverse the widgets and assign the assigned values in the fields
		Xmloption opt;
		for (int i = 0; i < controls.length; i++) {
			opt = (Xmloption) controls[i].getData();
			if (controls[i] instanceof TypedText) {
				opt.setValue(((TypedText) controls[i]).getText());
			} else if (controls[i] instanceof Composite) {
				// Composites that are not TypedText, includes Group
				setOptions(((Composite) controls[i]).getChildren());
			} else if (controls[i] instanceof Button) {
				Button btn = (Button) controls[i];
				if ((btn.getStyle() & SWT.RADIO) != 0) {
					if (btn.getSelection()) {
						opt.setValue((String) btn.getData(btn.getText()));
					}
				} else if ((btn.getStyle() & SWT.CHECK) != 0) {
					if (btn.getSelection()) {
						opt.setValue("True");
					} else {
						opt.setValue("False");
					}
				}
			} else if (controls[i] instanceof Combo) {
				Combo cb = (Combo) controls[i];
				opt.setValue((String) cb.getData(cb.getText()));
			} else if (controls[i] instanceof Text) {
				opt.setValue(((Text) controls[i]).getText());
			}
		}
	}

	/**************************************************************************/
	// Launch
	/**************************************************************************/

	/**
	 * This method first checks if fields are ok and then sets options from the
	 * textfield to XmlOption.
	 * 
	 * @return true if fields are ok.
	 */
	public boolean validateAndSetOptions() {
		boolean bok = false;
		if (validateView()) {
			setOptions();
			bok = true;
		}
		return bok;
	}

	/**************************************************************************/
	// Control fields
	/**************************************************************************/

	/*
	 * (non-Javadoc)
	 * 
	 * @see fable.framework.xmlparser.internal.IOptions#validateView()
	 */
	public boolean validateView() {
		return checkFields(mainComposite, true);
	}

	/***************************************************************************
	 * Register or remove listeners
	 * 
	 ************************************************************************/
	public void addPropertyChangeListener(IPropertyChangeListener listener) {
		listeners.add(listener);
	}

	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		listeners.remove(listener);
	}

	public void fireButtonStartPushed() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {

				element.propertyChange(new PropertyChangeEvent(this, "start",
						false, true));
			}
		}
	}

	public void fireButtonStopPushed() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {

				element.propertyChange(new PropertyChangeEvent(this, "quit",
						false, true));
			}
		}
	}

	public void fireOptionsAreNotValid() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {
				element.propertyChange(new PropertyChangeEvent(this,
						"unvalidate", false, currentErrorField));
			}
		}
	}

	/**
	 * Fires a PropertyChanged event. Called when a field value is changed.
	 * 
	 * @param name
	 *            Used for oldValue for the PropertyChangeEvent.
	 * @param value
	 *            Used for newValue for the PropertyChangeEvent.
	 */
	public void fireFieldModified(String name, String value) {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {
				element.propertyChange(new PropertyChangeEvent(this,
						"fieldChanged", name, value));
			}
		}
	}

	public void addListener(IPropertyChangeListener listener) {
		listeners.add(listener);
	}

	public void removeListener(IPropertyChangeListener listener) {
		listeners.remove(listener);
	}

	/**
	 * Displays default values stored in options in the fields. Called from
	 * button default to restore default values. Calls fireFieldModified.
	 * 
	 * @param controls
	 *            Array of controls to set.
	 * @param opt
	 *            Apparently unnecessary parameter.
	 */
	private void setDefault(Control[] controls, Xmloption opt) {
		for (int i = 0; i < controls.length; i++) {
			String defaultValue = null;
			if (controls[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) controls[i]).getData();
				if (opt != null) {
					defaultValue = opt.getDefaultValue();
					if (defaultValue != null) {
						((TypedText) controls[i]).set_Text(defaultValue);
						fireFieldModified(opt.getOption(), defaultValue);
					}
				}
			} else if (controls[i] instanceof Text) {
				opt = (Xmloption) ((Text) controls[i]).getData();
				if (opt != null) {
					defaultValue = opt.getDefaultValue();
					if (defaultValue != null) {
						((Text) controls[i]).setText(defaultValue);
						fireFieldModified(opt.getOption(), defaultValue);
					}
				}
			} else if (controls[i] instanceof Combo) {
				Combo cbo = ((Combo) controls[i]);
				opt = (Xmloption) cbo.getData();
				if (opt != null) {
					defaultValue = opt.getDefaultValue();
					if (defaultValue != null) {
						cbo.select(cbo.indexOf(defaultValue));
						fireFieldModified(opt.getOption(), defaultValue);
					}
				}
			} else if (controls[i] instanceof Group) {
				// if(((Group)element[i]).getData() != null){
				setDefault(((Group) controls[i]).getChildren(),
						(Xmloption) ((Group) controls[i]).getData());
				// }
			} else if (controls[i] instanceof Button) {
				Button btn = (Button) controls[i];
				if ((btn.getStyle() & SWT.RADIO) != 0) {
					if (opt != null) {
						defaultValue = opt.getDefaultValue();
						if (defaultValue != null) {
							btn.setSelection(defaultValue.equals(btn
									.getData(btn.getText())));
							fireFieldModified(opt.getOption(), defaultValue);
						}
					}
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#updateFields(java.lang.String
	 * , java.lang.String)
	 */
	public boolean updateFields(String KeyOption, String value) {
		return updateFields(mainComposite.getChildren(), KeyOption, value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#updateFields(org.eclipse.
	 * swt.widgets.Control[], java.lang.String, java.lang.String)
	 */
	public boolean updateFields(Control[] element, String KeyOption,
			String value) {
		Xmloption opt;
		if (element == null) {
			element = mainComposite.getChildren();
		}
		boolean bFound = false; // stops when widget is found
		for (int i = 0; !bFound && i < element.length; i++) {
			if (element[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) element[i]).getData();
				if (opt.getOption().equals(KeyOption)) {
					if (value == null) {
						String defaultValue = (String) ((TypedText) element[i])
								.getData("default");
						((TypedText) element[i]).set_Text(defaultValue);
					} else {
						((TypedText) element[i]).set_Text(value);
					}
					bFound = true;
				}
			} else if (element[i] instanceof Text) {
				opt = (Xmloption) ((Text) element[i]).getData();
				if (opt.getOption().equals(KeyOption)) {
					if (value == null) {
						String defaultValue = (String) ((Text) element[i])
								.getData("default");
						((Text) element[i]).setText(defaultValue);
					} else {
						((Text) element[i]).setText(value);
					}
					bFound = true;
				}
			} else if (element[i] instanceof Composite) {
				bFound = updateFields(((Composite) element[i]).getChildren(),
						KeyOption, value);
			}
		}
		updateControls(null);
		return bFound;

	}

	/**
	 * Changes the image on the run button (btnRun).<br>
	 * <br>
	 * Note: Currently btnRun is not created.
	 * 
	 * @param bplay
	 */
	private void setLaunchImage(boolean bplay) {
		// TODO Currently btnRun is not used. This routine could be deleted.
		if (!bplay) {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					if (btnRun != null && !imgplay.isDisposed()) {
						btnRun.setImage(imgplay);
						btnRun.setToolTipText("Launch program");
					}
				}
			});
		} else {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					if (btnRun != null && !imgPause.isDisposed()) {
						btnRun.setImage(imgPause);
					}
					btnRun.setToolTipText("Stop program");
				}
			});
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse
	 * .jface.util.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent event) {
		// Do nothing
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#setCurrentPath(java.lang.
	 * String)
	 */
	public void setCurrentPath(String fileName) {
		if (fileName == null) {
			// Do nothing
			return;
		}
		File file = new File(fileName);
		// Only reset the currentPath if filename exists
		if (file.exists()) {
			if (file.isDirectory()) {
				currentPath = file.getPath();
			} else {
				String parent = file.getParent();
				if (parent != null) {
					currentPath = parent;
				}
			}
		}
	}

	/**
	 * Updates the Controls for all Controls.
	 * 
	 */
	public void updateControls() {
		updateControls(mainComposite.getChildren());
	}

	/**
	 * Updates the Controls from the options. Enables or disables Controls
	 * according to the current enabled conditions and sets the values of the
	 * Controls from the current options.
	 * 
	 * @param element
	 *            Array of controls. Use to null to do all of them.
	 */
	public void updateControls(Control[] element) {
		// KE: This method seems to do the same things for all Controls that
		// are not a Group or a Composite and just recurses for those. It could
		// probably be written with two branches.
		// KE: Since the visibility of some controls depends on the others is it
		// meaningful update only specified ones and not all
		if (element == null) {
			element = mainComposite.getChildren();
		}
		for (int i = 0; i < element.length; i++) {
			Xmloption option = null;
			if (element[i] instanceof TypedText) {
				TypedText txt = (TypedText) element[i];
				option = (Xmloption) txt.getData();
				if (option != null) {
					txt.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = setOptionFromControls(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							txt.setEnabled(false);
						}
					}
				}
			} else if (element[i] instanceof Text) {
				Text txt = (Text) element[i];
				option = (Xmloption) txt.getData();
				if (option != null) {
					txt.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = setOptionFromControls(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							txt.setEnabled(false);
						}
					}
				}
			} else if (element[i] instanceof Button) {
				Button btn = (Button) element[i];
				option = (Xmloption) btn.getData();
				if (option != null) {
					btn.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = setOptionFromControls(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							btn.setEnabled(false);
						}
					}
				}
			} else if (element[i] instanceof Combo) {
				Combo combo = (Combo) element[i];
				option = (Xmloption) combo.getData();
				if (option != null) {
					combo.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = setOptionFromControls(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							combo.setEnabled(false);
						}
					}
				}
			} else if (element[i] instanceof Group) {
				updateControls(((Group) element[i]).getChildren());
			} else if (element[i] instanceof Composite) {
				updateControls(((Composite) element[i]).getChildren());
			}
		}
	}

	/**
	 * Loops over all Controls until the Control with the option name in the
	 * parameter is found, then sets the option's value from the Control.
	 * 
	 * @param controls
	 *            Array of Controls. If null do all controls.
	 * @param option_Name
	 *            Name of the option.
	 * @param opt
	 *            Must be null to do anything. If not null, just returns the
	 *            option. (This logic should be fixed.) Usually called with
	 *            null.
	 * @return
	 */
	public Xmloption setOptionFromControls(Control[] controls,
			String option_Name, Xmloption opt) {
		if (controls == null) {
			controls = mainComposite.getChildren();
		}
		Xmloption xmlOptionFound = opt; // Stops when widget is found
		for (int i = 0; (xmlOptionFound == null) && i < controls.length; i++) {
			if (controls[i] instanceof TypedText) {
				TypedText txt = (TypedText) controls[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) txt.getData();
					xmlOptionFound.setValue(txt.getTextField().getText());
				}
			} else if (controls[i] instanceof Text) {
				Text txt = (Text) controls[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) txt.getData();
					xmlOptionFound.setValue(txt.getText());
				}
			} else if (controls[i] instanceof Combo) {
				Combo cbo = ((Combo) controls[i]);
				String keyopt = (String) (cbo).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) cbo.getData();
					xmlOptionFound.setValue(cbo.getText());
				}
			} else if (controls[i] instanceof Group) {
				Group grp = ((Group) controls[i]);
				String keyopt = (String) (grp).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) grp.getData();
					for (int j = 0; xmlOptionFound != null
							&& j < grp.getChildren().length; j++) {
						if (grp.getChildren()[j] instanceof Button) {
							Button btn = (Button) grp.getChildren()[j];
							if ((btn.getStyle() & SWT.RADIO) != 0) {
								if (btn.getSelection()) {
									xmlOptionFound.setValue((String) btn
											.getData("value"));
								}
							}
						}
					}
				} else {
					xmlOptionFound = setOptionFromControls(
							((Composite) controls[i]).getChildren(),
							option_Name, xmlOptionFound);
				}
			} else if (controls[i] instanceof Button) {
				Button btn = (Button) controls[i];
				if ((btn.getStyle() & SWT.RADIO) != 0) {
					String keyopt = (String) (btn).getData("option");
					if (keyopt != null && keyopt.equals(option_Name)) {
						xmlOptionFound = (Xmloption) btn.getData();
						if (btn.getSelection()) {
							xmlOptionFound.setValue((String) btn
									.getData("value"));
						}
					}
				}
				if ((btn.getStyle() & SWT.CHECK) != 0) {
					String keyopt = (String) (btn).getData("option");
					if (keyopt != null && keyopt.equals(option_Name)) {
						xmlOptionFound = (Xmloption) btn.getData();
						if (btn.getSelection()) {
							xmlOptionFound.setValue("True");
						} else {
							xmlOptionFound.setValue("False");
						}
					}
				}
			} else if (controls[i] instanceof Composite) {
				xmlOptionFound = setOptionFromControls(
						((Composite) controls[i]).getChildren(), option_Name,
						xmlOptionFound);
			}
		}
		return xmlOptionFound;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#loadOptions(org.eclipse.swt
	 * .widgets.Control[], fable.framework.xmlparser.object.Xmloption)
	 */
	public boolean loadOptions(Control[] controls, Xmloption option) {
		String option_Name = option.getOption();
		if (controls == null) {
			controls = mainComposite.getChildren();
		}
		boolean bFound = false; // stops when widget is found
		for (int i = 0; !bFound && i < controls.length; i++) {
			if (controls[i] instanceof TypedText) {
				TypedText txt = (TypedText) controls[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					txt.setData(option);
					txt.setData("default", option.getDefaultValue());
					txt.set_Text(option.getDefaultValue());
					bFound = true;
				}
			} else if (controls[i] instanceof Text) {
				Text txt = (Text) controls[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					txt.setData(option);
					txt.setData("default", option.getDefaultValue());
					txt.setText(option.getDefaultValue());
					bFound = true;
				}
			} else if (controls[i] instanceof Button) {
				Button btn = (Button) controls[i];
				String keyopt = (String) (btn.getData("option"));
				if (keyopt != null && keyopt.equals(option_Name)) {
					btn.setData(option);
					if (option.getType().equals(IVarKeys.XML_OPTION_CHOICE)) {
						if ((btn.getStyle() & SWT.RADIO) != 0
								|| (btn.getStyle() & SWT.CHECK) != 0) {
							// Warning : do not get the default value for
							// buttons
							String val = (String) btn.getData("value");
							if (val != null) {
								boolean select = val.equals(option
										.getDefaultValue());
								btn.setSelection(select);
							}
						}
					}
					if (option.getType().equals(IVarKeys.XML_OPTION_CHECK)) {
						String val = (String) btn.getData("value");
						if (val != null) {
							String defaultVal = option.getDefaultValue();
							boolean select = defaultVal.equals("True");
							btn.setSelection(select);
						}
					}
				}
			} else if (controls[i] instanceof Combo) {
				Combo cb = (Combo) controls[i];
				String keyopt = (String) cb.getData("option");
				if (option.getOption().equals(keyopt)) {
					cb.setData("default", option.getDefaultValue());
					if (option.getType().equals(IVarKeys.XML_OPTION_CHOICE)) {
						option.getChoices().replaceAll("\\(", "");
						cb.select(cb.indexOf(option.getDefaultValue()));
					}
					bFound = true;
				}
			} else if (controls[i] instanceof Composite) {
				bFound = loadOptions(((Composite) controls[i]).getChildren(),
						option);
			}
		}
		return bFound;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#loadOptions(fable.framework
	 * .xmlparser.object.Xmloption)
	 */
	public boolean loadOptions(Xmloption option) {
		return loadOptions(mainComposite.getChildren(), option);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * fable.framework.xmlparser.internal.IOptions#getDefaultValue(java.lang
	 * .String)
	 */
	public String getDefaultValue(String option) {
		Xmloption opt = setOptionFromControls(null, option, null);
		String ret = "";
		if (opt != null) {
			ret = opt.getDefaultValue();
		}
		return ret;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see fable.framework.xmlparser.internal.IOptions#resetFields()
	 */
	public void resetFields() {
		setDefault(mainComposite.getChildren(), null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see fable.framework.xmlparser.internal.IOptions#stop()
	 */
	public void stop() {
		isRunning = false;
		setLaunchImage(isRunning);
	}

	public void run() {
		isRunning = true;
		setLaunchImage(isRunning);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see fable.framework.xmlparser.internal.IOptions#getOptions()
	 */
	public Vector<Xmloption> getOptions() {
		return options;
	}

	public TypedText getCurrentNonValidField() {
		return currentErrorField;
	}

	/**
	 * Returns a value to use for the filterPath for Dialogs. Tries to get it
	 * from the supplied TypedText. Uses the currentPath as a fall back.
	 * 
	 * @param txt
	 *            Text to get current value from if possible.
	 * @return
	 */
	private String getFilterPath(TypedText txt) {
		String dir = null;
		if (txt != null && txt.getText().length() > 0) {
			String text = txt.getText();
			File file = new File(text);
			if (file.exists()) {
				if (file.isDirectory()) {
					dir = file.getPath();
				} else {
					String parent = file.getParent();
					if (parent != null) {
						dir = parent;
					}
				}
			}
		}
		if (dir == null) {
			dir = currentPath;
		}
		return dir;
	}

	/**
	 * Utility for printing out the instance options in a readable format. Can
	 * be used for debugging.
	 * 
	 * @param optionName
	 *            The name of an option or null to do all of them.
	 */
	public void printOptions(String optionName) {
		printOptions(this.options, optionName);
	}

	/**
	 * Utility for printing out the given options in a readable format. Can be
	 * used for debugging.
	 * 
	 * @param options
	 *            A Vector of options.
	 * @param optionName
	 *            The name of an option or null to do all of them.
	 */
	public static void printOptions(Vector<Xmloption> options, String optionName) {
		boolean abort = false;
		String info = "";
		if (options == null) {
			info += "Options vector is null\n";
			abort = true;
		}
		if (options.size() == 0) {
			info += "Options vector is empty\n";
			abort = true;
		}
		if (abort) {
			System.out.println(info);
			return;
		}
		for (Xmloption option : options) {
			if (optionName != null && !optionName.equals(option.getOption())) {
				continue;
			}
			info += option.getOption() + "\n";
			info += String.format("  [%08x]", option.hashCode()) + "\n";
			info += "  Value: " + option.getValue() + "\n";
			info += "  Default: " + option.getDefaultValue() + "\n";
			info += "  Label: " + option.getLabel() + "\n";
			info += "  Short Name: " + option.getShortName() + "\n";
			info += "  Type: " + option.getType() + "\n";
			info += "  Choices: " + option.getChoices() + "\n";
			info += "  Enabled: " + option.isEnabled() + "\n";
			info += "  Enabled Condition: " + option.getEnabledCondition()
					+ "\n";
			info += "  Required: " + option.isRequired() + "\n";
			info += "  Vary: " + option.getVary() + "\n";
			info += "  Action: " + option.getAction() + "\n";
			info += "  Dest: " + option.getDest() + "\n";
		}
		System.out.println(info);
	}

}
