package fable.framework.xmlparser.internal;

import java.util.Vector;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;

/**
 * 
 * @author SUCHET
 * @description this interface is used for extension point
 */
public interface IOptions {
	/**
	 * Loops through fields (Controls) and checks if fields and their values are
	 * OK.
	 * 
	 * @return boolean Whether OK or not.
	 */
	public boolean validateView();

	public void setOptions();

	/**
	 * Creates the controls both for the Xmloptions and for the buttons at the
	 * top of the View.
	 * 
	 * @param Composite
	 *            parent
	 * @throws XmlParserException
	 *             if the XML file is not correct
	 */
	public void createControls(Composite parent) throws XmlParserException;

	public boolean validateAndSetOptions();

	public void stop();

	public void addListener(IPropertyChangeListener i);

	public void removeListener(IPropertyChangeListener i);

	/**
	 * Updates the given fields (Controls) with the values from the options.
	 * 
	 * @param controls
	 *            Array of Controls.
	 * @param KeyOption
	 *            Name of the option.
	 * @param value
	 *            Value for the option.
	 * @return
	 */
	public boolean updateFields(Control[] controls, String KeyOption,
			String value);

	/**
	 * Updates the all of the fields (Controls) with the values from the
	 * options.
	 * 
	 * @param KeyOption
	 *            Name of the option.
	 * @param value
	 *            Value for the option.
	 * @return
	 */
	public boolean updateFields(String KeyOption, String value);

	public boolean loadOptions(Xmloption options);

	public boolean loadOptions(Control[] controls, Xmloption options);

	/**
	 * Sets the current path.
	 * 
	 * @param currentSamplePath  The path to set.
	 */
	public void setCurrentPath(String currentSamplePath);

	/**
	 * Gets the default value for the given option.
	 * 
	 * @param option
	 *            Name of the option.
	 * @return
	 */
	public String getDefaultValue(String option);

	public void resetFields();

	/**
	 * Get a Vector containing all the options.
	 * 
	 * @return Vector of Xmloption's.
	 */
	public Vector<Xmloption> getOptions();

}
