/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import java.util.Vector;
import jep.JepException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class HeaderTableView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.imageviewer.views.HeaderView";
    public static HeaderTableView view;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private FabioFile fabioFile = null;
    private Table table;
    private SampleController controller = SampleController.getController();
    private Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            TableColumn sortColumn = HeaderTableView.this.table.getSortColumn();
            HeaderTableView.this.currentColumn = (TableColumn)e.widget;
            HeaderTableView.this.dir = HeaderTableView.this.table.getSortDirection();
            if (sortColumn == HeaderTableView.this.currentColumn) {
                HeaderTableView.this.dir = HeaderTableView.this.dir == 128 ? 1024 : 128;
            } else {
                HeaderTableView.this.table.setSortColumn(HeaderTableView.this.currentColumn);
                HeaderTableView.this.dir = 128;
            }
            TableColumn[] cols = HeaderTableView.this.table.getColumns();
            HeaderTableView.this.currentSortColumnIndex = 0;
            int x = 0;
            while (HeaderTableView.this.currentSortColumnIndex == 0 && x < cols.length) {
                if (cols[x].getText().equals(HeaderTableView.this.currentColumn.getText())) {
                    HeaderTableView.this.currentSortColumnIndex = x;
                }
                ++x;
            }
            int direction = HeaderTableView.this.dir;
            HeaderTableView.this.populateTable(HeaderTableView.this.currentSortColumnIndex, direction);
            HeaderTableView.this.table.setSortDirection(HeaderTableView.this.dir);
            HeaderTableView.this.table.setSortColumn(HeaderTableView.this.currentColumn);
            int n = 0;
            while (n < HeaderTableView.this.table.getItemCount()) {
                HeaderTableView.this.table.getItem(n).setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : HeaderTableView.this.light_blue);
                ++n;
            }
        }
    };
    private Text txtFindKey;
    private int indexFinder = 0;
    protected TableColumn currentColumn;
    protected int dir = 128;
    protected int currentSortColumnIndex = 0;

    private void showKeyInTable(String key) {
        key = key.toLowerCase();
        if (this.table != null) {
            boolean bfound = false;
            this.table.setSelection(-1);
            ++this.indexFinder;
            while (this.indexFinder < this.table.getItemCount() && !(bfound = this.table.getItem(this.indexFinder).getText(1).toLowerCase().contains(key))) {
                ++this.indexFinder;
            }
            if (bfound) {
                this.table.select(this.indexFinder);
                this.table.setTopIndex(this.indexFinder);
            } else {
                this.indexFinder = 0;
                this.table.setTopIndex(this.indexFinder);
            }
        }
    }

    public void createPartControl(Composite parent) {
        view = this;
        parent.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(parent, 0);
        lbl.setText("Find key");
        this.txtFindKey = new Text(parent, 2048);
        this.txtFindKey.setLayoutData((Object)new GridData(4, 2, true, false));
        this.txtFindKey.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    if (HeaderTableView.this.txtFindKey.getText().trim().length() > 0) {
                        HeaderTableView.this.showKeyInTable(HeaderTableView.this.txtFindKey.getText());
                    } else {
                        HeaderTableView.this.indexFinder = 0;
                        HeaderTableView.this.table.setTopIndex(0);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.createTable(parent);
        this.showHeader();
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void loadFile(String path, String file) {
        try {
            this.fabioFile = new FabioFile(String.valueOf(path) + "/" + file);
        }
        catch (FabioFileException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Unable to load file", (Throwable)ex);
        }
        this.setPartName("Header " + file);
        this.showHeader();
    }

    public void loadFile(FabioFile file) {
        this.fabioFile = file;
        this.setPartName("Header " + this.fabioFile.getFileName());
        this.showHeader();
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.table.setLayoutData((Object)gd);
        this.initColumn();
    }

    private void initColumn() {
        String[] titles = new String[]{"#", "Key", "Value"};
        int i = 0;
        while (i < titles.length) {
            int style = 0;
            TableColumn column = new TableColumn(this.table, style);
            column.setText(titles[i]);
            column.addListener(13, this.sortListener);
            ++i;
        }
        this.table.removeAll();
        i = 0;
        while (i < titles.length) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void showHeader() {
        if (this.fabioFile != null) {
            this.populateTable();
        }
    }

    private void populateTable() {
        this.table.removeAll();
        try {
            Vector keysInFileHeader = this.fabioFile.getKeysAsListedInHeader();
            int i = 0;
            while (i < keysInFileHeader.size()) {
                TableItem item = this.table.getItemCount() > i + 1 ? this.table.getItem(i + 1) : new TableItem(this.table, 0);
                String myKey = (String)keysInFileHeader.elementAt(i);
                item.setText(0, String.valueOf(i + 1));
                item.setText(1, myKey);
                try {
                    item.setText(2, this.fabioFile.getValue(myKey));
                }
                catch (FabioFileException fabioFileException) {
                    item.setText(2, "Na");
                }
                item.setBackground(i % 2 == 0 ? Display.getCurrent().getSystemColor(1) : this.light_blue);
                ++i;
            }
            this.populateTable(this.currentSortColumnIndex, this.dir);
        }
        catch (FabioFileException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Unable to populate table", (Throwable)ex);
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)ex);
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    public void setFocus() {
        FabioFile file;
        if (this.controller == null) {
            this.controller = SampleController.getController();
        }
        if ((file = this.controller.getCurrentFile()) != null) {
            this.loadFile(file);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getProperty().equals("CurrentFile")) {
            Object val = evt.getNewValue();
            this.loadFile((FabioFile)val);
        }
    }

    public void dispose() {
        this.controller.removePropertyChangeListener((IPropertyChangeListener)view);
        super.dispose();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateTable(int index, int direction) {
        cols = this.table.getColumns();
        items = this.table.getItems();
        i = 0;
        while (i < items.length) {
            value1 = items[i].getText(index);
            j = 0;
            block3: while (j < i) {
                block15: {
                    block16: {
                        value2 = items[j].getText(index);
                        try {
                            block17: {
                                fValue1 = Float.parseFloat(value1);
                                fValue2 = Float.parseFloat(value2);
                                if (direction != 128) break block17;
                                if (!(fValue1 < fValue2)) break block15;
                                values = new String[cols.length];
                                n = 0;
                                if (true) ** GOTO lbl51
                            }
                            if (fValue1 > fValue2) {
                                values = new String[cols.length];
                                n = 0;
                                while (true) {
                                    if (n >= cols.length) {
                                        if (i == this.indexFinder) {
                                            this.indexFinder = j;
                                        }
                                        items[i].dispose();
                                        item = new TableItem(this.table, 0, j);
                                        item.setText(values);
                                        items = this.table.getItems();
                                        break block3;
                                    }
                                    values[n] = items[i].getText(n);
                                    ++n;
                                }
                            }
                            break block15;
                        }
                        catch (NumberFormatException v0) {
                            if (direction != 128) break block16;
                            if (value1.compareTo(value2) >= 0) break block15;
                            values = new String[cols.length];
                            n = 0;
                            if (true) ** GOTO lbl62
                        }
                    }
                    if (value1.compareTo(value2) <= 0) break block15;
                    values = new String[cols.length];
                    n = 0;
                    if (true) ** GOTO lbl73
                }
                ++j;
                continue;
                do {
                    values[n] = items[i].getText(n);
                    ++n;
lbl51:
                    // 2 sources

                } while (n < cols.length);
                if (i == this.indexFinder) {
                    this.indexFinder = j;
                }
                items[i].dispose();
                item = new TableItem(this.table, 0, j);
                item.setText(values);
                items = this.table.getItems();
                break;
                do {
                    values[n] = items[i].getText(n);
                    ++n;
lbl62:
                    // 2 sources

                } while (n < cols.length);
                if (i == this.indexFinder) {
                    this.indexFinder = j;
                }
                items[i].dispose();
                item = new TableItem(this.table, 0, j);
                item.setText(values);
                items = this.table.getItems();
                break;
                do {
                    values[n] = items[i].getText(n);
                    ++n;
lbl73:
                    // 2 sources

                } while (n < cols.length);
                if (i == this.indexFinder) {
                    this.indexFinder = j;
                }
                items[i].dispose();
                item = new TableItem(this.table, 0, j);
                item.setText(values);
                items = this.table.getItems();
                break;
            }
            ++i;
        }
        n = 0;
        while (n < this.table.getItemCount()) {
            this.table.getItem(n).setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : this.light_blue);
            ++n;
        }
        this.table.setTopIndex(this.indexFinder);
    }
}

