/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.framework.writer.Xmlwriter;
import fable.framework.writer.XmlwriterException;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;
import fable.framework.xmlparser.views.Options;
import fable.peaksearch.Activator;
import fable.peaksearch.actions.LoadXmlOption;
import fable.peaksearch.actions.PeakSearchCommandLineOptionsAction;
import fable.peaksearch.actions.RunAction;
import fable.peaksearch.actions.SaveXmlOptions;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import fable.python.Sample;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PeaksearchView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.peaksearch.view.PeaksearchView";
    public static PeaksearchView view;
    private Peaksearch peaksearch;
    private Options guiOptionsBuilder;
    private boolean linkToNavigator;
    private Logger logger = FableLogger.getLogger(PeaksearchView.class);
    private Sample currentSample;
    private Action setDefaultValues;
    private Action loadOptions;
    private Action saveOptions;
    private Action commandLineInfoAction;
    private RunAction runAction;
    private ImageDescriptor imageDefault = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/revert.gif");
    private ImageDescriptor imageLoad = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/loadOptions.gif");
    private ImageDescriptor saveImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/saveoptions.gif");
    private ImageDescriptor peakSearchImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/peaksearch.JPG");
    private Text optionsNameText;
    private Text workingDirectoryText;
    private Button linkWithNavigatorButton;
    private SampleController controller = SampleController.getController();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.linkToNavigator = store.getBoolean("pref_lint_to_image_navigator");
    }

    public void createPartControl(Composite parent) {
        Composite composite;
        ScrolledComposite sc;
        block6: {
            view = this;
            this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
            try {
                this.peaksearch = Peaksearch.getPeaksearch();
                this.peaksearch.setSamples(this.controller.getSamples());
            }
            catch (PeaksearchException ex) {
                FableUtils.excMsg((Object)((Object)this), (String)"Error setting samples", (Throwable)ex);
                FableMessageConsole.console.displayIn(ex.getMessage());
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error setting samples", (Throwable)ex);
                FableMessageConsole.console.displayIn(ex.getMessage());
            }
            this.peaksearch.addPropertyChangeListener(this);
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Welcome to Peaksearch " + ToolBox.getPluginVersion((String)"fable.peaksearch"));
            }
            sc = new ScrolledComposite(parent, 768);
            composite = new Composite((Composite)sc, 20);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            sc.setContent((Control)composite);
            this.createTopControls(composite);
            try {
                this.guiOptionsBuilder = new Options(composite, this.peaksearch.getOptions());
                this.guiOptionsBuilder.addListener((IPropertyChangeListener)this);
            }
            catch (XmlParserException ex) {
                if (FableMessageConsole.console == null) break block6;
                FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch preferred file", (Throwable)ex);
                FableMessageConsole.console.displayIn("Peaksearch is not able to load its preferred  file to build option view.");
            }
        }
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(composite.computeSize(-1, -1));
        this.makeActions();
        this.contributeToActionBars();
    }

    private void createTopControls(Composite parent) {
        Composite row1 = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)row1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        row1.setLayout((Layout)gridLayout);
        Label label = new Label(row1, 0);
        label.setText("Options file");
        this.optionsNameText = new Text(row1, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).hint(40, -1).applyTo((Control)this.optionsNameText);
        if (this.peaksearch != null && Peaksearch.getOptionsFile() != null) {
            this.optionsNameText.setText(Peaksearch.getOptionsFile());
        } else {
            this.optionsNameText.setText("No .xml options file loaded");
        }
        this.optionsNameText.setToolTipText("The name of the .xml options file used in this view. You can drag a .xml options file here.");
        this.optionsNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    try {
                        PeaksearchView.this.peaksearch.loadOptionsFile(PeaksearchView.this.optionsNameText.getText());
                    }
                    catch (PeaksearchException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
                    }
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.optionsNameText, 17);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String fileName = (String)event.data;
                    PeaksearchView.this.optionsNameText.setText(fileName);
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileNames = (String[])event.data;
                    PeaksearchView.this.optionsNameText.setText(fileNames[0]);
                    try {
                        PeaksearchView.this.peaksearch.loadOptionsFile(PeaksearchView.this.optionsNameText.getText());
                    }
                    catch (PeaksearchException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
                    }
                }
            }
        });
        Button browse = new Button(row1, 8);
        browse.setText("Browse...");
        browse.setToolTipText("Browse for a .xml options file.");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                String[] filterExt = new String[]{"*.xml", "*.*;*"};
                String[] filterNames = new String[]{".xml", "All(*.*)"};
                fileDlg.setFilterExtensions(filterExt);
                fileDlg.setFilterNames(filterNames);
                fileDlg.setText("Select a .xml options file.");
                String file = fileDlg.open();
                if (file != null) {
                    PeaksearchView.this.optionsNameText.setText(file);
                    try {
                        PeaksearchView.this.peaksearch.loadOptionsFile(PeaksearchView.this.optionsNameText.getText());
                    }
                    catch (PeaksearchException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
                    }
                }
            }
        });
        Composite row2 = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)row2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        row2.setLayout((Layout)gridLayout);
        this.linkWithNavigatorButton = new Button(row2, 0x1000020);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.linkWithNavigatorButton);
        this.linkWithNavigatorButton.setText("Link to Image Navigator");
        this.linkWithNavigatorButton.setToolTipText("Link to the Image Navigator. Options for Stem, Format, First, Last, Outfile,\nand the Working Directory will be automatically updated from the Image Navigator\nand the files selected in the Image Navigator will be used.\nSee the PeakSearch Help for more information.");
        this.linkWithNavigatorButton.setSelection(this.linkToNavigator);
        this.linkWithNavigatorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeaksearchView.this.linkToNavigator = PeaksearchView.this.linkWithNavigatorButton.getSelection();
                if (PeaksearchView.this.linkToNavigator) {
                    PeaksearchView.this.updateCurrentSample();
                    if (PeaksearchView.this.currentSample == null) {
                        FableUtils.warnMsg((Object)((Object)this), (String)"There is no current Image Navigator sample");
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.updateCurrentSample();
    }

    public void dispose() {
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        this.peaksearch.removePropertyChangeListener(this);
        super.dispose();
    }

    private void makeActions() {
        this.setDefaultValues = new Action(){

            public void run() {
                PeaksearchView.this.guiOptionsBuilder.resetFields();
            }
        };
        this.setDefaultValues.setText("Restore Default Values");
        this.setDefaultValues.setToolTipText("Restore default values");
        this.setDefaultValues.setImageDescriptor(this.imageDefault);
        this.saveOptions = new SaveXmlOptions();
        this.saveOptions.setText("Save Current Options");
        this.saveOptions.setToolTipText("Save current options");
        this.saveOptions.setImageDescriptor(this.saveImgDesc);
        this.loadOptions = new LoadXmlOption();
        this.loadOptions.setText("Load Options");
        this.loadOptions.setToolTipText("Load options by selecting an XML file");
        this.loadOptions.setImageDescriptor(this.imageLoad);
        this.commandLineInfoAction = new PeakSearchCommandLineOptionsAction();
        this.commandLineInfoAction.setText("PeakSearch Command-Line Options...");
        this.commandLineInfoAction.setToolTipText("Get the PeakSearch command-line parameters");
        this.commandLineInfoAction.setImageDescriptor(this.peakSearchImgDesc);
        this.runAction = new RunAction();
        this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_run.gif"));
        this.runAction.setText("Start Peak Searching");
        this.runAction.setToolTipText("Start peak searching");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.peaksearch.actions.RunAction", (IAction)this.runAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.setDefaultValues);
        manager.add((IContributionItem)new Separator());
        MenuManager subMenuManager = new MenuManager("Help", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"), null);
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.commandLineInfoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.setDefaultValues);
        manager.add((IAction)this.runAction);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("start")) {
            if (this.validateView()) {
                this.peaksearch.run(this.linkToNavigator);
                this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_stop.gif"));
                this.runAction.setText("Stop peak searching");
                this.runAction.setToolTipText("Stop peak searching");
                this.logger.info((Object)"PeakSearch running test from PeakSearchView");
                FableMessageConsole.console.displayOut("PeakSearch is running.");
            } else {
                FableLogger.warn((Object)"PeakSearch options are not valid");
                String error = String.valueOf((String)this.getNonValidField().getData("option")) + ": " + this.getNonValidField().getErrorMessage();
                FableMessageConsole.console.displayError("Peaksearch options contain at least one wrong value :\n" + error);
                this.peaksearch.forceQuit();
            }
        } else if (event.getProperty().equals("quit")) {
            if (this.peaksearch.isRunning()) {
                this.peaksearch.forceQuit();
            }
        } else {
            this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_run.gif"));
            this.runAction.setText("Start peak searching");
            this.runAction.setToolTipText("Start peak searching");
            if (event.getProperty().equals("stop")) {
                if (this.peaksearch.hasBeenCanceled()) {
                    this.logger.info((Object)"PeakSearch has been cancelled.");
                    FableMessageConsole.console.displayOut("Peaksearch has been cancelled.");
                    this.guiOptionsBuilder.stop();
                } else {
                    this.guiOptionsBuilder.stop();
                    this.logger.info((Object)"PeakSearch has finished.");
                    SWTUtils.tryToRefreshProject((String)Peaksearch.getOptionsFile());
                    SWTUtils.tryToRefreshProject((String)this.peaksearch.getOutputDirectory());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    FableMessageConsole.console.displayInfo("PeakSearch has finished.");
                    FableMessageConsole.console.displayInfo("The output directory should be: ");
                    FableMessageConsole.console.displayInfo("  " + this.peaksearch.getOutputDirectory());
                    FableMessageConsole.console.displayInfo("For each search, one filtered Peak file (.flt) per threshold and one 2D Peak");
                    FableMessageConsole.console.displayInfo("file (.spt) per threshold have been created in your output directory.");
                    FableMessageConsole.console.displayInfo("You can either calibrate the filtered Peak file in Transformation, plot");
                    FableMessageConsole.console.displayInfo("spots using the PeakSearch/Open 3D Peak file(.flt) menu, or display 2D");
                    FableMessageConsole.console.displayInfo("peaks on images using the PeakSearch/Open 2D Peak file(.spt) menu.");
                }
            } else if (event.getProperty().equals("fieldChanged")) {
                if (this.currentSample != null && this.linkToNavigator) {
                    String property_label = (String)event.getOldValue();
                    String val = (String)event.getNewValue();
                    if (property_label.equals("first")) {
                        try {
                            int nval = Integer.valueOf(val);
                            this.currentSample.setFirst(nval);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (property_label.equals("last")) {
                        try {
                            int nval = Integer.valueOf(val);
                            this.currentSample.setlast(Integer.valueOf(nval).intValue());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (property_label.equals("stem")) {
                        this.currentSample.setStem(val);
                    } else if (property_label.equals("format")) {
                        this.currentSample.setFileFormat(val);
                    } else if (property_label.equals("ndigits")) {
                        this.currentSample.setNDigits(val);
                    } else if (property_label.equals("outfile")) {
                        this.currentSample.setPeaksearchOutfile(val);
                    } else if (property_label.equals("workdir")) {
                        this.currentSample.setDirectoryPath(val);
                    }
                }
            } else if (event.getProperty().equals("currentSample")) {
                this.updateCurrentSample();
            } else if (event.getProperty().equals("setOptions")) {
                this.guiOptionsBuilder.setOptions();
            } else if (event.getProperty().equals("unvalidate")) {
                this.peaksearch.firePeakSearchStops();
                TypedText field = (TypedText)event.getNewValue();
                FableMessageConsole.console.displayIn("Please check options :" + ((Xmloption)field.getData()).getOption());
            } else if (event.getProperty().equals("load_ini")) {
                Vector<Xmloption> v_options = this.peaksearch.getOptions();
                int i = 0;
                while (i < v_options.size()) {
                    Xmloption xmloption = v_options.elementAt(i);
                    this.guiOptionsBuilder.loadOptions(null, xmloption);
                    ++i;
                }
                this.guiOptionsBuilder.updateControls();
                if (this.optionsNameText != null) {
                    this.optionsNameText.setText(Peaksearch.getOptionsFile());
                }
            } else if (event.getProperty().equals("save_ini")) {
                this.guiOptionsBuilder.storeDefaultOptions();
                String value = (String)event.getNewValue();
                if (value != null) {
                    try {
                        FableLogger.info((Object)("PeakSearch options saved: " + value));
                        new Xmlwriter("root", "option", value, this.peaksearch.getOptions());
                        SWTUtils.infoMsgAsync((String)("Your options file " + value + " has been saved.\n\n " + "For the next peak search, you can " + "load these options " + "using the " + "\"PeakSearch/Options/Load Options\" " + "menu or you can set this file " + "as the default in PeakSearch " + "preferences " + "(\"Window|Preferences\" menu)."));
                    }
                    catch (XmlwriterException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error saving PeakSearch options", (Throwable)ex);
                    }
                }
            }
        }
    }

    public void updateGuiWithCurrentNavigatorSettings() {
        if (!this.linkToNavigator) {
            return;
        }
        this.guiOptionsBuilder.updateFields(null, "stem", this.currentSample != null ? this.currentSample.getStem() : "");
        if (this.currentSample != null) {
            this.guiOptionsBuilder.setCurrentPath(this.currentSample.getDirectoryPath());
        } else {
            this.guiOptionsBuilder.setCurrentPath(null);
        }
        this.guiOptionsBuilder.updateFields(null, "first", this.currentSample != null ? String.valueOf(this.currentSample.getFirst()) : "");
        this.guiOptionsBuilder.updateFields(null, "last", this.currentSample != null ? String.valueOf(this.currentSample.getLast()) : "");
        this.guiOptionsBuilder.updateFields(null, "format", this.currentSample != null ? this.currentSample.getFileFormat() : "");
        this.guiOptionsBuilder.updateFields("ndigits", this.currentSample != null ? this.currentSample.getNDigits() : "");
        this.guiOptionsBuilder.updateFields("outfile", this.currentSample != null ? this.currentSample.getPeaksearchoutStem() : "");
        this.guiOptionsBuilder.updateFields("workdir", this.currentSample != null ? this.currentSample.getDirectoryPath() : "");
    }

    public boolean validateView() {
        return this.guiOptionsBuilder.validateAndSetOptions();
    }

    public void iniFields(String iniFile) throws PeaksearchException {
        this.peaksearch.loadOptionsFile(iniFile);
    }

    public Vector<Xmloption> getValues() {
        return this.guiOptionsBuilder.getOptions();
    }

    public TypedText getNonValidField() {
        return this.guiOptionsBuilder.getCurrentNonValidField();
    }

    public Vector<Xmloption> getOptions() {
        return this.guiOptionsBuilder.getOptions();
    }

    public Options getGuiBuilder() {
        return this.guiOptionsBuilder;
    }

    public Sample getCurrentSample() {
        return this.currentSample;
    }

    public void updateCurrentSample() {
        if (this.controller != null) {
            this.currentSample = this.controller.getCurrentsample();
            if (this.currentSample != null) {
                this.updateGuiWithCurrentNavigatorSettings();
            }
        }
    }
}

