/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.framework.xmlparser.object.FableXmlContentHandler;
import fable.framework.xmlparser.object.Xmloption;
import fable.peaksearch.Activator;
import fable.peaksearch.object.PeaksearchException;
import fable.python.Sample;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Peaksearch {
    private Vector<Xmloption> options;
    private static Vector<Xmloption> defaultOptions;
    private Vector<Sample> samples;
    private Sample sample;
    private static Logger logger;
    private FableXmlContentHandler xmlContentHandler;
    private XMLReader saxReader;
    private static Peaksearch peaksearch;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ArrayList<String> listKillFile = new ArrayList();
    private static String optionsFile;
    String lastWorkingDirectory;
    private Job job;
    private ArrayList<PeaksearchThread> peaksearchersRunning;
    private boolean forceQuit = false;
    private IProgressMonitor peaksearchProgressMonitor;

    static {
        peaksearch = null;
        optionsFile = "";
    }

    public static Peaksearch getPeaksearch() throws PeaksearchException, JepException {
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    public static Peaksearch getPeaksearch(String optionsFileName) throws PeaksearchException, JepException {
        optionsFile = optionsFileName;
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    private Peaksearch() throws PeaksearchException {
        logger = Logger.getLogger(Peaksearch.class);
        logger.info((Object)"Create Peaksearch");
        if (defaultOptions == null) {
            this.xmlContentHandler = new FableXmlContentHandler();
            optionsFile = Activator.getDefault().getPreferenceStore().getDefaultString("pref_ini_peaksearch");
            if (ToolBox.checkIfFileExists((String)optionsFile)) {
                this.parse();
                defaultOptions = new Vector();
                for (Xmloption opt : this.options) {
                    defaultOptions.add(opt);
                }
                this.options.removeAllElements();
            } else {
                FableLogger.error((Object)("The default options file from preferences does not exist: " + optionsFile));
            }
        }
        if (ToolBox.checkIfFileExists((String)(optionsFile = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch")))) {
            this.parse();
        } else {
            FableLogger.error((Object)("The options file from preferences does not exist: " + optionsFile));
        }
        this.peaksearchersRunning = new ArrayList();
    }

    private void parse() throws PeaksearchException {
        if (this.saxReader == null) {
            try {
                this.saxReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)ex);
                throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
            }
        }
        try {
            this.saxReader.setContentHandler((ContentHandler)this.xmlContentHandler);
            this.saxReader.parse(new InputSource("file:" + optionsFile));
            this.setOptions(this.xmlContentHandler.getOptions());
            this.addMissingOptions();
            this.fireIniFile();
        }
        catch (IOException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)(String.valueOf(optionsFile) + " used to create view not found"), (Throwable)ex);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
        }
        catch (SAXException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)ex);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
        }
    }

    private void addMissingOptions() {
        if (defaultOptions == null) {
            return;
        }
        for (Xmloption defaultOpt : defaultOptions) {
            boolean found = false;
            for (Xmloption opt : this.options) {
                if (!opt.getOption().equals(defaultOpt.getOption())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.options.add(defaultOpt.clone());
        }
    }

    public void loadOptionsFile(String ini) throws PeaksearchException {
        if (ToolBox.checkIfFileExists((String)ini)) {
            optionsFile = ini;
            FableLogger.info((Object)("Loading PeakSearch .xml options file: " + ini));
            this.parse();
            this.addMissingOptions();
        } else {
            FableUtils.errMsg((Object)this, (String)("File does not exist:\n" + ini));
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayIn(" is unable to load  options file: " + ini);
            }
        }
    }

    public Vector<Xmloption> getOptions() {
        return this.options;
    }

    public Sample getSample(int index) {
        Sample s = null;
        if (this.samples != null) {
            s = this.samples.elementAt(index);
        }
        return s;
    }

    public Vector<Sample> getSamples() {
        return this.samples;
    }

    public void setSamples(Vector<Sample> s) {
        this.samples = s;
    }

    public void setOptionsFile(String fileName) {
        optionsFile = fileName;
        this.fireGetOptions();
    }

    public static String getOptionsFile() {
        return optionsFile;
    }

    public void setOptions(Vector<Xmloption> options) {
        this.options = options;
    }

    public void run(final boolean linkToNavigator) {
        if (linkToNavigator) {
            if (this.samples == null) {
                String msg = "PeakSearch cannot be launched : The array of Samples is null";
                FableUtils.errMsg((Object)this, (String)msg);
                return;
            }
            if (this.samples.size() == 0) {
                String msg = "PeakSearch cannot be launched : The array of Samples is empty";
                FableUtils.errMsg((Object)this, (String)msg);
                return;
            }
        }
        this.peaksearchersRunning.removeAll(this.peaksearchersRunning);
        this.listKillFile.removeAll(this.listKillFile);
        this.forceQuit = false;
        this.job = new Job("PeakSearch Job"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!linkToNavigator) {
                    Peaksearch.this.firePeakSearchRuns();
                    new PeaksearchThread().run();
                } else {
                    if (Peaksearch.this.samples == null) {
                        String msg = "PeakSearch cannot be run : The array of Samples is null";
                        FableUtils.errMsg((Object)((Object)this), (String)msg);
                        return Status.CANCEL_STATUS;
                    }
                    if (Peaksearch.this.samples.size() == 0) {
                        String msg = "PeakSearch cannot be run : The array of Samples is empty";
                        FableUtils.errMsg((Object)((Object)this), (String)msg);
                        return Status.CANCEL_STATUS;
                    }
                    if (!Peaksearch.this.forceQuit) {
                        Peaksearch.this.firePeakSearchRuns();
                        int i = 0;
                        int size = Peaksearch.this.samples.size();
                        i = 0;
                        while (i < size && !Peaksearch.this.forceQuit) {
                            Peaksearch.this.sample = (Sample)Peaksearch.this.samples.elementAt(i);
                            Peaksearch.this.peaksearchProgressMonitor = monitor;
                            Peaksearch.this.peaksearchProgressMonitor.beginTask("Search for peaks in sample " + Peaksearch.this.sample.getDirectoryName(), -1);
                            Peaksearch.this.peaksearchersRunning.add(new PeaksearchThread(Peaksearch.this.sample));
                            ((PeaksearchThread)Peaksearch.this.peaksearchersRunning.get(i)).run();
                            if (Peaksearch.this.peaksearchProgressMonitor.isCanceled()) {
                                Peaksearch.this.forceQuit = true;
                                Peaksearch.this.firePeakSearchStops();
                                Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
                                return Status.CANCEL_STATUS;
                            }
                            ++i;
                        }
                    }
                }
                Peaksearch.this.firePeakSearchStops();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(false);
        this.job.schedule();
    }

    public void forceQuit() {
        this.forceQuit = true;
        for (String file : this.listKillFile) {
            File f = new File(file);
            try {
                if (f.createNewFile()) {
                    logger.debug((Object)("Force peaksearch to exit with killFile = " + file));
                } else {
                    logger.debug((Object)("file " + file + " already exists "));
                }
                if (this.peaksearchProgressMonitor != null) {
                    this.peaksearchProgressMonitor.setCanceled(true);
                }
                if (this.job == null) continue;
                this.job.done(Status.CANCEL_STATUS);
            }
            catch (IOException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error creating a file to kill PeakSearch", (Throwable)ex);
            }
        }
        this.peaksearchProgressMonitor.setCanceled(true);
    }

    public boolean isRunning() {
        if (this.job == null) {
            return false;
        }
        return this.job.getState() == 4;
    }

    public boolean hasBeenCanceled() {
        return this.forceQuit;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireGetOptions() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "save_ini", null, (Object)optionsFile));
        }
    }

    public void firePeakSearchRuns() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "run", (Object)false, (Object)true));
        }
    }

    public void fireIniFile() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "load_ini", (Object)false, (Object)true));
        }
    }

    public void fireLaunchPeaksearch() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "start", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchStops() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "stop", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchForceQuit() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "quit", (Object)false, (Object)false));
        }
    }

    public void createTempOptionFile() {
        try {
            FableJep jep = new FableJep();
            FableJep.jepImportSpecificDefinition((Jep)jep.getJep(), (String)"ImageD11", (String)"xml_pks");
            jep.eval("");
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error creating temporary option file for PeakSearch", (Throwable)ex);
        }
    }

    public ArrayList<IPropertyChangeListener> getPropertyChangeListeners() {
        return this.listeners;
    }

    public String getOutputDirectory() {
        String dir = null;
        if (this.options != null) {
            for (Xmloption opt : this.options) {
                if (!opt.getOption().equals("outfile")) continue;
                String fileName = opt.getValue();
                File file = new File(fileName);
                dir = file.getParent();
                break;
            }
        }
        if (dir == null) {
            dir = this.lastWorkingDirectory;
        }
        if (dir == null || dir.length() == 0) {
            return null;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        return dir;
    }

    private void addTimedSleep(String prefix) {
        long lasttime = System.currentTimeMillis();
        System.out.println(String.valueOf(prefix) + "Time before sleep=" + lasttime);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        lasttime = System.currentTimeMillis();
        System.out.println("Time after sleep=" + lasttime);
    }

    class PeaksearchThread
    implements Runnable {
        private Sample sample = null;
        private FableJep peaksearchJep = null;
        private StdoutRead stdout;
        private boolean stop = false;
        private String killFile;
        protected String currentStem;

        public PeaksearchThread(Sample s) {
            this.sample = s;
        }

        public PeaksearchThread() {
        }

        private boolean init() {
            boolean breturn = true;
            try {
                this.peaksearchJep = new FableJep();
                try {
                    File stdoutFilename = File.createTempFile("peaksearcher", ".stdout");
                    stdoutFilename.deleteOnExit();
                    logger.debug((Object)("tempFile = " + stdoutFilename.getAbsolutePath()));
                    this.peaksearchJep.redirectStdout(stdoutFilename.getAbsolutePath());
                    this.stdout = new StdoutRead(stdoutFilename.getAbsolutePath());
                    this.stdout.start();
                    String dir = stdoutFilename.getPath();
                    int index = dir.lastIndexOf(stdoutFilename.getName());
                    if (index > 0 && index < dir.length()) {
                        dir = dir.substring(0, index);
                    }
                    this.killFile = String.valueOf(dir) + "killPeakSearch." + new Date().getTime();
                    Peaksearch.this.listKillFile.add(this.killFile);
                }
                catch (IOException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName()), (Throwable)ex);
                    FableMessageConsole.console.displayIn("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName());
                    breturn = false;
                }
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)("Error running PeakSearch for sample " + this.sample.getDirectoryName()), (Throwable)ex);
                FableMessageConsole.console.displayIn("Error running PeakSearch for sample " + this.sample.getDirectoryName());
            }
            return breturn;
        }

        @Override
        public void run() {
            if (this.stop) {
                this.stdout.stopped = true;
                return;
            }
            if (!this.init()) {
                this.stop = true;
                this.stdout.stopped = true;
                return;
            }
            try {
                this.getDefaultPythonOptions();
            }
            catch (JepException ex) {
                this.catchJepException(ex);
            }
            String workingDirectory = null;
            if (this.sample != null) {
                final String usedDirectory = workingDirectory = this.sample.getDirectoryPath();
                if (this.peaksearchJep != null) {
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayOut("Peak searching on " + usedDirectory);
                            }
                        });
                        this.transferOptionsJavaToPython(this.sample);
                        this.stdout.stopped = true;
                        this.stop = true;
                    }
                    catch (PeaksearchException ex) {
                        this.stdout.stopped = true;
                        this.stop = true;
                        final String consoleMsg = "Error getting PeakSearch options: " + ex.getMessage();
                        FableUtils.excNoTraceMsg((Object)this, (String)"Error getting PeakSearch options", (Throwable)ex);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError(consoleMsg);
                            }
                        });
                    }
                }
            } else {
                try {
                    this.transferOptionsJavaToPython();
                }
                catch (PeaksearchException ex) {
                    this.stdout.stopped = true;
                    this.stop = true;
                    final String msg = "Program failed: " + ex.getMessage();
                    FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FableMessageConsole.console.displayError(msg);
                        }
                    });
                }
            }
            this.stop = true;
        }

        private void catchJepException(JepException ex) {
            this.stdout.stopped = true;
            this.stop = true;
            Peaksearch.this.firePeakSearchStops();
            FableUtils.excNoTraceMsg((Object)this, (String)"Jep Exception in PeakSearch", (Throwable)ex);
            if (Peaksearch.this.peaksearchProgressMonitor != null) {
                Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
            }
        }

        private void getDefaultPythonOptions() throws JepException {
            try {
                FableJep.jepImportSpecificDefinition((Jep)this.peaksearchJep.getJep(), (String)"ImageD11", (String)"peaksearcher");
                this.peaksearchJep.eval("class o:\n    def add_option(self, *a, **k):\n        setattr(self, k[\"dest\"], k[\"default\"])\n");
                this.peaksearchJep.eval("option_holder = o()");
                this.peaksearchJep.eval("temp=peaksearcher.get_options( option_holder )");
                this.peaksearchJep.flushStdout();
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error getting Python options", (Throwable)ex);
            }
        }

        public void notifyEndToPeaksearch() {
            logger.debug((Object)("killFile = " + this.killFile));
            new File(this.killFile);
            this.stop = true;
        }

        private void transferOptionsJavaToPython(final Sample mySample) throws PeaksearchException {
            String workingDirectory = null;
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                if (opt.getOption().equals("stem")) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            logger.info((Object)("we are peaksearching for these files stem = " + mySample.getStem()));
                            PeaksearchThread.this.currentStem = mySample.getStem();
                        }
                    });
                    opt.setValue(this.currentStem);
                } else if (opt.getOption().equals("first")) {
                    opt.setValue(String.valueOf(mySample.getFirst()));
                } else if (opt.getOption().equals("format")) {
                    opt.setValue(String.valueOf(mySample.getFileFormat()));
                } else if (opt.getOption().equals("last")) {
                    opt.setValue(String.valueOf(mySample.getLast()));
                } else if (opt.getOption().equals("outfile")) {
                    String shortOutputName = mySample.getPeaksearchoutStem();
                    if (shortOutputName != null) {
                        opt.setValue(String.valueOf(shortOutputName) + ".spt");
                    }
                    shortOutputName = opt.getValue();
                } else if (opt.getOption().equals("workdir")) {
                    workingDirectory = opt.getValue();
                } else if (opt.getOption().equals("ndigits")) {
                    opt.setValue(String.valueOf(mySample.getNDigits()));
                }
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    try {
                        boolean res = this.setWorkingDirectoryInPython(workingDirectory);
                        if (!res) {
                            throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", "Error setting the PeakSearch working directory");
                        }
                    }
                    catch (JepException ex) {
                        throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", ex.getMessage());
                    }
                    this.optionDriver();
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error setting kill file for PeakSearch for stem " + mySample.getDirectoryName()), (Throwable)ex);
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error setting kill file for PeakSearch for stem " + mySample.getDirectoryName() + ".");
                    }
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", ex.getMessage());
                }
            }
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private void transferOptionsJavaToPython() throws PeaksearchException {
            String workingDirectory = null;
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                if (opt.getOption().equals("outfile")) {
                    String shortOutputName = opt.getValue();
                    if (shortOutputName != null && !shortOutputName.endsWith(".spt")) {
                        opt.setValue(String.valueOf(shortOutputName) + ".spt");
                    }
                } else if (opt.getOption().equals("workdir")) {
                    workingDirectory = opt.getValue();
                }
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    try {
                        boolean res = this.setWorkingDirectoryInPython(workingDirectory);
                        if (!res) {
                            throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", "Error setting the PeakSearch working directory");
                        }
                    }
                    catch (JepException ex) {
                        throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", ex.getMessage());
                    }
                    this.optionDriver();
                }
                catch (JepException ex) {
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", ex.getMessage());
                }
            }
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private boolean setWorkingDirectoryInPython(String workingDirectory) throws JepException {
            String dir = workingDirectory;
            if (!(dir != null && dir.length() != 0 || (dir = System.getProperty("user.dir", "")) != null && dir.length() != 0)) {
                FableUtils.errMsg((Object)this, (String)"Cannot determine PeakSearch working directory");
                return false;
            }
            File file = new File(dir);
            if (!file.exists()) {
                FableUtils.errMsg((Object)this, (String)("Specified PeakSearch working directory does not exist:\n" + dir));
                return false;
            }
            if (!file.isDirectory()) {
                FableUtils.errMsg((Object)this, (String)("Specified PeakSearch working directory is not a directory:\n" + dir));
                return false;
            }
            if (this.peaksearchJep == null) {
                FableUtils.errMsg((Object)this, (String)"Cannot set PeakSearch working directory: Jep is null");
                return false;
            }
            Peaksearch.this.lastWorkingDirectory = null;
            FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
            this.peaksearchJep.eval("os.chdir(\"" + dir + "\")");
            Peaksearch.this.lastWorkingDirectory = dir;
            return true;
        }

        private void setKillFile() {
            if (this.killFile != null && !Peaksearch.this.forceQuit) {
                try {
                    this.peaksearchJep.set("killfile", this.killFile);
                    this.peaksearchJep.eval("option_holder.killfile=killfile");
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error setting kill file name for PeakSearch", (Throwable)ex);
                }
            }
        }

        private void optionDriver() throws JepException {
            this.peaksearchJep.eval("peaksearcher.peaksearch_driver( option_holder , () )");
            this.peaksearchJep.flushStdout();
        }

        private void optionHolder(Xmloption opt) throws PeaksearchException {
            logger.info((Object)(String.valueOf(opt.getDest()) + " " + opt.getOption() + " get value: " + opt.getValue() + " and type " + opt.getType()));
            if (opt.getValue() != null && !opt.getValue().equals("")) {
                if (opt.getOption().equals("workdir")) {
                    FableMessageConsole.console.displayOut("opt:" + opt.getOption() + "=" + opt.getValue());
                    return;
                }
                try {
                    this.peaksearchJep.eval("option_holder." + opt.toString());
                    logger.info((Object)("option_holder." + opt.toString()));
                }
                catch (JepException ex) {
                    String msg = "Error setting options for PeakSearch [" + opt.getOption() + "]";
                    FableLogger.error((Object)msg, (Throwable)ex);
                    throw new PeaksearchException(1, this.getClass().getName(), "optionHolder", String.valueOf(msg) + ": " + ex.getMessage());
                }
            }
            try {
                this.peaksearchJep.flushStdout();
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error flushing stdout for PeakSearch", (Throwable)ex);
            }
            FableMessageConsole.console.displayOut("opt:" + opt.getOption() + "=" + opt.getValue());
        }
    }
}

