/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.imageviewer.views.ImageView;
import fable.peaksearch.view.PeaksSptView;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenSptFileResource
implements IObjectActionDelegate {
    private ISelection selection = null;
    private int nview = 0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IFile iFile = null;
        if (this.selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)this.selection).iterator();
            while (it.hasNext()) {
                iFile = null;
                Object element = it.next();
                if (element instanceof IFile) {
                    iFile = (IFile)element;
                } else if (element instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)element).getAdapter(IFile.class);
                }
                if (iFile == null) continue;
                this.loadFile(iFile);
            }
        }
    }

    private void loadFile(IFile iFile) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.peaksearch.perspective.smallScreen", window);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.peaksearch.perspective", window);
                }
            }
            catch (WorkbenchException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening PeakSearch perspective", (Throwable)ex);
                return;
            }
            try {
                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "right", 1);
                imageView.initWithShowPeaks();
            }
            catch (PartInitException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening ImageView", (Throwable)ex);
                return;
            }
            try {
                IViewPart[] stack_view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewStack((IViewPart)PeaksSptView.view);
                if (stack_view != null) {
                    this.nview = stack_view.length;
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(PeaksSptView.getID(), "\"" + this.nview + "\"", 1);
                PeaksSptView cfr_ignored_0 = (PeaksSptView)window.getActivePage().getWorkbenchWindow().getActivePage().findView(PeaksSptView.getID());
                PeaksSptView.view.loadSptFile(iFile.getLocation().toString());
            }
            catch (PartInitException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening PeaksSptView", (Throwable)ex);
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

