/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class LoadXmlOption
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.peaksearch.actions.LoadXmlOption";
    private static final String[] filterName = new String[]{".xml", "All(*.*)"};
    private static final String[] filterExt = new String[]{"*.xml", "*.*;*"};

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.loadDefaultOption();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        this.loadDefaultOption();
    }

    private void loadDefaultOption() {
        FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell(), 64);
        dlg.setFilterNames(filterName);
        dlg.setFilterExtensions(filterExt);
        try {
            String fileName;
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null) {
                if (ToolBox.isSmallPerspectiveSet()) {
                    activeWindow.getWorkbench().showPerspective("fable.peaksearch.perspective.smallScreen", activeWindow);
                } else {
                    activeWindow.getWorkbench().showPerspective("fable.peaksearch.perspective", activeWindow);
                }
            }
            if ((fileName = dlg.open()) != null) {
                Peaksearch.getPeaksearch(fileName).loadOptionsFile(fileName);
                FableMessageConsole.console.displayOut("PeakSearch options loaded from: " + fileName);
            }
        }
        catch (PeaksearchException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
        }
        catch (WorkbenchException ex) {
            FableUtils.excTraceMsg((Object)((Object)this), (String)"Error loading PeakSearch options", (Throwable)ex);
        }
    }

    public static String getID() {
        return ID;
    }
}

