/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.grainspotter.actions.OpenGveFileAction;
import fable.grainspotter.editors.GrainSpotterGveFile3D;
import fable.grainspotter.internal.IVarKeys;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class Grains3DView
extends ViewPart {
    public static final String ID = "fable.grainspotter.grains3dview";
    private GrainSpotterGveFile3D plot3D;
    private Text gveNameText;
    private Action infoAction;
    private OpenGveFileAction openGvecFileAction;
    private DropTarget dropTargetGveFile;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite row1 = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)row1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        row1.setLayout((Layout)gridLayout);
        Label label = new Label(row1, 0);
        label.setText("Gve file :");
        this.gveNameText = new Text(row1, 2048);
        this.gveNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gveNameText.setText("No .gve file loaded");
        this.gveNameText.setToolTipText("The name of the .gve file used in this view. You can drag a .gve file here.");
        this.gveNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    Grains3DView.this.loadGVectors(Grains3DView.this.gveNameText.getText());
                }
            }
        });
        this.dropTargetGveFile = new DropTarget((Control)this.gveNameText, 17);
        this.dropTargetGveFile.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        this.dropTargetGveFile.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String fileName = (String)event.data;
                    Grains3DView.this.gveNameText.setText(fileName);
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileNames = (String[])event.data;
                    Grains3DView.this.gveNameText.setText(fileNames[0]);
                    Grains3DView.this.loadGVectors(Grains3DView.this.gveNameText.getText());
                }
            }
        });
        Button browse = new Button(row1, 8);
        browse.setText("Browse...");
        browse.setToolTipText("Browse for a .gve file.");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
                fileDlg.setText("Select a .gve file.");
                String file = fileDlg.open();
                if (file != null) {
                    Grains3DView.this.gveNameText.setText(file);
                }
            }
        });
        this.plot3D = new GrainSpotterGveFile3D(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.plot3D);
        this.makeActions();
        this.contributeToActionBars();
    }

    public void dispose() {
        if (this.dropTargetGveFile != null) {
            this.dropTargetGveFile.dispose();
        }
        super.dispose();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openGvecFileAction);
        manager.add((IAction)this.infoAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openGvecFileAction);
        manager.add((IAction)this.infoAction);
    }

    private void makeActions() {
        this.openGvecFileAction = new OpenGveFileAction();
        if (this.plot3D != null) {
            this.infoAction = this.plot3D.getInfoAction();
        }
    }

    public void setFocus() {
        if (this.plot3D != null) {
            this.plot3D.setFocus();
        }
    }

    public void loadGVectors(String fileName) {
        if (this.plot3D != null && fileName != null) {
            this.plot3D.loadGVectors(fileName);
            this.gveNameText.setText(fileName);
        }
    }

    public void setLogFile(String fileName) {
        if (this.plot3D != null) {
            this.plot3D.setLogFile(fileName);
        }
    }

    public static String getID() {
        return ID;
    }

    public GrainSpotterGveFile3D getPlot3D() {
        return this.plot3D;
    }
}

