/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.OpenGveFileAction;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.run.ReadGveThread;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

@Deprecated
public class Grains3DOrigView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.grainspotter.grains3dorigview";
    GrainSpotter grainSpotter;
    public static Grains3DOrigView thisView = null;
    public static GLContext context;
    public static GLU glu;
    private static SceneGrip grip;
    private Button gvectorShowButton;
    private Composite controlsComposite;
    private Composite canvasComposite;
    private Composite xyzControlsComposite;
    private static GLCanvas canvas;
    private static double[] oneGrain_xyz;
    private static int pointSize;
    private static Spinner pointSizeSpinner;
    private static int grains;
    private static Combo grainSelectCombo;
    private static int selectedGrain;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Text xrotText;
    private Text yrotText;
    private static Boolean showGVectors;
    private static Boolean allGvectorsListFirst;
    private static int allGvectorsList;
    private static int width;
    private static int height;
    private static float aspect;
    private Action infoAction;
    private OpenGveFileAction openGvecFileAction;
    public static ReadGveThread readgveThread;
    private LogFile logFile;
    private Text logFileText;
    private Logger logger;

    static {
        glu = new GLU();
        pointSize = 1;
        grains = 1;
        selectedGrain = 1;
        showGVectors = false;
        allGvectorsListFirst = true;
    }

    static void init(GLCanvas canvas) {
        canvas.setCurrent();
        Grains3DOrigView.resize(canvas);
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glHint((int)3152, (int)4354);
    }

    static void render() {
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClear((int)16640);
        GL11.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        GL11.glLoadIdentity();
        grip.adjust();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)1, (int)0, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)1, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)0, (int)1);
        GL11.glPointSize((float)pointSize);
        GL11.glCallList((int)allGvectorsList);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRasterPos2i((int)1, (int)1);
        GL11.glEnable((int)2896);
    }

    static void resize(GLCanvas canvas) {
        canvas.setCurrent();
        Rectangle rect = canvas.getClientArea();
        width = rect.width;
        height = Math.max(rect.height, 1);
        aspect = (float)width / (float)height;
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        thisView = this;
        this.grainSpotter = new GrainSpotter();
        this.grainSpotter.addPropertyChangeListener(this);
        this.logger = Logger.getLogger(Grains3DOrigView.class);
        readgveThread = new ReadGveThread();
        parent.setLayout((Layout)new GridLayout());
        GridLayout threeColGridLayout = new GridLayout();
        threeColGridLayout.numColumns = 3;
        threeColGridLayout.makeColumnsEqualWidth = false;
        this.controlsComposite = new Composite(parent, 4);
        this.controlsComposite.setLayout((Layout)threeColGridLayout);
        this.controlsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Group gvectorShowGroup = new Group(this.controlsComposite, 0);
        gvectorShowGroup.setText("plot gvectors");
        gvectorShowGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        gvectorShowGroup.setLayout((Layout)new FillLayout());
        this.gvectorShowButton = new Button((Composite)gvectorShowGroup, 32);
        this.gvectorShowButton.setText("show all gvectors");
        this.gvectorShowButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Grains3DOrigView.this.updatePlot3D();
            }
        });
        Group grainSelectGroup = new Group(this.controlsComposite, 0);
        grainSelectGroup.setText("plot grain");
        grainSelectGroup.setLayout((Layout)new GridLayout(4, false));
        grainSelectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lbl = new Label((Composite)grainSelectGroup, 0);
        this.logFileText = new Text((Composite)grainSelectGroup, 2048);
        this.logFileText.setLayoutData((Object)new GridData(4, 4, true, false));
        lbl.setText("Log file");
        this.logFileText.setToolTipText("Set log file name from grainspotter output to plot gve against grains");
        this.logFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Grains3DOrigView.this.parseLogFile();
            }
        });
        this.logFileText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    Grains3DOrigView.this.parseLogFile();
                }
            }
        });
        Button browse = new Button((Composite)grainSelectGroup, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setText("Select a log file.");
                String file = fileDlg.open();
                if (file != null) {
                    Grains3DOrigView.this.logFileText.setText(file);
                }
            }
        });
        grainSelectCombo = new Combo((Composite)grainSelectGroup, 4);
        grainSelectCombo.setToolTipText("Plot g-vectors per Grain number from log file.");
        grainSelectCombo.add("all grains");
        int i = 0;
        while (i < grains) {
            grainSelectCombo.add(Integer.toString(i + 1));
            ++i;
        }
        grainSelectCombo.select(0);
        grainSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectedGrain = grainSelectCombo.getSelectionIndex();
                if (selectedGrain > 0) {
                    selectedGrain = selectedGrain - 1;
                }
                Grains3DOrigView.this.plotGrain();
                Grains3DOrigView.drawAllGvectorsList();
                Grains3DOrigView.render();
                Grains3DOrigView.resize(canvas);
            }
        });
        Group pointSizeGroup = new Group(this.controlsComposite, 0);
        pointSizeGroup.setText("point size");
        pointSizeGroup.setLayout((Layout)new FillLayout());
        pointSizeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        pointSizeSpinner = new Spinner((Composite)pointSizeGroup, 0x1000004);
        pointSizeSpinner.setMinimum(1);
        pointSizeSpinner.setMaximum(10);
        pointSizeSpinner.setSelection(1);
        pointSizeSpinner.setIncrement(1);
        pointSizeSpinner.setPageIncrement(5);
        pointSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                pointSize = pointSizeSpinner.getSelection();
                Grains3DOrigView.drawAllGvectorsList();
            }
        });
        GLData data = new GLData();
        data.doubleBuffer = true;
        Composite plotComposite = new Composite(parent, 4);
        GridLayout plotGridLayout = new GridLayout();
        plotGridLayout.numColumns = 2;
        plotComposite.setLayout((Layout)plotGridLayout);
        plotComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvasComposite = new Composite(plotComposite, 4);
        this.canvasComposite.setLayout((Layout)new GridLayout());
        this.canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas = new GLCanvas(this.canvasComposite, 262144, data);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Grains3DOrigView.resize(canvas);
            }
        });
        this.xyzControlsComposite = new Composite(plotComposite, 4);
        this.xyzControlsComposite.setLayout((Layout)new GridLayout());
        this.xyzControlsComposite.setLayoutData((Object)new GridData(0, 4, false, true));
        Group xoffGroup = new Group(this.xyzControlsComposite, 4);
        xoffGroup.setText("xoff");
        xoffGroup.setLayout((Layout)new FillLayout());
        xoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xoffText = new Text((Composite)xoffGroup, 0x1000004);
        Group yoffGroup = new Group(this.xyzControlsComposite, 4);
        yoffGroup.setText("yoff");
        yoffGroup.setLayout((Layout)new FillLayout());
        yoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yoffText = new Text((Composite)yoffGroup, 0x1000004);
        Group zoffGroup = new Group(this.xyzControlsComposite, 4);
        zoffGroup.setText("zoff");
        zoffGroup.setLayout((Layout)new FillLayout());
        zoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.zoffText = new Text((Composite)zoffGroup, 0x1000004);
        Group xrotGroup = new Group(this.xyzControlsComposite, 4);
        xrotGroup.setText("xrot");
        xrotGroup.setLayout((Layout)new FillLayout());
        xrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xrotText = new Text((Composite)xrotGroup, 0x1000004);
        Group yrotGroup = new Group(this.xyzControlsComposite, 4);
        yrotGroup.setText("yrot");
        yrotGroup.setLayout((Layout)new FillLayout());
        yrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yrotText = new Text((Composite)yrotGroup, 0x1000004);
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        Grains3DOrigView.init(canvas);
        grip = new SceneGrip();
        grip.setDefaultView();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        new Runnable(){

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                Grains3DOrigView.render();
                canvas.swapBuffers();
                canvas.getDisplay().timerExec(100, (Runnable)this);
            }
        }.run();
        parent.pack();
    }

    private void parseLogFile() {
        if (!this.logFileText.getText().equals("")) {
            this.loadLogFile(this.logFileText.getText());
        } else {
            oneGrain_xyz = null;
            this.logFile = null;
            grainSelectCombo.removeAll();
            Grains3DOrigView.drawAllGvectorsList();
        }
    }

    public void dispose() {
        this.grainSpotter.removePropertyChangeListener(this);
    }

    private static void drawAllGvectorsList() {
        if (allGvectorsListFirst.booleanValue()) {
            GL11.glDeleteLists((int)allGvectorsList, (int)1);
            allGvectorsList = GL11.glGenLists((int)1);
            FableLogger.debug((Object)"Grains3DView :drawAllGvectorsList -GL11.glDeleteLists(allGvectorsList, 1);");
        }
        allGvectorsListFirst = false;
        GL11.glNewList((int)allGvectorsList, (int)4864);
        GL11.glPointSize((float)pointSize);
        if (showGVectors.booleanValue()) {
            GL11.glBegin((int)0);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            CopyOnWriteArrayList<double[]> list = readgveThread.getGveXYZ();
            int i_gv = 0;
            while (i_gv < list.size()) {
                double[] gvector_xyz = (double[])list.get(i_gv);
                GL11.glVertex3d((double)gvector_xyz[0], (double)gvector_xyz[1], (double)gvector_xyz[2]);
                ++i_gv;
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)0);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (oneGrain_xyz != null) {
            int i_gv = 0;
            while (i_gv < oneGrain_xyz.length / 3) {
                GL11.glVertex3d((double)oneGrain_xyz[i_gv * 3], (double)oneGrain_xyz[i_gv * 3 + 1], (double)oneGrain_xyz[i_gv * 3 + 2]);
                ++i_gv;
            }
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void setFocus() {
        canvas.setFocus();
    }

    public static int getPointSize() {
        return pointSize;
    }

    public static void setPointSize(int pointSize) {
        Grains3DOrigView.pointSize = pointSize;
    }

    public static int getGrains() {
        return grains;
    }

    public static void setGrains(int grains) {
        Grains3DOrigView.grains = grains;
        String[] items = new String[grains + 1];
        items[0] = "all grains";
        int i = 0;
        while (i < grains) {
            items[i + 1] = Integer.toString(i + 1);
            ++i;
        }
        grainSelectCombo.setItems(items);
    }

    public void plotGrain() {
        int index = grainSelectCombo.getSelectionIndex();
        boolean valReturn = true;
        valReturn = index > 0 ? this.fillGvecPerGrains(index - 1) : this.getAllGrains();
        this.updatePlot3D();
        if (!valReturn) {
            SWTUtils.infoMsgAsync((String)"All g-vectors available in log file couldn' t be loaded.\nCheck in your Grainspotter ini file if log file has been generated with this g-vector file");
            FableMessageConsole.console.displayInfo("All g-vectors available in log file couldn' t be loaded.\nCheck in your Grainspotter ini file if log file has been generated with this g-vector file");
        }
    }

    private boolean getAllGrains() {
        boolean valReturn = true;
        if (this.logFile != null) {
            GrainSyntaxModel grains = this.logFile.getGrains();
            oneGrain_xyz = new double[grains.getGvecsExpected() * 3];
            int begin = 0;
            int j = 0;
            while (j < grains.getGrains().size()) {
                GrainSyntaxModel grain = grains.getGrains().get(j);
                List<GrainGvectorModel> vectors = grain.getGVectors();
                this.logger.info((Object)("Get Grain #" + grain.getId() + " for plotting in getAllGrains() "));
                int i = 0;
                while (i < vectors.size()) {
                    int gvector_id = vectors.get(i).getid();
                    int index = i * 3 + begin;
                    if (readgveThread.getGveXYZ().size() > gvector_id) {
                        double[] xyz = readgveThread.getGveXYZ().get(gvector_id);
                        Grains3DOrigView.oneGrain_xyz[index] = xyz[0];
                        Grains3DOrigView.oneGrain_xyz[++index] = xyz[1];
                        Grains3DOrigView.oneGrain_xyz[++index] = xyz[2];
                    } else {
                        valReturn = false;
                        this.logger.info((Object)("G-Vector id= " + gvector_id + " not found for Grain #" + grain.getId()));
                    }
                    ++i;
                }
                begin += vectors.size() * 3;
                ++j;
            }
        }
        return valReturn;
    }

    private boolean fillGvecPerGrains(int grainIndex) {
        boolean valReturn = true;
        if (this.logFile != null) {
            GrainSyntaxModel grain = this.logFile.getGrains().getGrains().get(grainIndex);
            List<GrainGvectorModel> vectors = grain.getGVectors();
            oneGrain_xyz = new double[vectors.size() * 3];
            this.logger.info((Object)("Grain #" + grain.getId()));
            int i = 0;
            while (i < vectors.size()) {
                int gvector_id = vectors.get(i).getid();
                if (readgveThread.getGveXYZ().size() > gvector_id) {
                    double[] xyz = readgveThread.getGveXYZ().get(gvector_id);
                    Grains3DOrigView.oneGrain_xyz[i * 3] = xyz[0];
                    Grains3DOrigView.oneGrain_xyz[i * 3 + 1] = xyz[1];
                    Grains3DOrigView.oneGrain_xyz[i * 3 + 2] = xyz[2];
                } else {
                    valReturn = false;
                    this.logger.info((Object)("G-Vector id = " + gvector_id));
                }
                ++i;
            }
        }
        return valReturn;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openGvecFileAction);
        manager.add((IAction)this.infoAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openGvecFileAction);
        manager.add((IAction)this.infoAction);
    }

    private void makeActions() {
        this.openGvecFileAction = new OpenGveFileAction();
        this.infoAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsHelpDialog dialog = new GraphicsHelpDialog(Grains3DOrigView.this.getSite().getWorkbenchWindow().getShell());
                        dialog.open();
                    }
                });
            }
        };
        this.infoAction.setText("Graphics Help");
        this.infoAction.setToolTipText("Summary of Graphics Manipulations");
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private static String getGraphicsHelp() {
        String ls = System.getProperty("line.separator");
        String info = "";
        info = String.valueOf(info) + "Button 1: Drag to examine" + ls;
        info = String.valueOf(info) + "Button 2: Drag vertically to zoom" + ls;
        info = String.valueOf(info) + "Button 3: Drag to pan" + ls;
        info = String.valueOf(info) + "Mouse Wheel: Zoom in/out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Up Arrow: Pan up" + ls;
        info = String.valueOf(info) + "Down Arrow: Pan down" + ls;
        info = String.valueOf(info) + "Left Arrow: Pan left" + ls;
        info = String.valueOf(info) + "Right Arrow: Pan right" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Ctrl + Up Arrow: Rotate one way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Down Arrow: Rotate other way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Left Arrow: Rotate one way about about vertical axis" + ls;
        info = String.valueOf(info) + "Ctrl + Right Arrow: Rotate other way about vertical axis" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Page Up: Zoom in" + ls;
        info = String.valueOf(info) + "Page Down: Zoom out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Home: Reset" + ls;
        info = String.valueOf(info) + "End: Reset to X-Axis right, Y-axis up, Z-axis out";
        return info;
    }

    public void loadGVectors(String fileName) {
        readgveThread.setGvectorFile(fileName);
        readgveThread.run();
        File f = new File(fileName);
        String name = f.getName();
        if (name != null) {
            this.setPartName(name);
            this.setTitleToolTip(fileName);
            this.setContentDescription(fileName);
        } else {
            this.setPartName("3DView");
            this.setContentDescription("");
        }
        this.gvectorShowButton.setSelection(true);
        this.plotGrain();
        if (!this.logFileText.getText().trim().equals("")) {
            this.loadLogFile(this.logFileText.getText());
        }
    }

    private void updatePlot3D() {
        showGVectors = this.gvectorShowButton.getSelection();
        Grains3DOrigView.drawAllGvectorsList();
    }

    private void loadLogFile(String file) {
        this.logFile = new LogFile(file);
        try {
            Job parsingJob = this.logFile.getParsingJob();
            parsingJob.schedule();
            parsingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int numGrains = Grains3DOrigView.this.logFile.getGrains().getGrains().size();
                            Grains3DOrigView.setGrains(numGrains);
                            grainSelectCombo.select(0);
                            Grains3DOrigView.this.plotGrain();
                        }
                    });
                }
            });
        }
        catch (GrainSpotterException e) {
            SWTUtils.infoMsgAsync((String)(String.valueOf(e.get_message()) + ".\n\nTry to plot when you are sure log file exists."));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("new log file")) {
            this.logFile = (LogFile)event.getNewValue();
            final String tryWithCurrentPath = String.valueOf((String)event.getOldValue()) + System.getProperty("file.separator") + this.logFile.getFileName();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    File myFile = new File(Grains3DOrigView.this.logFile.getFileName());
                    if (!myFile.exists()) {
                        Grains3DOrigView.this.logFileText.setText(tryWithCurrentPath);
                    } else {
                        Grains3DOrigView.this.logFileText.setText(Grains3DOrigView.this.logFile.getFileName());
                    }
                }
            });
        } else if (event.getProperty().equals("new gve file")) {
            String fileName = (String)event.getNewValue();
            String tryWithCurrentPath = String.valueOf((String)event.getOldValue()) + System.getProperty("file.separator") + fileName;
            File myFile = new File(fileName);
            if (!myFile.exists()) {
                this.loadGVectors(tryWithCurrentPath);
            } else {
                this.loadGVectors(fileName);
            }
        } else if (event.getProperty().equals("grainspotter") && event.equals("stopped")) {
            this.logFile = this.grainSpotter.getLogFile();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Grains3DOrigView.this.logFileText.setText(Grains3DOrigView.this.logFile.getFileName());
                }
            });
        }
    }

    public class GraphicsHelpDialog
    extends Dialog {
        public GraphicsHelpDialog(Shell parent) {
            this(parent, 2144);
        }

        public GraphicsHelpDialog(Shell parent, int style) {
            super(parent, style);
        }

        public String open() {
            Shell shell = new Shell(this.getParent(), this.getStyle());
            shell.setText("Graphics Help");
            shell.setImage(Grains3DOrigView.this.getTitleImage());
            this.createContents(shell);
            shell.pack();
            shell.open();
            Display display = this.getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return null;
        }

        private void createContents(final Shell shell) {
            GridLayout grid = new GridLayout();
            grid.numColumns = 1;
            shell.setLayout((Layout)grid);
            Group box = new Group((Composite)shell, 2048);
            box.setText("Graphics Manipulations");
            grid = new GridLayout();
            grid.numColumns = 1;
            box.setLayout((Layout)grid);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            box.setLayoutData((Object)data);
            Text text = new Text((Composite)box, 2);
            text.setEditable(false);
            text.setText(Grains3DOrigView.getGraphicsHelp());
            data = new GridData();
            text.setLayoutData((Object)data);
            Button close = new Button((Composite)shell, 8);
            close.setText("Close");
            data = new GridData(64);
            close.setLayoutData((Object)data);
            close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    shell.close();
                }
            });
            shell.setDefaultButton(close);
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private boolean move;
        private boolean zoom;
        private int xdown;
        private int ydown;
        private int ylast;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            this.zoff = -8.0f;
            Grains3DOrigView.this.xrotText.setText(Float.toString(this.xrot));
            Grains3DOrigView.this.yrotText.setText(Float.toString(this.yrot));
            Grains3DOrigView.this.xoffText.setText(Float.toString(this.xoff));
            Grains3DOrigView.this.yoffText.setText(Float.toString(this.yoff));
            Grains3DOrigView.this.zoffText.setText(Float.toString(this.zoff));
        }

        public void setDefaultView() {
            this.init();
            grip.setOffsets(-0.25f, -0.25f, -5.5f);
            grip.setRotation(45.0f, -30.0f);
        }

        public void mouseDown(MouseEvent e) {
            if (++this.mouseDown == 1) {
                this.move = false;
                this.zoom = false;
                if (e.button == 2) {
                    this.zoom = true;
                } else {
                    this.move = e.button == 3;
                    if (this.move) {
                        this.xcpy = this.xoff;
                        this.ycpy = this.yoff;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(21));
                    } else {
                        this.xcpy = this.xrot;
                        this.ycpy = this.yrot;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(5));
                    }
                }
                this.xdown = e.x;
                this.ydown = this.ylast = e.y;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (--this.mouseDown == 0) {
                ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent e) {
            Point p = ((Control)e.widget).getSize();
            if (this.mouseDown > 0) {
                if (this.zoom) {
                    int dy = e.y - this.ylast;
                    this.ylast = e.y;
                    this.zoff += (float)dy / 6.0f;
                } else if (this.move) {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.yoff = this.ycpy + (this.zoff + 1.0f) * (float)dy / (2.0f * (float)p.y);
                    this.xoff = this.xcpy - (this.zoff + 1.0f) * (float)dx / (2.0f * (float)p.x);
                } else {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.xrot = this.xcpy + (float)dy / 2.0f;
                    this.yrot = this.ycpy + (float)dx / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff += (float)event.count / 6.0f;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot -= 0.5f;
                        break;
                    }
                    this.yoff += 0.05f;
                    break;
                }
                case 0x1000002: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot += 0.5f;
                        break;
                    }
                    this.yoff -= 0.05f;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot -= 0.5f;
                        break;
                    }
                    this.xoff -= 0.05f;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot += 0.5f;
                        break;
                    }
                    this.xoff += 0.05f;
                    break;
                }
                case 0x1000005: {
                    this.zoff += 0.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff -= 0.05f;
                    break;
                }
                case 0x1000007: {
                    this.setDefaultView();
                    break;
                }
                case 0x1000008: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void updateTextDisplay() {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
            nf.applyPattern("0.0");
            Grains3DOrigView.this.xrotText.setText(nf.format(this.xrot));
            Grains3DOrigView.this.yrotText.setText(nf.format(this.yrot));
            Grains3DOrigView.this.xoffText.setText(nf.format(this.xoff));
            Grains3DOrigView.this.yoffText.setText(nf.format(this.yoff));
            Grains3DOrigView.this.zoffText.setText(nf.format(this.zoff));
        }

        public void adjust() {
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            GL11.glOrtho((double)(-grip.zoff), (double)grip.zoff, (double)(-grip.zoff / aspect), (double)(grip.zoff / aspect), (double)-100000.0, (double)100000.0);
            GL11.glTranslatef((float)this.xoff, (float)this.yoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)0.1f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)0.1f, (float)0.0f);
            this.updateTextDisplay();
        }

        public void setOffsets(float x, float y, float z) {
            this.xoff = x;
            this.yoff = y;
            this.zoff = z;
        }

        public void setRotation(float x, float y) {
            this.xrot = x;
            this.yrot = y;
        }
    }
}

