/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterInput;
import fable.grainspotter.internal.IGrainSpotterHelp;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.InputFile;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GrainSpotterInputEditor
extends MultiPageEditorPart
implements IGrainSpotterHelp,
IResourceChangeListener,
IReusableEditor {
    private static final String ID = "fable.grainspotter.editors.GrainspotterInputEditor";
    private static final boolean USE_TEXT_EDITOR = false;
    private TextEditor textEditor;
    private InputFile inputFile;
    private static final int indexPageInput = 0;
    private static final int indexText = 1;
    private boolean pagesCreated = false;
    private boolean dirty = false;
    private boolean justSaved = false;
    protected int activeColumn;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/add.gif");
    private GrainSpotterInput gsInput;

    public GrainSpotterInputEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.justSaved = false;
        this.updateTitle();
    }

    protected void createPages() {
        this.createPageInput();
        this.pagesCreated = true;
    }

    void createPageInput() {
        this.createInputFile();
        this.gsInput = new GrainSpotterInput(this.getContainer(), 0, this);
        this.gsInput.setInputFile(this.inputFile);
        this.gsInput.init();
        if (!this.pagesCreated) {
            this.addPage(0, (Control)this.gsInput);
            this.setPageText(0, "Input");
        } else {
            this.setControl(0, (Control)this.gsInput);
        }
    }

    protected void createText() {
        try {
            this.textEditor = new TextEditor();
            if (this.pagesCreated) {
                this.removePage(1);
            }
            this.addPage(1, (IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(1, "Text");
        }
        catch (PartInitException e) {
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)"Error creating text editor", null, (IStatus)e.getStatus());
        }
    }

    public void createInputFile() {
        block5: {
            if (this.inputFile != null) {
                return;
            }
            IPath iPath = SWTUtils.getPath((IEditorInput)this.getEditorInput());
            if (iPath == null) {
                FableUtils.errMsg((Object)this, (String)"Cannot find path for input file");
                return;
            }
            String fileName = iPath.toOSString();
            if (fileName == null) {
                FableUtils.errMsg((Object)this, (String)"Input file name is null");
                return;
            }
            try {
                this.inputFile = new InputFile(fileName);
                this.inputFile.parseIniFile(fileName);
            }
            catch (GrainSpotterException ex) {
                String msg = "Error parsing GrainSpotter .ini file: " + fileName;
                FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
                if (FableMessageConsole.console == null) break block5;
                FableMessageConsole.console.displayError(ex.get_message());
            }
        }
    }

    public void doSave(IProgressMonitor arg0) {
        this.save();
    }

    public void save() {
        if (this.gsInput.setOptions()) {
            block3: {
                this.setDirty(false);
                try {
                    this.inputFile.save();
                    this.justSaved = true;
                }
                catch (GrainSpotterException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error saving GrainSpotter input file", (Throwable)ex);
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError(ex.get_message());
                }
            }
            this.firePropertyChange(258);
        }
    }

    public void doSaveAs() {
        if (this.gsInput.setOptions()) {
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
            String[] filterExt = new String[]{"*.ini", "*.*"};
            String[] filterNames = new String[]{"input files (*.ini)", "All Files (*.*)"};
            dialog.setFilterExtensions(filterExt);
            dialog.setFilterNames(filterNames);
            IEditorInput input = this.getEditorInput();
            String name = FableUtils.getShortName((String)input.getName());
            dialog.setFileName(name);
            String file = dialog.open();
            boolean confirm = true;
            if (file != null) {
                if (ToolBox.checkIfFileExists((String)file)) {
                    confirm = FableUtils.confirmMsg((Object)this, (String)(String.valueOf(file) + " already exists. Do you want to overwrite it?"));
                }
                if (confirm) {
                    this.doSaveAs(file);
                    SWTUtils.tryToRefreshProject((String)file);
                    SWTUtils.tryToOpenWorkspaceFileEditor((String)file, (String)GrainSpotterInputEditor.getID());
                }
            }
        }
    }

    public void doSaveAs(String fileName) {
        block2: {
            try {
                this.inputFile.saveAs(fileName);
            }
            catch (GrainSpotterException ex) {
                String msg = "Problem saving: " + fileName;
                FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
                if (FableMessageConsole.console == null) break block2;
                FableMessageConsole.console.displayError(msg);
                FableMessageConsole.console.displayError(ex.get_message());
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void setFocus() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 2 && event.getType() == 1) {
            IFileEditorInput fileInput = null;
            IPath path = null;
            IResourceDelta delta = null;
            IResource res = null;
            if (this.getEditorInput() != null && this.getEditorInput() instanceof IFileEditorInput) {
                fileInput = (IFileEditorInput)this.getEditorInput();
                path = fileInput.getFile().getFullPath();
            }
            if (path != null) {
                delta = event.getDelta().findMember(path);
            }
            if (delta != null) {
                res = delta.getResource();
            }
            if (res != null) {
                int kind = delta.getKind();
                if (kind == 2) {
                    final IFileEditorInput input = fileInput;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage[] pages = GrainSpotterInputEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                IEditorPart editorPart = pages[i].findEditor((IEditorInput)input);
                                pages[i].closeEditor(editorPart, true);
                                ++i;
                            }
                        }
                    });
                } else if (kind == 4) {
                    if (this.justSaved) {
                        this.justSaved = false;
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                GrainSpotterInputEditor.this.handleEditorInputChanged();
                            }
                        });
                    }
                } else {
                    SWTUtils.infoMsgAsync((String)("Got POST_CHANGE [" + delta.getKind() + "] for " + path.toOSString()));
                }
            }
        }
    }

    public void handleEditorInputChanged() {
        String msg;
        String title;
        String fileName;
        Shell shell = this.getSite().getShell();
        boolean exists = false;
        try {
            IPath iPath = SWTUtils.getPath((IEditorInput)this.getEditorInput());
            File file = iPath.toFile();
            exists = file.exists();
            fileName = iPath.toOSString();
        }
        catch (Exception ex) {
            FableLogger.error((Object)"Problem getting file name for editor input change", (Throwable)ex);
            return;
        }
        if (exists) {
            title = "GrainSpotter Input File Changed";
            msg = "The file " + fileName + " has been changed on the file system. Do you want " + "to replace the editor contents with these changes?";
            boolean res = MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            if (res) {
                this.inputFile = null;
                this.setInput(this.getEditorInput());
            }
        } else if (this.isSaveAsAllowed()) {
            title = "GrainSpotter Input File Not Accessible";
            msg = "The file " + fileName + " has been deleted or is not accessible. Do you want" + " to save your changes or close the editor without" + " saving?";
            String[] buttons = new String[]{"Save", "Close"};
            MessageDialog dialog = new MessageDialog(shell, title, null, msg, 3, buttons, 0);
            if (dialog.open() == 0) {
                this.doSaveAs();
            } else {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        } else {
            title = "GrainSpotter Input File Not Accessible";
            msg = "The file " + fileName + " has been deleted or is not accessible. This editor" + " will be closed?";
            if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg)) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.pagesCreated) {
            this.createPages();
            this.firePropertyChange(258);
        }
    }

    public static String getID() {
        return ID;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void updateTitle() {
        IEditorInput input = this.getEditorInput();
        String name = FableUtils.getShortName((String)input.getName());
        name = name == null ? "GrainSpotter .ini" : name;
        this.setPartName(name);
        this.setTitleToolTip(input.getToolTipText());
    }

    public GrainSpotterInput getGsInput() {
        return this.gsInput;
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }
}

