/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.grainspotter.internal.GrainSpotterListener;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.run.ReadGveThread;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class GrainSpotterGveFile3D
extends Composite {
    private static final boolean DEBUG_FLOW = false;
    public GLContext context;
    public GLU glu = new GLU();
    private static SceneGrip grip;
    private Text logFileText;
    private Button gVectorShowButton;
    private Composite controlComposite;
    private Composite canvasComposite;
    private Composite xyzControlsComposite;
    private GLCanvas canvas;
    private double[] gvecsXYZ;
    private int pointSize = 1;
    private Spinner pointSizeSpinner;
    private int nGrains = 1;
    private Combo grainSelectCombo;
    private int selectedGrain = 1;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Text xrotText;
    private Text yrotText;
    private Boolean showGVectors = false;
    private Boolean allGvectorsListFirst = true;
    private int allGvectorsList;
    private int width;
    private int height;
    private float aspect;
    private Action infoAction;
    public ReadGveThread readGveThread = new ReadGveThread(true, false);
    private LogFile logFile;
    private GrainSpotterListener listener;
    private DropTarget dropTargetLogFile;

    public GrainSpotterGveFile3D(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.controlComposite = new Composite((Composite)this, 4);
        this.controlComposite.setLayout((Layout)gridLayout);
        this.controlComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite row1 = new Composite(this.controlComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)row1);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        row1.setLayout((Layout)gridLayout);
        Composite row2 = new Composite(this.controlComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)row2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        row2.setLayout((Layout)gridLayout);
        Label label = new Label(row1, 0);
        label.setText("Log file :");
        this.logFileText = new Text(row1, 2048);
        this.logFileText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.logFileText.setText("No .log file loaded");
        this.logFileText.setToolTipText("The name of the GrainSpotter .log file used to assign the g-vectors to grains.\nYou can drag a .log file here.");
        this.logFileText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    GrainSpotterGveFile3D.this.parseLogFile();
                }
            }
        });
        this.dropTargetLogFile = new DropTarget((Control)this.logFileText, 17);
        this.dropTargetLogFile.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        this.dropTargetLogFile.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String fileName = (String)event.data;
                    GrainSpotterGveFile3D.this.logFileText.setText(fileName);
                    GrainSpotterGveFile3D.this.parseLogFile();
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileNames = (String[])event.data;
                    GrainSpotterGveFile3D.this.logFileText.setText(fileNames[0]);
                    GrainSpotterGveFile3D.this.parseLogFile();
                }
            }
        });
        Button browse = new Button(row1, 8);
        browse.setText("Browse...");
        browse.setToolTipText("Browse for a .log file.");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setText("Select a .log file.");
                String file = fileDlg.open();
                if (file != null) {
                    GrainSpotterGveFile3D.this.logFileText.setText(file);
                    GrainSpotterGveFile3D.this.loadLogFile(file);
                }
            }
        });
        this.gVectorShowButton = new Button(row2, 32);
        this.gVectorShowButton.setText("Show All G-Vectors");
        this.gVectorShowButton.setToolTipText("Show all of the g-vectors in white in addition to the selected grain(s) in green\n");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.gVectorShowButton);
        this.gVectorShowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!GrainSpotterGveFile3D.this.readGveThread.getGveFileRead()) {
                    FableUtils.warnMsg((Object)((Object)this), (String)"The .gve file has not been read yet");
                    return;
                }
                GrainSpotterGveFile3D.this.updatePlot3D();
            }
        });
        Composite composite = new Composite(row2, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        label.setText("Choose Grain :");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)label);
        this.grainSelectCombo = new Combo(composite, 4);
        this.grainSelectCombo.setToolTipText("Choose all grains or a selected single grain.");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)this.grainSelectCombo);
        this.grainSelectCombo.add("All Grains");
        int i = 0;
        while (i < this.nGrains) {
            this.grainSelectCombo.add(Integer.toString(i + 1));
            ++i;
        }
        this.grainSelectCombo.select(0);
        this.grainSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterGveFile3D.this.selectedGrain = GrainSpotterGveFile3D.this.grainSelectCombo.getSelectionIndex();
                if (GrainSpotterGveFile3D.this.selectedGrain > 0) {
                    GrainSpotterGveFile3D grainSpotterGveFile3D = GrainSpotterGveFile3D.this;
                    grainSpotterGveFile3D.selectedGrain = grainSpotterGveFile3D.selectedGrain - 1;
                }
                GrainSpotterGveFile3D.this.plotGrain();
                GrainSpotterGveFile3D.this.drawAllGvectorsList();
                GrainSpotterGveFile3D.this.render();
                GrainSpotterGveFile3D.this.resize(GrainSpotterGveFile3D.this.canvas);
            }
        });
        composite = new Composite(row2, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        label.setText("Point Size :");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)label);
        this.pointSizeSpinner = new Spinner(composite, 0);
        this.pointSizeSpinner.setToolTipText("Set the size of the plotted points.");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)this.pointSizeSpinner);
        this.pointSizeSpinner.setMinimum(1);
        this.pointSizeSpinner.setMaximum(10);
        this.pointSizeSpinner.setSelection(1);
        this.pointSizeSpinner.setIncrement(1);
        this.pointSizeSpinner.setPageIncrement(5);
        this.pointSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainSpotterGveFile3D.this.pointSize = GrainSpotterGveFile3D.this.pointSizeSpinner.getSelection();
                GrainSpotterGveFile3D.this.drawAllGvectorsList();
            }
        });
        GLData data = new GLData();
        data.doubleBuffer = true;
        Composite plotComposite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        plotComposite.setLayout((Layout)gridLayout);
        plotComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvasComposite = new Composite(plotComposite, 4);
        this.canvasComposite.setLayout((Layout)new GridLayout());
        this.canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas = new GLCanvas(this.canvasComposite, 262144, data);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GrainSpotterGveFile3D.this.resize(GrainSpotterGveFile3D.this.canvas);
            }
        });
        this.xyzControlsComposite = new Composite(plotComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.xyzControlsComposite.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().align(0x1000000, 128).grab(false, true).applyTo((Control)this.xyzControlsComposite);
        Group xoffGroup = new Group(this.xyzControlsComposite, 4);
        xoffGroup.setText("xoff");
        xoffGroup.setLayout((Layout)new FillLayout());
        xoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xoffText = new Text((Composite)xoffGroup, 0x1000004);
        Group yoffGroup = new Group(this.xyzControlsComposite, 4);
        yoffGroup.setText("yoff");
        yoffGroup.setLayout((Layout)new FillLayout());
        yoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yoffText = new Text((Composite)yoffGroup, 0x1000004);
        Group zoffGroup = new Group(this.xyzControlsComposite, 4);
        zoffGroup.setText("zoff");
        zoffGroup.setLayout((Layout)new FillLayout());
        zoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.zoffText = new Text((Composite)zoffGroup, 0x1000004);
        Group xrotGroup = new Group(this.xyzControlsComposite, 4);
        xrotGroup.setText("xrot");
        xrotGroup.setLayout((Layout)new FillLayout());
        xrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xrotText = new Text((Composite)xrotGroup, 0x1000004);
        Group yrotGroup = new Group(this.xyzControlsComposite, 4);
        yrotGroup.setText("yrot");
        yrotGroup.setLayout((Layout)new FillLayout());
        yrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yrotText = new Text((Composite)yrotGroup, 0x1000004);
        if (!this.setContext()) {
            return;
        }
        this.init(this.canvas);
        grip = new SceneGrip();
        grip.setDefaultView();
        this.canvas.addMouseListener((MouseListener)grip);
        this.canvas.addMouseMoveListener((MouseMoveListener)grip);
        this.canvas.addListener(37, (Listener)grip);
        this.canvas.addKeyListener((KeyListener)grip);
        new Runnable(){

            @Override
            public void run() {
                if (GrainSpotterGveFile3D.this.canvas.isDisposed()) {
                    return;
                }
                GrainSpotterGveFile3D.this.render();
                GrainSpotterGveFile3D.this.canvas.swapBuffers();
                GrainSpotterGveFile3D.this.canvas.getDisplay().timerExec(100, (Runnable)this);
            }
        }.run();
        this.pack();
        this.makeActions();
        this.hookContextMenu((Control)this.canvas);
    }

    private void hookContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GrainSpotterGveFile3D.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.infoAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsHelpDialog dialog = new GraphicsHelpDialog(GrainSpotterGveFile3D.this.getShell());
                        dialog.open();
                    }
                });
            }
        };
        this.infoAction.setText("Graphics Help");
        this.infoAction.setToolTipText("Summary of Graphics Manipulations");
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    public void dispose() {
        if (this.dropTargetLogFile != null) {
            this.dropTargetLogFile.dispose();
        }
    }

    public ReadGveThread getReadGveFileThread() {
        return this.readGveThread;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    private void parseLogFile() {
        if (!this.logFileText.getText().equals("")) {
            this.loadLogFile(this.logFileText.getText());
        } else {
            this.gvecsXYZ = null;
            this.logFile = null;
            this.grainSelectCombo.removeAll();
            this.drawAllGvectorsList();
        }
    }

    private void loadLogFile(String fileName) {
        this.logFile = new LogFile(fileName);
        if (this.logFile != null && this.listener != null) {
            this.logFile.removeGrainSpotterListener(this.listener);
            this.listener = null;
        }
        this.logFile.addGrainSpotterListener(new GrainSpotterListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        });
        try {
            Job parsingJob = this.logFile.getParsingJob();
            parsingJob.schedule();
            parsingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int numGrains = GrainSpotterGveFile3D.this.logFile.getGrains().getGrains().size();
                            GrainSpotterGveFile3D.this.setNGrains(numGrains);
                            GrainSpotterGveFile3D.this.grainSelectCombo.select(0);
                            GrainSpotterGveFile3D.this.plotGrain();
                            if (numGrains == 0) {
                                FableUtils.errMsg((Object)this, (String)("No grains found for " + GrainSpotterGveFile3D.this.logFile.getFileName()));
                            }
                        }
                    });
                }
            });
        }
        catch (GrainSpotterException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)("Error getting parsing job for: " + fileName), (Throwable)ex);
        }
    }

    void init(GLCanvas canvas) {
        if (!this.setContext()) {
            return;
        }
        this.resize(canvas);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glHint((int)3152, (int)4354);
    }

    void render() {
        if (!this.setContext()) {
            return;
        }
        GL11.glClear((int)16640);
        GL11.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        GL11.glLoadIdentity();
        grip.adjust();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)1, (int)0, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)1, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)0, (int)1);
        GL11.glPointSize((float)this.pointSize);
        GL11.glCallList((int)this.allGvectorsList);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRasterPos2i((int)1, (int)1);
        GL11.glEnable((int)2896);
    }

    void resize(GLCanvas canvas) {
        if (!this.setContext()) {
            return;
        }
        Rectangle rect = canvas.getClientArea();
        this.width = rect.width;
        this.height = Math.max(rect.height, 1);
        this.aspect = (float)this.width / (float)this.height;
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    private void drawAllGvectorsList() {
        if (!this.setContext()) {
            return;
        }
        if (this.allGvectorsListFirst.booleanValue()) {
            GL11.glDeleteLists((int)this.allGvectorsList, (int)1);
            this.allGvectorsList = GL11.glGenLists((int)1);
            FableLogger.debug((Object)"Grains3DView :drawAllGvectorsList -GL11.glDeleteLists(allGvectorsList, 1);");
        }
        this.allGvectorsListFirst = false;
        GL11.glNewList((int)this.allGvectorsList, (int)4864);
        GL11.glPointSize((float)this.pointSize);
        if (this.showGVectors.booleanValue()) {
            GL11.glBegin((int)0);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            CopyOnWriteArrayList<double[]> list = this.readGveThread.getGveXYZ();
            int i_gv = 0;
            while (i_gv < list.size()) {
                double[] gvector_xyz = (double[])list.get(i_gv);
                GL11.glVertex3d((double)gvector_xyz[0], (double)gvector_xyz[1], (double)gvector_xyz[2]);
                ++i_gv;
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)0);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (this.gvecsXYZ != null) {
            int i_gv = 0;
            while (i_gv < this.gvecsXYZ.length / 3) {
                GL11.glVertex3d((double)this.gvecsXYZ[i_gv * 3], (double)this.gvecsXYZ[i_gv * 3 + 1], (double)this.gvecsXYZ[i_gv * 3 + 2]);
                ++i_gv;
            }
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public boolean setFocus() {
        this.setContext();
        return this.canvas.setFocus();
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(int pointSize) {
        this.pointSize = pointSize;
    }

    public int getNGrains() {
        return this.nGrains;
    }

    public void setNGrains(int nGrains) {
        this.nGrains = nGrains;
        String[] items = new String[nGrains + 1];
        items[0] = "All Grains";
        int i = 0;
        while (i < nGrains) {
            items[i + 1] = Integer.toString(i + 1);
            ++i;
        }
        this.grainSelectCombo.setItems(items);
    }

    public void plotGrain() {
        if (!this.readGveThread.getGveFileRead()) {
            FableUtils.warnMsg((Object)((Object)this), (String)"The .gve file has not been read yet");
            return;
        }
        int index = this.grainSelectCombo.getSelectionIndex();
        boolean valReturn = true;
        valReturn = index > 0 ? this.getOneGrain(index - 1) : this.getAllGrains();
        this.updatePlot3D();
        if (!valReturn) {
            FableUtils.errMsg((Object)((Object)this), (String)"All g-vectors available in the log file could not be loaded.\nCheck in your GrainSpotter .ini file if this log file has been generated with this g-vector file");
        }
    }

    private boolean getAllGrains() {
        boolean valReturn = true;
        if (this.logFile != null) {
            GrainSyntaxModel grains = this.logFile.getGrains();
            this.gvecsXYZ = new double[grains.getGvecsExpected() * 3];
            int begin = 0;
            int j = 0;
            while (j < grains.getGrains().size()) {
                GrainSyntaxModel grain = grains.getGrains().get(j);
                List<GrainGvectorModel> vectors = grain.getGVectors();
                int i = 0;
                while (i < vectors.size()) {
                    int gvector_id = vectors.get(i).getid();
                    int index = i * 3 + begin;
                    if (this.readGveThread.getGveXYZ().size() > gvector_id) {
                        double[] xyz = this.readGveThread.getGveXYZ().get(gvector_id);
                        this.gvecsXYZ[index] = xyz[0];
                        this.gvecsXYZ[++index] = xyz[1];
                        this.gvecsXYZ[++index] = xyz[2];
                    } else {
                        valReturn = false;
                    }
                    ++i;
                }
                begin += vectors.size() * 3;
                ++j;
            }
        }
        return valReturn;
    }

    private boolean getOneGrain(int grainIndex) {
        boolean valReturn = true;
        if (this.logFile != null) {
            GrainSyntaxModel grain = this.logFile.getGrains().getGrains().get(grainIndex);
            List<GrainGvectorModel> vectors = grain.getGVectors();
            this.gvecsXYZ = new double[vectors.size() * 3];
            int i = 0;
            while (i < vectors.size()) {
                int gvector_id = vectors.get(i).getid();
                if (this.readGveThread.getGveXYZ().size() > gvector_id) {
                    double[] xyz = this.readGveThread.getGveXYZ().get(gvector_id);
                    this.gvecsXYZ[i * 3] = xyz[0];
                    this.gvecsXYZ[i * 3 + 1] = xyz[1];
                    this.gvecsXYZ[i * 3 + 2] = xyz[2];
                } else {
                    valReturn = false;
                }
                ++i;
            }
        }
        return valReturn;
    }

    private static String getGraphicsHelp() {
        String ls = System.getProperty("line.separator");
        String info = "";
        info = String.valueOf(info) + "Button 1: Drag to examine" + ls;
        info = String.valueOf(info) + "Button 2: Drag vertically to zoom" + ls;
        info = String.valueOf(info) + "Button 3: Drag to pan" + ls;
        info = String.valueOf(info) + "Mouse Wheel: Zoom in/out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Up Arrow: Pan up" + ls;
        info = String.valueOf(info) + "Down Arrow: Pan down" + ls;
        info = String.valueOf(info) + "Left Arrow: Pan left" + ls;
        info = String.valueOf(info) + "Right Arrow: Pan right" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Ctrl + Up Arrow: Rotate one way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Down Arrow: Rotate other way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Left Arrow: Rotate one way about about vertical axis" + ls;
        info = String.valueOf(info) + "Ctrl + Right Arrow: Rotate other way about vertical axis" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Page Up: Zoom in" + ls;
        info = String.valueOf(info) + "Page Down: Zoom out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Home: Reset" + ls;
        info = String.valueOf(info) + "End: Reset to X-Axis right, Y-axis up, Z-axis out";
        return info;
    }

    public void updatePlot3D() {
        this.showGVectors = this.gVectorShowButton.getSelection();
        this.drawAllGvectorsList();
    }

    public void loadGVectors(String fileName) {
        this.readGveThread.setGvectorFile(fileName);
        this.readGveThread.run();
        this.gVectorShowButton.setSelection(true);
        this.plotGrain();
    }

    public void setLogFile(String fileName) {
        this.logFileText.setText(fileName);
    }

    public boolean setContext() {
        if (this.canvas == null || this.canvas.isDisposed()) {
            return false;
        }
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"GLContext.useContext error", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void reset() {
        this.init(this.canvas);
        this.allGvectorsListFirst = true;
        this.setContext();
        this.updatePlot3D();
    }

    public Action getInfoAction() {
        return this.infoAction;
    }

    public class GraphicsHelpDialog
    extends Dialog {
        public GraphicsHelpDialog(Shell parent) {
            this(parent, 2144);
        }

        public GraphicsHelpDialog(Shell parent, int style) {
            super(parent, style);
        }

        public String open() {
            Shell shell = new Shell(this.getParent(), this.getStyle());
            shell.setText("Graphics Help");
            this.createContents(shell);
            shell.pack();
            shell.open();
            Display display = this.getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return null;
        }

        private void createContents(final Shell shell) {
            GridLayout grid = new GridLayout();
            grid.numColumns = 1;
            shell.setLayout((Layout)grid);
            Group box = new Group((Composite)shell, 2048);
            box.setText("Graphics Manipulations");
            grid = new GridLayout();
            grid.numColumns = 1;
            box.setLayout((Layout)grid);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            box.setLayoutData((Object)data);
            Text text = new Text((Composite)box, 2);
            text.setEditable(false);
            text.setText(GrainSpotterGveFile3D.getGraphicsHelp());
            data = new GridData();
            text.setLayoutData((Object)data);
            Button close = new Button((Composite)shell, 8);
            close.setText("Close");
            data = new GridData(64);
            close.setLayoutData((Object)data);
            close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    shell.close();
                }
            });
            shell.setDefaultButton(close);
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private boolean move;
        private boolean zoom;
        private int xdown;
        private int ydown;
        private int ylast;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            this.zoff = -8.0f;
            GrainSpotterGveFile3D.this.xrotText.setText(Float.toString(this.xrot));
            GrainSpotterGveFile3D.this.yrotText.setText(Float.toString(this.yrot));
            GrainSpotterGveFile3D.this.xoffText.setText(Float.toString(this.xoff));
            GrainSpotterGveFile3D.this.yoffText.setText(Float.toString(this.yoff));
            GrainSpotterGveFile3D.this.zoffText.setText(Float.toString(this.zoff));
        }

        public void setDefaultView() {
            this.init();
            grip.setOffsets(-0.25f, -0.25f, -5.5f);
            grip.setRotation(45.0f, -30.0f);
        }

        public void mouseDown(MouseEvent e) {
            if (++this.mouseDown == 1) {
                this.move = false;
                this.zoom = false;
                if (e.button == 2) {
                    this.zoom = true;
                } else {
                    this.move = e.button == 3;
                    if (this.move) {
                        this.xcpy = this.xoff;
                        this.ycpy = this.yoff;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(21));
                    } else {
                        this.xcpy = this.xrot;
                        this.ycpy = this.yrot;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(5));
                    }
                }
                this.xdown = e.x;
                this.ydown = this.ylast = e.y;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (--this.mouseDown == 0) {
                ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent e) {
            Point p = ((Control)e.widget).getSize();
            if (this.mouseDown > 0) {
                if (this.zoom) {
                    int dy = e.y - this.ylast;
                    this.ylast = e.y;
                    this.zoff += (float)dy / 6.0f;
                } else if (this.move) {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.yoff = this.ycpy + (this.zoff + 1.0f) * (float)dy / (2.0f * (float)p.y);
                    this.xoff = this.xcpy - (this.zoff + 1.0f) * (float)dx / (2.0f * (float)p.x);
                } else {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.xrot = this.xcpy + (float)dy / 2.0f;
                    this.yrot = this.ycpy + (float)dx / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff += (float)event.count / 6.0f;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot -= 0.5f;
                        break;
                    }
                    this.yoff += 0.05f;
                    break;
                }
                case 0x1000002: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot += 0.5f;
                        break;
                    }
                    this.yoff -= 0.05f;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot -= 0.5f;
                        break;
                    }
                    this.xoff -= 0.05f;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot += 0.5f;
                        break;
                    }
                    this.xoff += 0.05f;
                    break;
                }
                case 0x1000005: {
                    this.zoff += 0.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff -= 0.05f;
                    break;
                }
                case 0x1000007: {
                    this.setDefaultView();
                    break;
                }
                case 0x1000008: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void updateTextDisplay() {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
            nf.applyPattern("0.0");
            if (GrainSpotterGveFile3D.this.xrotText != null && !GrainSpotterGveFile3D.this.xrotText.isDisposed()) {
                GrainSpotterGveFile3D.this.xrotText.setText(nf.format(this.xrot));
            }
            if (GrainSpotterGveFile3D.this.yrotText != null && !GrainSpotterGveFile3D.this.yrotText.isDisposed()) {
                GrainSpotterGveFile3D.this.yrotText.setText(nf.format(this.yrot));
            }
            if (GrainSpotterGveFile3D.this.xoffText != null && !GrainSpotterGveFile3D.this.xoffText.isDisposed()) {
                GrainSpotterGveFile3D.this.xoffText.setText(nf.format(this.xoff));
            }
            if (GrainSpotterGveFile3D.this.yoffText != null && !GrainSpotterGveFile3D.this.yoffText.isDisposed()) {
                GrainSpotterGveFile3D.this.yoffText.setText(nf.format(this.yoff));
            }
            if (GrainSpotterGveFile3D.this.zoffText != null && !GrainSpotterGveFile3D.this.zoffText.isDisposed()) {
                GrainSpotterGveFile3D.this.zoffText.setText(nf.format(this.zoff));
            }
        }

        public void adjust() {
            if (!GrainSpotterGveFile3D.this.setContext()) {
                return;
            }
            GL11.glOrtho((double)(-grip.zoff), (double)grip.zoff, (double)(-grip.zoff / GrainSpotterGveFile3D.this.aspect), (double)(grip.zoff / GrainSpotterGveFile3D.this.aspect), (double)-100000.0, (double)100000.0);
            GL11.glTranslatef((float)this.xoff, (float)this.yoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)0.1f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)0.1f, (float)0.0f);
            this.updateTextDisplay();
        }

        public void setOffsets(float x, float y, float z) {
            this.xoff = x;
            this.yoff = y;
            this.zoff = z;
        }

        public void setRotation(float x, float y) {
            this.xrot = x;
            this.yrot = y;
        }
    }
}

