/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.internal;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.event.PolyxsimEvent;
import fable.polyxsim.internal.PolyXSimException;
import fable.polyxsim.listener.IPolyxsimEventListener;
import fable.polyxsim.rcp.Activator;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PolyXSim
implements IPropertyChangeListener {
    private PolyXSimThread polyXSimThread;
    private IProgressMonitor polyXSimMonitor;
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    private static FableJep jep = null;
    private String inputFileName;
    private float wavelength;
    private Float distance;
    private Float polarisationFactor;
    private Float polarisationDirection;
    private Float detyCenter;
    private Float detzCenter;
    private Float ySize;
    private Float zSize;
    private Float detySize;
    private Float detzSize;
    private Float omegaStart;
    private Float omegaEnd;
    private Float omegaStep;
    private Float thetaMin;
    private Float thetaMax;
    private Integer[] detOrientation = new Integer[4];
    private int numGrains = 0;
    private int numPhases = 0;
    private Integer[] phases = null;
    private Integer[] phaseGrains = null;
    private Integer[] phaseGrainSizeflag;
    private Float grainSize;
    private Float grainMinSize;
    private Float grainMaxSize;
    private Integer genGrainOrientation;
    private Integer genGrainPosition;
    private Float[] sampleXYZ = new Float[3];
    private Float[] sampleCyl = new Float[2];
    private Float[] unitCellA = null;
    private Float[] unitCellB = null;
    private Float[] unitCellC = null;
    private Float[] unitCellAlpha = null;
    private Float[] unitCellBeta = null;
    private Float[] unitCellGamma = null;
    private Integer[] unitCellSpaceGroup = null;
    private Integer makeImages;
    private String prefix;
    private String format = "edf";
    private Float flux;
    private Integer noise;
    private Integer background;
    private Integer psf;
    private Integer peakShape;
    private Float detTiltX;
    private Float detTiltY;
    private Float detTiltZ;
    private String[] structureFile = null;
    private boolean outputFlt = false;
    private boolean outputGve = false;
    private boolean outputUbi = false;
    private boolean outputPar = false;
    private StdoutRead stdoutThread;
    private String killFile = ".polyxsim.killfile";
    Logger logger;
    File tempFile;
    private float wedge;
    private float mosaicity;
    private Float intensityConstant;
    private boolean polarisation;
    private boolean lorentzFactor;
    private String inputDirectory;
    private String outputDirectory;
    private Float[] peakParameters = new Float[2];
    private Integer omegaSign;
    private Float[] phaseGrainSize = null;
    private Float[] phaseGrainMinSize = null;
    private Float[] phaseGrainMaxSize = null;
    private boolean isCylinder = false;
    private boolean isCube = false;
    boolean runStatus = false;
    boolean jobCanceled = false;
    boolean bValue = true;
    String spatial = "";
    private int gen_eps_flag;
    private Float gen_eps_meanValuefordiagonal;
    private Float gen_eps_spread_value;
    private Float gen_eps_meanValueforOffDiagonal;
    private Float gen_eps_spread_valueforOffDiagonal;
    private int[] gen_eps_Flag_phase_y;
    private Float[] gen_eps_meanValuefordiagonal_y;
    private Float[] gen_eps_spread_value_y;
    private Float[] gen_eps_meanValueforOffDiagonal_y;
    private Float[] gen_eps_spread_valueforOffDiagonal_y;
    private String eps_grains;
    private ArrayList<IPolyxsimEventListener> polyxsimListeners;
    private String U_grains;
    private String pos_Grains;
    private String gen_pos;
    private boolean gen_U;
    private String beamWidth;
    protected boolean hasGen_eps_phase = false;
    private int gen_phase_flag;
    protected int gen_size_flag;
    private String size_grains;
    private static HashMap<String, Object> optionalItems;

    public PolyXSim() {
        this.logger = Logger.getLogger(PolyXSim.class);
        this.polyxsimListeners = new ArrayList();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void fireProperty(String property) {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "polyxsim", null, (Object)property));
        }
    }

    public static void createNewInputFile(String file) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        PolyXSim.writeInputFile(file, preferences.getString("preference_input_file_polyxsim"));
    }

    private void setThisDirectoryRelativeToOs() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            if (this.outputDirectory.indexOf(":") == -1) {
                this.outputDirectory = String.valueOf(this.inputDirectory) + File.separator + this.outputDirectory;
            }
        } else if (!this.outputDirectory.startsWith(File.separator)) {
            this.outputDirectory = String.valueOf(this.inputDirectory) + File.separator + this.outputDirectory;
        }
    }

    private void fireSaveFileDone() {
        PolyxsimEvent polyxsimeEvent = new PolyxsimEvent(this);
        for (IPolyxsimEventListener listener : this.polyxsimListeners) {
            listener.saveInputFileEvent(polyxsimeEvent);
        }
    }

    private void fireInputFileLoaded() {
        PolyxsimEvent polyxsimeEvent = new PolyxsimEvent(this);
        for (IPolyxsimEventListener listener : this.polyxsimListeners) {
            listener.loadInputFileEvent(polyxsimeEvent);
        }
    }

    public boolean saveInputFile(final String outputFileName) {
        Job job = new Job("Save input file"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Save as input file", 100);
                PolyXSim.writeInputFile(outputFileName, "");
                monitor.worked(10);
                try {
                    FableJep jep = new FableJep();
                    jep.outputConsole(FableMessageConsole.console);
                    monitor.subTask("Load python modules");
                    PolyXSim.this.loadPythonModules(jep);
                    monitor.worked(20);
                    String currentDirectory = PolyXSim.this.inputDirectory.replaceAll("\\\\", "/");
                    jep.eval("os.chdir(\"" + currentDirectory + "\")");
                    jep.set("sim_filename", outputFileName);
                    jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
                    FableMessageConsole.console.displayOut("pass values from ui");
                    PolyXSim.this.updateValues(jep);
                    monitor.worked(10);
                    FableMessageConsole.console.displayOut("check input");
                    monitor.subTask("check input again");
                    jep.eval("myinput.check()");
                    monitor.worked(10);
                    jep.eval("file_io.write_res(myinput.param,'" + outputFileName + "')");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PolyXSim.this.fireSaveFileDone();
                        }
                    });
                    if (jep != null) {
                        jep.close();
                    }
                }
                catch (JepException e) {
                    monitor.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((String)e.getMessage());
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                catch (PolyXSimException e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((String)e.getMessage());
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PolyXSim.this.bValue = event.getResult() == Status.OK_STATUS;
            }
        });
        job.schedule();
        return this.bValue;
    }

    public void initValuesFromPython(FableJep jep) throws JepException {
        jep.eval("from polyxsim import check_input");
        jep.eval("myinput = check_input.parse_input(input_file='" + this.getFileName() + "')");
        jep.eval("myinput.read()");
        this.makeImages = jep.getIntegerValue("myinput.param['make_image']");
        this.outputDirectory = jep.getStringValue("myinput.param['direc']");
        this.setThisDirectoryRelativeToOs();
    }

    public void run() {
        Job job = new Job("Running PolyXSim "){

            protected IStatus run(IProgressMonitor monitor) {
                String fileName = PolyXSim.this.inputFileName;
                if (PolyXSim.this.inputFileName != null && !PolyXSim.this.inputFileName.equals("")) {
                    if (PolyXSim.this.inputFileName.lastIndexOf(File.separatorChar) != -1) {
                        fileName = PolyXSim.this.inputFileName.substring(PolyXSim.this.inputFileName.lastIndexOf(File.separatorChar) + 1);
                    }
                    PolyXSim.this.polyXSimMonitor = monitor;
                    PolyXSim.this.polyXSimMonitor.beginTask("Running polyxsim -i " + fileName + " ... ", -1);
                    PolyXSim.this.polyXSimThread = new PolyXSimThread();
                    PolyXSim.this.polyXSimThread.run();
                    PolyXSim.this.polyXSimMonitor.done();
                    return Status.OK_STATUS;
                }
                FableMessageConsole.console.displayError("no input file specified - run aborted");
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (PolyXSim.this.runStatus) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " completed successfully");
                    }
                    if (PolyXSim.this.makeImages == 1 && !Display.getDefault().isDisposed()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ToolBox.checkIfIsDirectory((String)PolyXSim.this.outputDirectory)) {
                                    PolyXSim.this.openImageViewer(PolyXSim.this.outputDirectory);
                                } else {
                                    SWTUtils.infoMsg((String)"Image viewer can not load images as they might be relative to input file for polyxsim.\nPlease, select open directory in the view and load the files manually.");
                                    PolyXSim.this.openImageViewer("");
                                }
                            }
                        });
                    }
                } else if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " did not complete successfully !");
                    if (!PolyXSim.this.jobCanceled) {
                        FableMessageConsole.console.displayOut(" Please check input file " + PolyXSim.this.inputFileName);
                    }
                }
            }
        });
    }

    protected void openImageViewer(String directory) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            activeWindow.getWorkbench().showPerspective("fable.imageviewer.perspective", activeWindow);
            SampleNavigatorView sampleView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
            sampleView.addDirectory(directory);
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)activeWindow.getShell(), (String)"Polyxsim", (String)"ImageViewer cannot be opened");
        }
    }

    private void loadPythonModules(FableJep jep) {
        try {
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"sys,os");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"optparse");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"CifFile");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"ImageD11");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
            try {
                jep.eval("from polyxsim import check_input");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import find_refl");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import generate_grains");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import make_image");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import make_imagestack");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import reflections");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import file_io");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from optparse import OptionParser");
            }
            catch (JepException jepException) {}
            try {
                jep.eval("from polyxsim import gopolyxsim");
            }
            catch (JepException jepException) {}
            jep.eval("from polyxsim import gopolyxsim");
            jep.eval("from polyxsim import check_input");
            jep.eval("from optparse import OptionParser");
            jep.eval("from polyxsim import find_refl");
            jep.eval("from polyxsim import generate_grains");
            jep.eval("from polyxsim import make_image");
            jep.eval("from polyxsim import make_imagestack");
            jep.eval("from polyxsim import reflections");
            jep.eval("from polyxsim import file_io");
        }
        catch (JepException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SWTUtils.errMsg((String)e.getMessage());
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError(e.getMessage());
                    }
                }
            });
        }
    }

    public void updateValues(FableJep jep) throws PolyXSimException {
        try {
            String line;
            int i;
            int end;
            int i2;
            jep.eval("import numpy as n");
            this.logger.trace((Object)("noGrains = " + this.numGrains));
            jep.eval("myinput.param['no_grains']=" + this.numGrains);
            jep.eval("myinput.param['wavelength']=" + this.wavelength);
            jep.eval("myinput.param['beamflux']=" + this.flux);
            if (this.spatial != null) {
                jep.eval("myinput.param['spatial']=" + this.spatial);
            } else {
                jep.eval("myinput.param['spatial']=None");
            }
            if (this.polarisation) {
                jep.eval("myinput.param['beampol_factor']=1");
            } else {
                jep.eval("myinput.param['beampol_factor']=0");
            }
            if (this.lorentzFactor) {
                jep.eval("myinput.param['lorentz_factor']=1");
            } else {
                jep.eval("myinput.param['lorentz_factor']=0");
            }
            jep.eval("myinput.param['beampol_factor']=" + this.polarisationFactor);
            jep.eval("myinput.param['beampol_direct']=" + this.polarisationDirection);
            jep.eval("myinput.param['wavelength']=" + this.wavelength);
            jep.eval("myinput.param['distance']=" + this.distance);
            jep.eval("myinput.param['dety_center']=" + this.detyCenter);
            jep.eval("myinput.param['detz_center']=" + this.detzCenter);
            jep.eval("myinput.param['y_size']=" + this.ySize);
            jep.eval("myinput.param['z_size']=" + this.zSize);
            jep.eval("myinput.param['dety_size']=" + this.detySize);
            jep.eval("myinput.param['detz_size']=" + this.detzSize);
            jep.eval("myinput.param['tilt_x']=" + this.detTiltX);
            jep.eval("myinput.param['tilt_y']=" + this.detTiltY);
            jep.eval("myinput.param['tilt_z']=" + this.detTiltZ);
            if (this.detOrientation[0] != null) {
                jep.eval("myinput.param['o11']=" + this.detOrientation[0]);
            }
            if (this.detOrientation[1] != null) {
                jep.eval("myinput.param['o12']=" + this.detOrientation[1]);
            }
            if (this.detOrientation[2] != null) {
                jep.eval("myinput.param['o21']=" + this.detOrientation[2]);
            }
            if (this.detOrientation[3] != null) {
                jep.eval("myinput.param['o22']=" + this.detOrientation[3]);
            }
            jep.eval("myinput.param['wedge']=" + this.wedge);
            jep.eval("myinput.param['omega_start']=" + this.omegaStart);
            jep.eval("myinput.param['omega_end']=" + this.omegaEnd);
            jep.eval("myinput.param['omega_step']=" + this.omegaStep);
            jep.eval("myinput.param['no_phases']=" + this.numPhases);
            jep.eval("myinput.param['no_grains']=" + this.numGrains);
            if (this.genGrainOrientation == 1) {
                jep.eval("myinput.param['gen_size'][1]=" + this.grainSize);
                jep.eval("myinput.param['gen_size'][2]=" + this.grainMinSize);
                jep.eval("myinput.param['gen_size'][3]=" + this.grainMaxSize);
            }
            if (this.isCube) {
                i2 = 0;
                while (i2 < 3) {
                    if (this.sampleXYZ[i2] != null) {
                        jep.eval("myinput.param['sample_xyz'][" + i2 + "]=" + this.sampleXYZ[i2]);
                    }
                    ++i2;
                }
            } else if (this.isCylinder) {
                i2 = 0;
                while (i2 < 2) {
                    if (this.sampleCyl[i2] != null) {
                        jep.eval("myinput.param['sample_cyl'][" + i2 + "]=" + this.sampleCyl[i2]);
                    }
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.numPhases) {
                int phaseIndex = 2 + i2 * 2;
                if (this.phaseGrains[i2] != null && this.numPhases > 1) {
                    jep.eval("myinput.param['gen_phase'][" + phaseIndex + "]=" + this.phaseGrains[i2]);
                    jep.eval("myinput.param['no_grains_phase_" + i2 + "']=" + this.phaseGrains[i2]);
                }
                String evalString = "myinput.param['gen_size_phase_" + i2 + "'][2]=" + this.phaseGrainMinSize[i2];
                jep.eval(evalString);
                evalString = "myinput.param['gen_size_phase_" + i2 + "'][3]=" + this.phaseGrainMaxSize[i2];
                jep.eval(evalString);
                evalString = "myinput.param['gen_size_phase_" + i2 + "'][1]=" + this.phaseGrainSize[i2];
                jep.eval(evalString);
                if (i2 < this.unitCellA.length) {
                    if (this.unitCellA[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][0]=" + this.unitCellA[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellB[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][1]=" + this.unitCellB[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellC[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][2]=" + this.unitCellC[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellAlpha[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][3]=" + this.unitCellAlpha[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellBeta[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][4]=" + this.unitCellBeta[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellGamma[i2] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i2 + "'][5]=" + this.unitCellGamma[i2];
                        jep.eval(evalString);
                    }
                    if (this.unitCellSpaceGroup[i2] != null) {
                        evalString = "myinput.param['sgno_phase_" + i2 + "']=" + this.unitCellSpaceGroup[i2];
                        jep.eval(evalString);
                    }
                }
                ++i2;
            }
            jep.eval("myinput.param['make_image']=" + this.makeImages);
            String tempOutputDirectory = this.outputDirectory.replaceAll("\\\\", "/");
            jep.eval("myinput.param['direc']='" + tempOutputDirectory + "'");
            jep.eval("myinput.param['stem']='" + this.prefix + "'");
            jep.eval("myinput.param['noise']=" + this.noise);
            jep.eval("myinput.param['bg']=" + this.background);
            jep.eval("myinput.param['psf']=" + this.psf);
            jep.eval("myinput.param['peakshape'][0]=" + this.peakShape);
            if (this.peakParameters[0] != null) {
                jep.eval("myinput.param['peakshape'][1]=" + this.peakParameters[0]);
            }
            if (this.peakParameters[1] != null) {
                jep.eval("myinput.param['peakshape'][2]=" + this.peakParameters[1]);
            }
            int i3 = 0;
            while (i3 < this.numPhases) {
                if (i3 < this.structureFile.length && this.structureFile[i3] != null) {
                    jep.eval("myinput.param['structure_phase_" + i3 + "']='" + this.structureFile[i3] + "'");
                }
                ++i3;
            }
            jep.eval("myinput.param['make_image']=" + this.makeImages);
            String output = "'" + this.format + "'";
            if (this.outputFlt || this.outputGve || this.outputUbi || this.outputPar) {
                if (this.outputFlt) {
                    output = String.valueOf(output) + ",'.flt'";
                }
                if (this.outputGve) {
                    output = String.valueOf(output) + ",'.gve'";
                }
                if (this.outputUbi) {
                    output = String.valueOf(output) + ",'.ubi'";
                }
                if (this.outputPar) {
                    output = String.valueOf(output) + ",'.par'";
                }
            }
            jep.eval("myinput.param['output']=[" + output + "]");
            if (this.format.startsWith("tif")) {
                jep.eval("myinput.param['format']='.tif'");
            } else {
                jep.eval("myinput.param['format']='" + this.format + "'");
            }
            jep.eval("myinput.param['gen_U']=" + this.gen_U);
            if (this.U_grains != null && this.U_grains.length() > 0) {
                int begin = 0;
                end = 0;
                i = 0;
                while (i < this.numGrains) {
                    begin = this.U_grains.indexOf("U_grains_" + i, end);
                    end = this.U_grains.indexOf("U_grains_" + i, begin + new String("U_grains_" + i).length());
                    line = this.U_grains.substring(begin, end);
                    jep.eval("myu_grains = n.array(" + line + ")");
                    jep.eval("myu_grains.shape = (3, 3)");
                    ++i;
                }
            }
            if (this.gen_pos != null && this.gen_pos.length() > 0) {
                jep.eval("myinput.param['gen_pos']=" + this.gen_pos);
            }
            if (this.pos_Grains != null && this.pos_Grains.length() > 0) {
                int begin = 0;
                end = 0;
                i = 0;
                while (i < this.numGrains) {
                    begin = this.pos_Grains.indexOf("pos_grains_" + i, end);
                    end = this.pos_Grains.indexOf("pos_grains_" + i, begin + new String("pos_grains_" + i).length());
                    line = this.pos_Grains.substring(begin, end);
                    jep.eval("myinput.param['pos_grains_" + i + "']=" + line);
                    ++i;
                }
            }
        }
        catch (JepException e) {
            throw new PolyXSimException(PolyXSim.class.getName(), "store values into python object", e.getMessage());
        }
    }

    public String getFileName() {
        return this.inputFileName;
    }

    public float getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(float value) {
        this.wavelength = value;
    }

    public Float getFlux() {
        return this.flux;
    }

    public void setFlux(float value) {
        this.flux = Float.valueOf(value);
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(float value) {
        this.distance = Float.valueOf(value);
    }

    public Float getDetyCenter() {
        return this.detyCenter;
    }

    public void setDetyCenter(float value) {
        this.detyCenter = Float.valueOf(value);
    }

    public Float getDetzCenter() {
        return this.detzCenter;
    }

    public void setDetzCenter(float value) {
        this.detzCenter = Float.valueOf(value);
    }

    public Float getYSize() {
        return this.ySize;
    }

    public void setYSize(float value) {
        this.ySize = Float.valueOf(value);
    }

    public Float getZSize() {
        return this.zSize;
    }

    public void setZSize(float value) {
        this.zSize = Float.valueOf(value);
    }

    public Float getDetySize() {
        return this.detySize;
    }

    public void setDetySize(float value) {
        this.detySize = Float.valueOf(value);
    }

    public Float getDetzSize() {
        return this.detzSize;
    }

    public void setDetzSize(float value) {
        this.detzSize = Float.valueOf(value);
    }

    public Float getOmegaStart() {
        return this.omegaStart;
    }

    public void setOmegaStart(float value) {
        this.omegaStart = Float.valueOf(value);
    }

    public Float getOmegaEnd() {
        return this.omegaEnd;
    }

    public void setOmegaEnd(float value) {
        this.omegaEnd = Float.valueOf(value);
    }

    public Integer getOmegaSign() {
        return this.omegaSign;
    }

    public void setOmegaSign(int value) {
        this.omegaSign = value;
    }

    public Float getOmegaStep() {
        return this.omegaStep;
    }

    public void setOmegaStep(float value) {
        this.omegaStep = Float.valueOf(value);
    }

    public Float getDetTiltX() {
        return this.detTiltX;
    }

    public void setDetTiltX(float value) {
        this.detTiltX = Float.valueOf(value);
    }

    public Float getDetTiltY() {
        return this.detTiltY;
    }

    public void setDetTiltY(float value) {
        this.detTiltY = Float.valueOf(value);
    }

    public Float getDetTiltZ() {
        return this.detTiltZ;
    }

    public void setDetTiltZ(float value) {
        this.detTiltZ = Float.valueOf(value);
    }

    public Float getThetaMin() {
        return this.thetaMin;
    }

    public void setThetaMin(float value) {
        this.thetaMin = Float.valueOf(value);
    }

    public Float getThetaMax() {
        return this.thetaMax;
    }

    public void setThetaMax(float value) {
        this.thetaMax = Float.valueOf(value);
    }

    public Integer getNoGrains() {
        return this.numGrains;
    }

    public void setNoGrains(int value) {
        this.numGrains = value;
    }

    public Float getGrainSize() {
        return this.grainSize;
    }

    public void setGrainSize(float value) {
        this.grainSize = Float.valueOf(value);
    }

    public Float getGrainMinSize() {
        return this.grainMinSize;
    }

    public void setGrainMinSize(float value) {
        this.grainMinSize = Float.valueOf(value);
    }

    public Float getGrainMaxSize() {
        return this.grainMaxSize;
    }

    public void setGrainMaxSize(float value) {
        this.grainMaxSize = Float.valueOf(value);
    }

    public Float[] getSampleXyz() {
        return this.sampleXYZ;
    }

    public void setSampleXyz(Float[] array) {
        this.sampleXYZ = array;
    }

    public Float[] getUnitCellA() {
        return this.unitCellA;
    }

    public void setUnitCellA(Float[] array) {
        this.unitCellA = array;
    }

    public Float[] getUnitCellB() {
        return this.unitCellB;
    }

    public void setUnitCellB(Float[] array) {
        this.unitCellB = array;
    }

    public Float[] getUnitCellC() {
        return this.unitCellC;
    }

    public void setUnitCellC(Float[] array) {
        this.unitCellC = array;
    }

    public Float[] getUnitCellAlpha() {
        return this.unitCellAlpha;
    }

    public void setUnitCellAlpha(Float[] array) {
        this.unitCellAlpha = array;
    }

    public Float[] getUnitCellBeta() {
        return this.unitCellBeta;
    }

    public void setUnitCellBeta(Float[] array) {
        this.unitCellBeta = array;
    }

    public Float[] getUnitCellGamma() {
        return this.unitCellGamma;
    }

    public void setUnitCellGamma(Float[] array) {
        this.unitCellGamma = array;
    }

    public Integer[] getUnitCellSpaceGroup() {
        return this.unitCellSpaceGroup;
    }

    public void setUnitCellSpaceGroup(Integer[] array) {
        this.unitCellSpaceGroup = array;
    }

    public String getStructureFile(int i) {
        if (this.structureFile != null && i < this.structureFile.length) {
            return this.structureFile[i];
        }
        return null;
    }

    public void setStructureFile(String file, int i) {
        if (this.structureFile != null) {
            this.structureFile[i] = file;
        }
    }

    public Integer getMakeImages() {
        return this.makeImages;
    }

    public void setMakeImages(int value) {
        this.makeImages = value;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String file) {
        this.outputDirectory = file.replaceAll("\\\\", "/");
        this.logger.debug((Object)("output Directory = " + this.outputDirectory));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String file) {
        this.prefix = file;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public Integer getNoise() {
        return this.noise;
    }

    public void setNoise(int value) {
        this.noise = value;
    }

    public Integer getBackground() {
        return this.background;
    }

    public void setBackground(int value) {
        this.background = value;
    }

    public Integer getPsf() {
        return this.psf;
    }

    public void setPsf(int value) {
        this.psf = value;
    }

    public Integer getPeakShape() {
        return this.peakShape;
    }

    public void setPeakShape(int value) {
        this.peakShape = value;
    }

    public int getGenGrainOrientation() {
        return this.genGrainOrientation;
    }

    public void setGenGrainOrientation(int value) {
        this.genGrainOrientation = value;
    }

    public int getGenGrainPosition() {
        return this.genGrainPosition;
    }

    public void setGenGrainPosition(int value) {
        this.genGrainPosition = value;
    }

    public boolean getOutputFlt() {
        return this.outputFlt;
    }

    public void setOutputFlt(boolean flt) {
        this.outputFlt = flt;
    }

    public boolean getOutputGve() {
        return this.outputGve;
    }

    public void setOutputGve(boolean gve) {
        this.outputGve = gve;
    }

    public boolean getOutputUbi() {
        return this.outputUbi;
    }

    public void setOutputUbi(boolean ubi) {
        this.outputUbi = ubi;
    }

    public boolean getOutputPar() {
        return this.outputPar;
    }

    public void setOutputPar(boolean par) {
        this.outputPar = par;
    }

    public int getNumPhases() {
        return this.numPhases;
    }

    public void setWedge(float value) {
        this.wedge = value;
    }

    public float getWedge() {
        return this.wedge;
    }

    public float getPolarisationFactor() {
        return this.polarisationFactor.floatValue();
    }

    public float getPolarisationDirection() {
        return this.polarisationDirection.floatValue();
    }

    public void setPolarisationFactor(float value) {
        this.polarisationFactor = Float.valueOf(value);
    }

    public void setPolarisationDirection(float value) {
        this.polarisationDirection = Float.valueOf(value);
    }

    public float getMosaicity() {
        return this.mosaicity;
    }

    public void setMosaicity(float value) {
        this.mosaicity = value;
    }

    public Float getIntensityConstant() {
        return this.intensityConstant;
    }

    public void setIntensityConstant(Float value) {
        this.intensityConstant = value;
    }

    public boolean getPolarisation() {
        return this.polarisation;
    }

    public void setPolarisation(boolean value) {
        this.polarisation = value;
    }

    public boolean getLorentzFactor() {
        return this.lorentzFactor;
    }

    public void setLorentzFactor(boolean value) {
        this.lorentzFactor = value;
    }

    public void setInputFileDirectory(String value) throws JepException {
        this.inputDirectory = value;
        if (this.inputDirectory != null) {
            this.inputDirectory = this.inputDirectory.replaceAll("\\\\", "/");
        }
    }

    public String getInputFileDirectory() {
        return this.inputDirectory;
    }

    public void setNumPhases(int value) {
        this.numPhases = value;
    }

    public Integer[] getDetOrientation() {
        return this.detOrientation;
    }

    public void setDetOrientation(Integer[] value) {
        int i = 0;
        while (i < 4) {
            this.detOrientation[i] = value[i];
            ++i;
        }
    }

    public Float[] getPeakParameters() {
        return this.peakParameters;
    }

    public void setPeakParameters(Float[] value) {
        this.peakParameters[0] = value[0];
        this.peakParameters[1] = value[1];
    }

    public Integer[] getPhaseGrains() {
        return this.phaseGrains;
    }

    public void setPhaseGrains(Integer[] value) {
        this.phaseGrains = new Integer[value.length];
        int i = 0;
        while (i < value.length) {
            this.phaseGrains[i] = value[i];
            ++i;
        }
    }

    public Integer[] getPhases() {
        return this.phases;
    }

    public void setPhases(Integer[] value) {
        this.phases = new Integer[value.length];
        int i = 0;
        while (i < value.length) {
            this.phases[i] = value[i];
            ++i;
        }
    }

    public Float[] getPhaseGrainSize() {
        return this.phaseGrainSize;
    }

    public void setPhaseGrainSize(Float[] value) {
        this.phaseGrainSize = value;
    }

    public Float[] getPhaseGrainMinSize() {
        return this.phaseGrainMinSize;
    }

    public void setPhaseGrainMinSize(Float[] value) {
        this.phaseGrainMinSize = value;
    }

    public Float[] getPhaseGrainMaxSize() {
        return this.phaseGrainMaxSize;
    }

    public void setPhaseGrainMaxSize(Float[] value) {
        this.phaseGrainMaxSize = value;
    }

    public boolean getSampleIsCylinder() {
        return this.isCylinder;
    }

    public boolean getSampleIsCube() {
        return this.isCube;
    }

    public void setSampleIsCylinder(boolean value) {
        this.isCylinder = value;
    }

    public void setSampleIsCube(boolean value) {
        this.isCube = value;
    }

    public Float[] getSampleCyl() {
        return this.sampleCyl;
    }

    public void setSampleCyl(Float[] array) {
        this.sampleCyl = array;
    }

    private static boolean writeInputFile(String file, String parameters) {
        boolean created = true;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(parameters);
            out.close();
        }
        catch (IOException e) {
            created = false;
            FableUtils.errMsg((Object)"Polyxsim", (String)("Input file can't be created. " + e.getMessage()));
        }
        return created;
    }

    public void addPolyXSimListener(IPolyxsimEventListener listener) {
        this.polyxsimListeners.add(listener);
    }

    public void removePolyXSimListener(IPolyxsimEventListener listener) {
        this.polyxsimListeners.remove(listener);
    }

    public String getInputFile() {
        return this.inputFileName;
    }

    public String getSpatial() {
        return this.spatial;
    }

    public String setSpatial() {
        return this.spatial;
    }

    public static String[] getAllKeyWords() {
        String[] allKeys = null;
        try {
            FableJep jep = new FableJep();
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
            jep.eval("from polyxsim import check_input");
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("required_items = checkObject.needed_items");
            jep.eval("optional_items = checkObject.optional_items");
            jep.eval("optional = optional_items is not None");
            jep.eval("required = required_items is not None");
            if (jep.getBooleanValue("optional").booleanValue() && jep.getBooleanValue("required").booleanValue()) {
                int len_optional_items = jep.getIntegerValue("len(optional_items)");
                int len_required_items = jep.getIntegerValue("len(required_items)");
                int len = len_required_items + len_optional_items;
                allKeys = new String[len];
                int i = 0;
                i = 0;
                while (i < len_optional_items) {
                    jep.set("i", i);
                    allKeys[i] = jep.getStringValue("optional_items.keys()[i]");
                    ++i;
                }
                int j = 0;
                while (j < len_required_items) {
                    jep.set("j", j);
                    allKeys[i] = jep.getStringValue("required_items.keys()[j]");
                    ++i;
                    ++j;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(PolyXSim.class, (String)"An error occured with jep", (Throwable)e);
        }
        return allKeys;
    }

    public static Object getDefaultValue(String key) {
        return PolyXSim.getOptionalItems().get(key);
    }

    public static HashMap<String, Object> getOptionalItems() {
        if (optionalItems == null) {
            optionalItems = new HashMap();
            try {
                FableJep jep = new FableJep();
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
                jep.eval("from polyxsim import check_input");
                jep.eval("checkObject = check_input.parse_input()");
                jep.eval("optional_items = checkObject.optional_items");
                if (jep.eval("optional_items is not None")) {
                    int len = jep.getIntegerValue("len(optional_items)");
                    int i = 0;
                    while (i < len) {
                        jep.set("i", i);
                        String key = jep.getStringValue("optional_items.keys()[i]");
                        if (key != null) {
                            jep.set("key_java", key);
                            Object value = jep.getValue("optional_items[key_java]");
                            optionalItems.put(key, value);
                        }
                        ++i;
                    }
                }
                jep.close();
            }
            catch (JepException e) {
                FableUtils.excMsg(PolyXSim.class, (String)"An error occured with jep", (Throwable)e);
            }
        }
        return optionalItems;
    }

    public void setSampleShapeNone() {
        this.isCylinder = false;
        this.isCube = false;
    }

    public String getDirec() {
        return this.outputDirectory;
    }

    public static ArrayList<String> getRequiredKeysFromPython() {
        ArrayList<String> requiredKeys = null;
        try {
            FableJep jep = new FableJep();
            jep.eval("from polyxsim import check_input");
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("required_items = checkObject.needed_items");
            if (jep.eval("required_items is not None")) {
                int len = jep.getIntegerValue("len(required_items)");
                requiredKeys = new ArrayList<String>(len);
                int i = 0;
                while (i < len) {
                    jep.set("i", i);
                    requiredKeys.add(jep.getStringValue("required_items.keys()[i]"));
                    ++i;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(PolyXSim.class, (String)"An error occured with jep", (Throwable)e);
        }
        return requiredKeys;
    }

    public void setInputFile(String file) {
        this.inputFileName = file;
    }

    public boolean getGenU() {
        return this.gen_U;
    }

    public String getUGrains() {
        return this.U_grains;
    }

    public String getPos() {
        return this.gen_pos;
    }

    public String getPosGrains() {
        return this.pos_Grains;
    }

    public void setGenU(boolean genu) {
        this.gen_U = genu;
    }

    public void setUGrains(String longString) {
        this.U_grains = longString;
    }

    public void setgenPos(String pos) {
        this.gen_pos = pos;
    }

    public void setPosGrains(String longString) {
        this.pos_Grains = longString;
    }

    public FableJep loadFileInPython(String _inputFileName) {
        this.inputFileName = _inputFileName;
        Job job = new Job("Wait while loading input file " + _inputFileName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Load input file", 100);
                try {
                    FableJep jep = new FableJep();
                    jep.outputConsole(FableMessageConsole.console);
                    PolyXSim.this.loadPythonModules(jep);
                    monitor.worked(25);
                    jep.set("sim_filename", PolyXSim.this.inputFileName);
                    PolyXSim.this.inputDirectory = new File(PolyXSim.this.inputFileName).getParent();
                    if (PolyXSim.this.inputDirectory != null) {
                        String currentDirectory = PolyXSim.this.inputDirectory.replaceAll("\\\\", "/");
                        jep.eval("os.chdir(\"" + currentDirectory + "\")");
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
                    jep.eval("myinput.read()");
                    monitor.worked(25);
                    try {
                        jep.eval("myinput.init_values()");
                    }
                    catch (JepException e) {
                        monitor.done();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (FableMessageConsole.console != null) {
                                    FableMessageConsole.console.displayError("A jep exception occured during python object initialisation: " + e.getMessage());
                                }
                                SWTUtils.errMsg((String)("A jep exception occured during python object initialisation: " + e.getMessage()));
                            }
                        });
                    }
                    try {
                        jep.eval("myinput.initialize()");
                    }
                    catch (JepException e) {
                        monitor.done();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (FableMessageConsole.console != null) {
                                    FableMessageConsole.console.displayError("A jep exception occured during initialize : " + e.getMessage());
                                }
                                SWTUtils.errMsg((String)("A jep exception occured during initialize: " + e.getMessage()));
                            }
                        });
                    }
                    monitor.worked(25);
                    this.setValues(jep);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(25);
                }
                catch (JepException e) {
                    monitor.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError("File can not be imported. A jep exception occured : " + e.getMessage());
                            }
                            SWTUtils.errMsg((String)("File can not be imported. A jep exception occured : " + e.getMessage()));
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private void setValues(FableJep jep) {
                Float valuef;
                Float value = jep.getFloatValue("myinput.param['wavelength']");
                if (value != null) {
                    PolyXSim.this.wavelength = value.floatValue();
                }
                if ((valuef = jep.getFloatValue("myinput.param['beamWidth']")) != null) {
                    PolyXSim.this.beamWidth = String.valueOf(valuef);
                }
                PolyXSim.this.flux = jep.getFloatValue("myinput.param['beamflux']");
                PolyXSim.this.distance = jep.getFloatValue("myinput.param['distance']");
                PolyXSim.this.intensityConstant = jep.getFloatValue("myinput.param['intensity_const']");
                PolyXSim.this.polarisation = false;
                if (jep.getIntegerValue("myinput.param['beampol_apply']") != null && jep.getIntegerValue("myinput.param['beampol_apply']") == 1) {
                    PolyXSim.this.polarisation = true;
                }
                PolyXSim.this.lorentzFactor = false;
                if (jep.getIntegerValue("myinput.param['lorentz_apply']") != null && jep.getIntegerValue("myinput.param['lorentz_apply']") == 1) {
                    PolyXSim.this.lorentzFactor = true;
                }
                PolyXSim.this.polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
                PolyXSim.this.polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
                PolyXSim.this.polarisationDirection = jep.getFloatValue("myinput.param['beampol_direct']");
                PolyXSim.this.detyCenter = jep.getFloatValue("myinput.param['dety_center']");
                PolyXSim.this.detzCenter = jep.getFloatValue("myinput.param['detz_center']");
                PolyXSim.this.ySize = jep.getFloatValue("myinput.param['y_size']");
                PolyXSim.this.zSize = jep.getFloatValue("myinput.param['z_size']");
                PolyXSim.this.detySize = jep.getFloatValue("myinput.param['dety_size']");
                PolyXSim.this.detzSize = jep.getFloatValue("myinput.param['detz_size']");
                PolyXSim.this.detTiltX = jep.getFloatValue("myinput.param['tilt_x']");
                PolyXSim.this.detTiltY = jep.getFloatValue("myinput.param['tilt_y']");
                PolyXSim.this.detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
                PolyXSim.this.detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
                ((PolyXSim)PolyXSim.this).detOrientation[0] = jep.getIntegerValue("myinput.param['o11']");
                ((PolyXSim)PolyXSim.this).detOrientation[1] = jep.getIntegerValue("myinput.param['o12']");
                ((PolyXSim)PolyXSim.this).detOrientation[2] = jep.getIntegerValue("myinput.param['o21']");
                ((PolyXSim)PolyXSim.this).detOrientation[3] = jep.getIntegerValue("myinput.param['o22']");
                if (jep.getStringValue("myinput.param['wedge']") != null) {
                    PolyXSim.this.wedge = jep.getFloatValue("myinput.param['wedge']").floatValue();
                }
                PolyXSim.this.omegaStart = jep.getFloatValue("myinput.param['omega_start']");
                PolyXSim.this.omegaEnd = jep.getFloatValue("myinput.param['omega_end']");
                PolyXSim.this.omegaStep = jep.getFloatValue("myinput.param['omega_step']");
                PolyXSim.this.omegaSign = jep.getIntegerValue("myinput.param['omega_sign']");
                try {
                    Object str = jep.getValue("myinput.param['no_phases']");
                    if (str != null) {
                        PolyXSim.this.numPhases = jep.getIntegerValue("myinput.param['no_phases']");
                    }
                }
                catch (JepException e1) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_size' key word: " + e1.getMessage()));
                }
                if (PolyXSim.this.numPhases == 0) {
                    PolyXSim.this.numPhases = 1;
                }
                jep.getIntegerValue("myinput.param['no_phases']");
                PolyXSim.this.numGrains = jep.getIntegerValue("myinput.param['no_grains']");
                PolyXSim.this.genGrainOrientation = jep.getIntegerValue("myinput.param['gen_U']");
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('gen_pos')")).booleanValue() && ((Boolean)jep.getValue("len(myinput.param['gen_pos'])>=1")).booleanValue()) {
                        PolyXSim.this.genGrainPosition = jep.getIntegerValue("myinput.param['gen_pos'][0]");
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_pos' key word: " + e.getMessage()));
                }
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('sample_xyz')")).booleanValue()) {
                        PolyXSim.this.isCube = true;
                        int i = 0;
                        while (i < 3) {
                            ((PolyXSim)PolyXSim.this).sampleXYZ[i] = jep.getFloatValue("myinput.param['sample_xyz'][" + i + "]");
                            if (PolyXSim.this.sampleXYZ[i] == null) {
                                PolyXSim.this.isCube = false;
                            }
                            ++i;
                        }
                    } else {
                        PolyXSim.this.isCube = false;
                    }
                }
                catch (JepException e2) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'sample_xyz' key word: " + e2.getMessage()));
                }
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('sample_cyl')")).booleanValue()) {
                        PolyXSim.this.isCylinder = true;
                        int i = 0;
                        while (i < 2) {
                            ((PolyXSim)PolyXSim.this).sampleCyl[i] = jep.getFloatValue("myinput.param['sample_cyl'][" + i + "]");
                            if (PolyXSim.this.sampleCyl[i] == null) {
                                PolyXSim.this.isCylinder = false;
                            }
                            ++i;
                        }
                    } else {
                        PolyXSim.this.isCylinder = false;
                    }
                }
                catch (JepException e2) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'sample_cyl' key word: " + e2.getMessage()));
                }
                PolyXSim.this.makeImages = jep.getIntegerValue("myinput.param['make_image']");
                PolyXSim.this.outputDirectory = jep.getStringValue("myinput.param['direc']");
                PolyXSim.this.setThisDirectoryRelativeToOs();
                PolyXSim.this.prefix = jep.getStringValue("myinput.param['stem']");
                PolyXSim.this.noise = jep.getIntegerValue("myinput.param['noise']");
                PolyXSim.this.background = jep.getIntegerValue("myinput.param['bg']");
                PolyXSim.this.psf = jep.getIntegerValue("myinput.param['psf']");
                PolyXSim.this.spatial = jep.getStringValue("myinput.param['spatial']");
                PolyXSim.this.peakShape = jep.getIntegerValue("myinput.param['peakshape'][0]");
                ((PolyXSim)PolyXSim.this).peakParameters[0] = jep.getFloatValue("myinput.param['peakshape'][1]");
                ((PolyXSim)PolyXSim.this).peakParameters[1] = jep.getFloatValue("myinput.param['peakshape'][2]");
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('gen_size')")).booleanValue() && ((Boolean)jep.getValue("len(myinput.param['gen_size'])>=4")).booleanValue()) {
                        PolyXSim.this.gen_size_flag = jep.getIntegerValue("myinput.param['gen_size'][0]");
                        PolyXSim.this.grainSize = jep.getFloatValue("myinput.param['gen_size'][1]");
                        PolyXSim.this.grainMinSize = jep.getFloatValue("float(myinput.param['gen_size'][2])");
                        PolyXSim.this.grainMaxSize = jep.getFloatValue("myinput.param['gen_size'][3]");
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_size' key word: " + e.getMessage()));
                }
                PolyXSim.this.phases = new Integer[PolyXSim.this.numPhases];
                PolyXSim.this.phaseGrainSizeflag = new Integer[PolyXSim.this.numPhases];
                PolyXSim.this.phaseGrains = new Integer[PolyXSim.this.numPhases];
                PolyXSim.this.phaseGrainSize = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.phaseGrainMinSize = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.phaseGrainMaxSize = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.structureFile = new String[PolyXSim.this.numPhases];
                if (PolyXSim.this.numPhases == 1) {
                    ((PolyXSim)PolyXSim.this).phaseGrains[0] = PolyXSim.this.numGrains;
                    try {
                        if (((Boolean)jep.getValue("myinput.param.has_key('structure_file')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).structureFile[0] = jep.getStringValue("myinput.param['structure_file']");
                        } else if (((Boolean)jep.getValue("myinput.param.has_key('structure_phase_0')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).structureFile[0] = jep.getStringValue("myinput.param['structure_phase_0']");
                        }
                    }
                    catch (JepException e) {
                        FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'structure_file' key word: " + e.getMessage()));
                    }
                } else {
                    try {
                        int i = 0;
                        while (i < PolyXSim.this.numPhases && ((Boolean)jep.getValue("myinput.param.has_key('structure_phase_" + i + "')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).structureFile[i] = jep.getStringValue("myinput.param['structure_phase_" + i + "']");
                            ++i;
                        }
                    }
                    catch (JepException e) {
                        FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'structure_phase' key word: " + e.getMessage()));
                    }
                }
                boolean hasGenPhaseKey = false;
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('gen_phase')")).booleanValue()) {
                        PolyXSim.this.gen_phase_flag = jep.getIntegerValue("myinput.param['gen_phase'][0]");
                        hasGenPhaseKey = true;
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_phase' key word: " + e.getMessage()));
                }
                int i = 0;
                while (i < PolyXSim.this.numPhases && hasGenPhaseKey) {
                    int phaseIndex = 1 + i * 2;
                    ((PolyXSim)PolyXSim.this).phases[i] = jep.getIntegerValue("myinput.param['gen_phase'][" + phaseIndex + "]");
                    ((PolyXSim)PolyXSim.this).phaseGrains[i] = jep.getIntegerValue("myinput.param['gen_phase'][" + ++phaseIndex + "]");
                    ++i;
                }
                try {
                    i = 0;
                    while (i < PolyXSim.this.numPhases && ((Boolean)jep.getValue("myinput.param.has_key('gen_size_phase_" + i + "')")).booleanValue()) {
                        ((PolyXSim)PolyXSim.this).phaseGrainSizeflag[i] = jep.getIntegerValue("myinput.param['gen_size_phase_" + i + "'][0]");
                        ((PolyXSim)PolyXSim.this).phaseGrainSize[i] = jep.getFloatValue("myinput.param['gen_size_phase_" + i + "'][1]");
                        ((PolyXSim)PolyXSim.this).phaseGrainMinSize[i] = jep.getFloatValue("myinput.param['gen_size_phase_" + i + "'][2]");
                        ((PolyXSim)PolyXSim.this).phaseGrainMaxSize[i] = jep.getFloatValue("myinput.param['gen_size_phase_" + i + "'][3]");
                        ++i;
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_size_phase' key word: " + e.getMessage()));
                }
                PolyXSim.this.unitCellA = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellB = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellC = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellAlpha = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellBeta = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellGamma = new Float[PolyXSim.this.numPhases];
                PolyXSim.this.unitCellSpaceGroup = new Integer[PolyXSim.this.numPhases];
                if (PolyXSim.this.numPhases == 1) {
                    try {
                        if (((Boolean)jep.getValue("myinput.param.has_key('unit_cell')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).unitCellA[0] = jep.getFloatValue("myinput.param['unit_cell'][0]");
                            ((PolyXSim)PolyXSim.this).unitCellB[0] = jep.getFloatValue("myinput.param['unit_cell'][1]");
                            ((PolyXSim)PolyXSim.this).unitCellC[0] = jep.getFloatValue("myinput.param['unit_cell'][2]");
                            ((PolyXSim)PolyXSim.this).unitCellAlpha[0] = jep.getFloatValue("myinput.param['unit_cell'][3]");
                            ((PolyXSim)PolyXSim.this).unitCellBeta[0] = jep.getFloatValue("myinput.param['unit_cell'][4]");
                            ((PolyXSim)PolyXSim.this).unitCellGamma[0] = jep.getFloatValue("myinput.param[''unit_cell'][5]");
                        } else if (((Boolean)jep.getValue("myinput.param.has_key('unit_cell_phase_0')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).unitCellA[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][0]");
                            ((PolyXSim)PolyXSim.this).unitCellB[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][1]");
                            ((PolyXSim)PolyXSim.this).unitCellC[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][2]");
                            ((PolyXSim)PolyXSim.this).unitCellAlpha[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][3]");
                            ((PolyXSim)PolyXSim.this).unitCellBeta[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][4]");
                            ((PolyXSim)PolyXSim.this).unitCellGamma[0] = jep.getFloatValue("myinput.param['unit_cell_phase_0'][5]");
                        }
                        if (((Boolean)jep.getValue("myinput.param.has_key('sgno')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).unitCellSpaceGroup[0] = jep.getIntegerValue("myinput.param['sgno']");
                        } else if (((Boolean)jep.getValue("myinput.param.has_key('sgno_phase_0')")).booleanValue()) {
                            ((PolyXSim)PolyXSim.this).unitCellSpaceGroup[0] = jep.getIntegerValue("myinput.param['sgno_phase_0']");
                        }
                    }
                    catch (JepException e) {
                        FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'sgno_phase_0' key word: " + e.getMessage()));
                    }
                } else {
                    i = 0;
                    while (i < PolyXSim.this.numPhases) {
                        ((PolyXSim)PolyXSim.this).unitCellA[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][0]");
                        ((PolyXSim)PolyXSim.this).unitCellB[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][1]");
                        ((PolyXSim)PolyXSim.this).unitCellC[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][2]");
                        ((PolyXSim)PolyXSim.this).unitCellAlpha[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][3]");
                        ((PolyXSim)PolyXSim.this).unitCellBeta[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][4]");
                        ((PolyXSim)PolyXSim.this).unitCellGamma[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][5]");
                        ((PolyXSim)PolyXSim.this).unitCellSpaceGroup[i] = jep.getIntegerValue("myinput.param['sgno_phase_" + i + "']");
                        PolyXSim.this.logger.debug((Object)("unit cell space group no " + PolyXSim.this.unitCellSpaceGroup[i]));
                        ++i;
                    }
                }
                int outFiles = jep.getIntegerValue("len(myinput.param['output'])");
                PolyXSim.this.logger.debug((Object)("outFiles " + outFiles));
                int i2 = 0;
                while (i2 < outFiles) {
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("tif")) {
                        PolyXSim.this.format = "tif";
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("tif16bit")) {
                        PolyXSim.this.format = "tif16bit";
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("edf")) {
                        PolyXSim.this.format = "edf";
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("flt")) {
                        PolyXSim.this.outputFlt = true;
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("gve")) {
                        PolyXSim.this.outputGve = true;
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("ubi")) {
                        PolyXSim.this.outputUbi = true;
                    }
                    if (jep.getStringValue("myinput.param['output'][" + i2 + "]").endsWith("par")) {
                        PolyXSim.this.outputPar = true;
                    }
                    ++i2;
                }
                try {
                    if (jep.getValue("myinput.param['gen_pos']") != null && jep.getIntegerValue("len(myinput.param['gen_pos'])") > 1) {
                        PolyXSim.this.gen_pos = jep.getValue("myinput.param['gen_pos'][0]") + " " + jep.getValue("myinput.param['gen_pos'][1]");
                    }
                }
                catch (JepException e1) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during setValues() with 'gen_pos' key word: " + e1.getMessage()));
                }
                if (jep.getIntegerValue("myinput.param['gen_U']") != null) {
                    PolyXSim.this.gen_U = jep.getIntegerValue("myinput.param['gen_U']") == 1;
                }
                PolyXSim.this.U_grains = "";
                try {
                    PolyXSim.this.fillU_grains(jep);
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during fillU_grains: " + e.getMessage()));
                }
                PolyXSim.this.pos_Grains = "";
                try {
                    PolyXSim.this.fillpos_grains_X(jep);
                }
                catch (JepException e1) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during fillpos_grains_X: " + e1.getMessage()));
                }
                int len = 0;
                try {
                    if (((Boolean)jep.getValue("myinput.param.has_key('gen_eps')")).booleanValue() && jep.getStringValue("myinput.param['gen_eps']") != null && (len = jep.getIntegerValue("len(myinput.param['gen_eps'])").intValue()) > 0 && len <= 5) {
                        PolyXSim.this.gen_eps_flag = jep.getIntegerValue("myinput.param['gen_eps'][0]");
                        PolyXSim.this.gen_eps_meanValuefordiagonal = jep.getFloatValue("myinput.param['gen_eps'][1]");
                        PolyXSim.this.gen_eps_spread_value = jep.getFloatValue("myinput.param['gen_eps'][2]");
                        PolyXSim.this.gen_eps_meanValueforOffDiagonal = jep.getFloatValue("myinput.param['gen_eps'][3]");
                        PolyXSim.this.gen_eps_spread_valueforOffDiagonal = jep.getFloatValue("myinput.param['gen_eps'][4]");
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim with 'gen_eps' key word: " + e.getMessage()));
                }
                try {
                    PolyXSim.this.hasGen_eps_phase = false;
                    if (PolyXSim.this.numPhases > 0 && ((Boolean)jep.getValue("myinput.param.has_key('gen_eps_phase_0')")).booleanValue()) {
                        PolyXSim.this.hasGen_eps_phase = true;
                        PolyXSim.this.gen_eps_Flag_phase_y = new int[PolyXSim.this.numPhases];
                        PolyXSim.this.gen_eps_meanValuefordiagonal_y = new Float[PolyXSim.this.numPhases];
                        PolyXSim.this.gen_eps_meanValueforOffDiagonal_y = new Float[PolyXSim.this.numPhases];
                        PolyXSim.this.gen_eps_spread_value_y = new Float[PolyXSim.this.numPhases];
                        PolyXSim.this.gen_eps_spread_valueforOffDiagonal_y = new Float[PolyXSim.this.numPhases];
                        int i3 = 0;
                        while (i3 < PolyXSim.this.numPhases && ((Boolean)jep.getValue("myinput.param.has_key('gen_eps_phase_" + i3 + "')")).booleanValue() && jep.getStringValue("myinput.param['gen_eps_phase_" + i3 + "']") != null && jep.getIntegerValue("len(myinput.param['gen_eps_phase_" + i3 + "'])") >= 5) {
                            ((PolyXSim)PolyXSim.this).gen_eps_Flag_phase_y[i3] = jep.getIntegerValue("myinput.param['gen_eps_phase_" + i3 + "'][0]");
                            ((PolyXSim)PolyXSim.this).gen_eps_meanValuefordiagonal_y[i3] = jep.getFloatValue("myinput.param['gen_eps_phase_" + i3 + "'][1]");
                            ((PolyXSim)PolyXSim.this).gen_eps_spread_value_y[i3] = jep.getFloatValue("myinput.param['gen_eps_phase_" + i3 + "'][2]");
                            ((PolyXSim)PolyXSim.this).gen_eps_meanValueforOffDiagonal_y[i3] = jep.getFloatValue("myinput.param['gen_eps_phase_" + i3 + "'][3]");
                            ((PolyXSim)PolyXSim.this).gen_eps_spread_valueforOffDiagonal_y[i3] = jep.getFloatValue("myinput.param['gen_eps_phase_" + i3 + "'][4]");
                            ++i3;
                        }
                    }
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim with 'gen_eps_phase_' key word: " + e.getMessage()));
                }
                try {
                    PolyXSim.this.fillEps_grains(jep);
                }
                catch (JepException e) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during fillEpsGrains(): " + e.getMessage()));
                }
                PolyXSim.this.size_grains = "";
                try {
                    PolyXSim.this.fillsize_grains_X(jep);
                }
                catch (JepException e1) {
                    FableLogger.error((Object)("An error occured in fable.polyxsim.internal.Polyxsim during fillsize_grains_X(): " + e1.getMessage()));
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PolyXSim.this.fireInputFileLoaded();
                    }
                });
            }
        };
        job.setUser(true);
        job.schedule();
        return jep;
    }

    protected void fillsize_grains_X(FableJep jep) throws JepException {
        this.size_grains = "";
        if (jep.eval("myinput.param['sizegrainsId'] is not None")) {
            int len = jep.getIntegerValue("len(myinput.param['sizegrainsId'])");
            int i = 0;
            while (i < len) {
                jep.set("i", i);
                String key = jep.getStringValue("myinput.param['sizegrainsId'][i]");
                if (key != null) {
                    jep.set("size_grains_id_key", key);
                    this.size_grains = String.valueOf(this.size_grains) + key + " ";
                    Object valueTest = jep.getValue("myinput.param[size_grains_id_key]");
                    this.size_grains = String.valueOf(this.size_grains) + (valueTest != null ? valueTest : "") + "\n";
                }
                ++i;
            }
        }
    }

    private void fillEps_grains(FableJep jep) throws JepException {
        this.eps_grains = "";
        if (jep.eval("myinput.param['epsgrainsId'] is not None")) {
            int len = jep.getIntegerValue("len(myinput.param['epsgrainsId'])");
            int i = 0;
            while (i < len) {
                jep.set("i", i);
                String key = jep.getStringValue("myinput.param['epsgrainsId'][i]");
                if (key != null) {
                    jep.set("eps_grains_id_key", key);
                    this.eps_grains = String.valueOf(this.eps_grains) + key + " ";
                    Object valueTest = jep.getValue("myinput.param[eps_grains_id_key][0]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[eps_grains_id_key][1]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[eps_grains_id_key][2]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[eps_grains_id_key][3]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[eps_grains_id_key][4]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[eps_grains_id_key][5]");
                    this.eps_grains = String.valueOf(this.eps_grains) + (valueTest != null ? valueTest : "") + "\n";
                }
                ++i;
            }
        }
    }

    public void fillU_grains(FableJep jep) throws JepException {
        this.U_grains = "";
        if (jep.eval("myinput.param['UgrainsId'] is not None")) {
            int len = jep.getIntegerValue("len(myinput.param['UgrainsId'])");
            int i = 0;
            while (i < len) {
                jep.set("i", i);
                String key = jep.getStringValue("myinput.param['UgrainsId'][i]");
                if (key != null) {
                    jep.set("u_grains_id_key", key);
                    this.U_grains = String.valueOf(this.U_grains) + key + " ";
                    Object valueTest = jep.getValue("myinput.param[u_grains_id_key][0][0]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][0][1]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][0][2]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][1][0]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][1][1]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][1][2]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][2][0]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][2][1]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[u_grains_id_key][2][2]");
                    this.U_grains = String.valueOf(this.U_grains) + (valueTest != null ? valueTest : "") + "\n";
                }
                ++i;
            }
        }
    }

    public void fillpos_grains_X(FableJep jep) throws JepException {
        this.pos_Grains = "";
        if (jep.eval("myinput.param['posgrainsId'] is not None")) {
            int len = jep.getIntegerValue("len(myinput.param['posgrainsId'])");
            int i = 0;
            while (i < len) {
                jep.set("i", i);
                String key = jep.getStringValue("myinput.param['posgrainsId'][i]");
                if (key != null) {
                    jep.set("pos_grains_id_key", key);
                    this.pos_Grains = String.valueOf(this.pos_Grains) + key + " ";
                    Object valueTest = jep.getValue("myinput.param[pos_grains_id_key][0]");
                    this.pos_Grains = String.valueOf(this.pos_Grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[pos_grains_id_key][1]");
                    this.pos_Grains = String.valueOf(this.pos_Grains) + (valueTest != null ? valueTest : "") + " ";
                    valueTest = jep.getValue("myinput.param[pos_grains_id_key][2]");
                    this.pos_Grains = String.valueOf(this.pos_Grains) + (valueTest != null ? valueTest : "") + "\n";
                }
                ++i;
            }
        }
    }

    public void reload() {
        this.loadFileInPython(this.inputFileName);
    }

    public String getBeamWidth() {
        return this.beamWidth;
    }

    public int getGen_eps_flag() {
        return this.gen_eps_flag;
    }

    public void setGen_eps_flag(int gen_eps_flag) {
        this.gen_eps_flag = gen_eps_flag;
    }

    public Float getGen_eps_meanValuefordiagonal() {
        return this.gen_eps_meanValuefordiagonal;
    }

    public void setGen_eps_meanValuefordiagonal(Float gen_eps_meanValuefordiagonal) {
        this.gen_eps_meanValuefordiagonal = gen_eps_meanValuefordiagonal;
    }

    public Float getGen_eps_spread_value() {
        return this.gen_eps_spread_value;
    }

    public void setGen_eps_spread_value(Float gen_eps_spread_value) {
        this.gen_eps_spread_value = gen_eps_spread_value;
    }

    public Float getGen_eps_meanValueforOffDiagonal() {
        return this.gen_eps_meanValueforOffDiagonal;
    }

    public void setGen_eps_meanValueforOffDiagonal(Float gen_eps_meanValueforOffDiagonal) {
        this.gen_eps_meanValueforOffDiagonal = gen_eps_meanValueforOffDiagonal;
    }

    public Float getGen_eps_spread_valueforOffDiagonal() {
        return this.gen_eps_spread_valueforOffDiagonal;
    }

    public void setGen_eps_spread_valueforOffDiagonal(Float gen_eps_spread_valueforOffDiagonal) {
        this.gen_eps_spread_valueforOffDiagonal = gen_eps_spread_valueforOffDiagonal;
    }

    public int[] getGen_eps_Flag_phase_y() {
        return this.gen_eps_Flag_phase_y;
    }

    public void setGen_eps_Flag_phase_y(int[] gen_eps_Flag_phase_y) {
        this.gen_eps_Flag_phase_y = gen_eps_Flag_phase_y;
    }

    public Float[] getGen_eps_meanValuefordiagonal_y() {
        return this.gen_eps_meanValuefordiagonal_y;
    }

    public void setGen_eps_meanValuefordiagonal_y(Float[] gen_eps_meanValuefordiagonal_y) {
        this.gen_eps_meanValuefordiagonal_y = gen_eps_meanValuefordiagonal_y;
    }

    public Float[] getGen_eps_spread_value_y() {
        return this.gen_eps_spread_value_y;
    }

    public void setGen_eps_spread_value_y(Float[] gen_eps_spread_value_y) {
        this.gen_eps_spread_value_y = gen_eps_spread_value_y;
    }

    public Float[] getGen_eps_meanValueforOffDiagonal_y() {
        return this.gen_eps_meanValueforOffDiagonal_y;
    }

    public void setGen_eps_meanValueforOffDiagonal_y(Float[] gen_eps_meanValueforOffDiagonal_y) {
        this.gen_eps_meanValueforOffDiagonal_y = gen_eps_meanValueforOffDiagonal_y;
    }

    public Float[] getGen_eps_spread_valueforOffDiagonal_y() {
        return this.gen_eps_spread_valueforOffDiagonal_y;
    }

    public void setGen_eps_spread_valueforOffDiagonal_y(Float[] gen_eps_spread_valueforOffDiagonal_y) {
        this.gen_eps_spread_valueforOffDiagonal_y = gen_eps_spread_valueforOffDiagonal_y;
    }

    public boolean isHasGen_eps_phase() {
        return this.hasGen_eps_phase;
    }

    public void setHasGen_eps_phase(boolean hasGen_eps_phase) {
        this.hasGen_eps_phase = hasGen_eps_phase;
    }

    public String getEps_grains() {
        return this.eps_grains;
    }

    public void setEps_grains(String eps_grains) {
        this.eps_grains = eps_grains;
    }

    public boolean getGen_phaseFlag() {
        return this.gen_phase_flag == 1;
    }

    public boolean getGen_sizeFlag() {
        return this.gen_size_flag == 1;
    }

    public String getSize_grains() {
        return this.size_grains;
    }

    public void setSize_grains(String size_grains) {
        this.size_grains = size_grains;
    }

    public Integer[] getPhaseGrainSizeflag() {
        return this.phaseGrainSizeflag;
    }

    public void setPhaseGrainSizeflag(Integer[] phaseGrainSizeflag) {
        this.phaseGrainSizeflag = phaseGrainSizeflag;
    }

    class PolyXSimThread
    implements Runnable {
        String outputMessage;
        private StdoutRead stdErrThread;

        PolyXSimThread() {
        }

        @Override
        public void run() {
            PolyXSim.this.jobCanceled = false;
            try {
                jep = new FableJep();
                jep.outputConsole(FableMessageConsole.console);
                PolyXSim.this.loadPythonModules(jep);
                PolyXSim.this.initValuesFromPython(jep);
                PolyXSim.this.tempFile = File.createTempFile("polyxsim", ".stdout");
                PolyXSim.this.tempFile.deleteOnExit();
                PolyXSim.this.logger.debug((Object)("tempFile = " + PolyXSim.this.tempFile.getAbsolutePath()));
                PolyXSim.this.killFile = PolyXSim.this.tempFile.getAbsolutePath().replaceAll("stdout", "kill");
                PolyXSim.this.logger.debug((Object)("killFile = " + PolyXSim.this.killFile));
                jep.redirectStdout(PolyXSim.this.tempFile.getAbsolutePath());
                PolyXSim.this.stdoutThread = new StdoutRead(PolyXSim.this.tempFile.getAbsolutePath());
                PolyXSim.this.stdoutThread.start();
                new ThreadMonitor().start();
                if (PolyXSim.this.inputDirectory != null) {
                    String currentDirectory = PolyXSim.this.inputDirectory.replaceAll("\\\\", "/");
                    jep.eval("os.chdir(\"" + currentDirectory + "\")");
                }
                jep.eval("option = OptionParser()");
                jep.eval("option.killfile=\"" + PolyXSim.this.killFile + "\"");
                jep.eval("option.filename=\"" + PolyXSim.this.inputFileName + "\"");
                PolyXSim.this.runStatus = true;
                jep.eval("gopolyxsim.run(option)");
                Thread.sleep(1000L);
            }
            catch (JepException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (InterruptedException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (IOException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            if (PolyXSim.this.runStatus) {
                FableMessageConsole.console.displayOut("polyxsim simulation finished");
            } else {
                FableMessageConsole.console.displayError("polyxsim simulation failed ");
            }
            jep.close();
            PolyXSim.this.fireProperty("stopped");
            if (PolyXSim.this.stdoutThread != null) {
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
        }

        public void run_fable1Version() {
            this.setCursor(1);
            PolyXSim.this.jobCanceled = false;
            try {
                jep = new FableJep();
                jep.outputConsole(FableMessageConsole.console);
                PolyXSim.this.loadPythonModules(jep);
                PolyXSim.this.tempFile = File.createTempFile("polyxsim", ".stdout");
                PolyXSim.this.tempFile.deleteOnExit();
                PolyXSim.this.logger.debug((Object)("tempFile = " + PolyXSim.this.tempFile.getAbsolutePath()));
                PolyXSim.this.killFile = PolyXSim.this.tempFile.getAbsolutePath().replaceAll("stdout", "kill");
                PolyXSim.this.logger.debug((Object)("killFile = " + PolyXSim.this.killFile));
                jep.redirectStdout(PolyXSim.this.tempFile.getAbsolutePath());
                String currentDirectory = PolyXSim.this.inputDirectory.replaceAll("\\\\", "/");
                jep.eval("os.chdir(\"" + currentDirectory + "\")");
                jep.set("sim_filename", PolyXSim.this.inputFileName);
                PolyXSim.this.stdoutThread = new StdoutRead(PolyXSim.this.tempFile.getAbsolutePath());
                PolyXSim.this.stdoutThread.start();
                jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
                if (this.updateMonitorStatus("Read input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("read input");
                jep.eval("myinput.read()");
                if (this.updateMonitorStatus("Check input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("check input");
                jep.eval("myinput.check()");
                PolyXSim.this.updateValues(jep);
                if (this.updateMonitorStatus("Check input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("check input");
                jep.eval("myinput.check()");
                if (this.updateMonitorStatus("Initialise", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("initialise");
                jep.eval("myinput.initialize()");
                if (this.updateMonitorStatus("Generate grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("generate reflections");
                jep.eval("hkl = []");
                jep.eval("print myinput.param['phase_list']");
                int i = 0;
                while (i < PolyXSim.this.numPhases) {
                    jep.eval("phase = " + i);
                    jep.eval("print 'phase = ',phase");
                    if (jep.getValue("myinput.param['structure_phase_" + i + "']") != null) {
                        jep.eval("xtal_structure = reflections.open_structure(myinput.param,phase)");
                        jep.eval("print 'UNIT CELL', myinput.param['unit_cell_phase_" + i + "']");
                        jep.eval("print 'Generating miller indices'");
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        if ((Integer)jep.getValue("myinput.param['structure_factors']") != 0) {
                            jep.eval("print 'Structure factor calculation'");
                            jep.eval("hkl.append(reflections.calc_intensity(hkl_tmp,xtal_structure,'" + PolyXSim.this.killFile + "'))");
                        } else {
                            jep.eval("print 'No structure factor calculation'");
                            jep.eval("hkl.append(reflections.add_intensity(hkl,myinput.param))");
                        }
                    } else {
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        jep.eval("hkl.append(reflections.add_intensity(hkl_tmp,myinput.param))");
                    }
                    ++i;
                }
                FableMessageConsole.console.displayOut("generate grains");
                jep.eval("generate_grains.generate_grains(myinput.param)");
                if (this.updateMonitorStatus("Write grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write grains");
                jep.eval("file_io.write_grains(myinput.param)");
                if (this.updateMonitorStatus("Write res", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write reflections");
                jep.eval("file_io.write_res(myinput.param)");
                if (this.updateMonitorStatus("Generate reflections", 60)) {
                    return;
                }
                if (this.updateMonitorStatus("Determine the reflection parameters for grains", 20)) {
                    return;
                }
                FableMessageConsole.console.displayOut("determine the reflection parameters for grains");
                jep.eval("graindata = find_refl.find_refl(myinput.param,hkl)");
                jep.eval("graindata.frameinfo = myinput.frameinfo");
                jep.eval("graindata.run()");
                jep.eval("graindata.save()");
                if (PolyXSim.this.outputGve) {
                    jep.eval("graindata.write_gve()");
                }
                if (PolyXSim.this.outputFlt) {
                    jep.eval("graindata.write_flt()");
                }
                if (PolyXSim.this.peakShape == 2) {
                    if (this.updateMonitorStatus("Make image stack", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_imagestack.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    if (this.updateMonitorStatus("Setup odf", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("setup odf");
                    jep.eval("image.setup_odf()");
                    if (this.updateMonitorStatus("Write images", 15)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("write images");
                    jep.eval("image.make_image()");
                    jep.eval("image.correct_image()");
                } else {
                    if (this.updateMonitorStatus("Make images", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_image.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    int noImages = jep.getIntegerValue("len(graindata.frameinfo)");
                    int i2 = 0;
                    while (i2 < noImages) {
                        if (this.updateMonitorStatus("Write images", (int)(15.0 / (double)noImages))) {
                            return;
                        }
                        jep.eval("image.make_image(" + i2 + ")");
                        ++i2;
                    }
                }
                Thread.sleep(1000L);
                PolyXSim.this.runStatus = true;
            }
            catch (JepException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (InterruptedException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (IOException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (PolyXSimException e) {
                FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
            }
            if (PolyXSim.this.runStatus) {
                FableMessageConsole.console.displayOut("polyxsim simulation finished");
            } else {
                FableMessageConsole.console.displayError("polyxsim simulation failed ");
            }
            PolyXSim.this.fireProperty("stopped");
            if (PolyXSim.this.stdoutThread != null) {
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
            this.setCursor(0);
        }

        void setCursor(final int cursor) {
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor arrowCursor = new Cursor((Device)Display.getDefault(), cursor);
                        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        activeWindow.getShell().setCursor(arrowCursor);
                    }
                });
            }
        }

        boolean updateMonitorStatus(String task, int work) {
            PolyXSim.this.polyXSimMonitor.subTask(task);
            PolyXSim.this.polyXSimMonitor.worked(work);
            if (PolyXSim.this.polyXSimMonitor.isCanceled()) {
                File killfile = new File(PolyXSim.this.killFile);
                try {
                    killfile.createNewFile();
                }
                catch (IOException e1) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((String)e1.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayOut("An error occurs while trying to create file called 'killfile' " + PolyXSim.this.killFile + " generated by Fable and used to stop polyxsim program : \n" + e1.getMessage());
                            }
                        }
                    });
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayOut("canceled polyxsim simulation");
                        }
                    }
                });
                PolyXSim.this.fireProperty("stopped");
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setCursor(0);
                killfile.delete();
                PolyXSim.this.jobCanceled = true;
                return true;
            }
            return false;
        }
    }

    class ThreadMonitor
    extends Thread {
        @Override
        public void run() {
            boolean cancelled = this.updateMonitorStatus();
            while (!cancelled && PolyXSim.this.runStatus) {
                cancelled = this.updateMonitorStatus();
            }
        }

        boolean updateMonitorStatus() {
            if (PolyXSim.this.polyXSimMonitor.isCanceled()) {
                File killfile = new File(PolyXSim.this.killFile);
                try {
                    killfile.createNewFile();
                }
                catch (IOException e1) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((String)e1.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayOut("An error occurs while trying to create file called 'killfile' " + PolyXSim.this.killFile + " generated by Fable and used to stop polyxsim program : \n" + e1.getMessage());
                            }
                        }
                    });
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayOut("canceled polyxsim simulation");
                        }
                    }
                });
                PolyXSim.this.fireProperty("stopped");
                PolyXSim.this.jobCanceled = true;
                return true;
            }
            return false;
        }
    }
}

