/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.editors.PolyXSimTextEditor;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class NewInputFile
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.window != null) {
            try {
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null) {
                    activeWindow.getWorkbench().showPerspective("fable.polyxsim.perspective", activeWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("PolyXSim perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening PolyXSim perspective : " + e.getMessage()));
            }
            FileDialog fileDlg = this.getSaveAsFileDialog();
            String fileName = fileDlg.open();
            fileDlg.getFilterPath();
            boolean confirm = false;
            confirm = ToolBox.checkIfFileExists((String)fileName) ? FableUtils.confirmMsg((Object)this, (String)(String.valueOf(fileName) + " already exists. \nDo you want to overwrite it and start with a new .inp with default input file available in PolyXSim preferences?")) : true;
            if (confirm) {
                PolyXSim.createNewInputFile(fileName);
                this.input = SWTUtils.createEditorInput((File)new File(fileName));
                String editorId = PolyXSimTextEditor.getId();
                try {
                    this.window.getActivePage().openEditor(this.input, editorId);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening input file: " + e.getMessage()));
                }
            }
        }
    }

    public FileDialog getSaveAsFileDialog() {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog fileDlg = new FileDialog(this.window.getShell(), 8192);
        fileDlg.setText("Create a new inp file.");
        fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
        fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INPUT);
        return fileDlg;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

