/*
 * Decompiled with CFR 0.152.
 */
package fable.python.preferences;

import fable.framework.toolbox.TreeWithAddRemove;
import fable.python.rcp.Activator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PythonPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor preferredScriptDirectory;
    private TreeWithAddRemove pythonPathTree;
    private IPreferenceStore preferencesStore;

    public PythonPreferencePage() {
    }

    public PythonPreferencePage(String title) {
        super(title);
    }

    public PythonPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 64);
        label.setText("Choose the directory for scripts :");
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).applyTo((Control)label);
        this.preferredScriptDirectory = new DirectoryFieldEditor("pref_python_script_path", "Script directory", composite);
        this.preferredScriptDirectory.setStringValue(this.preferencesStore.getString("pref_python_script_path"));
        label = new Label(composite, 64);
        label.setText("Choose the PYTHONPATH :");
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).applyTo((Control)label);
        String id = "pythonPathPreference";
        this.pythonPathTree = new TreeWithAddRemove(composite, 0, this.preferencesStore.getString(id));
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.pythonPathTree);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.preferencesStore = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(this.preferencesStore);
    }

    protected void performDefaults() {
        this.preferredScriptDirectory.setStringValue(this.preferencesStore.getDefaultString("pref_python_script_path"));
        String id = "pythonPathPreference";
        this.pythonPathTree.resetTreeItems(this.preferencesStore.getDefaultString(id));
        super.performDefaults();
    }

    public boolean performOk() {
        this.preferencesStore.setValue("pref_python_script_path", this.preferredScriptDirectory.getStringValue());
        String id = "pythonPathPreference";
        this.preferencesStore.setValue(id, this.pythonPathTree.getTreeItemsAsString());
        return super.performOk();
    }
}

