/*
 * Decompiled with CFR 0.152.
 */
package fable.python.jep;

import fable.framework.logging.FableLogger;
import fable.python.jep.FableJep;
import java.io.File;
import jep.JepException;

public class PythonInfo {
    private static final String[] checkCommands = new String[]{"import matplotlib", "import numpy", "import numpy.oldnumeric", "import PIL", "import OpenGL", "import OpenGL.Tk", "from OpenGL import Tk", "import FitAllB", "import Fabric", "from ImageD11 import peaksearcher", "import fabio.openimage", "import polyxsim"};

    public static String getPythonInfo() {
        String info = "";
        info = String.valueOf(info) + "Python: \n";
        info = String.valueOf(info) + "  prefix: " + PythonInfo.getPythonSysValue("  ", "prefix") + "\n";
        info = String.valueOf(info) + "  exec_prefix: " + PythonInfo.getPythonSysValue("  ", "exec_prefix") + "\n";
        info = String.valueOf(info) + "  version: " + PythonInfo.getPythonSysValue("  ", "version") + "\n";
        info = String.valueOf(info) + "\n";
        info = String.valueOf(info) + "PYTHONPATH from Environment:\n";
        info = String.valueOf(info) + PythonInfo.getPythonPathFromEnvironment("  ");
        info = String.valueOf(info) + "\n";
        info = String.valueOf(info) + "PYTHONPATH from Python:\n";
        info = String.valueOf(info) + PythonInfo.getPythonPathFromPython("  ");
        info = String.valueOf(info) + "\n";
        info = String.valueOf(info) + "PATH:\n";
        info = String.valueOf(info) + PythonInfo.getPathFromEnvironment("  ");
        String[] stringArray = checkCommands;
        int n = checkCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            info = String.valueOf(info) + "\n";
            info = String.valueOf(info) + "Check '" + cmd + "':\n";
            info = String.valueOf(info) + "  " + (PythonInfo.checkCommand(cmd) != false ? "Succeeded" : "Failed") + "\n";
            ++n2;
        }
        return info;
    }

    public static String getPythonSysValue(String linePrefix, String var) {
        String info = "";
        FableJep jep = null;
        try {
            try {
                jep = new FableJep();
                info = String.valueOf(linePrefix) + (String)jep.getValue("sys." + var);
            }
            catch (JepException ex) {
                info = String.valueOf(info) + linePrefix + "Error running Jep:\n\n" + linePrefix + ex.getMessage();
                if (jep != null) {
                    jep.close();
                }
            }
        }
        finally {
            if (jep != null) {
                jep.close();
            }
        }
        return info;
    }

    public static String getPythonPathFromEnvironment() {
        return PythonInfo.getPythonPathFromEnvironment("");
    }

    public static String getPythonPathFromEnvironment(String linePrefix) {
        String info = "";
        String path = System.getenv("PYTHONPATH");
        if (path != null) {
            String[] elements;
            String[] stringArray = elements = path.split(File.pathSeparator);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                info = String.valueOf(info) + linePrefix + element + "\n";
                ++n2;
            }
        } else {
            info = String.valueOf(info) + linePrefix + "Not Found" + "\n";
        }
        return info;
    }

    public static String getPathFromEnvironment() {
        return PythonInfo.getPathFromEnvironment("");
    }

    public static String getPathFromEnvironment(String linePrefix) {
        String info = "";
        String path = System.getenv("PATH");
        if (path != null) {
            String[] elements;
            String[] stringArray = elements = path.split(File.pathSeparator);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                info = String.valueOf(info) + linePrefix + element + "\n";
                ++n2;
            }
        } else {
            info = String.valueOf(info) + linePrefix + "Not Found" + "\n";
        }
        return info;
    }

    public static String getPythonPathFromPython() {
        return PythonInfo.getPythonPathFromEnvironment("");
    }

    private static String getPythonPathFromPython(String linePrefix) {
        String info;
        block8: {
            info = "";
            FableJep jep = null;
            try {
                try {
                    jep = new FableJep();
                    jep.eval("import sys");
                    jep.set("linePrefix", linePrefix);
                    jep.set("delimiter", "\n" + linePrefix);
                    info = (String)jep.getValue("linePrefix + delimiter.join(sys.path)");
                }
                catch (JepException ex) {
                    info = String.valueOf(info) + linePrefix + "Error running Jep:\n\n" + linePrefix + ex.getMessage();
                    if (jep != null) {
                        jep.close();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (jep != null) {
                    jep.close();
                }
                throw throwable;
            }
            if (jep != null) {
                jep.close();
            }
        }
        return String.valueOf(info) + "\n";
    }

    private static Boolean checkCommand(String cmd) {
        Boolean retVal = true;
        FableJep jep = null;
        try {
            try {
                jep = new FableJep();
                jep.eval(cmd);
            }
            catch (JepException ex) {
                FableLogger.error((Object)("Checking Python command \"" + cmd + "\" failed: " + ex.getMessage()));
                retVal = false;
                if (jep != null) {
                    jep.close();
                }
            }
        }
        finally {
            if (jep != null) {
                jep.close();
            }
        }
        return retVal;
    }
}

