/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.toolbox.SWTUtils;
import fable.framework.ui.rcp.Activator;
import fable.python.ColumnFile;
import java.io.File;
import jep.JepException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ColumnFileEditorInput
implements IEditorInput {
    private String fileName;
    private ColumnFile columnFile;
    private ImageDescriptor image = Activator.getImageDescriptor("images/colfile_open.jpg");

    public ColumnFileEditorInput() {
    }

    public ColumnFileEditorInput(final String file) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnFileEditorInput.this.columnFile = new ColumnFile(file);
                    ColumnFileEditorInput.this.fileName = file;
                }
                catch (JepException e) {
                    SWTUtils.errMsgAsync((String)("Error in ColumnFileEditorInput " + e.getMessage()));
                }
            }
        });
    }

    public ColumnFile getColumn() {
        return this.columnFile;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public String getName() {
        return this.fileName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fileName;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnFileEditorInput otherInput = (ColumnFileEditorInput)obj;
        return !(this.fileName == null ? otherInput.fileName != null : !this.fileName.equals(otherInput.fileName));
    }

    public void save() {
        this.columnFile.saveColumnFile(this.columnFile.getFileName());
    }

    public boolean saveAs() {
        FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] filterExt = new String[]{"*.flt", "*.*"};
        String[] filterNames = new String[]{"filtered files (*.flt)", "All Files (*.*)"};
        fileDlg.setFilterExtensions(filterExt);
        fileDlg.setFilterNames(filterNames);
        fileDlg.setText("Save file");
        String file = fileDlg.open();
        if (file != null) {
            file = String.valueOf(fileDlg.getFilterPath()) + File.separatorChar + fileDlg.getFileName();
            this.columnFile.saveColumnFile(file);
            this.fileName = file;
            return true;
        }
        return false;
    }
}

