/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.Activator;
import fable.fitallb.editors.FitAllB;
import fable.fitallb.event.FitAllBEvent;
import fable.fitallb.internal.IVarKeys;
import fable.fitallb.listeners.IFitAllBEventListener;
import fable.fitallb.wizard.IInputPage;
import fable.fitallb.wizard.InputWizard;
import fable.framework.toolbox.TypedText;
import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FitPage
extends WizardPage
implements IInputPage {
    private Button wfit;
    private Button wfix;
    private Button tiltFit;
    private Button tiltFix;
    private Button pixelFit;
    private Button pixelFix;
    private Button centerFit;
    private Button centerFix;
    private Button LFit;
    private Button LFix;
    private Text cycle;
    private Button xyzFit;
    private Button xyzFix;
    private Button rodFit;
    private Button rodFix;
    private Button epsFit;
    private Button epsFix;
    private Button near_xyzFit;
    private Button near_xyzFix;
    private Button near_rodFit;
    private Button near_rodFix;
    private Text tol_grain;
    private Text tol_rotpos;
    private Text tol_global;
    private FitAllB fitAllB;
    private Group grpGlobal;
    private FitallbListener fitallbListener;
    private Group grpParameters2;
    private int textlimit = 180;
    final String YES = "1";
    final String NO = "0";
    private Button near_epsFix;
    private Button near_epsFit;

    protected FitPage(String pageName, FitAllB fit) {
        super(pageName);
        this.setTitle("Fit");
        this.setDescription("Fit");
        this.fitAllB = fit;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.createGroupGlobal(container);
        this.createGrainParameters(container);
        this.createGrainParameters2(container);
        this.createGroupTolerances(container);
        this.setData();
        this.setControl((Control)container);
        this.init(container);
        this.setToolTipText();
        this.dialogChanged();
    }

    private void setToolTipText() {
        this.wfit.setToolTipText("w: fit omega stage tilt parameter wy ");
        this.wfix.setToolTipText("w: do not fit omega stage tilt parameter wy ");
        this.tiltFit.setToolTipText("tilt: fit detector tilt parameters tx, ty, tx");
        this.tiltFix.setToolTipText("tilt: do not fit detector tilt parameters tx, ty, tx");
        this.pixelFit.setToolTipText("pixel: fit pixel size py and pz ");
        this.pixelFix.setToolTipText("pixel: do not fit pixel size py and pz ");
        this.centerFit.setToolTipText("center: fit detector centre along y-axis, cy");
        this.centerFix.setToolTipText("center: do not fit detector centre along y-axis, cy");
        this.LFit.setToolTipText("L: fit sample-to-detector distance ");
        this.LFix.setToolTipText("L: do not fit sample-to-detector distance ");
        this.cycle.setToolTipText("cycle: specified number of refinement cycles");
        this.xyzFit.setToolTipText("xyz: refine positions");
        this.xyzFix.setToolTipText("xyz: do not refine positions");
        this.rodFit.setToolTipText("rod: refine orientations");
        this.rodFix.setToolTipText("rod: refine orientations");
        this.epsFit.setToolTipText("eps: refine strains");
        this.epsFix.setToolTipText("eps: do not refine strains, use undeformed material");
        this.near_rodFit.setToolTipText("near_rod: fit orientations in Rodrigues representation for near-field data");
        this.near_rodFix.setToolTipText("near_rod: do not fit orientations in Rodrigues representation for near-field data");
        this.near_epsFit.setToolTipText("near_eps: fit strain tensors for near-field data");
        this.near_epsFix.setToolTipText("near_eps: do not fit strain tensors for near-field data");
        this.near_xyzFit.setToolTipText("near_xyz: fit grain positions for near-field data");
        this.near_xyzFix.setToolTipText("near_xyz: do not fit grain positions for near-field data");
        this.tol_grain.setToolTipText("tol_rotpos: tolerance for grain refinement");
        this.tol_rotpos.setToolTipText("tol_rotpos: tolerance for orientation and position refinement");
        this.tol_global.setToolTipText("tol_global: tolerance for global parameter refinement");
    }

    private void init(Composite container) {
        this.fitAllB = ((InputWizard)this.getWizard()).getFitAllB();
        this.fitallbListener = new FitallbListener();
        this.fitAllB.addFitallbListener(this.fitallbListener);
        this.showSecondDetectorParameters(this.fitAllB.getNumberOfDetectors() == 2);
        this.enableGroupGlobal((Composite)this.grpGlobal, !this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB));
        this.initialize(container);
    }

    private void createGroupTolerances(Composite container) {
        Group grpTolerances = new Group(container, 16);
        GridLayout layout = new GridLayout(2, false);
        grpTolerances.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        grpTolerances.setLayoutData((Object)gd);
        grpTolerances.setText("Tolerances");
        Label label = new Label((Composite)grpTolerances, 0);
        label.setText("Tolerances for:");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)grpTolerances, 0);
        label.setText("Grain Refinement:");
        gd = new GridData(2);
        this.tol_grain = new Text((Composite)grpTolerances, 2048);
        this.tol_grain.setLayoutData((Object)gd);
        gd.widthHint = this.textlimit;
        label = new Label((Composite)grpTolerances, 0);
        label.setText("Orientation And Position Refinement:");
        gd = new GridData(2);
        this.tol_rotpos = new Text((Composite)grpTolerances, 2048);
        this.tol_rotpos.setLayoutData((Object)gd);
        gd.widthHint = this.textlimit;
        label = new Label((Composite)grpTolerances, 0);
        label.setText("Global Parameters Refinement:");
        gd = new GridData(2);
        this.tol_global = new Text((Composite)grpTolerances, 2048);
        this.tol_global.setLayoutData((Object)gd);
        gd.widthHint = this.textlimit;
    }

    private void createGrainParameters(Composite container) {
        Group grpParameters = new Group(container, 16);
        GridLayout layout = new GridLayout(1, true);
        grpParameters.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        grpParameters.setLayoutData((Object)gd);
        Composite composite = new Composite((Composite)grpParameters, 0);
        FillLayout fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        grpParameters.setText("Grain Parameters, First Detector (Far-Field");
        Label label = new Label(composite, 0);
        label.setText("Grain position For Far-Field Data:");
        this.xyzFit = new Button(composite, 16);
        this.xyzFit.setText("Fit");
        this.xyzFix = new Button(composite, 16);
        this.xyzFix.setText("Fix");
        composite = new Composite((Composite)grpParameters, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Orientations In Rodrigues Representatin For Far-Field Data:");
        this.rodFit = new Button(composite, 16);
        this.rodFit.setText("Fit");
        this.rodFix = new Button(composite, 16);
        this.rodFix.setText("Fix");
        composite = new Composite((Composite)grpParameters, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Strain Tensors:");
        this.epsFit = new Button(composite, 16);
        this.epsFit.setText("Fit");
        this.epsFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.epsFix = new Button(composite, 16);
        this.epsFix.setText("Fix");
        this.epsFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
    }

    private void createGrainParameters2(Composite container) {
        this.grpParameters2 = new Group(container, 16);
        GridLayout layout = new GridLayout(1, true);
        this.grpParameters2.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.grpParameters2.setLayoutData((Object)gd);
        this.grpParameters2.setText("Grain Parameters, Second Detector (Near-Field)");
        Composite composite = new Composite((Composite)this.grpParameters2, 0);
        FillLayout fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText("Grain position For Near-Field Data:");
        this.near_xyzFit = new Button(composite, 16);
        this.near_xyzFit.setText("Fit");
        this.near_xyzFix = new Button(composite, 16);
        this.near_xyzFix.setText("Fix");
        composite = new Composite((Composite)this.grpParameters2, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Orientations In Rodrigues Representatin For Near-Field Data:");
        this.near_rodFit = new Button(composite, 16);
        this.near_rodFit.setText("Fit");
        this.near_rodFix = new Button(composite, 16);
        this.near_rodFix.setText("Fix");
        composite = new Composite((Composite)this.grpParameters2, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Strain Tensors for Near-Field Data:");
        this.near_epsFit = new Button(composite, 16);
        this.near_epsFit.setText("Fit");
        this.near_epsFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.near_epsFix = new Button(composite, 16);
        this.near_epsFix.setText("Fix");
        this.near_epsFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
    }

    private void createGroupGlobal(Composite container) {
        this.grpGlobal = new Group(container, 16);
        GridLayout layout = new GridLayout(1, true);
        this.grpGlobal.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.grpGlobal.setLayoutData((Object)gd);
        this.grpGlobal.setText("Global Parameters");
        Composite composite = new Composite((Composite)this.grpGlobal, 0);
        FillLayout fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText("Omega:");
        this.wfit = new Button(composite, 16);
        this.wfit.setText("Fit");
        this.wfit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.wfix = new Button(composite, 16);
        this.wfix.setText("Fix");
        this.wfix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        composite = new Composite((Composite)this.grpGlobal, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Tilt:");
        this.tiltFit = new Button(composite, 16);
        this.tiltFit.setText("Fit");
        this.tiltFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.tiltFix = new Button(composite, 16);
        this.tiltFix.setText("Fix");
        this.tiltFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        composite = new Composite((Composite)this.grpGlobal, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Pixel:");
        this.pixelFit = new Button(composite, 16);
        this.pixelFit.setText("Fit");
        this.pixelFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.pixelFix = new Button(composite, 16);
        this.pixelFix.setText("Fix");
        this.pixelFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        composite = new Composite((Composite)this.grpGlobal, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Center:");
        this.centerFit = new Button(composite, 16);
        this.centerFit.setText("Fit");
        this.centerFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.centerFix = new Button(composite, 16);
        this.centerFix.setText("Fix");
        this.centerFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        composite = new Composite((Composite)this.grpGlobal, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("L:");
        this.LFit = new Button(composite, 16);
        this.LFit.setText("Fit");
        this.LFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        this.LFix = new Button(composite, 16);
        this.LFix.setText("Fix");
        this.LFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitPage.this.dialogChanged();
            }
        });
        composite = new Composite((Composite)this.grpGlobal, 0);
        GridLayout gdlayout = new GridLayout(2, false);
        composite.setLayout((Layout)gdlayout);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("Cycle:");
        this.cycle = new Text(composite, 2048);
        gd = new GridData(2);
        this.cycle.setLayoutData((Object)gd);
        gd.widthHint = this.textlimit;
    }

    private void setData() {
        this.wfit.setData("w", (Object)"1");
        this.wfix.setData("w", (Object)"0");
        this.tiltFit.setData("tilt", (Object)"1");
        this.tiltFix.setData("tilt", (Object)"0");
        this.wfit.setData((Object)"w");
        this.wfix.setData((Object)"w");
        this.tiltFit.setData((Object)"tilt");
        this.tiltFix.setData((Object)"tilt");
        this.pixelFit.setData("pixel", (Object)"1");
        this.pixelFix.setData("pixel", (Object)"0");
        this.centerFit.setData("center", (Object)"1");
        this.centerFix.setData("center", (Object)"0");
        this.LFit.setData("L", (Object)"1");
        this.LFix.setData("L", (Object)"0");
        this.pixelFit.setData((Object)"pixel");
        this.pixelFix.setData((Object)"pixel");
        this.centerFit.setData((Object)"center");
        this.centerFix.setData((Object)"center");
        this.LFit.setData((Object)"L");
        this.LFix.setData((Object)"L");
        this.cycle.setData((Object)"cycle");
        this.xyzFit.setData("xyz", (Object)"1");
        this.xyzFix.setData("xyz", (Object)"0");
        this.rodFit.setData("rod", (Object)"1");
        this.rodFix.setData("rod", (Object)"0");
        this.epsFit.setData("eps", (Object)"1");
        this.epsFix.setData("eps", (Object)"0");
        this.near_rodFit.setData("near_rod", (Object)"1");
        this.near_rodFix.setData("near_rod", (Object)"0");
        this.near_xyzFit.setData("near_xyz", (Object)"1");
        this.near_xyzFix.setData("near_xyz", (Object)"0");
        this.near_epsFit.setData("near_eps", (Object)"1");
        this.near_epsFix.setData("near_eps", (Object)"0");
        this.xyzFit.setData((Object)"xyz");
        this.xyzFix.setData((Object)"xyz");
        this.rodFit.setData((Object)"rod");
        this.rodFix.setData((Object)"rod");
        this.epsFit.setData((Object)"eps");
        this.epsFix.setData((Object)"eps");
        this.near_rodFit.setData((Object)"near_rod");
        this.near_rodFix.setData((Object)"near_rod");
        this.near_xyzFit.setData((Object)"near_xyz");
        this.near_xyzFix.setData((Object)"near_xyz");
        this.near_epsFit.setData((Object)"near_eps");
        this.near_epsFix.setData((Object)"near_eps");
        this.tol_grain.setData((Object)"tol_grain");
        this.tol_rotpos.setData((Object)"tol_rotpos");
        this.tol_global.setData((Object)"tol_global");
    }

    private void dialogChanged() {
        boolean modeFitAllB = this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB);
        if (!modeFitAllB && this.epsFit.getSelection()) {
            this.updateStatus("Strain tensor for an input file for fitgloball or fitglobalgrain should be set to fix.");
            return;
        }
        if (!modeFitAllB && !this.isGlobalParameterSetToFit((Composite)this.grpGlobal, false)) {
            this.updateStatus("At least one Global Parameters must be set to fit.");
            return;
        }
        this.updateStatus(null);
    }

    private boolean isGlobalParameterSetToFit(Composite container, boolean fitFound) {
        Control[] children = container.getChildren();
        boolean foundOneFit = fitFound;
        int i = 0;
        while (i < children.length && !foundOneFit) {
            String fit;
            String name;
            Button button;
            if (children[i] instanceof Composite) {
                foundOneFit = this.isGlobalParameterSetToFit((Composite)children[i], foundOneFit);
            } else if (children[i] instanceof Button && ((button = (Button)children[i]).getStyle() & 0x10) != 0 && (name = (String)button.getData()) != null && (fit = (String)button.getData(name)).equals("1")) {
                foundOneFit = button.getSelection();
            }
            ++i;
        }
        return foundOneFit;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void initialize(Composite container) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            String key;
            if (children[i] instanceof Button) {
                Button child = (Button)children[i];
                if ((child.getStyle() & 0x10) != 0 && (key = (String)child.getData()) != null) {
                    int preferredValue = preferences.getInt(key);
                    String value = (String)child.getData(key);
                    if (value != null) {
                        child.setSelection(value.equals(String.valueOf(preferredValue)));
                    }
                }
            } else if (children[i] instanceof Text) {
                String preferredValue;
                Text text = (Text)children[i];
                key = (String)text.getData();
                if (key != null && (preferredValue = preferences.getString(key)) != null) {
                    text.setText(preferredValue);
                }
            } else if (children[i] instanceof Group) {
                this.initialize((Composite)((Group)children[i]));
            } else if (children[i] instanceof Composite && !(children[i] instanceof TypedText)) {
                this.initialize((Composite)children[i]);
            }
            ++i;
        }
        if (this.fitAllB != null && !this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB)) {
            this.epsFix.setSelection(true);
            this.epsFit.setSelection(false);
        }
    }

    private void enableGroupGlobal(Composite composite, boolean enabled) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button) {
                ((Button)child).setEnabled(enabled);
            } else if (child instanceof Text) {
                ((Text)child).setEnabled(enabled);
            } else if (child instanceof Composite) {
                this.enableGroupGlobal((Composite)child, enabled);
            }
            ++n2;
        }
    }

    public void showSecondDetectorParameters(boolean show) {
        this.grpParameters2.setVisible(show);
        GridData data = (GridData)this.grpParameters2.getLayoutData();
        data.exclude = !show;
        Composite parent = this.grpParameters2.getParent();
        if (parent != null) {
            parent.layout(false);
        }
    }

    public void dispose() {
        this.fitAllB.removeFitallbListener(this.fitallbListener);
    }

    public boolean getWfit() {
        return this.wfit.getSelection();
    }

    public boolean getWfix() {
        return this.wfix.getSelection();
    }

    public boolean getTiltFit() {
        return this.tiltFit.getSelection();
    }

    public boolean getTiltFix() {
        return this.tiltFix.getSelection();
    }

    public boolean getPixelFit() {
        return this.pixelFit.getSelection();
    }

    public boolean getPixelFix() {
        return this.pixelFix.getSelection();
    }

    public boolean getCenterFit() {
        return this.centerFit.getSelection();
    }

    public boolean getCenterFix() {
        return this.centerFix.getSelection();
    }

    public boolean getLFit() {
        return this.LFit.getSelection();
    }

    public boolean getLFix() {
        return this.LFix.getSelection();
    }

    public boolean getXyzFit() {
        return this.xyzFit.getSelection();
    }

    public boolean getXyzFix() {
        return this.xyzFix.getSelection();
    }

    public boolean getRodFit() {
        return this.rodFit.getSelection();
    }

    public boolean getRodFix() {
        return this.rodFix.getSelection();
    }

    public boolean getEpsFit() {
        return this.epsFit.getSelection();
    }

    public boolean getNear_EpsFit() {
        return this.near_epsFit.getSelection();
    }

    public boolean getEpsFix() {
        return this.epsFix.getSelection();
    }

    public boolean getNear_EpsFix() {
        return this.near_epsFix.getSelection();
    }

    public boolean getNear_xyzFit() {
        return this.near_xyzFit.getSelection();
    }

    public boolean getNear_xyzFix() {
        return this.near_xyzFix.getSelection();
    }

    public boolean getNear_rodFit() {
        return this.near_rodFit.getSelection();
    }

    public boolean getNear_rodFix() {
        return this.near_rodFix.getSelection();
    }

    public String getTol_grain() {
        return this.tol_grain.getText();
    }

    public String getTol_rotpos() {
        return this.tol_rotpos.getText();
    }

    public String getTol_global() {
        return this.tol_global.getText();
    }

    public String getCycle() {
        return this.cycle.getText();
    }

    @Override
    public void writePage(BufferedWriter writer) throws IOException {
        writer.write("#Fit parameters");
        writer.newLine();
        if (!this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB)) {
            writer.write("w " + (this.getWfit() ? "1" : "0"));
            writer.newLine();
            writer.write("tilt " + (this.getTiltFit() ? "1" : "0"));
            writer.newLine();
            writer.write("pixel " + (this.getPixelFit() ? "1" : "0"));
            writer.newLine();
            writer.write("center " + (this.getCenterFit() ? "1" : "0"));
            writer.newLine();
            writer.write("L " + (this.getLFit() ? "1" : "0"));
            writer.newLine();
            if (this.getCycle() != null && this.getCycle().trim().length() > 0) {
                writer.write("cycle " + this.getCycle());
                writer.newLine();
            }
        }
        writer.write("xyz " + (this.getXyzFit() ? "1" : "0"));
        writer.newLine();
        writer.write("rod " + (this.getRodFit() ? "1" : "0"));
        writer.newLine();
        writer.write("eps " + (this.getEpsFit() ? "1" : "0"));
        writer.newLine();
        if (this.fitAllB.getNumberOfDetectors() == 2) {
            writer.write("near_xyz " + (this.getNear_xyzFit() ? "1" : "0"));
            writer.newLine();
            writer.write("near_rod " + (this.getNear_rodFit() ? "1" : "0"));
            writer.newLine();
            writer.write("near_eps " + (this.getNear_EpsFit() ? "1" : "0"));
            writer.newLine();
        }
        if (this.getTol_grain() != null && this.getTol_grain().trim().length() > 0) {
            writer.write("tol_grain " + this.getTol_grain());
            writer.newLine();
        }
        if (this.getTol_rotpos() != null && this.getTol_rotpos().trim().length() > 0) {
            writer.write("tol_rotpos " + this.getTol_rotpos());
            writer.newLine();
        }
        if (this.getTol_global() != null && this.getTol_global().trim().length() > 0) {
            writer.write("tol_global " + this.getTol_global());
            writer.newLine();
        }
    }

    class FitallbListener
    implements IFitAllBEventListener {
        FitallbListener() {
        }

        @Override
        public void updateInputFileEvent(FitAllBEvent event) {
            FitPage.this.enableGroupGlobal((Composite)FitPage.this.grpGlobal, !FitPage.this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB));
            if (!FitPage.this.fitAllB.getProgram().equals(IVarKeys.MODE_FITALLB)) {
                FitPage.this.epsFix.setSelection(true);
                FitPage.this.epsFit.setSelection(false);
            }
            FitPage.this.dialogChanged();
        }

        @Override
        public void updateNumberOfDetectors(FitAllBEvent event) {
            FitPage.this.showSecondDetectorParameters(FitPage.this.fitAllB.getNumberOfDetectors() == 2);
        }

        @Override
        public void updateCurrentDirectory(FitAllBEvent event) {
        }
    }
}

