package fable;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

import fable.framework.ui.internal.IVarKeys;
import fable.framework.ui.internal.MainMenuBar;
import fable.framework.ui.internal.MainStatusBar;

/**
 * An action bar advisor is responsible for creating, adding, and disposing of
 * the actions added to a workbench window. Each window will be populated with
 * new actions.
 */
public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

	/** Main fable menu bar. */
	private MainMenuBar fableMainMenu;
	/** Introduction action added to help menu to launch welcome page. */
	private IWorkbenchAction introAction;
	/**
	 * A fable status bar. Used for example in preprocessor to display on/off
	 * line mode.<BR>
	 * To get this status line, call
	 * <code>(MainStatusBar)getViewSite().getActionBars().getStatusLineManager().find(IVarKeys.MAIN_STATUS_LINE);</code>
	 */
	private MainStatusBar fabMainStatusBar;

	/**
	 * 
	 * @param configurer
	 */
	public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
		super(configurer);
		fableMainMenu = new MainMenuBar(configurer);
	}

	/**
	 * @param window
	 *            IWorkbench window for this bundle
	 */
	protected void makeActions(final IWorkbenchWindow window) {
		fableMainMenu.makeActions(window);
		introAction = ActionFactory.INTRO.create(window);
		register(introAction);
		fabMainStatusBar = new MainStatusBar(IVarKeys.MAIN_STATUS_LINE, 30);

	}

	/**
	 * @param menuBar
	 *            menu bar for this window
	 */
	protected void fillMenuBar(IMenuManager menuBar) {
		fableMainMenu.fillMenuBar(menuBar);

		fableMainMenu.helpMenu.insert(0, new Separator());
		fableMainMenu.helpMenu.insert(0,
				new ActionContributionItem(introAction));

	}

	@Override
	protected void fillStatusLine(IStatusLineManager statusLine) {
		statusLine.add(fabMainStatusBar);
	}

	@Override
	protected void fillCoolBar(ICoolBarManager coolBar) {
		fableMainMenu.fillCoolBar(coolBar);
	}
}
