import sys
from Fabric import check_input
from Fabric import find_refl
from Fabric import harvest_refl


def get_options(parser):
    parser.add_option("-i", "--input", action="store",
                      dest="filename", type="string",
                      help="Name of the file containing the input parameters")
    parser.add_option("-d", "--debug", action="store_true",
                      dest="debug",default =False,
                      help="Run in debug mode")
    parser.add_option("-u", "--make-uvmap", action="store_true",
                      dest="make_uvmap",default =False,
                      help="Make uv-maps")
    options, args = parser.parse_args()

    return options

def run_fabric(options):
    if options.filename == None:
        raise ValueError, "\nNo input file supplied [-i filename]\n"

    # Read and check input
    myinput = check_input.parse_input(input_file=options.filename) 
    myinput.read()                                # read input file
    myinput.check()                               # check validity of input
    if myinput.missing == True:                   # if problem exit
        raise ValueError('MISSING ITEMS STOPPING')

    myinput.initialize()                      # if ok initialize

    import time
    # Determine the reflection parameters for grains
    graindata = find_refl.find_refl(myinput.entries)
    graindata.run()
    if myinput.entries['overlap_test'] == True: 
        t1 = time.clock()
#        graindata.overlap()
        graindata.overlap_new()
        print time.clock()-t1

    graindata.save()

    harvest = harvest_refl.harvest_refl(myinput.entries,graindata.grain,myinput.frameinfo)
    harvest.frameinfo()
    harvest.run()
