/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.editors;

import fable.framework.internal.ICrystalSymmetryVarKeys;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.ui.dialog.CrystalSymmetryDialog;
import fable.framework.ui.views.JmolView;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.actions.RunAction;
import fable.polyxsim.event.PolyxsimEvent;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import fable.polyxsim.internal.PolyXSimException;
import fable.polyxsim.listener.IPolyxsimEventListener;
import fable.polyxsim.views.PolyXSimInputView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import jep.JepException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class InputEditor
extends EditorPart
implements IResourceChangeListener,
IPropertyChangeListener {
    private static final int GEN_SIZE_EACH_GRAIN = 3;
    private boolean dirty;
    public static int ANSWER_YES = 0;
    public static int ANSWER_CANCEL = 1;
    private DropTargetListener dropTargetPathListener;
    private DropTargetListener dropTargetStemListener;
    private DropTargetListener dropTargetFileListener;
    public static final String ID = "fable.polyxsim.editors.InputEditor";
    public static final String EDITOR_CONTEXT = "fable.polyxsim.editors.InputEditor.context";
    private Composite parent;
    private FloatText wavelength;
    private FloatText beamflux;
    private FloatText beampol_factor;
    private FloatText beampol_direct;
    private FloatText detz_center;
    private FloatText dety_center;
    private FloatText z_size;
    private FloatText y_size;
    private FloatText dety_size;
    private FloatText detz_size;
    private FloatText distance;
    private FloatText tilt_x;
    private FloatText tilt_y;
    private FloatText tilt_z;
    private Combo omega_sign;
    private FloatText wedge;
    private FloatText omega_start;
    private FloatText omega_end;
    private FloatText omega_step;
    private IntegerText no_grains;
    private FloatText[] gen_size_phase_x;
    private FloatText[] gen_size_phase_x_min;
    private FloatText[] gen_size_phase_x_max;
    private FloatText gen_size_median;
    private FloatText gen_size_min;
    private FloatText gen_size_max;
    private Button gen_U;
    private Combo gen_pos;
    private StringText pos_grains;
    private FloatText sample_xyz_X;
    private FloatText sample_xyz_Y;
    private FloatText sample_xyz_Z;
    private FloatText[] unit_cell_phase_a;
    private FloatText[] unit_cell_phase_b;
    private FloatText[] unit_cell_phase_c;
    private FloatText[] unit_cell_phase_alpha;
    private FloatText[] unit_cell_phase_beta;
    private FloatText[] unit_cell_phase_gamma;
    private IntegerText[] sgno_phase;
    private Button[] unitCellSpaceGroupHelpBtn;
    private StringText[] structure_phase = null;
    private Button[] structureFileViewButton = null;
    private Button imageFlagButton;
    private StringText imageStemFileText;
    private Combo fileFormatCombo;
    private Button noise;
    private FloatText bg;
    private Button psfButton;
    private FloatText psf;
    private Button outputFltButton;
    private Button outputGveButton;
    private Button outputUbiButton;
    private Button outputParButton;
    Group sampleBoxGroup;
    Group sampleCylinderGroup;
    public Text inputFileText;
    private TabFolder tabFolder;
    private TabItem[] tabItem = new TabItem[6];
    private static Composite[] container = new Composite[6];
    private ScrolledComposite[] scrolledComposite = new ScrolledComposite[6];
    GridLayout gridLayout;
    private Combo intensityCombo;
    FloatText intensityConstantFloatText;
    private Button lorentzFactorButton;
    private Button polarisationButton;
    private Combo peakTypeCombo;
    private FloatText gaussianPeakPixelsFloatText;
    private FloatText gaussianPeakDegreesFloatText;
    private Combo odfTypeCombo;
    private StringText odfFile;
    private Button odfFileBrowseButton;
    private FloatText mosaicity;
    private FloatText sample_cyl_height;
    private FloatText sample_cyl_diameter;
    private String[] structureFiles = null;
    private Float[] unitCell = null;
    private Button addPhaseButton;
    private Button deletePhaseButton;
    private Group grainSizeGroup;
    private Group genEpsGroup;
    private Combo sampleShapeCombo;
    private Combo[] phaseDistributionCombo = null;
    private IntegerText no_phases;
    private int numPhases = 1;
    private Group structureFileGroup;
    private Group unitCellGroup;
    private Button structureFileButton;
    private Button structureCellButton;
    private String inputFileDirectory;
    private Button[] structureFileBrowseButton;
    private IntegerText[] no_grains_phase_Y;
    private Label[] phaseLabel = null;
    private Label[] phaseAndGrainsLabel = null;
    private Label[] phaseLabelEps = null;
    private Label[] phaseLabelMeanDiagEps = null;
    private Label[] phaseLabelMeanOffDiagEps = null;
    private Label[] phaseLabelSpreadDiagEps = null;
    private Label[] phaseLabelSpreadOffEps = null;
    private Integer[] phaseGrains = null;
    private Integer[] phases = null;
    private Float[] phaseGrainSize = null;
    private Float[] phaseGrainMinSize = null;
    private Float[] phaseGrainMaxSize = null;
    static final int FILES_TAB = 0;
    static final int CRYSTAL_TAB = 1;
    static final int SAMPLE_TAB = 2;
    static final int REFLECTIONS_TAB = 3;
    static final int INSTRUMENTAL_TAB = 4;
    static final int DETECTOR_TAB = 5;
    private RunAction runAction;
    private Combo spaceGroupTypeCombo;
    private int spaceGroupType = 0;
    private Combo spaceGroupCombo;
    private int spaceGroup = 1;
    private Spinner spaceGroupSpinner;
    private Image helpImg;
    private Combo orientCombo;
    private static int idxOrientation = 0;
    private static String[] orientNames = new String[]{"-1 0 0 -1", "-1 0 0 1", "1 0 0 -1", "1 0 0 1", "0 -1 1 0", "0 1 -1 0", "0 -1 -1 0", "0 1 1 0"};
    private static int[][] orientParams;
    final Color light_grey = new Color((Device)Display.getCurrent(), 205, 192, 176);
    private PolyXSim polyXSim = null;
    private PolyxsimListener polyxsimListener;
    private StringText spatial;
    private Button addBckgrdButton;
    private Button spatialDistortionButton;
    private IEditorInput input;
    private StringText u_grains;
    private StringText direc;
    private ArrayList<String> requiredKeys;
    private Composite activeComposite;
    private Composite currentComposite;
    private Combo gen_eps;
    private FloatText gen_eps_meanDiag;
    private FloatText gen_eps_spreadDiag;
    private FloatText gen_eps_meanOffDiag;
    private FloatText gen_eps_spreadOffDiag;
    private StringText eps_grains;
    private FloatText[] gen_eps_meanDiag_Y;
    private FloatText[] gen_eps_spreadDiag_Y;
    private FloatText[] gen_eps_spreadoffDiag_Y;
    private FloatText[] gen_eps_meanoffDiag_Y;
    private Group grpEps;
    private FloatText beam_width;
    private Group grpEpsGroupAll;
    private Group grpEps_grains;
    private Button[] gen_eps_random;
    private Button gen_phase_flag;
    private Group gaussianPeakGroup;
    private Group odfPeakGroup;
    private Group grainAndPhaseGroup;
    private StringText size_grains;
    private Group grpSizeAll;
    private Group grpSizeForEachPhase;
    private Button[] gen_size_phase_flag;
    private Combo gen_size;
    public static final String spaceGroupDesc = "spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in PolyXSim";
    private static final String CYLINDER = "cylinder";
    private static final String BOX = "box";
    private static final int textlimit = 30;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[3] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = -1;
        nArray2[3] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[3] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[3] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = -1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[1] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[1] = -1;
        nArray7[2] = -1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArrayArray[7] = nArray8;
        orientParams = nArrayArray;
    }

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
        IPath path = SWTUtils.getPath((IEditorInput)this.input);
        File file = path.toFile();
        this.doFinish(file.getAbsolutePath());
        this.setDirty(false);
        try {
            this.setFileText(this.polyXSim.getInputFile());
        }
        catch (PolyXSimException e) {
            SWTUtils.errMsg((String)e.getMessage());
        }
    }

    public void doSaveAs() {
        FileDialog fileDlg = new FileDialog(new Shell(), 8192);
        fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
        fileDlg.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
        fileDlg.setText("Select a new or an existing Polyxsim input file");
        String file = fileDlg.open();
        if (file != null) {
            FableMessageConsole.console.displayOut("write Polyxsim simulation input file " + file);
            boolean confirm = true;
            if (file != null) {
                if (ToolBox.checkIfFileExists((String)file)) {
                    confirm = FableUtils.confirmMsg((Object)((Object)this), (String)(String.valueOf(file) + " already exists. Do you want to overwrite it?"));
                }
                if (confirm) {
                    this.doFinish(file);
                    this.setDirty(false);
                    File fileobject = new File(file);
                    if (fileobject.exists()) {
                        this.input = SWTUtils.createEditorInput((File)fileobject);
                        this.setInput(this.input);
                        this.updateTitle();
                        try {
                            this.polyXSim.setInputFileDirectory(file);
                            try {
                                this.setFileText(this.polyXSim.getInputFile());
                            }
                            catch (PolyXSimException e) {
                                SWTUtils.errMsg((String)e.getMessage());
                            }
                        }
                        catch (JepException e) {
                            SWTUtils.errMsg((String)e.getMessage());
                        }
                    }
                }
            }
        }
    }

    public void init(IEditorSite site, IEditorInput in) throws PartInitException {
        this.input = in;
        this.setInput(in);
        this.setSite((IWorkbenchPartSite)site);
        IPath path = SWTUtils.getPath((IEditorInput)in);
        File file = path.toFile();
        this.polyxsimListener = new PolyxsimListener();
        this.polyXSim = new PolyXSim();
        this.polyXSim.addPolyXSimListener(this.polyxsimListener);
        this.polyXSim.loadFileInPython(file.getAbsolutePath());
        this.updateTitle();
    }

    protected void updateTitle() {
        IEditorInput input = this.getEditorInput();
        String name = FableUtils.getShortName((String)input.getName());
        name = name == null ? "PolyXSim input file" : name;
        this.setPartName(name);
        this.setTitleToolTip(input.getToolTipText());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public InputEditor() {
        this.dropTargetPathListener = new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    File file;
                    DropTarget target = (DropTarget)event.widget;
                    Text txt = (Text)target.getControl();
                    String[] data = (String[])event.data;
                    if (data.length > 0 && (file = new File(data[0])) != null && file.exists()) {
                        if (file.isDirectory()) {
                            txt.setText(file.getAbsolutePath());
                        } else if (file.isFile()) {
                            String path = file.getParent();
                            txt.setText(path);
                        }
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
        this.dropTargetFileListener = new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    File file;
                    DropTarget target = (DropTarget)event.widget;
                    Text txt = (Text)target.getControl();
                    String[] data = (String[])event.data;
                    if (data.length > 0 && (file = new File(data[0])) != null && file.exists()) {
                        txt.setText(file.getAbsolutePath());
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
        this.dropTargetStemListener = new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    File file;
                    DropTarget target = (DropTarget)event.widget;
                    Text txt = (Text)target.getControl();
                    String[] data = (String[])event.data;
                    if (data.length > 0 && (file = new File(data[0])) != null && file.exists()) {
                        String draggedText = InputEditor.this.getFileStem(file.getName());
                        txt.setText(draggedText);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.requiredKeys = PolyXSim.getRequiredKeysFromPython();
        this.makeActions();
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        this.helpImg = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        this.tabFolder = new TabFolder(parent, 2560);
        this.tabFolder.setLayout((Layout)oneColGridLayout);
        int i = 0;
        while (i < container.length) {
            this.scrolledComposite[i] = new ScrolledComposite((Composite)this.tabFolder, 768);
            InputEditor.container[i] = new Composite((Composite)this.scrolledComposite[i], 20);
            container[i].setLayout((Layout)oneColGridLayout);
            container[i].setLayoutData((Object)new GridData(4, 4, true, true));
            this.scrolledComposite[i].setContent((Control)container[i]);
            this.scrolledComposite[i].setMinSize(800, 500);
            this.scrolledComposite[i].setExpandHorizontal(true);
            this.scrolledComposite[i].setExpandVertical(true);
            ++i;
        }
        i = 0;
        while (i < this.tabItem.length) {
            this.tabItem[i] = new TabItem(this.tabFolder, 20);
            this.tabItem[i].setControl((Control)this.scrolledComposite[i]);
            ++i;
        }
        this.createFileTab();
        this.createCrystalPhasesTab();
        this.createSampleTab();
        this.createReflectionsTab();
        this.createInstrumentalTab();
        this.createDetectorTab();
        this.setHelpContextIDs();
        this.setData();
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        DropTarget target = new DropTarget((Control)this.direc.getTextField(), 17);
        target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
        target.addDropListener(this.dropTargetPathListener);
        target = new DropTarget((Control)this.imageStemFileText.getTextField(), 17);
        target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
        target.addDropListener(this.dropTargetStemListener);
        target = new DropTarget((Control)this.spatial.getTextField(), 17);
        target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
        target.addDropListener(this.dropTargetFileListener);
    }

    private String getFileStem(String file) {
        String fileName;
        String[] fileNameChunks;
        String value = "";
        if (file != null && (fileNameChunks = (fileName = new File(file).getName()).split("_[0-9]n\\.")) != null && fileNameChunks.length > 0) {
            value = fileNameChunks[0];
        }
        return value;
    }

    private void initValues() {
        this.structureCellButton.setSelection(this.polyXSim.getStructureFile(0) == null);
        this.structureFileButton.setSelection(this.polyXSim.getStructureFile(0) != null);
        this.crystalTabShowUnitCellOrStructurePhase();
        String shape = this.sampleShapeCombo.getText();
        this.sampleShapeRules(shape);
        this.u_grains.set_isRequiredField(!this.gen_U.getSelection());
        this.u_grains.setEnabled(!this.gen_U.getSelection());
        this.pos_grains.set_isRequiredField(this.gen_pos.getText().equals("Do not generate"));
        this.pos_grains.setEnabled(this.gen_pos.getText().equals("Do not generate"));
        this.initRequire(this.parent);
        this.enableSpecificGrainStrains();
        this.initepsGrainswithSampleValues();
        this.initUGrainsWithsampleValues();
        this.initPosGrainsWithSampleValues();
        this.enableGaussianOrSpikeType();
        this.gen_size_EnableFields();
        this.gen_phase_setRequirement();
        this.enableGenSizePhase(this.gen_size.getText().equals("Generate at random using different lognormal distributions for each phase"));
        if (this.bg.getText().trim().length() == 0 || this.bg.getText().trim().length() > 0 && this.bg.getText().trim().equals("0")) {
            this.addBckgrdButton.setSelection(false);
        } else {
            this.addBckgrdButton.setSelection(true);
        }
        this.bg.getTextField().setEnabled(this.addBckgrdButton.getSelection());
        this.bg.set_isRequiredField(this.spatialDistortionButton.getSelection());
        if (this.psf.getText().trim().length() == 0 || this.psf.getText().trim().length() > 0 && this.psf.getText().trim().equals("0")) {
            this.psfButton.setSelection(false);
        } else {
            this.psfButton.setSelection(true);
        }
        this.psf.getTextField().setEnabled(this.psfButton.getSelection());
        this.psf.set_isRequiredField(this.spatialDistortionButton.getSelection());
        if (this.spatial.getText().trim().length() == 0 || this.spatial.getText().trim().length() > 0 && this.spatial.getText().trim().equals("0")) {
            this.spatialDistortionButton.setSelection(false);
        } else {
            this.spatialDistortionButton.setSelection(true);
        }
        this.spatial.getTextField().setEnabled(this.spatialDistortionButton.getSelection());
        this.spatial.set_isRequiredField(this.spatialDistortionButton.getSelection());
    }

    private void initepsGrainswithSampleValues() {
        if (this.gen_eps.getText().equals("Provide specific strain tensors for each grain ") && this.eps_grains.getText().trim().length() == 0) {
            this.eps_grains.set_Text("#eps_grains_eps11 eps12 eps13 eps22 eps23 eps33");
            String s = "";
            int i = 0;
            while (i < Integer.valueOf(this.no_grains.getText())) {
                s = String.valueOf(s) + "eps_grains_" + i + " 0 0 0 0 0 0\n";
                ++i;
            }
            this.eps_grains.set_Text(s);
        }
    }

    private void initPosGrainsWithSampleValues() {
        if (this.gen_pos.getText().equals("Do not generate") && this.pos_grains.getText().trim().length() == 0) {
            this.pos_grains.set_Text("#pos_grains_x y z [mm]");
            String s = "";
            int i = 0;
            while (i < Integer.valueOf(this.no_grains.getText())) {
                s = String.valueOf(s) + "pos_grains_" + i + " 0 0 0\n";
                ++i;
            }
            this.pos_grains.set_Text(s);
        }
    }

    private int getComboOdfTypeValue() {
        String odf_type = this.odfTypeCombo.getText();
        int odf_type_value = 0;
        if (this.odfTypeCombo.getData(odf_type) != null) {
            odf_type_value = (Integer)this.odfTypeCombo.getData(odf_type);
        } else if (odf_type.equals("grid from file")) {
            odf_type_value = 2;
        } else if (odf_type.equals("isotropic Gaussian")) {
            odf_type_value = 1;
        }
        return odf_type_value;
    }

    private void initRequire(Composite parent2) {
        Control[] element = parent2.getChildren();
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText) {
                    TypedText text = (TypedText)element[i];
                    if (text.getData() != null && this.requiredKeys.contains(text.getData())) {
                        text.set_isRequiredField(true);
                    } else {
                        text.set_isRequiredField(false);
                    }
                } else {
                    this.initRequire((Composite)element[i]);
                }
            }
            ++i;
        }
    }

    private void makeActions() {
        this.runAction = new RunAction(){

            @Override
            public void run() {
                InputEditor.this.launchProgramWithThisFile();
            }
        };
        this.getEditorSite().getActionBars().setGlobalActionHandler("fable.polyxsim.actions.RunAction", (IAction)this.runAction);
    }

    private void createFileTab() {
        this.tabItem[0].setText("Files");
        Group outputFileGroup = LookAndFeel.getGroup((Composite)container[0], (String)"Output", (int)6, (int)1);
        GridLayout outputFileGroupLayout = new GridLayout();
        outputFileGroupLayout.numColumns = 6;
        outputFileGroupLayout.makeColumnsEqualWidth = true;
        outputFileGroup.setLayout((Layout)outputFileGroupLayout);
        this.imageFlagButton = new Button((Composite)outputFileGroup, 32);
        this.imageFlagButton.setText("Images in format");
        this.imageFlagButton.setToolTipText("make_image: Generate images during simulation");
        this.imageFlagButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.imageFlagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.fileFormatCombo = new Combo((Composite)outputFileGroup, 8);
        this.fileFormatCombo.setLayoutData((Object)new GridData(16, 16, false, false));
        this.fileFormatCombo.setToolTipText("output: Image file format");
        this.fileFormatCombo.add("tif");
        this.fileFormatCombo.add("tif16bit");
        this.fileFormatCombo.add("edf");
        this.fileFormatCombo.setText("tif");
        this.fileFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.outputFltButton = new Button((Composite)outputFileGroup, 32);
        this.outputFltButton.setText("Filtered peaks");
        this.outputFltButton.setToolTipText("output: '.flt' ");
        this.outputFltButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputFltButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.outputGveButton = new Button((Composite)outputFileGroup, 32);
        this.outputGveButton.setText("Scattering vectors");
        this.outputGveButton.setToolTipText("output: '.gve'");
        this.outputGveButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputGveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.outputUbiButton = new Button((Composite)outputFileGroup, 32);
        this.outputUbiButton.setText("Grain orientation");
        this.outputUbiButton.setToolTipText("output: '.ubi'");
        this.outputUbiButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputUbiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.outputParButton = new Button((Composite)outputFileGroup, 32);
        this.outputParButton.setText("Parameters");
        this.outputParButton.setToolTipText("output: ImageD11 parameters '.par' file");
        this.outputParButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputParButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        new Label((Composite)outputFileGroup, 0).setText("Output directory");
        this.direc = new StringText((Composite)outputFileGroup, 0, "");
        this.direc.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        GridData direcGridData = new GridData(4, 16, true, true);
        direcGridData.horizontalSpan = 4;
        this.direc.setLayoutData((Object)direcGridData);
        this.direc.setToolTipText("direc: Directory to save output from Polyxsim");
        Button browseDir = new Button((Composite)outputFileGroup, 8);
        browseDir.setText("Browse");
        browseDir.setToolTipText("Select or enter the output file directory");
        browseDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getDefault().getActiveShell(), 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String dir = directoryDialog.open();
                if (dir != null) {
                    InputEditor.this.handleModify();
                    InputEditor.this.direc.set_Text(dir);
                }
            }
        });
        new Label((Composite)outputFileGroup, 0).setText("File stem");
        this.imageStemFileText = new StringText((Composite)outputFileGroup, 0, "");
        this.imageStemFileText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        GridData imageStemGridData = new GridData(4, 16, true, true);
        imageStemGridData.horizontalSpan = 4;
        this.imageStemFileText.setLayoutData((Object)imageStemGridData);
        this.imageStemFileText.setToolTipText("stem: The base of all out put files");
        Button imageStemBrowseButton = new Button((Composite)outputFileGroup, 8);
        imageStemBrowseButton.setText("Browse");
        imageStemBrowseButton.setToolTipText("Select or enter the image stem directory file");
        imageStemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getDefault().getActiveShell(), 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String file = directoryDialog.open();
                if (file != null) {
                    InputEditor.this.handleModify();
                    InputEditor.this.imageStemFileText.set_Text(file);
                }
            }
        });
        GridData inputFileGridData = new GridData(4, 4, true, true);
        this.inputFileText = new Text(container[0], 2890);
        this.inputFileText.setText("Input file contents will be displayed here ...");
        this.inputFileText.setLayoutData((Object)inputFileGridData);
        this.inputFileText.setEditable(false);
        this.inputFileText.setEnabled(true);
    }

    protected void handleModify() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void createCrystalPhasesTab() {
        this.tabItem[1].setText("Crystal Phases");
        Group grainGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure phases", (int)3, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.no_phases = new IntegerText((Composite)grainGroup, 8, "Number of phases in sample");
        this.no_phases.setToolTipText("Number of structure phases");
        this.no_phases.set_isRequiredField(true);
        this.no_phases.setLayoutData((Object)new GridData(4, 16, true, true));
        this.no_phases.set_Text(Integer.toString(this.numPhases));
        this.no_phases.setEnabled(false);
        this.addPhaseButton = new Button((Composite)grainGroup, 8);
        this.addPhaseButton.setText("Add phase");
        this.addPhaseButton.setToolTipText("Add new phase");
        this.addPhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputEditor inputEditor = InputEditor.this;
                inputEditor.numPhases = inputEditor.numPhases + 1;
                InputEditor.this.no_phases.set_Text(Integer.toString(InputEditor.this.numPhases));
                InputEditor.this.deletePhaseButton.setEnabled(true);
                InputEditor.this.createSizePhase();
                InputEditor.this.createEpsphaseGrains();
                InputEditor.this.handleModify();
                InputEditor.this.createStructureFileGroup();
                InputEditor.this.createNumberOfGrainsPerPhase();
                int i = 0;
                while (i < InputEditor.this.polyXSim.getNumPhases()) {
                    if (InputEditor.this.polyXSim.getStructureFile(i) != null && InputEditor.this.structure_phase != null && InputEditor.this.structure_phase[i] != null) {
                        InputEditor.this.structure_phase[i].set_Text(InputEditor.this.polyXSim.getStructureFile(i));
                    }
                    ++i;
                }
                InputEditor.this.createUnitCellGroup();
            }
        });
        this.deletePhaseButton = new Button((Composite)grainGroup, 8);
        this.deletePhaseButton.setText("Delete phase");
        this.deletePhaseButton.setToolTipText("Delete last phase");
        if (this.numPhases <= 1) {
            this.deletePhaseButton.setEnabled(false);
        }
        this.deletePhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (InputEditor.this.numPhases > 1) {
                    InputEditor inputEditor = InputEditor.this;
                    inputEditor.numPhases = inputEditor.numPhases - 1;
                    InputEditor.this.no_phases.set_Text(Integer.toString(InputEditor.this.numPhases));
                    InputEditor.this.crystalTabShowUnitCellOrStructurePhase();
                    InputEditor.this.createSizePhase();
                    InputEditor.this.createEpsphaseGrains();
                    InputEditor.this.createNumberOfGrainsPerPhase();
                    InputEditor.this.handleModify();
                    if (InputEditor.this.numPhases <= 1) {
                        InputEditor.this.deletePhaseButton.setEnabled(false);
                    }
                }
            }
        });
        this.structureFileButton = new Button((Composite)grainGroup, 16);
        this.structureFileButton.setText("Read structure from file (cif or pdb)");
        this.structureCellButton = new Button((Composite)grainGroup, 16);
        this.structureCellButton.setText("Choose space group and specify unit cell");
        this.structureFileGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure file(s)", (int)3, (int)1);
        new Label((Composite)grainGroup, 0);
        this.gridLayout = (GridLayout)this.structureFileGroup.getLayout();
        this.structureFiles = new String[this.numPhases];
        this.createStructureFileGroup();
        this.structureFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputEditor.this.crystalTabShowUnitCellOrStructurePhase();
                InputEditor.this.handleModify();
            }
        });
        this.unitCellGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Unit cell(s)", (int)8, (int)1);
        this.gridLayout = (GridLayout)this.unitCellGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.unitCell = new Float[this.numPhases];
        this.createUnitCellGroup();
        this.structureCellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputEditor.this.crystalTabShowUnitCellOrStructurePhase();
                InputEditor.this.handleModify();
            }
        });
    }

    private void crystalTabShowUnitCellOrStructurePhase() {
        this.createUnitCellGroup();
        this.createStructureFileGroup();
        this.showStructurePhaseGroup(this.structureFileButton.getSelection());
        this.showUnitCellGroup(this.structureCellButton.getSelection());
    }

    private void createStructureFileGroup() {
        this.diposeStructureFileGroup();
        if (this.structureFileButton.getSelection()) {
            this.structure_phase = new StringText[this.numPhases];
            this.structureFileViewButton = new Button[this.numPhases];
            this.structureFileBrowseButton = new Button[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                this.structure_phase[i] = new StringText((Composite)this.structureFileGroup, 0, "Structure file for phase " + i);
                this.structure_phase[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                DropTarget target = new DropTarget((Control)this.structure_phase[i].getTextField(), 17);
                target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
                target.addDropListener(this.dropTargetFileListener);
                this.structure_phase[i].setData((Object)("structure_phase_" + i));
                if (i < this.structureFiles.length && this.structureFiles[i] != null) {
                    this.structure_phase[i].set_Text(this.structureFiles[i]);
                }
                this.structure_phase[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.structureFileBrowseButton[i] = new Button((Composite)this.structureFileGroup, 8);
                this.structureFileBrowseButton[i].setText("Browse");
                this.structureFileBrowseButton[i].setToolTipText("Browse structure file");
                this.structureFileBrowseButton[i].setData((Object)i);
                this.structureFileBrowseButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                        fileDialog.setText("Select an existing structure file");
                        String file = fileDialog.open();
                        if (file != null) {
                            ((InputEditor)InputEditor.this).structureFiles[iStructureFile.intValue()] = file;
                            InputEditor.this.structure_phase[iStructureFile].set_Text(file);
                        }
                    }
                });
                this.structureFileViewButton[i] = new Button((Composite)this.structureFileGroup, 8);
                this.structureFileViewButton[i].setText("View");
                this.structureFileViewButton[i].setToolTipText("View 3D structure");
                this.structureFileViewButton[i].setData((Object)i);
                this.structureFileViewButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        String structureFile = InputEditor.this.structure_phase[iStructureFile].getText();
                        InputEditor.this.openJmolView(structureFile);
                    }
                });
                ++i;
            }
        }
        this.structureFileGroup.pack();
        container[1].pack();
    }

    private void openJmolView(String structureFile) {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            if (structureFile.indexOf(":") == -1) {
                structureFile = String.valueOf(this.inputFileDirectory) + File.separator + structureFile;
            }
        } else if (!structureFile.startsWith(File.separator)) {
            structureFile = String.valueOf(this.inputFileDirectory) + File.separator + structureFile;
        }
        if (structureFile != null && new File(structureFile).exists()) {
            try {
                JmolView jmolView = null;
                jmolView = (JmolView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.JmolView", Integer.toString(JmolView.viewCount), 1);
                if (jmolView != null) {
                    jmolView.openFile(structureFile);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private void diposeStructureFileGroup() {
        if (this.structure_phase != null) {
            this.structureFiles = new String[this.numPhases];
            int i = 0;
            while (i < this.structure_phase.length) {
                if (i < this.structureFiles.length && !this.structure_phase[i].isDisposed()) {
                    this.structureFiles[i] = this.structure_phase[i].getText();
                }
                this.structure_phase[i].dispose();
                this.structureFileViewButton[i].dispose();
                this.structureFileBrowseButton[i].dispose();
                ++i;
            }
            this.structure_phase = null;
            this.structureFileViewButton = null;
            this.structureFileViewButton = null;
        }
    }

    private void createUnitCellGroup() {
        this.disposeAllUnitCellWidgets();
        if (this.structureCellButton.getSelection()) {
            this.unit_cell_phase_a = new FloatText[this.numPhases];
            this.unit_cell_phase_b = new FloatText[this.numPhases];
            this.unit_cell_phase_c = new FloatText[this.numPhases];
            this.unit_cell_phase_alpha = new FloatText[this.numPhases];
            this.unit_cell_phase_beta = new FloatText[this.numPhases];
            this.unit_cell_phase_gamma = new FloatText[this.numPhases];
            this.sgno_phase = new IntegerText[this.numPhases];
            this.unitCellSpaceGroupHelpBtn = new Button[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                this.unit_cell_phase_a[i] = new FloatText((Composite)this.unitCellGroup, 0, "a (\u00c5)");
                this.unit_cell_phase_a[i].set_isRequiredField(true);
                this.unit_cell_phase_a[i].setToolTipText("Unit cell a axis in Angstroms");
                this.unit_cell_phase_a[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_a[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_b[i] = new FloatText((Composite)this.unitCellGroup, 0, "b (\u00c5)");
                this.unit_cell_phase_b[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_b[i].set_isRequiredField(true);
                this.unit_cell_phase_b[i].setToolTipText("Unit cell b axis in Angstroms");
                this.unit_cell_phase_b[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_c[i] = new FloatText((Composite)this.unitCellGroup, 0, "c (\u00c5)");
                this.unit_cell_phase_c[i].set_isRequiredField(true);
                this.unit_cell_phase_c[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_c[i].setToolTipText("Unit cell c axis in Angstroms");
                this.unit_cell_phase_c[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_alpha[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b1 (\u00b0)");
                this.unit_cell_phase_alpha[i].set_isRequiredField(true);
                this.unit_cell_phase_alpha[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_alpha[i].setToolTipText("Unit cell alpha angle in degrees");
                this.unit_cell_phase_alpha[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_beta[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b2 (\u00b0)");
                this.unit_cell_phase_beta[i].set_isRequiredField(true);
                this.unit_cell_phase_beta[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_beta[i].setToolTipText("Unit cell beta angle in degrees");
                this.unit_cell_phase_beta[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_gamma[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b3 (\u00b0)");
                this.unit_cell_phase_gamma[i].set_isRequiredField(true);
                this.unit_cell_phase_gamma[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.unit_cell_phase_gamma[i].setToolTipText("Unit cell gamma angle in degrees");
                this.unit_cell_phase_gamma[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.sgno_phase[i] = new IntegerText((Composite)this.unitCellGroup, 0, "Space\nGroup", 1, 230);
                this.sgno_phase[i].getTextField().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InputEditor.this.handleModify();
                    }
                });
                this.sgno_phase[i].set_isRequiredField(true);
                this.sgno_phase[i].setToolTipText("Unit cell space group number");
                GridData gd = new GridData(4, 16, true, false);
                gd.minimumWidth = 30;
                this.sgno_phase[i].setLayoutData((Object)gd);
                this.unitCellSpaceGroupHelpBtn[i] = new Button((Composite)this.unitCellGroup, 0x840000);
                this.unitCellSpaceGroupHelpBtn[i].setImage(this.helpImg);
                final int index = i;
                this.unitCellSpaceGroupHelpBtn[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CrystalSymmetryDialog dialog;
                        int value;
                        int oldValue = 0;
                        String strOldValue = InputEditor.this.sgno_phase[index].getText();
                        try {
                            oldValue = Integer.valueOf(strOldValue);
                        }
                        catch (Exception exception) {
                            oldValue = 1;
                        }
                        if (oldValue < 1) {
                            oldValue = 1;
                        }
                        if (oldValue > 230) {
                            oldValue = 230;
                        }
                        if ((value = (dialog = new CrystalSymmetryDialog(Display.getDefault().getActiveShell(), oldValue)).open()) != 0) {
                            InputEditor.this.sgno_phase[index].set_Text(String.valueOf(value));
                        }
                    }
                });
                this.unitCellSpaceGroupHelpBtn[i].setToolTipText("");
                if ((i + 1) * 7 <= this.unitCell.length) {
                    if (this.unitCell[i * 7] != null) {
                        this.unit_cell_phase_a[i].set_Text(Float.toString(this.unitCell[i * 7].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 1] != null) {
                        this.unit_cell_phase_b[i].set_Text(Float.toString(this.unitCell[i * 7 + 1].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 2] != null) {
                        this.unit_cell_phase_c[i].set_Text(Float.toString(this.unitCell[i * 7 + 2].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 3] != null) {
                        this.unit_cell_phase_alpha[i].set_Text(Float.toString(this.unitCell[i * 7 + 3].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 4] != null) {
                        this.unit_cell_phase_beta[i].set_Text(Float.toString(this.unitCell[i * 7 + 4].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 5] != null) {
                        this.unit_cell_phase_gamma[i].set_Text(Float.toString(this.unitCell[i * 7 + 5].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 6] != null) {
                        this.sgno_phase[i].set_Text(Integer.toString(this.unitCell[i * 7 + 6].intValue()));
                    }
                }
                ++i;
            }
        }
        this.unitCellGroup.pack();
        container[1].pack();
    }

    public void createSampleTab() {
        this.tabItem[2].setText("Sample");
        Group sampleGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Sample", (int)2, (int)1);
        this.createSampleShape(sampleGroup);
        Group grainGroup = this.createGrainSize();
        this.createGrainOrientations(grainGroup);
        this.createGrainPositions(grainGroup);
        this.createGrainStrains(grainGroup);
    }

    private void createSampleShape(Group sampleGroup) {
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        Composite composite = new Composite((Composite)sampleGroup, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)this.gridLayout);
        Label sampleShapeLabel = new Label(composite, 0);
        sampleShapeLabel.setText("Sample shape");
        this.sampleShapeCombo = new Combo(composite, 8);
        this.sampleShapeCombo.add("");
        this.sampleShapeCombo.add(CYLINDER);
        this.sampleShapeCombo.add(BOX);
        this.sampleShapeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String shape = InputEditor.this.sampleShapeCombo.getText();
                InputEditor.this.sampleShapeRules(shape);
                InputEditor.this.handleModify();
            }
        });
        this.sampleShapeCombo.setToolTipText("sample_cyl: Cylindrical sample shape or sample_xyz: Box shaped sample");
        this.sampleBoxGroup = LookAndFeel.getGroup((Composite)sampleGroup, (String)"Box dimensions", (int)3, (int)1);
        gd = new GridData(4, 4, true, false);
        this.sampleBoxGroup.setLayoutData((Object)gd);
        this.sample_xyz_X = new FloatText((Composite)this.sampleBoxGroup, 0, "X (mm)");
        gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        this.sample_xyz_X.setLayoutData((Object)gd);
        this.sample_xyz_X.set_isRequiredField(true);
        this.sample_xyz_X.setToolTipText("X sample size in mm");
        this.sample_xyz_X.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.sample_xyz_Y = new FloatText((Composite)this.sampleBoxGroup, 0, "Y (mm)");
        gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        this.sample_xyz_Y.setLayoutData((Object)gd);
        this.sample_xyz_Y.set_isRequiredField(true);
        this.sample_xyz_Y.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.sample_xyz_Y.setToolTipText("Y sample size in mm");
        this.sample_xyz_Z = new FloatText((Composite)this.sampleBoxGroup, 0, "Z (mm)");
        gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        this.sample_xyz_Z.setLayoutData((Object)gd);
        this.sample_xyz_Z.set_isRequiredField(true);
        this.sample_xyz_Z.setToolTipText("Z sample size in mm");
        this.sample_xyz_Z.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.sampleCylinderGroup = new Group((Composite)sampleGroup, 0);
        this.sampleCylinderGroup.setText("Cylinder dimensions");
        this.sampleCylinderGroup.setLayout((Layout)new GridLayout(2, false));
        this.sampleCylinderGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.sample_cyl_diameter = new FloatText((Composite)this.sampleCylinderGroup, 0, "Height (mm)");
        this.sample_cyl_diameter.set_isRequiredField(true);
        this.sample_cyl_diameter.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.sample_cyl_diameter.setToolTipText("Sample diameter in mm");
        gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        this.sample_cyl_diameter.setLayoutData((Object)gd);
        this.sample_cyl_height = new FloatText((Composite)this.sampleCylinderGroup, 0, "Diameter (mm)");
        this.sample_cyl_height.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.sample_cyl_height.set_isRequiredField(true);
        gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        this.sample_cyl_height.setLayoutData((Object)gd);
        this.sample_cyl_height.setToolTipText("Sample height diameter in mm");
    }

    private Group createGrainSize() {
        Group grainGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Grains", (int)1, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.no_grains = new IntegerText((Composite)grainGroup, 0, "Total number of grains");
        this.no_grains.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.no_grains.setToolTipText("no_grains: Total number of grains");
        this.no_grains.set_isRequiredField(true);
        GridData gd = new GridData(16, 4, true, false);
        gd.minimumWidth = 180;
        gd.horizontalSpan = 1;
        this.no_grains.setLayoutData((Object)gd);
        this.no_grains.getTextField().setLayoutData((Object)gd);
        this.grainAndPhaseGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Grains and phase", (int)2, (int)1);
        this.grainAndPhaseGroup.setLayoutData((Object)new GridLayout(2, false));
        GridData grainAndPhaseGridData = new GridData(4, 16, true, false);
        grainAndPhaseGridData.horizontalSpan = 2;
        this.grainAndPhaseGroup.setLayoutData((Object)grainAndPhaseGridData);
        this.gen_phase_flag = new Button((Composite)this.grainAndPhaseGroup, 32);
        this.gen_phase_flag.setText("Appoint which grain belongs to which phase");
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.gen_phase_flag.setLayoutData((Object)gd);
        this.gen_phase_flag.setToolTipText("gen_phase <flag> : Check this button if you want \nPolyXsim appoint which grain belongs to which phase.");
        this.gen_phase_flag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.gen_phase_setRequirement();
            }
        });
        this.createNumberOfGrainsPerPhase();
        this.grainSizeGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Size(s)", (int)1, (int)1);
        GridData grainSizeGridData = new GridData(4, 4, true, true);
        this.grainSizeGroup.setLayoutData((Object)grainSizeGridData);
        this.gen_size = new Combo((Composite)this.grainSizeGroup, 8);
        this.gen_size.add("Do not generate", 0);
        this.gen_size.add("Generate at random using the same lognormal distribution for all phases", 1);
        this.gen_size.add("Generate at random using different lognormal distributions for each phase", 2);
        this.gen_size.add("Provide specific grain sizes for each grain", 3);
        this.gen_size.setToolTipText("gen_size: flag [0= do not, or 1= do] median-grain-size-of-distribution [mm] minimum-grain-size [mm] maximum-grain-size [mm] ");
        this.gen_size.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.gen_size_EnableFields();
            }
        });
        this.grpSizeAll = new Group((Composite)this.grainSizeGroup, 0);
        GridLayout layout = new GridLayout(3, false);
        this.grpSizeAll.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.grpSizeAll.setLayoutData((Object)gridData);
        this.grpSizeAll.setText("Specific value for all phases");
        this.gen_size_median = new FloatText((Composite)this.grpSizeAll, 0, "Median");
        this.gen_size_median.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gen_size_median.setToolTipText("gen_size: Median grain size for log normal distribution");
        this.gen_size_median.set_isRequiredField(true);
        this.gen_size_median.setLayoutData((Object)new GridData(4, 16, true, true));
        this.gen_size_min = new FloatText((Composite)this.grpSizeAll, 0, "Min");
        this.gen_size_min.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gen_size_min.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gen_size_min.setToolTipText("gen_size: Minimum grain cutoff size");
        this.gen_size_min.setLayoutData((Object)new GridData(4, 16, true, true));
        this.gen_size_max = new FloatText((Composite)this.grpSizeAll, 0, "Max");
        this.gen_size_max.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gen_size_max.setToolTipText("gen_size: Maximum grain cutoff size");
        this.gen_size_max.setLayoutData((Object)new GridData(4, 16, true, true));
        this.grpSizeForEachPhase = new Group((Composite)this.grainSizeGroup, 0);
        layout = new GridLayout(5, false);
        this.grpSizeForEachPhase.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        this.grpSizeForEachPhase.setLayoutData((Object)gridData);
        this.grpSizeForEachPhase.setText("Specific value for each phase");
        this.createSizePhase();
        Group grpSizeForEachGrain = new Group((Composite)this.grainSizeGroup, 0);
        grpSizeForEachGrain.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 4, true, true);
        grpSizeForEachGrain.setLayoutData((Object)gridData);
        grpSizeForEachGrain.setText("Specific grain size (mm)");
        gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 6;
        this.size_grains = new StringText((Composite)grpSizeForEachGrain, 834);
        this.size_grains.setLayoutData((Object)gridData);
        this.size_grains.getTextField().setLayoutData((Object)gridData);
        this.size_grains.setToolTipText("size_grains_X grain-diameter [mm]");
        this.size_grains.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        return grainGroup;
    }

    protected void enableGenSizeallPhase(boolean ball) {
        this.grpSizeAll.setEnabled(ball);
        this.gen_size_median.setEnabled(ball);
        this.gen_size_min.setEnabled(ball);
        this.gen_size_max.setEnabled(ball);
    }

    private void enableGenSizePhase(boolean b) {
        this.grpSizeForEachPhase.setEnabled(b);
        int i = 0;
        while (i < this.numPhases) {
            if (!this.gen_size_phase_flag[i].isDisposed()) {
                this.gen_size_phase_flag[i].setEnabled(b);
            }
            if (!this.gen_size_phase_x[i].isDisposed()) {
                this.gen_size_phase_x[i].setEnabled(b);
            }
            if (!this.gen_size_phase_x_min[i].isDisposed()) {
                this.gen_size_phase_x_min[i].setEnabled(b);
            }
            if (!this.gen_size_phase_x_max[i].isDisposed()) {
                this.gen_size_phase_x_max[i].setEnabled(b);
            }
            ++i;
        }
    }

    private void gen_phase_setRequirement() {
        int i = 0;
        while (i < this.numPhases) {
            if (!this.no_grains_phase_Y[i].isDisposed()) {
                this.no_grains_phase_Y[i].set_isRequiredField(this.gen_phase_flag.getSelection());
                this.no_grains_phase_Y[i].showDecoration();
                this.no_grains_phase_Y[i].setEnabled(this.gen_phase_flag.getSelection());
            }
            ++i;
        }
    }

    private void createGrainOrientations(Group grainGroup) {
        Group grainOrientationGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Orientation(s)", (int)1, (int)1);
        this.gridLayout = (GridLayout)grainOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData(4, 4, true, true);
        grainOrientationGroup.setLayoutData((Object)gridData);
        this.gen_U = new Button((Composite)grainOrientationGroup, 32);
        this.gen_U.setText("Generate random orientations");
        this.gen_U.setToolTipText("gen_U: flag [0= do not, or 1= do]");
        this.gen_U.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.u_grains.set_isRequiredField(!InputEditor.this.gen_U.getSelection());
                InputEditor.this.u_grains.setEnabled(!InputEditor.this.gen_U.getSelection());
                InputEditor.this.initUGrainsWithsampleValues();
            }
        });
        Label l = new Label((Composite)grainOrientationGroup, 0);
        l.setText("Use these specific orientations matrix:");
        gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 6;
        this.u_grains = new StringText((Composite)grainOrientationGroup, 834);
        this.u_grains.setLayoutData((Object)new GridData(4, 4, true, true));
        this.u_grains.getTextField().setLayoutData((Object)gridData);
        this.u_grains.setData((Object)"U_grains_");
        this.u_grains.setToolTipText("U_grains_X U11 U12 U13 U21 U22 U23 U31 U32 U33");
        this.u_grains.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
    }

    private void initUGrainsWithsampleValues() {
        if (!this.gen_U.getSelection() && this.u_grains.getText().trim().length() == 0) {
            this.u_grains.set_Text("#U_grains_U11 U12 U13 U21 U22 U23 U31 U32 U33 ");
            String s = "";
            int i = 0;
            while (i < Integer.valueOf(this.no_grains.getText())) {
                s = String.valueOf(s) + "U_grains_" + i + " 0 0 0 0 0 0 0 0 0\n";
                ++i;
            }
            this.u_grains.set_Text(s);
        }
    }

    private void createGrainStrains(Group grainGroup) {
        this.genEpsGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Grain strains", (int)1, (int)1);
        this.gridLayout = (GridLayout)this.genEpsGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.genEpsGroup.setLayoutData((Object)gridData);
        this.gen_eps = new Combo((Composite)this.genEpsGroup, 8);
        this.gen_eps.add("Do not generate", 0);
        this.gen_eps.add("No strain ", 1);
        this.gen_eps.add("Generate randomly from Gaussian distribution with same mean and spread for all phases", 2);
        this.gen_eps.add("Generate randomly from Gaussian distribution with different mean and spread for each phase", 3);
        this.gen_eps.add("Provide specific strain tensors for each grain ", 4);
        this.gen_eps.setToolTipText("gen_eps: generate random strain tensors (value=1) or specify strains (value =0)");
        this.gen_eps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.enableSpecificGrainStrains();
                InputEditor.this.initepsGrainswithSampleValues();
            }
        });
        this.gen_eps.setToolTipText("gen_eps: generate random strain tensors (value=1) or specify strains (value =0)");
        this.grpEpsGroupAll = new Group((Composite)this.genEpsGroup, 0);
        GridLayout layout = new GridLayout(3, false);
        this.grpEpsGroupAll.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        this.grpEpsGroupAll.setLayoutData((Object)gridData);
        this.grpEpsGroupAll.setText("Specific value for all phases");
        Label l = new Label((Composite)this.grpEpsGroupAll, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        l.setLayoutData((Object)gridData);
        l.setText("Diagonal elements of strain tensor:");
        new Label((Composite)this.grpEpsGroupAll, 0).setText("Mean value");
        this.gen_eps_meanDiag = new FloatText((Composite)this.grpEpsGroupAll, 0, "");
        gridData = new GridData(16, 16, true, false);
        gridData.minimumWidth = 180;
        this.gen_eps_meanDiag.setLayoutData((Object)gridData);
        this.gen_eps_meanDiag.setToolTipText("Mean value of diagonal elements of strain tensor");
        this.gen_eps_meanDiag.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        new Label((Composite)this.grpEpsGroupAll, 0).setText("Spread");
        this.gen_eps_spreadDiag = new FloatText((Composite)this.grpEpsGroupAll, 0, "");
        this.gen_eps_spreadDiag.setToolTipText("Spread for diagonal elements of strain tensor");
        this.gen_eps_spreadDiag.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gridData = new GridData(16, 16, true, false);
        gridData.minimumWidth = 180;
        this.gen_eps_spreadDiag.setLayoutData((Object)gridData);
        l = new Label((Composite)this.grpEpsGroupAll, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        l.setLayoutData((Object)gridData);
        l.setText("Offdiagonal elements of strain tensor:");
        new Label((Composite)this.grpEpsGroupAll, 0).setText("Mean value");
        this.gen_eps_meanOffDiag = new FloatText((Composite)this.grpEpsGroupAll, 0, "");
        this.gen_eps_meanOffDiag.setToolTipText("Mean value for offdiagonal element of strain tensor");
        this.gen_eps_meanOffDiag.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gridData = new GridData(16, 16, true, false);
        gridData.minimumWidth = 180;
        this.gen_eps_meanOffDiag.setLayoutData((Object)gridData);
        new Label((Composite)this.grpEpsGroupAll, 0).setText("Spread");
        this.gen_eps_spreadOffDiag = new FloatText((Composite)this.grpEpsGroupAll, 0, "");
        this.gen_eps_spreadOffDiag.setToolTipText("Spread for offdiagonal elements of strain tensor");
        this.gen_eps_spreadOffDiag.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gridData = new GridData(16, 16, true, false);
        gridData.minimumWidth = 180;
        this.gen_eps_spreadOffDiag.setLayoutData((Object)gridData);
        this.grpEps = new Group((Composite)this.genEpsGroup, 0);
        this.grpEps.setText("Use grain strains for each phase");
        layout = new GridLayout(6, false);
        this.grpEps.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        this.grpEps.setLayoutData((Object)gridData);
        this.createEpsphaseGrains();
        this.grpEps_grains = new Group((Composite)this.genEpsGroup, 0);
        this.grpEps_grains.setText("Strain tensors for each grain");
        layout = new GridLayout();
        this.grpEps_grains.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        this.grpEps_grains.setLayoutData((Object)gridData);
        this.eps_grains = new StringText((Composite)this.grpEps_grains, 834);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 6;
        this.eps_grains.getTextField().setLayoutData((Object)gd);
        this.eps_grains.setLayoutData((Object)new GridData(4, 4, true, true));
        this.eps_grains.setData((Object)"eps_grains_");
        this.eps_grains.setToolTipText("eps_grains_Y eps11 eps12 eps13 eps22 eps23 eps33");
        this.eps_grains.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
    }

    private void enableSpecificGrainStrains() {
        InputEditor.setEnableGroup(this.grpEpsGroupAll, this.gen_eps.getText().equals("Generate randomly from Gaussian distribution with same mean and spread for all phases"));
        InputEditor.setEnableGroup(this.grpEps, this.gen_eps.getText().equals("Generate randomly from Gaussian distribution with different mean and spread for each phase"));
        InputEditor.setEnableGroup(this.grpEps_grains, this.gen_eps.getText().equals("Provide specific strain tensors for each grain "));
    }

    public void setEnableGroup(Composite parent, boolean benable) {
        Control[] element = parent.getChildren();
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setEnableGroup((Composite)element[i], benable);
                } else {
                    element[i].setEnabled(benable);
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    private void createGrainPositions(Group grainGroup) {
        Group grainPositionGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Position(s)", (int)2, (int)1);
        this.gridLayout = (GridLayout)grainPositionGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData(4, 4, true, true);
        grainPositionGroup.setLayoutData((Object)gridData);
        Label l = new Label((Composite)grainPositionGroup, 0);
        l.setText("Grain positions:");
        this.gen_pos = new Combo((Composite)grainPositionGroup, 8);
        this.gen_pos.add("Do not generate");
        this.gen_pos.add("Set all positions at origo");
        this.gen_pos.add("Generate random positions within box or cylinder");
        this.gen_pos.setToolTipText("gen_pos: [0= do not, or 1= do] flag2 [0= all at (0,0,0), 1= generate randomly within box or cylinder]");
        this.gen_pos.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.pos_grains.set_isRequiredField(InputEditor.this.gen_pos.getText().equals("Do not generate"));
                InputEditor.this.pos_grains.setEnabled(InputEditor.this.gen_pos.getText().equals("Do not generate"));
                InputEditor.this.initPosGrainsWithSampleValues();
            }
        });
        l = new Label((Composite)grainPositionGroup, 0);
        l.setText("Use these specific positions:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        l.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        this.pos_grains = new StringText((Composite)grainPositionGroup, 834);
        gridData.verticalSpan = 6;
        gridData.horizontalSpan = 2;
        this.pos_grains.setLayoutData((Object)gridData);
        this.pos_grains.getTextField().setLayoutData((Object)gridData);
        this.pos_grains.setData((Object)"pos_grains_");
        this.pos_grains.setToolTipText("pos_grains_X x y z [mm]");
        this.pos_grains.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
    }

    private void enableSampleShape(boolean iscube, boolean iscylindrique) {
        this.sample_xyz_X.set_isRequiredField(iscube);
        this.sample_xyz_Y.set_isRequiredField(iscube);
        this.sample_xyz_Z.set_isRequiredField(iscube);
        this.sample_cyl_height.set_isRequiredField(iscylindrique);
        this.sample_cyl_diameter.set_isRequiredField(iscylindrique);
        InputEditor.setEnableGroup(this.sampleCylinderGroup, iscylindrique);
        InputEditor.setEnableGroup(this.sampleBoxGroup, iscube);
    }

    private void createNumberOfGrainsPerPhase() {
        int i;
        if (this.phaseAndGrainsLabel != null) {
            i = 0;
            while (i < this.phaseAndGrainsLabel.length) {
                this.phaseAndGrainsLabel[i].dispose();
                this.no_grains_phase_Y[i].dispose();
                ++i;
            }
        }
        this.phaseAndGrainsLabel = new Label[this.numPhases];
        this.no_grains_phase_Y = new IntegerText[this.numPhases];
        i = 0;
        while (i < this.numPhases) {
            this.phaseAndGrainsLabel[i] = new Label((Composite)this.grainAndPhaseGroup, 0);
            this.phaseAndGrainsLabel[i].setText("Phase " + i);
            this.no_grains_phase_Y[i] = new IntegerText((Composite)this.grainAndPhaseGroup, 0, "Grains");
            this.no_grains_phase_Y[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.no_grains_phase_Y[i].setData((Object)"gen_phase");
            this.no_grains_phase_Y[i].setData((Object)("no_grains_phase_" + i));
            this.no_grains_phase_Y[i].setToolTipText("gen_phase: Number of grains in this phase");
            this.no_grains_phase_Y[i].set_isRequiredField(true);
            ++i;
        }
        this.grainAndPhaseGroup.pack();
        container[2].pack();
    }

    private void createSizeOptions() {
        this.phaseLabel = new Label[this.numPhases];
        this.phaseDistributionCombo = new Combo[this.numPhases];
        this.gen_size_phase_x = new FloatText[this.numPhases];
        this.gen_size_phase_x_min = new FloatText[this.numPhases];
        this.gen_size_phase_x_max = new FloatText[this.numPhases];
        int i = 0;
        while (i < this.numPhases) {
            this.phaseLabel[i] = new Label((Composite)this.grainSizeGroup, 0);
            this.phaseLabel[i].setText("Phase " + i);
            this.phaseDistributionCombo[i] = new Combo((Composite)this.grainSizeGroup, 8);
            this.phaseDistributionCombo[i].setLayoutData((Object)new GridData(16, 0x1000000, true, true));
            this.phaseDistributionCombo[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.phaseDistributionCombo[i].add("fixed");
            this.phaseDistributionCombo[i].add("lognormal");
            this.phaseDistributionCombo[i].select(0);
            this.phaseDistributionCombo[i].setToolTipText("gen_size: Grain size distribution");
            this.gen_size_phase_x[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Median");
            this.gen_size_phase_x[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x[i].setData((Object)"gen_size_phase_");
            this.gen_size_phase_x[i].setToolTipText("gen_size: Median grain size for log normal distribution");
            this.gen_size_phase_x[i].set_isRequiredField(true);
            this.gen_size_phase_x[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_min[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Min");
            this.gen_size_phase_x_min[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_min[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_min[i].setToolTipText("gen_size: Minimum grain cutoff size");
            this.gen_size_phase_x_min[i].set_isRequiredField(true);
            this.gen_size_phase_x_min[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_max[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Max");
            this.gen_size_phase_x_max[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_max[i].setToolTipText("gen_size: Maximum grain cutoff size");
            this.gen_size_phase_x_max[i].set_isRequiredField(true);
            this.gen_size_phase_x_max[i].setLayoutData((Object)new GridData(4, 16, true, true));
            ++i;
        }
        this.grainSizeGroup.pack();
        container[2].pack();
    }

    private void createSizePhase() {
        int i;
        if (this.phaseLabel != null) {
            i = 0;
            while (i < this.phaseLabel.length) {
                this.phaseLabel[i].dispose();
                this.gen_size_phase_flag[i].dispose();
                this.gen_size_phase_x[i].dispose();
                this.gen_size_phase_x_min[i].dispose();
                this.gen_size_phase_x_max[i].dispose();
                ++i;
            }
        }
        this.phaseLabel = new Label[this.numPhases];
        this.gen_size_phase_flag = new Button[this.numPhases];
        this.gen_size_phase_x = new FloatText[this.numPhases];
        this.gen_size_phase_x_min = new FloatText[this.numPhases];
        this.gen_size_phase_x_max = new FloatText[this.numPhases];
        i = 0;
        while (i < this.numPhases) {
            this.phaseLabel[i] = new Label((Composite)this.grpSizeForEachPhase, 0);
            this.phaseLabel[i].setText("Phase " + i);
            this.gen_size_phase_flag[i] = new Button((Composite)this.grpSizeForEachPhase, 32);
            this.gen_size_phase_flag[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_flag[i].setText("Generate");
            this.gen_size_phase_flag[i].setToolTipText("gen_size_phase_Y flag");
            this.gen_size_phase_x[i] = new FloatText((Composite)this.grpSizeForEachPhase, 0, "Median");
            this.gen_size_phase_x[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x[i].setData((Object)"gen_size_phase_");
            this.gen_size_phase_x[i].setToolTipText("gen_size: Median grain size for log normal distribution");
            this.gen_size_phase_x[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_min[i] = new FloatText((Composite)this.grpSizeForEachPhase, 0, "Min");
            this.gen_size_phase_x_min[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_min[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_min[i].setToolTipText("gen_size: Minimum grain cutoff size");
            this.gen_size_phase_x_min[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_max[i] = new FloatText((Composite)this.grpSizeForEachPhase, 0, "Max");
            this.gen_size_phase_x_max[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_size_phase_x_max[i].setToolTipText("gen_size: Maximum grain cutoff size");
            this.gen_size_phase_x_max[i].setLayoutData((Object)new GridData(4, 16, true, true));
            ++i;
        }
        this.grainSizeGroup.pack();
        container[2].pack();
    }

    private void createEpsphaseGrains() {
        int i;
        if (this.phaseLabelEps != null) {
            i = 0;
            while (i < this.phaseLabelEps.length) {
                this.phaseLabelEps[i].dispose();
                this.gen_eps_meanDiag_Y[i].dispose();
                this.gen_eps_spreadDiag_Y[i].dispose();
                this.gen_eps_meanoffDiag_Y[i].dispose();
                this.gen_eps_spreadoffDiag_Y[i].dispose();
                this.phaseLabelMeanDiagEps[i].dispose();
                this.phaseLabelMeanOffDiagEps[i].dispose();
                this.phaseLabelSpreadDiagEps[i].dispose();
                this.phaseLabelSpreadOffEps[i].dispose();
                this.gen_eps_random[i].dispose();
                ++i;
            }
        }
        this.phaseLabelEps = new Label[this.numPhases];
        this.gen_eps_meanDiag_Y = new FloatText[this.numPhases];
        this.gen_eps_spreadDiag_Y = new FloatText[this.numPhases];
        this.gen_eps_meanoffDiag_Y = new FloatText[this.numPhases];
        this.gen_eps_spreadoffDiag_Y = new FloatText[this.numPhases];
        this.gen_eps_random = new Button[this.numPhases];
        this.phaseLabelMeanDiagEps = new Label[this.numPhases];
        this.phaseLabelMeanOffDiagEps = new Label[this.numPhases];
        this.phaseLabelSpreadDiagEps = new Label[this.numPhases];
        this.phaseLabelSpreadOffEps = new Label[this.numPhases];
        i = 0;
        while (i < this.numPhases) {
            this.phaseLabelEps[i] = new Label((Composite)this.grpEps, 0);
            this.phaseLabelEps[i].setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.phaseLabelEps[i].setText("Phase " + i);
            GridData gd = new GridData();
            gd.verticalSpan = 2;
            this.phaseLabelEps[i].setLayoutData((Object)gd);
            this.gen_eps_random[i] = new Button((Composite)this.grpEps, 32);
            this.gen_eps_random[i].setText("Generate randomly");
            gd = new GridData();
            gd.verticalSpan = 2;
            this.gen_eps_random[i].setLayoutData((Object)gd);
            this.phaseLabelMeanDiagEps[i] = new Label((Composite)this.grpEps, 0);
            this.phaseLabelMeanDiagEps[i].setText("Diagonal elements of strain tensor: Mean value");
            this.gen_eps_meanDiag_Y[i] = new FloatText((Composite)this.grpEps, 0, "");
            this.gen_eps_meanDiag_Y[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_eps_meanDiag_Y[i].setData((Object)"gen_eps_phase_");
            this.gen_eps_meanDiag_Y[i].setToolTipText("gen_eps_phase_" + i);
            this.phaseLabelSpreadDiagEps[i] = new Label((Composite)this.grpEps, 0);
            this.phaseLabelSpreadDiagEps[i].setText("Spread");
            this.gen_eps_spreadDiag_Y[i] = new FloatText((Composite)this.grpEps, 0, "");
            this.gen_eps_spreadDiag_Y[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_eps_spreadDiag_Y[i].setData((Object)"gen_eps_phase_");
            this.gen_eps_spreadDiag_Y[i].setToolTipText("gen_eps_phase_" + i);
            this.phaseLabelMeanOffDiagEps[i] = new Label((Composite)this.grpEps, 0);
            this.phaseLabelMeanOffDiagEps[i].setText("Offdiagonal elements of strain tensor: Mean value");
            this.gen_eps_meanoffDiag_Y[i] = new FloatText((Composite)this.grpEps, 0, "");
            this.gen_eps_meanoffDiag_Y[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_eps_meanoffDiag_Y[i].setData((Object)"gen_eps_phase_");
            this.gen_eps_meanoffDiag_Y[i].setToolTipText("gen_eps_phase_" + i);
            this.phaseLabelSpreadOffEps[i] = new Label((Composite)this.grpEps, 0);
            this.phaseLabelSpreadOffEps[i].setText("Spread");
            this.gen_eps_spreadoffDiag_Y[i] = new FloatText((Composite)this.grpEps, 0, "");
            this.gen_eps_spreadoffDiag_Y[i].getTextField().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputEditor.this.handleModify();
                }
            });
            this.gen_eps_spreadoffDiag_Y[i].setToolTipText("gen_eps_phase_" + i);
            this.gen_eps_spreadoffDiag_Y[i].setData((Object)"gen_eps_phase_");
            gd = new GridData();
            gd.horizontalSpan = 2;
            ++i;
        }
        this.grpEps.pack();
        this.genEpsGroup.pack();
        container[2].pack();
        this.scrolledComposite[2].setMinSize(container[2].computeSize(-1, -1));
    }

    public void createReflectionsTab() {
        this.tabItem[3].setText("Reflections");
        Group reflectionGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Reflection intensities", (int)3, (int)1);
        this.gridLayout = (GridLayout)reflectionGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        GridData gd = new GridData(4, 16, true, false);
        reflectionGroup.setLayout((Layout)this.gridLayout);
        reflectionGroup.setLayoutData((Object)gd);
        Label intensityLabel = new Label((Composite)reflectionGroup, 0);
        intensityLabel.setText("Intensity");
        this.intensityCombo = new Combo((Composite)reflectionGroup, 8);
        gd = new GridData(16384, 16, true, false);
        this.intensityCombo.add("constant");
        this.intensityCombo.add("structure factor");
        this.intensityCombo.select(0);
        this.intensityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.intensityConstantFloatText.setEnabled(InputEditor.this.intensityCombo.getSelectionIndex() == 0);
                InputEditor.this.handleModify();
            }
        });
        this.intensityConstantFloatText = new FloatText((Composite)reflectionGroup, 0, "Constant");
        this.intensityConstantFloatText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.lorentzFactorButton = new Button((Composite)reflectionGroup, 32);
        this.lorentzFactorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.lorentzFactorButton.setText("Apply Lorentz factor");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.lorentzFactorButton.setLayoutData((Object)gd);
        this.polarisationButton = new Button((Composite)reflectionGroup, 32);
        this.polarisationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.polarisationButton.setText("Apply beam polarisation");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.polarisationButton.setLayoutData((Object)gd);
        Group diffractionPeaksGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Diffraction peaks", (int)2, (int)1);
        this.gridLayout = (GridLayout)diffractionPeaksGroup.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        diffractionPeaksGroup.setLayout((Layout)this.gridLayout);
        Composite peakTypeComposite = new Composite((Composite)diffractionPeaksGroup, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 2;
        peakTypeComposite.setLayoutData((Object)gd);
        peakTypeComposite.setLayout((Layout)this.gridLayout);
        Label peakTypeLabel = new Label(peakTypeComposite, 0x1000000);
        peakTypeLabel.setText("Peak type");
        this.peakTypeCombo = new Combo(peakTypeComposite, 8);
        this.peakTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.enableGaussianOrSpikeType();
            }
        });
        this.peakTypeCombo.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.peakTypeCombo.add("Spike 2x2 pixels");
        this.peakTypeCombo.add("Gaussian");
        this.peakTypeCombo.add("ODF");
        this.peakTypeCombo.select(0);
        this.gaussianPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Gaussian peak parameters", (int)2, (int)1);
        this.gaussianPeakGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.gaussianPeakPixelsFloatText = new FloatText((Composite)this.gaussianPeakGroup, 0, "FWHM (pixels)");
        this.gaussianPeakPixelsFloatText.set_isRequiredField(true);
        this.gaussianPeakPixelsFloatText.setToolTipText("Gaussian peak spread in pixels");
        this.gaussianPeakPixelsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.gaussianPeakPixelsFloatText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gaussianPeakDegreesFloatText = new FloatText((Composite)this.gaussianPeakGroup, 0, "FWHM in \u03c9-direction (deg)");
        this.gaussianPeakDegreesFloatText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.gaussianPeakDegreesFloatText.set_isRequiredField(true);
        this.gaussianPeakDegreesFloatText.setToolTipText("Guassian peak spread in degrees");
        this.gaussianPeakDegreesFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.odfPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Orientation distribution function", (int)3, (int)1);
        this.odfPeakGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.odfTypeCombo = new Combo((Composite)this.odfPeakGroup, 8);
        this.odfTypeCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        this.odfTypeCombo.add("isotropic Gaussian");
        this.odfTypeCombo.add("grid from file");
        this.odfTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int odf_type_value = InputEditor.this.getComboOdfTypeValue();
                InputEditor.this.enableMosaicity(odf_type_value == 1);
                InputEditor.this.enableODF(odf_type_value == 2);
                InputEditor.this.handleModify();
            }
        });
        this.odfFile = new StringText((Composite)this.odfPeakGroup, 0, "ODF file");
        this.odfFile.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.odfFile.setToolTipText("ODF file grid");
        this.odfFile.setLayoutData((Object)new GridData(4, 16, true, true));
        this.odfFileBrowseButton = new Button((Composite)this.odfPeakGroup, 8);
        this.odfFileBrowseButton.setText("Browse");
        this.odfFileBrowseButton.setToolTipText("Browse ODF file");
        this.odfFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                fileDialog.setText("Select an existing structure file");
                String file = fileDialog.open();
                if (file != null) {
                    InputEditor.this.handleModify();
                    InputEditor.this.odfFile.set_Text(file);
                }
            }
        });
        this.odfFile.setEnabled(false);
        this.odfFileBrowseButton.setEnabled(false);
        new Label((Composite)this.odfPeakGroup, 0);
        this.mosaicity = new FloatText((Composite)this.odfPeakGroup, 0, "Mosaicity (degrees)");
        this.mosaicity.set_isRequiredField(true);
        this.mosaicity.setToolTipText("Mosaicity in degrees");
        this.mosaicity.setLayoutData((Object)new GridData(4, 16, true, true));
        this.mosaicity.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
    }

    protected void enableGaussianOrSpikeType() {
        boolean enable = this.peakTypeCombo.getText().equals("Gaussian");
        this.gaussianPeakDegreesFloatText.setEnabled(enable);
        this.gaussianPeakPixelsFloatText.setEnabled(enable);
        boolean enableOdf = this.peakTypeCombo.getText().equals("ODF");
        this.odfFile.setEnabled(enableOdf);
        this.odfFileBrowseButton.setEnabled(enableOdf);
        this.mosaicity.setEnabled(enableOdf);
        this.odfTypeCombo.setEnabled(enableOdf);
        int odf_type_value = this.getComboOdfTypeValue();
        this.enableMosaicity(enableOdf && odf_type_value == 1);
        this.enableODF(enableOdf && odf_type_value == 2);
    }

    private void enableMosaicity(boolean enable) {
        this.mosaicity.setEnabled(enable);
        this.mosaicity.set_isRequiredField(enable);
    }

    private void enableODF(boolean enable) {
        this.odfFile.setEnabled(enable);
        this.odfFile.set_isRequiredField(enable);
        this.odfFile.showDecoration();
        this.odfFileBrowseButton.setEnabled(enable);
    }

    public void createInstrumentalTab() {
        this.tabItem[4].setText("Instrumental");
        Group beamGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam", (int)4, (int)1);
        GridData gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 3;
        Label wavelengthLabel = new Label((Composite)beamGroup, 0);
        wavelengthLabel.setText("Wavelength (\u00c5)");
        this.wavelength = new FloatText((Composite)beamGroup, 0, "");
        this.wavelength.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.wavelength.set_isRequiredField(true);
        this.wavelength.setToolTipText("wavelength in Angstrom");
        gd.minimumWidth = 180;
        this.wavelength.setLayoutData((Object)gd);
        new Label((Composite)beamGroup, 0).setText("Beam width (mm)");
        this.beam_width = new FloatText((Composite)beamGroup, 0, "");
        this.beam_width.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 3;
        gd.minimumWidth = 180;
        this.beam_width.setLayoutData((Object)gd);
        this.beam_width.setToolTipText("If no beam width is specified \nit is assumed that the entire sample width is illuminated");
        Label fluxLabel = new Label((Composite)beamGroup, 0);
        fluxLabel.setText("Flux (ph/s/mm2)");
        this.beamflux = new FloatText((Composite)beamGroup, 0, "");
        gd = new GridData(16384, 4, true, false);
        gd.minimumWidth = 180;
        gd.horizontalSpan = 3;
        this.beamflux.setLayoutData((Object)gd);
        this.beamflux.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.beamflux.set_isRequiredField(true);
        Label polarisationFactorLabel = new Label((Composite)beamGroup, 0);
        polarisationFactorLabel.setText("Polarisation factor");
        this.beampol_factor = new FloatText((Composite)beamGroup, 0, "");
        this.beampol_factor.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.beampol_factor.set_isRequiredField(true);
        this.beampol_factor.setToolTipText("polarisation factor in percent");
        gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 3;
        gd.minimumWidth = 180;
        this.beampol_factor.setLayoutData((Object)gd);
        Label polarisationDirectionLabel = new Label((Composite)beamGroup, 0);
        polarisationDirectionLabel.setText("Polarisation direction (degrees)");
        this.beampol_direct = new FloatText((Composite)beamGroup, 0, "");
        this.beampol_direct.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.beampol_direct.set_isRequiredField(true);
        this.beampol_direct.setToolTipText("polarisation direction in degrees");
        gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 3;
        gd.minimumWidth = 180;
        this.beampol_direct.setLayoutData((Object)gd);
        Group beamCenterGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam center on detector", (int)2, (int)1);
        Label beamCenterYLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterYLabel.setText("Y beam (pixels)");
        this.dety_center = new FloatText((Composite)beamCenterGroup, 0, "");
        this.dety_center.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.dety_center.set_isRequiredField(true);
        this.dety_center.setToolTipText("Y beamcenter in pixel coordinates");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        this.dety_center.setLayoutData((Object)gd);
        Label beamCenterZLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterZLabel.setText("Z beam (pixels)");
        this.detz_center = new FloatText((Composite)beamCenterGroup, 0, "");
        this.detz_center.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.detz_center.set_isRequiredField(true);
        this.detz_center.setToolTipText("Z beamcenter in pixel coordinates");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        this.detz_center.setLayoutData((Object)gd);
        Group omegaGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Rotation axis", (int)6, (int)2);
        GridLayout gridLayout = (GridLayout)omegaGroup.getLayout();
        gridLayout.makeColumnsEqualWidth = false;
        Label omegaDirectionLabel = new Label((Composite)omegaGroup, 0);
        omegaDirectionLabel.setText("Direction (+/-)");
        this.omega_sign = new Combo((Composite)omegaGroup, 8);
        gd = new GridData(16384, 16, true, true);
        gd.horizontalSpan = 5;
        gd.horizontalIndent = 20;
        this.omega_sign.setLayoutData((Object)gd);
        this.omega_sign.add("cw");
        this.omega_sign.add("ccw");
        this.omega_sign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        new Label((Composite)omegaGroup, 0).setText("Wedge (degrees)");
        this.wedge = new FloatText((Composite)omegaGroup, 0, "");
        this.wedge.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.wedge.set_isRequiredField(true);
        this.wedge.setToolTipText("Angle between beam and rotation axis minus 90 in degrees");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        gd.horizontalSpan = 5;
        this.wedge.setLayoutData((Object)gd);
        new Label((Composite)omegaGroup, 0).setText("Start (degrees)");
        this.omega_start = new FloatText((Composite)omegaGroup, 0, "");
        this.omega_start.set_isRequiredField(true);
        this.omega_start.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.omega_start.setToolTipText("Minimum rotation angle in degrees");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        this.omega_start.setLayoutData((Object)gd);
        new Label((Composite)omegaGroup, 0).setText("End (degrees)");
        this.omega_end = new FloatText((Composite)omegaGroup, 0, "");
        this.omega_end.set_isRequiredField(true);
        this.omega_end.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.omega_end.setToolTipText("Maximum rotation angle in degrees");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        this.omega_end.setLayoutData((Object)gd);
        new Label((Composite)omegaGroup, 0).setText("Step (degrees)");
        this.omega_step = new FloatText((Composite)omegaGroup, 0, "");
        this.omega_step.set_isRequiredField(true);
        this.omega_step.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.omega_step.setToolTipText("Rotation angle step size in degrees");
        gd = new GridData(16, 16, true, false);
        gd.minimumWidth = 180;
        this.omega_step.setLayoutData((Object)gd);
    }

    public void createDetectorTab() {
        this.tabItem[5].setText("Detector");
        container[5].setLayout((Layout)new GridLayout(2, true));
        Composite detectorDistanceComposite = new Composite(container[5], 0);
        GridLayout detectorDistanceLayout = new GridLayout();
        detectorDistanceLayout.makeColumnsEqualWidth = true;
        GridData gd = new GridData(4, 16, true, false);
        gd.horizontalSpan = 2;
        detectorDistanceComposite.setLayout((Layout)detectorDistanceLayout);
        detectorDistanceComposite.setLayoutData((Object)gd);
        this.distance = new FloatText(detectorDistanceComposite, 16384, "Sample to detector distance (mm)");
        this.distance.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.distance.set_isRequiredField(true);
        this.distance.setToolTipText("sample-detector distance in mm");
        GridData gdText = new GridData(16, 16, true, false);
        gdText.minimumWidth = 180;
        this.distance.getTextField().setLayoutData((Object)gdText);
        this.distance.setLayoutData((Object)gdText);
        Group detectorSizeGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector size", (int)4, (int)1);
        this.gridLayout = (GridLayout)detectorSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        Label detSizeYLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeYLabel.setText("Y size (pixels)");
        this.dety_size = new FloatText((Composite)detectorSizeGroup, 0, "");
        this.dety_size.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.dety_size.set_isRequiredField(true);
        this.dety_size.setToolTipText("Y detector size in pixels");
        this.dety_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Label detSizeZLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeZLabel.setText("Z size (pixels)");
        this.detz_size = new FloatText((Composite)detectorSizeGroup, 0, "");
        this.detz_size.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.detz_size.set_isRequiredField(true);
        this.detz_size.setToolTipText("Z detector size in pixels");
        this.detz_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Group pixelSizeGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Pixel size", (int)4, (int)1);
        this.gridLayout = (GridLayout)pixelSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        Label pixelSizeYLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeYLabel.setText("Y pixel (mm)");
        this.y_size = new FloatText((Composite)pixelSizeGroup, 0, "");
        this.y_size.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.y_size.set_isRequiredField(true);
        this.y_size.setToolTipText("Y pixel size in mm");
        this.y_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Label pixelSizeZLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeZLabel.setText("Z pixel (mm)");
        this.z_size = new FloatText((Composite)pixelSizeGroup, 0, "");
        this.z_size.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.z_size.set_isRequiredField(true);
        this.z_size.setToolTipText("Z pixel size in mm");
        this.z_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Group detectorTiltGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector tilt", (int)6, (int)1);
        this.gridLayout = (GridLayout)detectorTiltGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = false;
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        detectorTiltGroup.setLayoutData((Object)gd);
        Label detTiltXLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltXLabel.setText("X tilt (radians)");
        this.tilt_x = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_x.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.tilt_x.set_isRequiredField(true);
        this.tilt_x.setToolTipText("detector tilt counterclockwise around lab x axis in radians");
        this.tilt_x.setLayoutData((Object)new GridData(4, 16, true, false));
        Label detTiltYLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltYLabel.setText("Y tilt (radians)");
        this.tilt_y = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_y.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.tilt_y.set_isRequiredField(true);
        this.tilt_y.setToolTipText("detector tilt counterclockwise around lab y axis in radians");
        this.tilt_y.setLayoutData((Object)new GridData(4, 16, true, false));
        Label detTiltZLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltZLabel.setText("Z tilt (radians)");
        this.tilt_z = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_z.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        this.tilt_z.set_isRequiredField(true);
        this.tilt_z.setToolTipText("Detector tilt counterclockwise around lab z axis in radians");
        this.tilt_z.setLayoutData((Object)new GridData(4, 16, true, false));
        Group detectorOrientationGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector orientation", (int)6, (int)1);
        this.gridLayout = (GridLayout)detectorOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        gd = new GridData(4, 16, true, false);
        gd.horizontalSpan = 2;
        detectorOrientationGroup.setLayoutData((Object)gd);
        Label orientLabel = new Label((Composite)detectorOrientationGroup, 0);
        orientLabel.setText("O parameters");
        this.orientCombo = new Combo((Composite)detectorOrientationGroup, 12);
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        String[] items = new String[8];
        int i = 0;
        while (i < 8) {
            items[i] = orientNames[i];
            ++i;
        }
        this.orientCombo.setItems(items);
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.select(0);
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                idxOrientation = InputEditor.this.orientCombo.getSelectionIndex();
            }
        });
        Group detectorDefectsGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector defects", (int)4, (int)1);
        this.gridLayout = (GridLayout)detectorDefectsGroup.getLayout();
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        detectorDefectsGroup.setLayoutData((Object)gd);
        this.noise = new Button((Composite)detectorDefectsGroup, 32);
        this.noise.setText("Noise");
        this.noise.setToolTipText("Add Poissonian to images during simulation");
        this.noise.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.noise.setLayoutData((Object)gd);
        this.addBckgrdButton = new Button((Composite)detectorDefectsGroup, 32);
        this.addBckgrdButton.setText("Background");
        this.addBckgrdButton.setToolTipText("Add background to images during simulation");
        this.addBckgrdButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.addBckgrdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.bg.getTextField().setEnabled(InputEditor.this.addBckgrdButton.getSelection());
                InputEditor.this.bg.set_isRequiredField(InputEditor.this.addBckgrdButton.getSelection());
            }
        });
        new Label((Composite)detectorDefectsGroup, 0).setText("Counts");
        this.bg = new FloatText((Composite)detectorDefectsGroup, 0, "");
        this.bg.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gd = new GridData(16, 16, true, false);
        gd.horizontalSpan = 2;
        gd.minimumWidth = 180;
        this.bg.setLayoutData((Object)gd);
        this.psfButton = new Button((Composite)detectorDefectsGroup, 32);
        this.psfButton.setText("Point spread");
        this.psfButton.setToolTipText("Add point spread function to images during simulation");
        this.psfButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.psf.getTextField().setEnabled(InputEditor.this.psfButton.getSelection());
                InputEditor.this.psf.set_isRequiredField(InputEditor.this.psfButton.getSelection());
            }
        });
        new Label((Composite)detectorDefectsGroup, 0).setText("FWHM (pixels)");
        this.psf = new FloatText((Composite)detectorDefectsGroup, 0, "");
        this.psf.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gd = new GridData(16, 16, true, false);
        gd.horizontalSpan = 2;
        gd.minimumWidth = 180;
        this.psf.setLayoutData((Object)gd);
        this.spatialDistortionButton = new Button((Composite)detectorDefectsGroup, 32);
        this.spatialDistortionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputEditor.this.handleModify();
                InputEditor.this.spatial.getTextField().setEnabled(InputEditor.this.spatialDistortionButton.getSelection());
                InputEditor.this.spatial.set_isRequiredField(InputEditor.this.spatialDistortionButton.getSelection());
            }
        });
        this.spatialDistortionButton.setText("Spatial distortion");
        this.spatialDistortionButton.setToolTipText("Add spatial distortion to images during simulation");
        new Label((Composite)detectorDefectsGroup, 0).setText("Spline file");
        this.spatial = new StringText((Composite)detectorDefectsGroup, 0, "");
        this.spatial.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputEditor.this.handleModify();
            }
        });
        gd = new GridData(4, 16, true, false);
        this.spatial.setLayoutData((Object)gd);
        Button spatialDistortionBrowseButton = new Button((Composite)detectorDefectsGroup, 0);
        spatialDistortionBrowseButton.setText("Browse");
        spatialDistortionBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                fileDialog.setText("Select an existing structure file");
                String file = fileDialog.open();
                if (file != null) {
                    InputEditor.this.handleModify();
                    InputEditor.this.spatial.set_Text(file);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = InputEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)InputEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(InputEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
        if (event.getType() == 1 && event.getSource() != this) {
            IFileEditorInput fileInput = null;
            IPath path = null;
            IResourceDelta delta = null;
            IResource res = null;
            if (this.getEditorInput() != null && this.getEditorInput() instanceof IFileEditorInput) {
                fileInput = (IFileEditorInput)this.getEditorInput();
                path = fileInput.getFile().getFullPath();
            }
            if (path != null) {
                delta = event.getDelta().findMember(path);
            }
            if (delta != null) {
                res = delta.getResource();
            }
            if (res != null) {
                int kind = delta.getKind();
                if (kind == 2) {
                    final IFileEditorInput input = fileInput;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage[] pages = InputEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                IEditorPart editorPart = pages[i].findEditor((IEditorInput)input);
                                pages[i].closeEditor(editorPart, true);
                                ++i;
                            }
                        }
                    });
                } else {
                    SWTUtils.infoMsgAsync((String)("Got POST_CHANGE [" + delta.getKind() + "] for " + path.toOSString()));
                    this.polyXSim.reload();
                }
            }
        }
    }

    private void disposeAllUnitCellWidgets() {
        if (this.unit_cell_phase_a != null) {
            this.unitCell = new Float[this.numPhases * 7];
            int i = 0;
            while (i < this.unit_cell_phase_a.length) {
                if ((i + 1) * 7 <= this.unitCell.length) {
                    if (!this.unit_cell_phase_a[i].isDisposed() && this.unit_cell_phase_a[i] != null && this.unit_cell_phase_a[i].getText().length() > 0) {
                        this.unitCell[i * 7] = Float.valueOf(this.unit_cell_phase_a[i].getText());
                    }
                    if (!this.unit_cell_phase_b[i].isDisposed() && this.unit_cell_phase_b[i] != null && this.unit_cell_phase_b[i].getText().length() > 0) {
                        this.unitCell[i * 7 + 1] = Float.valueOf(this.unit_cell_phase_b[i].getText());
                    }
                    if (!this.unit_cell_phase_c[i].isDisposed() && this.unit_cell_phase_c[i] != null && this.unit_cell_phase_c[i].getText().length() > 0) {
                        this.unitCell[i * 7 + 2] = Float.valueOf(this.unit_cell_phase_c[i].getText());
                    }
                    if (!this.unit_cell_phase_alpha[i].isDisposed() && this.unit_cell_phase_alpha[i] != null && this.unit_cell_phase_alpha[i].getText().length() > 0) {
                        this.unitCell[i * 7 + 3] = Float.valueOf(this.unit_cell_phase_alpha[i].getText());
                    }
                    if (!this.unit_cell_phase_beta[i].isDisposed() && this.unit_cell_phase_beta[i] != null && this.unit_cell_phase_beta[i].getText().length() > 0) {
                        this.unitCell[i * 7 + 4] = Float.valueOf(this.unit_cell_phase_beta[i].getText());
                    }
                    if (!this.unit_cell_phase_gamma[i].isDisposed() && this.unit_cell_phase_gamma[i] != null && this.unit_cell_phase_gamma[i].getText().length() > 0) {
                        this.unitCell[i * 7 + 5] = Float.valueOf(this.unit_cell_phase_gamma[i].getText());
                    }
                    try {
                        if (!this.sgno_phase[i].isDisposed() && this.sgno_phase[i].getText() != null && this.sgno_phase[i].getText().length() > 0) {
                            this.unitCell[i * 7 + 6] = Float.valueOf(this.sgno_phase[i].getText());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.unit_cell_phase_a[i].dispose();
                this.unit_cell_phase_b[i].dispose();
                this.unit_cell_phase_c[i].dispose();
                this.unit_cell_phase_alpha[i].dispose();
                this.unit_cell_phase_beta[i].dispose();
                this.unit_cell_phase_gamma[i].dispose();
                this.sgno_phase[i].dispose();
                this.unitCellSpaceGroupHelpBtn[i].dispose();
                ++i;
            }
            this.unit_cell_phase_a = null;
            this.unit_cell_phase_b = null;
            this.unit_cell_phase_c = null;
            this.unit_cell_phase_alpha = null;
            this.unit_cell_phase_beta = null;
            this.unit_cell_phase_gamma = null;
            this.sgno_phase = null;
            this.unitCellSpaceGroupHelpBtn = null;
        }
    }

    public void dispose() {
        this.disposeAllUnitCellWidgets();
        this.diposeStructureFileGroup();
        this.polyXSim.removePolyXSimListener(this.polyxsimListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void getInputValues() {
        String epsgrain;
        this.wavelength.set_Text(String.valueOf(this.polyXSim.getWavelength()));
        if (this.polyXSim.getBeamWidth() != null) {
            this.beam_width.setText(this.polyXSim.getBeamWidth());
        }
        if (this.polyXSim.getFlux() != null) {
            this.beamflux.set_Text("" + this.polyXSim.getFlux());
        }
        this.beampol_factor.set_Text(Float.toString(this.polyXSim.getPolarisationFactor()));
        this.beampol_direct.set_Text(Float.toString(this.polyXSim.getPolarisationDirection()));
        this.dety_center.set_Text(Float.toString(this.polyXSim.getDetyCenter().floatValue()));
        this.detz_center.set_Text(Float.toString(this.polyXSim.getDetzCenter().floatValue()));
        this.y_size.set_Text(Float.toString(this.polyXSim.getYSize().floatValue()));
        this.z_size.set_Text(Float.toString(this.polyXSim.getZSize().floatValue()));
        this.dety_size.set_Text(Float.toString(this.polyXSim.getDetySize().floatValue()));
        this.detz_size.set_Text(Float.toString(this.polyXSim.getDetzSize().floatValue()));
        this.distance.set_Text(Float.toString(this.polyXSim.getDistance().floatValue()));
        this.tilt_x.set_Text(Float.toString(this.polyXSim.getDetTiltX().floatValue()));
        this.tilt_y.set_Text(Float.toString(this.polyXSim.getDetTiltY().floatValue()));
        this.tilt_z.set_Text(Float.toString(this.polyXSim.getDetTiltZ().floatValue()));
        Integer[] detOrientation = this.polyXSim.getDetOrientation();
        if (detOrientation != null && detOrientation.length < 4 && detOrientation.length > 0 && detOrientation[0] != null && detOrientation[1] != null && detOrientation[2] != null && detOrientation[3] != null) {
            idxOrientation = 0;
        }
        boolean match = false;
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 4) {
                match = true;
                if (detOrientation[j] != orientParams[i][j]) {
                    match = false;
                    break;
                }
                ++j;
            }
            if (match) {
                idxOrientation = i;
            }
            ++i;
        }
        this.orientCombo.select(idxOrientation);
        this.wedge.set_Text(Float.toString(this.polyXSim.getWedge()));
        this.omega_start.set_Text(Float.toString(this.polyXSim.getOmegaStart().floatValue()));
        this.omega_end.set_Text(Float.toString(this.polyXSim.getOmegaEnd().floatValue()));
        this.omega_step.set_Text(Float.toString(this.polyXSim.getOmegaStep().floatValue()));
        int omegaSign = this.polyXSim.getOmegaSign();
        if (omegaSign == -1) {
            this.omega_sign.select(1);
        } else {
            this.omega_sign.select(0);
        }
        this.no_grains.set_Text(Integer.toString(this.polyXSim.getNoGrains()));
        int grainOrientation = this.polyXSim.getGenGrainOrientation();
        this.gen_U.setSelection(grainOrientation == 1);
        if (!this.polyXSim.getGen_sizeFlag()) {
            this.gen_size.select(0);
        }
        this.enableSampleShape(this.polyXSim.getSampleIsCube(), this.polyXSim.getSampleIsCylinder());
        if (this.polyXSim.getSampleIsCube()) {
            Float[] sampleXyz = this.polyXSim.getSampleXyz();
            if (sampleXyz != null) {
                if (sampleXyz[0] != null) {
                    this.sample_xyz_X.set_Text(Float.toString(sampleXyz[0].floatValue()));
                }
                if (sampleXyz[1] != null) {
                    this.sample_xyz_Y.set_Text(Float.toString(sampleXyz[1].floatValue()));
                }
                if (sampleXyz[2] != null) {
                    this.sample_xyz_Z.set_Text(Float.toString(sampleXyz[2].floatValue()));
                }
            }
            this.sampleShapeCombo.setText(BOX);
        } else if (this.polyXSim.getSampleIsCylinder()) {
            Float[] sampleCyl = this.polyXSim.getSampleCyl();
            if (sampleCyl != null) {
                if (sampleCyl[0] != null) {
                    this.sample_cyl_height.set_Text(Float.toString(sampleCyl[0].floatValue()));
                }
                if (sampleCyl[1] != null) {
                    this.sample_cyl_diameter.set_Text(Float.toString(sampleCyl[1].floatValue()));
                }
            }
            this.sampleShapeCombo.setText(CYLINDER);
        }
        this.numPhases = this.polyXSim.getNumPhases();
        this.no_phases.set_Text(Integer.toString(this.numPhases));
        this.phases = this.polyXSim.getPhases();
        this.phaseGrains = this.polyXSim.getPhaseGrains();
        this.phaseGrainSize = this.polyXSim.getPhaseGrainSize();
        this.phaseGrainMinSize = this.polyXSim.getPhaseGrainMinSize();
        this.phaseGrainMaxSize = this.polyXSim.getPhaseGrainMaxSize();
        if (!this.polyXSim.getGen_sizeFlag()) {
            this.gen_size.select(0);
        }
        this.size_grains.set_Text(this.polyXSim.getSize_grains());
        this.gen_size_min.set_Text(String.valueOf(this.polyXSim.getGrainMinSize()));
        this.gen_size_max.set_Text(String.valueOf(this.polyXSim.getGrainMaxSize()));
        this.gen_size_median.set_Text(String.valueOf(this.polyXSim.getGrainSize()));
        boolean check = false;
        if (String.valueOf(this.polyXSim.getGrainMinSize()).length() > 0 && String.valueOf(this.polyXSim.getGrainMaxSize()).length() > 0 && String.valueOf(this.polyXSim.getGrainSize()).length() > 0) {
            this.gen_size.select(1);
        }
        this.createSizePhase();
        int i2 = 0;
        while (i2 < this.numPhases) {
            if (this.polyXSim.getPhaseGrainSizeflag() != null && this.polyXSim.getPhaseGrainSizeflag()[i2] != null) {
                this.gen_size_phase_flag[i2].setSelection(this.polyXSim.getPhaseGrainSizeflag()[i2] == 1);
                check = true;
            }
            if (this.polyXSim.getPhaseGrainSize() != null && this.polyXSim.getPhaseGrainSize()[i2] != null) {
                this.gen_size_phase_x[i2].setText(String.valueOf(this.polyXSim.getPhaseGrainSize()[i2]));
            }
            if (this.polyXSim.getPhaseGrainMinSize() != null && this.polyXSim.getPhaseGrainMinSize()[i2] != null) {
                this.gen_size_phase_x_min[i2].setText(String.valueOf(this.polyXSim.getPhaseGrainMinSize()[i2]));
            }
            if (this.polyXSim.getPhaseGrainMaxSize() != null && this.polyXSim.getPhaseGrainMaxSize()[i2] != null) {
                this.gen_size_phase_x_min[i2].setText(String.valueOf(this.polyXSim.getPhaseGrainMaxSize()[i2]));
            }
            ++i2;
        }
        if (check) {
            this.gen_size.select(2);
        }
        if (this.polyXSim.getSize_grains().length() > 0) {
            this.gen_size.select(3);
        }
        if (this.polyXSim.getGen_eps_flag() == 0) {
            this.gen_eps.select(0);
        }
        Float value = this.polyXSim.getGen_eps_meanValuefordiagonal();
        boolean valueHasBeenSet = false;
        Float totalValue = value;
        if (value != null) {
            valueHasBeenSet = true;
            this.gen_eps_meanDiag.setText(String.valueOf(value));
        }
        value = this.polyXSim.getGen_eps_spread_value();
        totalValue = Float.valueOf(totalValue.floatValue() + value.floatValue());
        if (value != null) {
            valueHasBeenSet = true;
            this.gen_eps_spreadDiag.setText(String.valueOf(value));
        }
        value = this.polyXSim.getGen_eps_meanValueforOffDiagonal();
        totalValue = Float.valueOf(totalValue.floatValue() + value.floatValue());
        if (value != null) {
            valueHasBeenSet = true;
            this.gen_eps_meanOffDiag.setText(String.valueOf(value));
        }
        value = this.polyXSim.getGen_eps_spread_valueforOffDiagonal();
        totalValue = Float.valueOf(totalValue.floatValue() + value.floatValue());
        if (value != null) {
            valueHasBeenSet = true;
            this.gen_eps_spreadOffDiag.setText(String.valueOf(value));
        }
        if (valueHasBeenSet && this.polyXSim.getGen_eps_flag() == 1) {
            if (totalValue.floatValue() > 0.0f || totalValue.floatValue() < 0.0f) {
                this.gen_eps.select(2);
            } else {
                this.gen_eps.select(1);
            }
        }
        this.createEpsphaseGrains();
        valueHasBeenSet = false;
        int i3 = 0;
        while (i3 < this.numPhases && this.polyXSim.isHasGen_eps_phase()) {
            if (this.polyXSim.getGen_eps_Flag_phase_y() != null) {
                this.gen_eps_random[i3].setSelection(this.polyXSim.getGen_eps_Flag_phase_y()[i3] == 1);
                valueHasBeenSet = true;
            }
            if (this.polyXSim.getGen_eps_meanValuefordiagonal_y() != null && this.polyXSim.getGen_eps_meanValuefordiagonal_y()[i3] != null) {
                this.gen_eps_meanDiag_Y[i3].setText(String.valueOf(this.polyXSim.getGen_eps_meanValuefordiagonal_y()[i3]));
            }
            if (this.polyXSim.getGen_eps_spread_value_y() != null && this.polyXSim.getGen_eps_spread_value_y()[i3] != null) {
                this.gen_eps_spreadDiag_Y[i3].setText(String.valueOf(this.polyXSim.getGen_eps_spread_value_y()[i3]));
            }
            if (this.polyXSim.getGen_eps_meanValueforOffDiagonal_y() != null && this.polyXSim.getGen_eps_meanValueforOffDiagonal_y()[i3] != null) {
                this.gen_eps_meanoffDiag_Y[i3].setText(String.valueOf(this.polyXSim.getGen_eps_meanValueforOffDiagonal_y()[i3]));
            }
            if (this.polyXSim.getGen_eps_spread_valueforOffDiagonal_y() != null && this.polyXSim.getGen_eps_spread_valueforOffDiagonal_y()[i3] != null) {
                this.gen_eps_spreadoffDiag_Y[i3].setText(String.valueOf(this.polyXSim.getGen_eps_spread_valueforOffDiagonal_y()[i3]));
            }
            ++i3;
        }
        if (valueHasBeenSet && this.polyXSim.getGen_eps_flag() == 1) {
            this.gen_eps.select(3);
        }
        if ((epsgrain = this.polyXSim.getEps_grains()) != null) {
            this.eps_grains.set_Text(this.polyXSim.getEps_grains());
        }
        if (this.polyXSim.getEps_grains().trim().length() > 0 && this.polyXSim.getGen_eps_flag() == 1) {
            this.gen_eps.select(4);
        }
        if (this.polyXSim.getStructureFile(0) != null) {
            this.structureFileButton.setSelection(true);
            this.structureCellButton.setSelection(false);
        } else {
            this.structureFileButton.setSelection(false);
            this.structureCellButton.setSelection(true);
        }
        this.crystalTabShowUnitCellOrStructurePhase();
        this.unitCell = new Float[this.numPhases * 7];
        int i4 = 0;
        while (i4 < this.polyXSim.getNumPhases()) {
            this.unitCell[i4 * 7] = this.polyXSim.getUnitCellA()[i4];
            this.unitCell[i4 * 7 + 1] = this.polyXSim.getUnitCellB()[i4];
            this.unitCell[i4 * 7 + 2] = this.polyXSim.getUnitCellC()[i4];
            this.unitCell[i4 * 7 + 3] = this.polyXSim.getUnitCellAlpha()[i4];
            this.unitCell[i4 * 7 + 4] = this.polyXSim.getUnitCellBeta()[i4];
            this.unitCell[i4 * 7 + 5] = this.polyXSim.getUnitCellGamma()[i4];
            if (this.polyXSim.getUnitCellSpaceGroup()[i4] != null) {
                this.unitCell[i4 * 7 + 6] = Float.valueOf(this.polyXSim.getUnitCellSpaceGroup()[i4].intValue());
            }
            if (this.structureCellButton.getSelection()) {
                if (this.polyXSim.getUnitCellA() != null && this.polyXSim.getUnitCellA()[i4] != null) {
                    this.unit_cell_phase_a[i4].set_Text(Float.toString(this.polyXSim.getUnitCellA()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellB() != null && this.polyXSim.getUnitCellB()[i4] != null) {
                    this.unit_cell_phase_b[i4].set_Text(Float.toString(this.polyXSim.getUnitCellB()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellC() != null && this.polyXSim.getUnitCellC()[i4] != null) {
                    this.unit_cell_phase_c[i4].set_Text(Float.toString(this.polyXSim.getUnitCellC()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellAlpha() != null && this.polyXSim.getUnitCellAlpha()[i4] != null) {
                    this.unit_cell_phase_alpha[i4].set_Text(Float.toString(this.polyXSim.getUnitCellAlpha()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellBeta() != null && this.polyXSim.getUnitCellBeta()[i4] != null) {
                    this.unit_cell_phase_beta[i4].set_Text(Float.toString(this.polyXSim.getUnitCellBeta()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellGamma() != null && this.polyXSim.getUnitCellGamma()[i4] != null) {
                    this.unit_cell_phase_gamma[i4].set_Text(Float.toString(this.polyXSim.getUnitCellGamma()[i4].floatValue()));
                }
                if (this.polyXSim.getUnitCellSpaceGroup() != null && this.polyXSim.getUnitCellSpaceGroup()[i4] != null) {
                    this.sgno_phase[i4].set_Text(Integer.toString(this.polyXSim.getUnitCellSpaceGroup()[i4]));
                }
            }
            if (this.polyXSim.getStructureFile(i4) != null) {
                this.structureFiles[i4] = this.polyXSim.getStructureFile(i4);
                if (this.structureFileButton.getSelection()) {
                    this.structure_phase[i4].set_Text(this.polyXSim.getStructureFile(i4));
                }
            }
            this.createNumberOfGrainsPerPhase();
            if (this.phases[i4] != null) {
                this.phaseLabel[i4].setText("Phase " + this.phases[i4]);
            }
            if (this.phaseGrains[i4] != null) {
                this.no_grains_phase_Y[i4].set_Text(Integer.toString(this.phaseGrains[i4]));
            }
            if (this.phaseGrainSize[i4] != null) {
                this.gen_size_phase_flag[i4].setSelection(this.polyXSim.getPhaseGrainSizeflag()[i4] == 1);
            }
            if (this.phaseGrainSize[i4] != null) {
                this.gen_size_phase_x[i4].set_Text(Float.toString(Math.abs(this.phaseGrainSize[i4].floatValue())));
            }
            Float cfr_ignored_0 = this.phaseGrainMinSize[i4];
            if (this.phaseGrainMinSize[i4] != null) {
                this.gen_size_phase_x_min[i4].set_Text(Float.toString(this.phaseGrainMinSize[i4].floatValue()));
            }
            if (this.phaseGrainMaxSize[i4] != null && this.phaseGrainMaxSize[i4] != null) {
                this.gen_size_phase_x_max[i4].set_Text(Float.toString(this.phaseGrainMaxSize[i4].floatValue()));
            }
            ++i4;
        }
        int makeImages = this.polyXSim.getMakeImages();
        this.imageFlagButton.setSelection(makeImages == 1);
        String fileFormat = this.polyXSim.getFormat();
        if (fileFormat.indexOf("edf") >= 0) {
            this.fileFormatCombo.setText("edf");
        } else if (fileFormat.indexOf("tif16") >= 0) {
            this.fileFormatCombo.setText("tif16bit");
        } else {
            this.fileFormatCombo.setText("tif");
        }
        String dirName = this.polyXSim.getOutputDirectory();
        dirName = String.valueOf(dirName) + File.separator + this.polyXSim.getPrefix();
        this.imageStemFileText.set_Text(this.polyXSim.getPrefix());
        int noisevalue = this.polyXSim.getNoise();
        this.noise.setSelection(noisevalue == 1);
        int psfval = this.polyXSim.getPsf();
        this.psfButton.setSelection(psfval > 0);
        this.psf.setText(String.valueOf(psfval));
        if (this.polyXSim.getPeakShape() != null) {
            this.peakTypeCombo.select(this.polyXSim.getPeakShape().intValue());
        }
        this.bg.set_Text(Integer.toString(this.polyXSim.getBackground()));
        this.outputFltButton.setSelection(this.polyXSim.getOutputFlt());
        this.outputGveButton.setSelection(this.polyXSim.getOutputGve());
        this.outputUbiButton.setSelection(this.polyXSim.getOutputUbi());
        this.outputParButton.setSelection(this.polyXSim.getOutputPar());
        this.mosaicity.set_Text(Float.toString(this.polyXSim.getMosaicity()));
        this.beampol_direct.set_Text(Float.toString(this.polyXSim.getPolarisationDirection()));
        this.polarisationButton.setSelection(this.polyXSim.getPolarisation());
        this.lorentzFactorButton.setSelection(this.polyXSim.getLorentzFactor());
        Float[] peakParameters = this.polyXSim.getPeakParameters();
        if (peakParameters[0] != null) {
            this.gaussianPeakPixelsFloatText.set_Text(peakParameters[0].toString());
        }
        if (peakParameters[1] != null) {
            this.gaussianPeakDegreesFloatText.set_Text(peakParameters[1].toString());
        }
        this.spatial.set_Text(this.polyXSim.getSpatial());
        this.direc.set_Text(this.polyXSim.getOutputDirectory());
        this.gen_U.setSelection(this.polyXSim.getGenU());
        this.u_grains.set_Text(this.polyXSim.getUGrains());
        String gen_pos_value = this.polyXSim.getPos();
        if (gen_pos_value != null) {
            if (gen_pos_value.equals("1 0")) {
                this.gen_pos.setText("Set all positions at origo");
            } else if (gen_pos_value.equals("1 1")) {
                this.gen_pos.setText("Generate random positions within box or cylinder");
            } else if (gen_pos_value.equals("0 0")) {
                this.gen_pos.setText("Do not generate");
            }
        }
        this.pos_grains.set_Text(this.polyXSim.getPosGrains());
        this.gen_phase_flag.setSelection(this.polyXSim.getGen_phaseFlag());
        int i5 = 0;
        while (i5 < container.length) {
            this.scrolledComposite[i5].setMinSize(container[i5].computeSize(-1, -1));
            ++i5;
        }
        Float valueint = this.polyXSim.getIntensityConstant();
        if (valueint != null && valueint != new Float(0.0f)) {
            this.intensityCombo.select(0);
            this.intensityConstantFloatText.setText(String.valueOf(valueint));
        } else {
            this.intensityCombo.select(1);
        }
        this.intensityConstantFloatText.setEnabled(this.intensityCombo.getSelectionIndex() == 0);
        this.initValues();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String val;
        if (event.getProperty().equals("polyXSim") && (val = (String)event.getNewValue()).equals("running")) {
            this.launchProgramWithThisFile();
        }
    }

    private void launchProgramWithThisFile() {
        if (this.checkFields(this.parent, true)) {
            int answer = this.confirmSave();
            if (answer != ANSWER_CANCEL) {
                if (answer == ANSWER_YES) {
                    this.doSave(null);
                }
                this.polyXSim.run();
            }
        } else {
            this.activeComposite.forceFocus();
            FableMessageConsole.console.displayError("Some of require fields are needed.");
        }
    }

    public boolean checkFields(Composite parent, boolean bok) {
        Control[] element = parent.getChildren();
        int i = 0;
        while (i < element.length && bok) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText) {
                    TypedText text = (TypedText)element[i];
                    boolean bl = bok = text.is_bValide() && bok;
                    if (bok) {
                        if (text.is_isRequiredField()) {
                            bok = !text.getText().trim().equals("");
                            this.activeComposite = this.currentComposite;
                            if (!bok) {
                                FableMessageConsole.console.displayError(" Field " + text.toString() + " is required.");
                            }
                        }
                    } else {
                        FableMessageConsole.console.displayError("Field " + text.toString() + " is not valid." + text.getErrorMessage());
                    }
                } else {
                    this.setCurrentComposite(element, i);
                    bok = this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    private void setCurrentComposite(Control[] element, int i) {
        if (this.getReflectionsTab().equals((Composite)element[i])) {
            this.currentComposite = (Composite)element[i];
        } else if (this.getTabFiles().equals((Composite)element[i])) {
            this.currentComposite = (Composite)element[i];
        } else if (this.getSampleTab().equals((Composite)element[i])) {
            this.currentComposite = (Composite)element[i];
        } else if (this.getDetectorTab().equals((Composite)element[i])) {
            this.currentComposite = (Composite)element[i];
        } else if (this.getTabCrystalPhase().equals((Composite)element[i])) {
            this.currentComposite = (Composite)element[i];
        }
    }

    public PolyXSim getPolyXSim() {
        return this.polyXSim;
    }

    public static String getId() {
        return ID;
    }

    public void setInputValues() {
        this.polyXSim.setWavelength(Float.valueOf(this.wavelength.getText()).floatValue());
        this.polyXSim.setFlux(Float.valueOf(this.beamflux.getText()).floatValue());
        this.polyXSim.setPolarisation(this.polarisationButton.getSelection());
        this.polyXSim.setLorentzFactor(this.lorentzFactorButton.getSelection());
        this.polyXSim.setPolarisationFactor(Float.valueOf(this.beampol_factor.getText()).floatValue());
        this.polyXSim.setPolarisationDirection(Float.valueOf(this.beampol_direct.getText()).floatValue());
        this.polyXSim.setDetyCenter(Float.valueOf(this.dety_center.getText()).floatValue());
        this.polyXSim.setDetzCenter(Float.valueOf(this.detz_center.getText()).floatValue());
        this.polyXSim.setYSize(Float.valueOf(this.y_size.getText()).floatValue());
        this.polyXSim.setZSize(Float.valueOf(this.z_size.getText()).floatValue());
        this.polyXSim.setDetySize(Float.valueOf(this.dety_size.getText()).floatValue());
        this.polyXSim.setDetzSize(Float.valueOf(this.detz_size.getText()).floatValue());
        this.polyXSim.setDistance(Float.valueOf(this.distance.getText()).floatValue());
        this.polyXSim.setDetTiltX(Float.valueOf(this.tilt_x.getText()).floatValue());
        this.polyXSim.setDetTiltY(Float.valueOf(this.tilt_y.getText()).floatValue());
        this.polyXSim.setDetTiltZ(Float.valueOf(this.tilt_z.getText()).floatValue());
        Integer[] detOrientation = new Integer[]{orientParams[idxOrientation][0], orientParams[idxOrientation][1], orientParams[idxOrientation][2], orientParams[idxOrientation][3]};
        this.polyXSim.setDetOrientation(detOrientation);
        this.polyXSim.setOmegaStart(Float.valueOf(this.omega_start.getText()).floatValue());
        this.polyXSim.setOmegaEnd(Float.valueOf(this.omega_end.getText()).floatValue());
        this.polyXSim.setOmegaStep(Float.valueOf(this.omega_step.getText()).floatValue());
        this.polyXSim.setNoGrains(Integer.valueOf(this.no_grains.getText()));
        int genGrains = 0;
        if (this.gen_U.getSelection()) {
            genGrains = 1;
        }
        this.polyXSim.setGenGrainOrientation(genGrains);
        genGrains = this.gen_size.getSelectionIndex() == 0 ? 0 : 1;
        this.polyXSim.setGenGrainPosition(genGrains);
        if (this.sampleShapeCombo.getText().equalsIgnoreCase(BOX)) {
            Float[] sampleXyz = new Float[]{Float.valueOf(this.sample_xyz_X.getText()), Float.valueOf(this.sample_xyz_Y.getText()), Float.valueOf(this.sample_xyz_Z.getText())};
            this.polyXSim.setSampleXyz(sampleXyz);
            this.polyXSim.setSampleIsCube(true);
            this.polyXSim.setSampleIsCylinder(false);
        } else if (this.sampleShapeCombo.getText().equalsIgnoreCase(CYLINDER)) {
            Float[] sampleCyl = new Float[]{Float.valueOf(this.sample_cyl_height.getText()), Float.valueOf(this.sample_cyl_diameter.getText())};
            this.polyXSim.setSampleCyl(sampleCyl);
            this.polyXSim.setSampleIsCube(false);
            this.polyXSim.setSampleIsCylinder(true);
        } else {
            this.polyXSim.setSampleShapeNone();
        }
        this.polyXSim.setNumPhases(this.numPhases);
        if (this.structureCellButton.getSelection()) {
            Float[] unitCellA = new Float[this.numPhases];
            Float[] unitCellB = new Float[this.numPhases];
            Float[] unitCellC = new Float[this.numPhases];
            Float[] unitCellAlpha = new Float[this.numPhases];
            Float[] unitCellBeta = new Float[this.numPhases];
            Float[] unitCellGamma = new Float[this.numPhases];
            Integer[] unitCellSpaceGroup = new Integer[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                if (this.unit_cell_phase_a[i].getText() != null) {
                    unitCellA[i] = Float.valueOf(this.unit_cell_phase_a[i].getText());
                }
                if (this.unit_cell_phase_b[i].getText() != null) {
                    unitCellB[i] = Float.valueOf(this.unit_cell_phase_b[i].getText());
                }
                if (this.unit_cell_phase_c[i].getText() != null) {
                    unitCellC[i] = Float.valueOf(this.unit_cell_phase_c[i].getText());
                }
                if (this.unit_cell_phase_alpha[i].getText() != null) {
                    unitCellAlpha[i] = Float.valueOf(this.unit_cell_phase_alpha[i].getText());
                }
                if (this.unit_cell_phase_beta[i].getText() != null) {
                    unitCellBeta[i] = Float.valueOf(this.unit_cell_phase_beta[i].getText());
                }
                if (this.unit_cell_phase_gamma[i].getText() != null) {
                    unitCellGamma[i] = Float.valueOf(this.unit_cell_phase_gamma[i].getText());
                }
                if (this.sgno_phase[i].getText() != null) {
                    unitCellSpaceGroup[i] = Integer.valueOf(this.sgno_phase[i].getText());
                }
                ++i;
            }
            this.polyXSim.setUnitCellA(unitCellA);
            this.polyXSim.setUnitCellB(unitCellB);
            this.polyXSim.setUnitCellC(unitCellC);
            this.polyXSim.setUnitCellAlpha(unitCellAlpha);
            this.polyXSim.setUnitCellBeta(unitCellBeta);
            this.polyXSim.setUnitCellGamma(unitCellGamma);
            this.polyXSim.setUnitCellSpaceGroup(unitCellSpaceGroup);
        } else {
            int i = 0;
            while (i < this.numPhases) {
                if (this.structure_phase[i].getText() != null) {
                    this.polyXSim.setStructureFile(this.structure_phase[i].getText(), i);
                }
                ++i;
            }
        }
        Float[] medGrainSize = new Float[this.numPhases];
        Float[] minGrainSize = new Float[this.numPhases];
        Float[] maxGrainSize = new Float[this.numPhases];
        int i = 0;
        while (i < this.numPhases) {
            if (this.structure_phase != null && this.structure_phase[i].getText() != null) {
                this.polyXSim.setStructureFile(this.structure_phase[i].getText(), i);
            }
            if (this.no_grains_phase_Y[i].getText() != null && this.no_grains_phase_Y[i].getText().length() > 0) {
                this.phaseGrains[i] = Integer.valueOf(this.no_grains_phase_Y[i].getText());
            }
            if (this.gen_size_phase_x[i].getText() != null) {
                medGrainSize[i] = this.phaseDistributionCombo[i].getText().equals("fixed") ? Float.valueOf(-Math.abs(Float.valueOf(this.gen_size_phase_x[i].getText()).floatValue())) : Float.valueOf(Math.abs(Float.valueOf(this.gen_size_phase_x[i].getText()).floatValue()));
            }
            if (this.gen_size_phase_x_min[i].getText() != null) {
                minGrainSize[i] = Float.valueOf(this.gen_size_phase_x_min[i].getText());
            }
            if (this.gen_size_phase_x_max[i].getText() != null) {
                maxGrainSize[i] = Float.valueOf(this.gen_size_phase_x_max[i].getText());
            }
            ++i;
        }
        this.polyXSim.setPhaseGrains(this.phaseGrains);
        this.polyXSim.setPhaseGrainSize(medGrainSize);
        this.polyXSim.setPhaseGrainMinSize(minGrainSize);
        this.polyXSim.setPhaseGrainMaxSize(maxGrainSize);
        int makeImages = 0;
        if (this.imageFlagButton.getSelection()) {
            makeImages = 1;
        }
        this.polyXSim.setMakeImages(makeImages);
        String fileFormat = this.fileFormatCombo.getText();
        this.polyXSim.setFormat("." + fileFormat);
        String fileStem = this.imageStemFileText.getText();
        if (fileStem.lastIndexOf(File.separatorChar) != -1) {
            fileStem.substring(0, fileStem.lastIndexOf(File.separatorChar));
            fileStem = fileStem.substring(fileStem.lastIndexOf(File.separatorChar) + 1);
        }
        this.polyXSim.setOutputDirectory(this.direc.getText());
        this.polyXSim.setPrefix(fileStem);
        int noiseValue = 0;
        if (this.noise.getSelection()) {
            noiseValue = 1;
        }
        this.polyXSim.setNoise(noiseValue);
        int psf = 0;
        if (this.psfButton.getSelection()) {
            psf = 1;
        }
        this.polyXSim.setPsf(psf);
        this.polyXSim.setPeakShape(this.peakTypeCombo.getSelectionIndex());
        Float[] peakParameters = new Float[]{Float.valueOf(this.gaussianPeakPixelsFloatText.getText()), Float.valueOf(this.gaussianPeakDegreesFloatText.getText())};
        this.polyXSim.setPeakParameters(peakParameters);
        this.bg.set_Text(Integer.toString(this.polyXSim.getBackground()));
        this.polyXSim.setBackground(Integer.valueOf(this.bg.getText()));
        this.polyXSim.setOutputFlt(this.outputFltButton.getSelection());
        this.polyXSim.setOutputGve(this.outputGveButton.getSelection());
        this.polyXSim.setOutputUbi(this.outputUbiButton.getSelection());
        this.polyXSim.setOutputPar(this.outputParButton.getSelection());
        this.polyXSim.setFormat("." + this.fileFormatCombo.getText());
        this.polyXSim.setWedge(Float.valueOf(this.wedge.getText()).floatValue());
        this.polyXSim.setMosaicity(Float.valueOf(this.mosaicity.getText()).floatValue());
        if ((String)this.gen_pos.getData(this.gen_pos.getText()) != null) {
            this.polyXSim.setgenPos((String)this.gen_pos.getData(this.gen_pos.getText()));
        }
        this.polyXSim.setGenU(this.gen_U.getSelection());
        if (this.pos_grains.getText().length() > 0) {
            this.polyXSim.setPosGrains(this.pos_grains.getText());
        }
        if (this.u_grains.getText().length() > 0) {
            this.polyXSim.setUGrains(this.u_grains.getText());
        }
    }

    public void setFileText(String inputFileName) throws PolyXSimException {
        this.setTitleToolTip(inputFileName);
        this.inputFileDirectory = inputFileName.substring(0, inputFileName.lastIndexOf(File.separatorChar));
        File file = new File(inputFileName);
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append("\r\n");
                }
            }
            catch (FileNotFoundException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", e.getMessage());
            }
            catch (IOException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", e.getMessage());
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", "reader.close():" + e.getMessage());
            }
        }
        this.inputFileText.setText(contents.toString());
        this.inputFileText.pack();
        container[0].pack();
    }

    private static void setEnableGroup(Group group, boolean enable) {
        Control[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
        group.setEnabled(enable);
    }

    private void setHelpContextIDs() {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.tabItem[0].getControl(), "fable.polyXSim.files_tab");
    }

    public void setSpaceGroup(int _spaceGroup) {
        int newspaceGroupType = 0;
        this.spaceGroup = _spaceGroup;
        int i = 0;
        while (i < ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (this.spaceGroup <= ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupType = i;
                break;
            }
            ++i;
        }
        if (newspaceGroupType != this.spaceGroupType) {
            this.spaceGroupCombo.setItems(ICrystalSymmetryVarKeys.SPACE_GROUPS[newspaceGroupType]);
            this.spaceGroupType = newspaceGroupType;
        }
        this.spaceGroupSpinner.setSelection(this.spaceGroup);
        this.spaceGroupTypeCombo.select(this.spaceGroupType);
        this.spaceGroupCombo.select(this.spaceGroup - ICrystalSymmetryVarKeys.SPACE_GROUP_MINIMUM[this.spaceGroupType]);
    }

    public static void setView(PolyXSimInputView view) {
        PolyXSimInputView.view = view;
    }

    public void setData() {
        this.direc.setData((Object)"direc");
        this.imageFlagButton.setData((Object)"output");
        this.fileFormatCombo.setData((Object)"output");
        this.outputGveButton.setData((Object)"output");
        this.outputParButton.setData((Object)"output");
        this.outputFltButton.setData((Object)"output");
        this.outputUbiButton.setData((Object)"output");
        this.outputGveButton.setData("output", (Object)".gve");
        this.outputUbiButton.setData("output", (Object)".ubi");
        this.outputParButton.setData("output", (Object)".par");
        this.outputFltButton.setData("output", (Object)".flt");
        this.no_phases.setData((Object)"no_phases");
        this.wavelength.setData((Object)"wavelength");
        this.beamflux.setData((Object)"beamflux");
        this.beampol_factor.setData((Object)"beampol_factor");
        this.beampol_direct.setData((Object)"beampol_direct");
        this.detz_center.setData((Object)"detz_center");
        this.dety_center.setData((Object)"dety_center");
        this.z_size.setData((Object)"z_size");
        this.y_size.setData((Object)"y_size");
        this.dety_size.setData((Object)"dety_size");
        this.detz_size.setData((Object)"detz_size");
        this.distance.setData((Object)"distance");
        this.tilt_x.setData((Object)"tilt_x");
        this.tilt_y.setData((Object)"tilt_y");
        this.tilt_z.setData((Object)"tilt_z");
        this.wedge.setData((Object)"wedge");
        this.omega_start.setData((Object)"omega_start");
        this.omega_end.setData((Object)"omega_end");
        this.omega_step.setData((Object)"omega_step");
        this.omega_sign.setData((Object)"omega_sign");
        this.omega_sign.setData("ccw", (Object)-1);
        this.omega_sign.setData("cw", (Object)1);
        this.no_grains.setData((Object)"no_grains");
        this.sample_xyz_X.setData((Object)"sample_xyz");
        this.sample_xyz_Y.setData((Object)"sample_xyz");
        this.sample_xyz_Z.setData((Object)"sample_xyz");
        this.imageStemFileText.setData((Object)"stem");
        this.bg.setData((Object)"bg");
        this.psf.setData((Object)"psf");
        this.peakTypeCombo.setData((Object)"peakshape");
        this.peakTypeCombo.setData("Spike 2x2 pixels", (Object)0);
        this.peakTypeCombo.setData("Gaussian", (Object)1);
        this.peakTypeCombo.setData("ODF", (Object)2);
        this.odfTypeCombo.setData((Object)"odf_type");
        this.odfTypeCombo.setData("grid from file", (Object)2);
        this.odfTypeCombo.setData("isotropic Gaussian", (Object)1);
        this.odfFile.setData((Object)"odf_file");
        this.gaussianPeakDegreesFloatText.setData((Object)"peakshape");
        this.gaussianPeakPixelsFloatText.setData((Object)"peakshape");
        this.gen_U.setData((Object)"gen_U");
        this.gen_pos.setData((Object)"gen_pos");
        this.gen_pos.setData("Set all positions at origo", (Object)"1 0");
        this.gen_pos.setData("Generate random positions within box or cylinder", (Object)"1 1");
        this.gen_pos.setData("Do not generate", (Object)"0 0");
        this.intensityCombo.setData((Object)"intensity_const");
        this.intensityCombo.setData("constant", (Object)"1");
        this.intensityCombo.setData("structure factor", (Object)"0");
        this.lorentzFactorButton.setData((Object)"lorentz_apply");
        this.polarisationButton.setData((Object)"beampol_apply");
    }

    public void loadData() {
    }

    public void showUnitCellGroup(boolean show) {
        this.unitCellGroup.setVisible(show);
        GridData data = (GridData)this.unitCellGroup.getLayoutData();
        data.exclude = !show;
        Composite parent = this.unitCellGroup.getParent();
        if (parent != null) {
            parent.layout(false);
        }
    }

    public void showStructurePhaseGroup(boolean show) {
        this.structureFileGroup.setVisible(show);
        GridData data = (GridData)this.structureFileGroup.getLayoutData();
        data.exclude = !show;
        Composite parent = this.structureFileGroup.getParent();
        if (parent != null) {
            parent.layout(false);
        }
    }

    private void sampleShapeRules(String shape) {
        if (shape.equalsIgnoreCase(CYLINDER)) {
            this.enableSampleShape(false, true);
        } else if (shape.equalsIgnoreCase(BOX)) {
            this.enableSampleShape(true, false);
        } else {
            this.enableSampleShape(false, false);
        }
    }

    public Composite getParent() {
        return this.parent;
    }

    public Composite getTabFiles() {
        return container[0];
    }

    public Composite getTabCrystalPhase() {
        return container[1];
    }

    public Composite getSampleTab() {
        return container[2];
    }

    public Composite getReflectionsTab() {
        return container[3];
    }

    public Composite getInstrumentalTab() {
        return container[4];
    }

    public Composite getDetectorTab() {
        return container[5];
    }

    public void writeTabReflection(BufferedWriter writer) throws IOException {
        writer.write("#Reflection");
        writer.newLine();
        String intensitySelection = this.intensityCombo.getText();
        if (intensitySelection.length() > 0) {
            String value = null;
            if (this.intensityCombo.getData(intensitySelection) != null) {
                value = (String)this.intensityCombo.getData(intensitySelection);
            }
            if (value != null) {
                writer.write("intensity_const " + value);
                writer.newLine();
            }
        }
        writer.write("lorentz_apply " + (this.lorentzFactorButton.getSelection() ? "1" : "0"));
        writer.newLine();
        writer.write("beampol_apply " + (this.polarisationButton.getSelection() ? "1" : "0"));
        writer.newLine();
        String peakShape = this.peakTypeCombo.getText();
        int peakShapeValue = 0;
        if (this.peakTypeCombo.getData(peakShape) != null) {
            peakShapeValue = (Integer)this.peakTypeCombo.getData(peakShape);
        }
        switch (peakShapeValue) {
            case 0: {
                writer.write("peakshape 0");
                writer.newLine();
                break;
            }
            case 1: {
                writer.write("peakshape 1 " + this.gaussianPeakPixelsFloatText.getText() + " " + this.gaussianPeakDegreesFloatText.getText());
                writer.newLine();
                break;
            }
            case 2: {
                writer.write("peakshape 2");
                writer.newLine();
                String text = this.odfTypeCombo.getText();
                int value = 0;
                if (this.odfTypeCombo.getData(text) != null) {
                    value = (Integer)this.odfTypeCombo.getData(text);
                }
                writer.write("odf_type " + value);
                writer.newLine();
                switch (Integer.valueOf(value)) {
                    case 2: {
                        writer.write("odf_file " + this.odfFile.getText());
                        writer.newLine();
                        break;
                    }
                    case 1: {
                        writer.write("mosaicity " + this.mosaicity.getText());
                        writer.newLine();
                        break;
                    }
                }
                writer.write("odf_type 2");
                writer.newLine();
                break;
            }
        }
    }

    public void writeTabFiles(BufferedWriter writer) throws IOException {
        writer.write("#File names and Format");
        writer.newLine();
        if (this.direc.getText().length() > 0) {
            writer.write("#Directory to save output files");
            writer.newLine();
            writer.write("direc '" + this.direc.getText() + "'");
            writer.newLine();
        }
        if (this.imageStemFileText.getText().length() > 0) {
            writer.write("stem '" + this.imageStemFileText.getText() + "'");
            writer.newLine();
        }
        String outputFileformat = "";
        writer.write("make_image " + (this.imageFlagButton.getSelection() ? "1" : "0"));
        writer.newLine();
        if (this.imageFlagButton.getSelection()) {
            outputFileformat = " '." + this.fileFormatCombo.getText() + "'";
        }
        if ((outputFileformat = String.valueOf(outputFileformat) + (this.outputFltButton.getSelection() ? "'.flt' " : "") + (this.outputGveButton.getSelection() ? "'.gve' " : "") + (this.outputParButton.getSelection() ? "'.par' " : "") + (this.outputUbiButton.getSelection() ? "'.ubi' " : "")).trim().length() > 0) {
            writer.write("output " + outputFileformat);
            writer.newLine();
        }
    }

    public void writeTabSample(BufferedWriter writer) throws IOException {
        int i;
        writer.write("#Crystal/grains parameters");
        writer.newLine();
        if (this.no_grains.getText().length() > 0) {
            writer.write("no_grains " + this.no_grains.getText() + " #Total number of grains summed over all phases to be simulated. Need to match the number of U_Grains_X key word");
            writer.newLine();
        }
        String gensizeflag = this.gen_size.getText().equals("Do not generate") ? "0" : "1";
        writer.write("gen_size");
        writer.write(" " + gensizeflag);
        writer.write(" " + (this.gen_size_median.getText().trim().length() > 0 ? this.gen_size_median.getText() : "0"));
        writer.write(" " + (this.gen_size_max.getText().trim().length() > 0 ? this.gen_size_max.getText() : "0"));
        writer.write(" " + (this.gen_size_max.getText().trim().length() > 0 ? this.gen_size_max.getText() : "0"));
        writer.newLine();
        if (this.gen_size.getText().equals("Generate at random using different lognormal distributions for each phase")) {
            i = 0;
            while (i < this.numPhases && this.gen_size_phase_x[i] != null && this.gen_size_phase_x_min[i] != null && this.gen_size_phase_x_max[i] != null) {
                writer.write("gen_size_phase_" + i);
                writer.write(" " + (this.gen_size_phase_flag[i].getSelection() ? "1" : "0"));
                writer.write(" " + (this.gen_size_phase_x[i].getText().trim().length() > 0 ? this.gen_size_phase_x[i].getText() : "0"));
                writer.write(" " + (this.gen_size_phase_x_min[i].getText().trim().length() > 0 ? this.gen_size_phase_x_min[i].getText() : "0"));
                writer.write(" " + (this.gen_size_phase_x_max[i].getText().trim().length() > 0 ? this.gen_size_phase_x_max[i].getText() : "0"));
                ++i;
            }
            writer.newLine();
        } else if (this.gen_size.getText().equals("Provide specific grain sizes for each grain") && this.size_grains.getText().length() > 0 && this.size_grains.getText() != null) {
            writer.write(this.size_grains.getText());
            writer.newLine();
        }
        writer.write("#Grain phase : If you want to let the PolyXSim appoint which grain belongs to which phase the following keyword can be used.");
        writer.newLine();
        writer.write("gen_phase");
        writer.write(" " + (this.gen_phase_flag.getSelection() ? "1" : "0"));
        i = 0;
        while (i < this.numPhases && this.no_grains_phase_Y[i] != null) {
            writer.write(" " + i);
            writer.write(" " + (this.no_grains_phase_Y[i].getText().trim().equals("") ? "0" : this.no_grains_phase_Y[i].getText()));
            ++i;
        }
        writer.newLine();
        writer.write("#Grain orientation : random (1) or specify specific orientation matrices (0)");
        writer.newLine();
        writer.write("gen_U " + (this.gen_U.getSelection() ? "1" : "0"));
        writer.newLine();
        if (this.u_grains.getText().length() > 0 && this.u_grains.getText() != null) {
            writer.write(this.u_grains.getText());
            writer.newLine();
        }
        if (this.gen_pos.getText() == null || this.gen_pos.getText().equals("Do not generate")) {
            writer.write("gen_pos 0 0");
            writer.newLine();
        } else if (this.gen_pos.getText().equals("Generate random positions within box or cylinder")) {
            writer.write("gen_pos 1 1");
            writer.newLine();
        } else if (this.gen_pos.getText().equals("Set all positions at origo")) {
            writer.write("gen_pos 1 0");
            writer.newLine();
        }
        if (this.pos_grains.getText().length() > 0) {
            writer.write(this.pos_grains.getText());
            writer.newLine();
        }
        if (this.sampleShapeCombo.getText().equalsIgnoreCase(CYLINDER)) {
            writer.write("sample_cyl " + this.sample_cyl_diameter.getText() + " " + this.sample_cyl_height.getText());
            writer.newLine();
        } else if (this.sampleShapeCombo.getText().equalsIgnoreCase(BOX)) {
            writer.write("sample_xyz " + this.sample_xyz_X.getText() + " " + this.sample_xyz_Y.getText() + " " + this.sample_xyz_Z.getText());
            writer.newLine();
        }
        String s = "";
        s = "gen_eps" + (this.gen_eps.getText().equals("Do not generate") ? " 0" : " 1");
        if (this.gen_eps.getText().equals("No strain ")) {
            s = String.valueOf(s) + " 0 0 0 0";
            writer.write(s);
            writer.newLine();
        } else if (this.gen_eps.getText().equals("Generate randomly from Gaussian distribution with same mean and spread for all phases") || this.gen_eps.getText().equals("Do not generate")) {
            s = String.valueOf(s) + " " + (this.gen_eps_meanDiag.getText().length() == 0 ? "0" : this.gen_eps_meanDiag.getText());
            s = String.valueOf(s) + " " + (this.gen_eps_spreadDiag.getText().length() == 0 ? "0" : this.gen_eps_spreadDiag.getText());
            s = String.valueOf(s) + " " + (this.gen_eps_meanOffDiag.getText().length() == 0 ? "0" : this.gen_eps_meanOffDiag.getText());
            s = String.valueOf(s) + " " + (this.gen_eps_spreadOffDiag.getText().length() == 0 ? "0" : this.gen_eps_spreadOffDiag.getText());
            writer.write(s);
            writer.newLine();
        } else if (this.gen_eps.getText().equals("Generate randomly from Gaussian distribution with different mean and spread for each phase")) {
            s = String.valueOf(s) + " 0 0 0 0";
            writer.write(s);
            writer.newLine();
            int i2 = 0;
            while (i2 < this.phaseLabelEps.length) {
                writer.write("gen_eps_phase_" + i2);
                writer.write(" " + (this.gen_eps_random[i2].getSelection() ? "1" : "0"));
                writer.write(" " + (this.gen_eps_meanDiag_Y[i2].getText().trim().length() > 0 ? this.gen_eps_meanDiag_Y[i2].getText() : "0"));
                writer.write(" " + (this.gen_eps_spreadDiag_Y[i2].getText().trim().length() > 0 ? this.gen_eps_spreadDiag_Y[i2].getText() : "0"));
                writer.write(" " + (this.gen_eps_meanoffDiag_Y[i2].getText().trim().length() > 0 ? this.gen_eps_meanoffDiag_Y[i2].getText() : "0"));
                writer.write(" " + (this.gen_eps_spreadoffDiag_Y[i2].getText().trim().length() > 0 ? this.gen_eps_spreadoffDiag_Y[i2].getText() : "0"));
                writer.newLine();
                ++i2;
            }
        } else if (this.gen_eps.getText().equals("Provide specific strain tensors for each grain ")) {
            s = String.valueOf(s) + " 0 0 0 0";
            writer.write(s);
            writer.newLine();
            writer.write(this.eps_grains.getText());
            writer.newLine();
        }
    }

    public void writeTabCrystal(BufferedWriter writer) throws IOException {
        block4: {
            String keyword_sgno;
            String keyword_unit_cell;
            block3: {
                writer.write("#Structural parameters");
                writer.newLine();
                this.numPhases = Integer.valueOf(this.no_phases.getText());
                writer.write("no_phases " + this.numPhases);
                writer.newLine();
                String keyword_structure_file = "structure_phase_";
                keyword_unit_cell = "unit_cell_phase_";
                keyword_sgno = "sgno_phase_";
                if (Integer.valueOf(this.no_phases.getText()) == 1) {
                    keyword_structure_file = "structure_file";
                    keyword_unit_cell = "unit_cell";
                    keyword_sgno = "sgno";
                }
                if (!this.structureFileButton.getSelection()) break block3;
                int i = 0;
                while (i < this.numPhases) {
                    writer.write(String.valueOf(keyword_structure_file) + (this.numPhases == 1 ? "" : Integer.valueOf(i)) + " '" + this.structure_phase[i].getText() + "'");
                    writer.newLine();
                    ++i;
                }
                break block4;
            }
            if (!this.structureCellButton.getSelection()) break block4;
            int i = 0;
            while (i < this.numPhases) {
                writer.write(String.valueOf(keyword_unit_cell) + (this.numPhases == 1 ? "" : Integer.valueOf(i)) + " " + this.unit_cell_phase_a[i].getText() + " " + this.unit_cell_phase_b[i].getText() + " " + this.unit_cell_phase_c[i].getText() + " " + this.unit_cell_phase_alpha[i].getText() + " " + this.unit_cell_phase_beta[i].getText() + " " + this.unit_cell_phase_gamma[i].getText());
                writer.newLine();
                writer.write(String.valueOf(keyword_sgno) + (this.numPhases == 1 ? "" : Integer.valueOf(i)) + " " + this.sgno_phase[i].getText());
                writer.newLine();
                ++i;
            }
        }
    }

    public void writeTabInstrumental(BufferedWriter writer) throws IOException {
        writer.write("#Instrumental");
        writer.newLine();
        writer.write("#Beam specs");
        writer.newLine();
        if (this.wavelength.getText().length() > 0) {
            writer.write("wavelength " + this.wavelength.getText());
            writer.newLine();
        }
        if (this.beam_width.getText().length() > 0) {
            writer.write("beam_width " + this.beam_width.getText());
            writer.newLine();
        }
        if (this.beamflux.getText().length() > 0) {
            writer.write("beamflux " + this.beamflux.getText());
            writer.newLine();
        }
        if (this.beampol_factor.getText().length() > 0) {
            writer.write("beampol_factor " + this.beampol_factor.getText());
            writer.newLine();
        }
        if (this.beampol_direct.getText().length() > 0) {
            writer.write("beampol_direct " + this.beampol_direct.getText());
            writer.newLine();
        }
        writer.write("#Beam center on detector [pixels]");
        writer.newLine();
        if (this.dety_center.getText().length() > 0) {
            writer.write("dety_center " + this.dety_center.getText());
            writer.newLine();
        }
        if (this.detz_center.getText().length() > 0) {
            writer.write("detz_center " + this.detz_center.getText());
            writer.newLine();
        }
        if (this.omega_start.getText().length() > 0) {
            writer.write("#Omega scan range [degrees]");
            writer.newLine();
            writer.write("omega_start " + this.omega_start.getText());
            writer.newLine();
        }
        if (this.omega_end.getText().length() > 0) {
            writer.write("omega_end " + this.omega_end.getText());
            writer.newLine();
        }
        if (this.omega_step.getText().length() > 0) {
            writer.write("#Omega step size [degrees]");
            writer.newLine();
            writer.write("omega_step " + this.omega_step.getText());
            writer.newLine();
        }
        writer.write("#Omega rotation direction [degrees]");
        writer.newLine();
        writer.write("omega_sign " + (this.omega_sign.getText() == "ccw" ? -1 : 1));
        writer.newLine();
        if (this.wedge.getText().length() > 0) {
            writer.write("#Wedge angle of omega axis");
            writer.newLine();
            writer.write("wedge " + this.wedge.getText());
            writer.newLine();
        }
    }

    public void writeTabDetector(BufferedWriter writer) throws IOException {
        String[] splitO;
        writer.write("#Instrumentation");
        writer.newLine();
        writer.write("#Detector pixel size [mm]");
        writer.newLine();
        if (this.y_size.getText().length() > 0) {
            writer.write("y_size " + this.y_size.getText() + " #" + this.y_size.getToolTipText());
            writer.newLine();
        }
        if (this.z_size.getText().length() > 0) {
            writer.write("z_size " + this.z_size.getText());
            writer.newLine();
        }
        writer.write("#Detector size [pixels]");
        writer.newLine();
        if (this.dety_size.getText().length() > 0) {
            writer.write("dety_size " + this.dety_size.getText());
            writer.newLine();
        }
        if (this.detz_size.getText().length() > 0) {
            writer.write("detz_size " + this.detz_size.getText());
            writer.newLine();
        }
        writer.write("#Distance from sample to detector [mm]");
        writer.newLine();
        if (this.distance.getText().length() > 0) {
            writer.write("distance " + this.distance.getText());
            writer.newLine();
        }
        writer.write("#Detector tilt ");
        writer.newLine();
        if (this.tilt_x.getText().length() > 0) {
            writer.write("tilt_x " + this.tilt_x.getText());
            writer.newLine();
        }
        if (this.tilt_y.getText().length() > 0) {
            writer.write("tilt_y " + this.tilt_y.getText());
            writer.newLine();
        }
        if (this.tilt_z.getText().length() > 0) {
            writer.write("tilt_z " + this.tilt_z.getText());
            writer.newLine();
        }
        writer.write("#Detector orientation ");
        writer.newLine();
        String o = this.orientCombo.getText();
        if (o != null && (splitO = o.split("\\p{Space}")).length == 4) {
            writer.write("o11 " + splitO[0]);
            writer.newLine();
            writer.write("o12 " + splitO[1]);
            writer.newLine();
            writer.write("o21 " + splitO[2]);
            writer.newLine();
            writer.write("o22 " + splitO[3]);
            writer.newLine();
        }
        if (this.bg.getText().length() > 0 && this.addBckgrdButton.getSelection()) {
            writer.write("#Background");
            writer.newLine();
            writer.write("bg " + this.bg.getText());
            writer.newLine();
        }
        writer.write("#Noise");
        writer.newLine();
        writer.write("noise " + (this.noise.getSelection() ? "1" : "0"));
        writer.newLine();
        if (this.psf.getText().length() > 0 && this.psfButton.getSelection()) {
            writer.write("#Detector point spread [in pixels]");
            writer.newLine();
            writer.write("psf " + this.psf.getText());
            writer.newLine();
        }
        if (this.spatial.getText().length() > 0 && this.spatialDistortionButton.getSelection()) {
            writer.write("#Spatial distortion of the detector");
            writer.newLine();
            writer.write("spatial '" + this.spatial.getText() + "'");
            writer.newLine();
        }
    }

    public int confirmSave() {
        int answer = ANSWER_YES;
        if (this.isDirty() && (answer = FableUtils.questionMsg((String)("'" + this.input.getName() + "' has changed.\n\n" + "Do you want to save it before running ?"))) == ANSWER_YES) {
            this.doSave(null);
        }
        return answer;
    }

    private void doFinish(final String savefile) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(savefile);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
                    InputEditor.this.writeTabFiles(writer);
                    InputEditor.this.writeTabCrystal(writer);
                    InputEditor.this.writeTabSample(writer);
                    InputEditor.this.writeTabDetector(writer);
                    InputEditor.this.writeTabReflection(writer);
                    InputEditor.this.writeTabInstrumental(writer);
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    FableUtils.errMsg(InputEditor.class, (String)("Error writing to file " + InputEditor.this.input.getName()));
                }
            }
        });
    }

    private void gen_size_EnableFields() {
        this.enableGenSizePhase(this.gen_size.getText().equals("Generate at random using different lognormal distributions for each phase"));
        this.enableGenSizeallPhase(this.gen_size.getText().equals("Generate at random using the same lognormal distribution for all phases"));
        this.size_grains.setEnabled(this.gen_size.getText().equals("Provide specific grain sizes for each grain"));
    }

    class PolyxsimListener
    implements IPolyxsimEventListener {
        PolyxsimListener() {
        }

        @Override
        public void loadInputFileEvent(PolyxsimEvent event) {
            try {
                InputEditor.this.setFileText(((PolyXSim)event.getSource()).getInputFile());
                InputEditor.this.getInputValues();
                InputEditor.this.setDirty(false);
            }
            catch (PolyXSimException e) {
                InputEditor.this.setDirty(false);
                SWTUtils.errMsg((String)e.getMessage());
            }
        }

        @Override
        public void saveInputFileEvent(PolyxsimEvent event) {
            String newInputfilename = ((PolyXSim)event.getSource()).getInputFile();
            try {
                InputEditor.this.setFileText(newInputfilename);
                InputEditor.this.getInputValues();
            }
            catch (PolyXSimException e) {
                SWTUtils.errMsg((String)e.getMessage());
            }
        }

        @Override
        public void updateInputFileEvent(PolyxsimEvent event) {
        }
    }
}

