/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.actions;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.polyxsim.editors.InputEditor;
import fable.polyxsim.editors.PolyXSimTextEditor;
import fable.polyxsim.internal.PolyXSim;
import java.io.File;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate,
IPropertyChangeListener,
IViewActionDelegate,
IEditorActionDelegate {
    public static final String ID = "fable.polyxsim.actions.RunAction";
    public static int ANSWER_YES = 0;
    public static int ANSWER_CANCEL = 1;
    private static boolean running;
    public static RunAction runAction;
    PolyXSim simulator;
    private String fileName;
    private String currentDirectory;
    private InputEditor currentEditor;
    private IWorkbenchWindow window;

    static {
        runAction = null;
    }

    public void dispose() {
        if (this.simulator != null) {
            this.simulator.removePropertyChangeListener(this);
        }
    }

    public void init(IWorkbenchWindow arg0) {
        running = false;
        runAction = this;
        this.window = arg0;
    }

    public void run(IAction arg0) {
        this.simulator = new PolyXSim();
        try {
            IEditorReference[] ref;
            this.simulator.setInputFileDirectory(this.currentDirectory);
            FableLogger.getLogger(RunAction.class).info((Object)("selected file :" + this.fileName));
            this.simulator.setInputFile(this.fileName);
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            File file = new File(this.fileName);
            int answer = ANSWER_YES;
            if (file.exists() && (ref = this.findEditor(file)) != null) {
                int i = 0;
                while (i < ref.length) {
                    if (ref[i].isDirty() && (answer = this.confirmSave(this.fileName)) == ANSWER_YES) {
                        ref[i].getEditor(true).doSave(null);
                    }
                    ++i;
                }
            }
            if (answer != ANSWER_CANCEL) {
                this.simulator.run();
            }
        }
        catch (JepException e) {
            SWTUtils.errMsg((String)e.getMessage());
        }
    }

    public void run() {
        running = !running;
    }

    public void selectionChanged(IAction arg0, ISelection selection) {
        IStructuredSelection sSelection;
        Object first;
        if (selection instanceof IStructuredSelection && (first = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof org.eclipse.core.internal.resources.File) {
            File file = ((org.eclipse.core.internal.resources.File)first).getLocation().toFile();
            this.fileName = file.getPath();
            this.currentDirectory = file.getParent();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("polyxsim")) {
            String val = (String)event.getNewValue();
            running = val.equals("running");
        }
    }

    public void init(IViewPart view) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof InputEditor) {
            this.currentEditor = (InputEditor)targetEditor;
            this.fileName = this.currentEditor.getPartName();
            this.currentDirectory = this.currentEditor.getPolyXSim().getInputFileDirectory();
        } else if (targetEditor instanceof PolyXSimTextEditor) {
            this.fileName = ((PolyXSimTextEditor)targetEditor).getFileName();
            this.currentDirectory = ((PolyXSimTextEditor)targetEditor).getCurrentDirectory();
            this.fileName = String.valueOf(this.currentDirectory) + this.fileName;
        } else {
            this.currentDirectory = null;
            this.fileName = null;
            this.currentEditor = null;
        }
    }

    public IEditorReference[] findEditor(File inputFile) {
        if (this.window != null) {
            IEditorInput input = SWTUtils.createEditorInput((File)inputFile);
            return this.window.getActivePage().findEditors(input, null, 1);
        }
        return null;
    }

    public int confirmSave(String filename) {
        int answer = ANSWER_YES;
        answer = FableUtils.questionMsg((String)("'" + filename + "' has changed.\n\n" + "Do you want to save it before running ?"));
        return answer;
    }
}

