/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database;

import fable.framework.database.Activator;
import fable.framework.toolbox.FableUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DerbyDatabase {
    private static final boolean DEBUG_CONNECTION = false;
    private static final boolean DO_TEST = false;
    private static boolean enabled = false;
    private String driver = Activator.getDefault().getEmbedded() ? "org.apache.derby.jdbc.EmbeddedDriver" : "org.apache.derby.jdbc.ClientDriver";
    private String url = Activator.getDefault().getUrl();
    private String user = Activator.getDefault().getUser();
    private String password = Activator.getDefault().getPassword();
    private static Connection conn = null;
    private Statement statement = null;
    private static DerbyDatabase database = null;

    private DerbyDatabase() throws SQLException {
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.password);
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (InstantiationException ex) {
            String msg = "Database error instantiating " + this.driver;
            FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "Database access error instantiating " + this.driver;
            FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            String msg = "Database class error instantiating " + this.driver;
            FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
        }
        conn = DriverManager.getConnection(this.url);
        this.statement = conn.createStatement();
    }

    public static Connection getConnection() {
        return conn;
    }

    private static void createDatabase() throws SQLException {
        database = new DerbyDatabase();
    }

    public void createTable(String table) throws SQLException {
        this.statement.execute("create table " + table);
    }

    public void insert(String table, String values) throws SQLException {
        this.statement.execute("insert into " + table + " values " + values);
    }

    public static DerbyDatabase getDatabase() throws SQLException {
        enabled = Activator.getDefault().getEnabled();
        if (enabled && database == null) {
            DerbyDatabase.createDatabase();
        }
        return database;
    }

    public static void setEnabled(boolean enabled) {
        DerbyDatabase.enabled = enabled;
    }
}

