/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.process;

import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import fable.python.Sample;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import org.eclipse.swt.widgets.Display;

public class RetrieveExperimentFromDb
extends Thread
implements IPreprocessorListener {
    private boolean stopListening = false;
    private boolean dataRetrieve = false;
    private Preprocessor spdPreprocessor = Preprocessor.getDefault();
    private DeviceProxy beamline;
    private String onLineDirectory = "";
    private String sampleName = "searching ...";
    private String experiment = "searching ...";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!Display.getDefault().isDisposed() && !this.stopListening) {
            this.dataRetrieve = this.retrieveExperimentData();
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (!Display.getDefault().isDisposed()) {
                            RetrieveExperimentFromDb.this.spdPreprocessor.setSample(new Sample(RetrieveExperimentFromDb.this.experiment, RetrieveExperimentFromDb.this.sampleName, RetrieveExperimentFromDb.this.getSampleDirectory()));
                        }
                    }
                });
            }
            if (!this.spdPreprocessor.getM_mode().equals("ON")) {
                try {
                    RetrieveExperimentFromDb retrieveExperimentFromDb = this;
                    synchronized (retrieveExperimentFromDb) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    FableUtils.errMsg((Object)this, (String)("An InterruptedException has been thrown while trying to stand by update Thread :" + e.getMessage()));
                }
                catch (Exception i) {
                    FableUtils.errMsg((Object)this, (String)("An InterruptedException has been thrown while trying to stand by update Thread :" + i.getMessage()));
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                FableUtils.errMsg((Object)this, (String)e.getMessage());
            }
        }
    }

    private boolean importBeamlineServer() {
        boolean bok = true;
        if (this.beamline == null) {
            try {
                this.beamline = new DeviceProxy("taco://id11/id11/database/1");
                this.beamline.set_rpc_protocol(1);
                bok = true;
            }
            catch (DevFailed e) {
                FableUtils.errMsg((Object)this, (String)e.getMessage());
                bok = false;
            }
        }
        return bok;
    }

    private boolean retrieveExperimentData() {
        boolean bok = this.importBeamlineServer();
        if (bok) {
            try {
                DeviceData in = new DeviceData();
                String[] s_arr = new String[]{"directory", "id11"};
                in.insert(s_arr);
                DeviceData myData = this.beamline.command_inout("DbQuerySettings", in);
                String[] out_arr = myData.extractStringArray();
                this.onLineDirectory = out_arr[0];
                try {
                    in = new DeviceData();
                    s_arr = new String[]{"experiment", "id11"};
                    in.insert(s_arr);
                    myData = this.beamline.command_inout("DbQuerySettings", in);
                    out_arr = myData.extractStringArray();
                    this.experiment = out_arr[0];
                    try {
                        in = new DeviceData();
                        s_arr = new String[]{"sample", "id11"};
                        in.insert(s_arr);
                        myData = this.beamline.command_inout("DbQuerySettings", in);
                        out_arr = myData.extractStringArray();
                        this.sampleName = out_arr[0];
                    }
                    catch (DevFailed e) {
                        Activator.log("Error accessing database to retrieve current experiment directory", 4, (Exception)((Object)e));
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayError("Error accessing database to retrieve current experiment directory");
                        }
                        FableUtils.errMsg((Object)this, (String)"Error accessing database to retrieve current experiment directory");
                        bok = false;
                    }
                }
                catch (DevFailed e) {
                    Activator.log("Error accessing database to retrieve current experiment", 4, (Exception)((Object)e));
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error accessing id11 database to retrieve current experiment");
                    }
                    FableUtils.errMsg((Object)this, (String)"Error accessing id11 database to retrieve current experiment");
                    bok = false;
                }
            }
            catch (DevFailed e) {
                FableUtils.errMsg((Object)this, (String)"Error accessing id11 database to retrieve current directory");
                Activator.log("Error accessing id11 database to retrieve current directory", 4, (Exception)((Object)e));
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Error accessing id11 database to retrieve current directory");
                }
                bok = false;
            }
        }
        return bok;
    }

    private String getSampleDirectory() {
        String sampleDirectory = null;
        sampleDirectory = this.onLineDirectory;
        return sampleDirectory;
    }

    public boolean isDataRetrieve() {
        return this.dataRetrieve;
    }

    public void setDataRetrieve(boolean dtRetrieve) {
        this.dataRetrieve = dtRetrieve;
    }

    public void stopListeningToDb() {
        this.stopListening = true;
    }

    public synchronized void start() {
        this.stopListening = false;
        super.start();
    }

    public void preprocessorChanged(PreprocessorEvent pe) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocessorModeChange(PreprocessorEvent pe) {
        String selectedMode = ((Preprocessor)pe.getSource()).getM_mode();
        if (selectedMode.equals("ON")) {
            RetrieveExperimentFromDb retrieveExperimentFromDb = this;
            synchronized (retrieveExperimentFromDb) {
                this.notifyAll();
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayInfo("Start looking for experiments information");
                }
            }
        }
        RetrieveExperimentFromDb retrieveExperimentFromDb = this;
        synchronized (retrieveExperimentFromDb) {
            try {
                this.wait();
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayInfo("Stop looking for experiments information");
                }
            }
            catch (InterruptedException e) {
                FableUtils.errMsg((Object)this, (String)e.getMessage());
            }
        }
    }

    public void preprocessorNewMessage(PreprocessorEvent pe) {
    }

    public void preprocessorNewSample(PreprocessorEvent pe) {
    }

    public void preprocessorStateChange(PreprocessorEvent pe) {
    }

    public void preprocessorNewImages(PreprocessorEvent pe) {
    }
}

