/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.process;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.PreprocessorEvent;
import fable.preprocessor.process.RetrieveExperimentFromDb;
import fable.preprocessor.toolBox.PreprocessorMessage;
import fable.preprocessor.toolBox.Toolbox;
import fable.preprocessor.views.ProcessingView;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Sample;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements Runnable,
Preferences.IPropertyChangeListener {
    public static Preprocessor preprocessor;
    private RetrieveExperimentFromDb updateThread;
    private String m_mode;
    private String darkStem;
    private String darkFile;
    private String floodFile;
    private String distFile;
    private int distortionAction;
    private boolean applyDarkCorrection;
    private boolean applyFloodCorrection;
    private boolean applyDistCorrection;
    private String spdCommand;
    private String extFlood;
    private String extDist;
    private String modeImage;
    private String modeText;
    private String otherOptions;
    private PreprocessorMessage logMessage;
    private boolean m_bStatusProcessing;
    private Vector<IPreprocessorListener> listListener = new Vector();
    private Sample sample;
    private ProcessThread _threadProcess = null;
    private String extTypeRegex;
    private boolean clearCommandOption;
    private String srcExt;
    private String corExt = "";
    private String inpConst;
    private String inpExp;
    private String inpFactor;
    private String saveDark;
    private String dark_const;
    private String darkExt;
    public String spdMode;
    public static int numberImages;
    private String spdServer = null;
    private DeviceProxy spdProxy = null;
    private IPropertyChangeListener preferencesListener;
    private Vector<Sample> v_Samples = new Vector();
    public boolean processAll = false;
    private boolean bSizeIsOk = true;
    private String reffileDim1 = "";
    private String reffileDim2 = "";
    private boolean zipCorrectedFiles;
    private boolean zipOriginalfiles;
    private String zipCmd;
    private String typeoutfile;
    private String dvo;
    private ArrayList<IPropertyChangeListener> viewsListeners = new ArrayList();
    private int notValidCounter;
    private Job jobToCheckSize;
    private String fileOfComparison;
    public String currentCorrectedFileName = "";
    public int processWorked = 0;

    private Preprocessor() {
        this.logMessage = new PreprocessorMessage();
    }

    public boolean isOnLine() {
        boolean bOnLine = false;
        if (this.getM_mode() != null) {
            bOnLine = this.getM_mode().equals("ON");
        }
        return bOnLine;
    }

    public boolean isOffLine() {
        boolean bOffLine = false;
        if (this.getM_mode() != null) {
            bOffLine = this.getM_mode().equals("OFF");
        }
        return bOffLine;
    }

    public boolean isZipCorrectedFiles() {
        return this.zipCorrectedFiles;
    }

    public void setZipCorrectedFiles(boolean zipCorrectedFiles) {
        this.zipCorrectedFiles = zipCorrectedFiles;
    }

    public void removeAllNewTypeOfFiles() {
        this.extTypeRegex = "";
    }

    public void addNewTypeOfFiles(String type) {
        if (this.extTypeRegex == null) {
            this.extTypeRegex = "";
        }
        this.extTypeRegex = String.valueOf(this.extTypeRegex) + "(" + type + ")?";
    }

    public void RemoveAllNewTypeOfFiles(String type) {
        this.extTypeRegex = "";
    }

    public static Preprocessor getDefault() {
        if (preprocessor == null) {
            preprocessor = new Preprocessor();
            Preferences prefs = Activator.getDefault().getPluginPreferences();
            prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)preprocessor);
            preprocessor.setM_mode(prefs.getString("pref_mode"));
            preprocessor.setCommand(prefs.getString("pref_cmd_spd"));
            preprocessor.setSpdMode(prefs.getString("pref_spd_server"));
        }
        return preprocessor;
    }

    public void addPreprocessorListener(IPreprocessorListener pl) {
        this.listListener.add(pl);
    }

    public void removePreprocessorListener(IPreprocessorListener pl) {
        this.listListener.remove(pl);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.viewsListeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.viewsListeners.remove(listener);
    }

    public void fireExperimentInfoChange(String[] selectedSamples, String experimentName) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_selectedFiles", null, (Object)selectedSamples));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_experiment", null, (Object)experimentName));
        }
    }

    public void fireCurrentSampleHasChanged(String stextSampleDirectory, String sampleName) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_directory", null, (Object)stextSampleDirectory));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_sample", null, (Object)sampleName));
        }
    }

    public void fireShowRequiredFields() {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_showRequired", null, (Object)true));
        }
    }

    public void fireCurrentCorrectedExtensionHasChanged(String val) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_correctedExtension", null, (Object)val));
        }
    }

    public void fireShowFlag() {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_ShowFilesInError", null, null));
        }
    }

    private void firePreprocessorChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorChanged(pe);
        }
    }

    private void firePreprocessorModeChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorModeChange(pe);
        }
    }

    private void firePreprocessorStateChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorStateChange(pe);
        }
    }

    private void firePreprocessorNewMessage() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorNewMessage(pe);
        }
    }

    public void fireSampleHasChanged() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorNewSample(pe);
        }
        if (this.isOnLine() && this.isM_bStatusProcessing()) {
            this.run();
        }
    }

    private void updateGUIOnLineMode() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorNewImages(pe);
        }
    }

    @Override
    public void run() {
        Vector<Sample> samples = this.get_Samples();
        if (samples != null) {
            numberImages = 0;
            this.processWorked = samples.size();
            if (this._threadProcess != null && this.isM_bStatusProcessing() && this.isOnLine()) {
                this._threadProcess.stopProcessing = true;
            }
            int i = 0;
            while (i < samples.size()) {
                this._threadProcess = new ProcessThread(samples.elementAt(i), this.isM_applyDarkCorrection(), this.isM_applyFloodCorrection(), this.isM_applyDistCorrection(), this.getM_mode());
                if (this.isM_bStatusProcessing()) {
                    this._threadProcess.start();
                }
                ++i;
            }
        }
    }

    public void stop() {
        if (this._threadProcess != null) {
            this._threadProcess.notifyEnd();
        }
    }

    public String getCommand() {
        String osName = System.getProperty("os.name").toLowerCase();
        String addInFrontOfCommand = "";
        String avoidErrorWithSpaces = "";
        if (osName.contains("windows")) {
            addInFrontOfCommand = "cmd /C ";
        }
        String myString = String.valueOf(addInFrontOfCommand) + avoidErrorWithSpaces + this.getSpdCommand() + avoidErrorWithSpaces + " ";
        if (!this.get_cor_ext().equals("")) {
            myString = String.valueOf(myString) + " cor_ext=" + this.get_cor_ext();
        }
        if (!this.get_src_ext().equals("")) {
            myString = String.valueOf(myString) + " src_ext=" + this.get_src_ext();
        }
        if (this.isM_applyDarkCorrection()) {
            if (!this.darkFile.equals("")) {
                myString = String.valueOf(myString) + " dark_file=" + this.darkFile;
            }
            if (this.get_dark_const() != null && !this.get_dark_const().equals("")) {
                myString = String.valueOf(myString) + " dark_const=" + this.get_dark_const();
            }
            if (this.get_dark_ext() != null && !this.get_dark_ext().equals("")) {
                myString = String.valueOf(myString) + " dark_ext=" + this.get_dark_ext();
            }
            if (this.get_inp_const() != null && !this.get_inp_const().equals("")) {
                myString = String.valueOf(myString) + " inp_const=" + this.get_inp_const();
            }
            if (this.get_inp_factor() != null && !this.get_inp_factor().equals("")) {
                myString = String.valueOf(myString) + " inp_factor=" + this.get_inp_factor();
            }
            if (this.get_inp_exp() != null && !this.get_inp_exp().equals("")) {
                myString = String.valueOf(myString) + " inp_exp=" + this.get_inp_exp();
            }
            if (this.get_save_dark() != null && !this.get_inp_const().equals("")) {
                myString = String.valueOf(myString) + " save_dark=" + this.get_save_dark();
            }
        }
        if (this.isM_applyFloodCorrection() && !this.floodFile.equals("")) {
            myString = String.valueOf(myString) + " flood_file=" + this.floodFile;
        }
        if (this.isM_applyDistCorrection()) {
            if (!this.distFile.equals("")) {
                myString = String.valueOf(myString) + " distortion_file=" + this.distFile;
            }
            myString = String.valueOf(myString) + " do_distortion=" + this.getDistortionAction() + " flat_distortion=1";
        } else {
            myString = String.valueOf(myString) + " do_distortion=0 ";
        }
        myString = String.valueOf(myString) + " pass=1";
        if (Toolbox.isSpdNew() && this.dvo != null && this.typeoutfile != null) {
            myString = String.valueOf(myString) + " dvo=" + this.dvo + " type=" + this.typeoutfile;
        }
        if (this.otherOptions != null) {
            myString = String.valueOf(myString) + " " + this.otherOptions;
        }
        return String.valueOf(myString) + " ";
    }

    public static void incrementImagesCorrected() {
        ProcessingView.getDefault().setDescription(--numberImages, "files left to process", 3);
        if (numberImages < 1 && preprocessor.isOffLine()) {
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }
    }

    public boolean isM_bStatusProcessing() {
        return this.m_bStatusProcessing;
    }

    public void setM_bStatusProcessing(boolean statusProcessing) {
        if (this.m_bStatusProcessing != statusProcessing) {
            this.m_bStatusProcessing = statusProcessing;
            if (this.m_bStatusProcessing) {
                Activator.log("Processor Status is running");
            } else {
                Activator.log("Processor Status is stopped");
            }
            this.firePreprocessorStateChange();
            this.firePreprocessorChange();
        }
    }

    public int getDistortionAction() {
        return this.distortionAction;
    }

    public void setDistortionAction(int action) {
        this.distortionAction = action;
    }

    public String getSpdCommand() {
        return this.spdCommand;
    }

    public String getZipCmd() {
        return this.zipCmd;
    }

    public void setZipCmd(String cmd) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            cmd = "\"" + cmd + "\"";
        }
        this.zipCmd = cmd;
    }

    public void setCommand(String newCommand) {
        System.getProperties();
        this.spdCommand = ToolBox.addQuotesForSpacesInName((String)newCommand, (String)"[\\\\/]", (String)System.getProperty("file.separator"));
    }

    public Vector<Sample> get_Samples() {
        return this.v_Samples;
    }

    public Sample getCurrentSample() {
        return this.sample;
    }

    public boolean set_Samples(Vector<Sample> listOfSamples) {
        this.v_Samples = (Vector)listOfSamples.clone();
        if (this.v_Samples.size() > 0) {
            this.sample = this.v_Samples.elementAt(0);
        }
        return true;
    }

    public boolean setSample(Sample spl) {
        Sample oldsample = null;
        if (this.v_Samples.size() > 0) {
            oldsample = this.v_Samples.elementAt(0);
        }
        boolean bnewsample = false;
        if (oldsample != null) {
            if (!oldsample.getParentDirectoryName().equals(spl.getParentDirectoryName())) {
                bnewsample = true;
            } else if (!oldsample.getDirectoryName().equals(spl.getDirectoryName())) {
                bnewsample = true;
            } else if (!oldsample.getDirectoryPath().equals(spl.getDirectoryPath())) {
                bnewsample = true;
            }
        } else {
            Activator.log("Set sample: " + spl);
            bnewsample = true;
        }
        if (bnewsample) {
            this.v_Samples.removeAllElements();
            this.v_Samples.setSize(1);
            this.v_Samples.set(0, spl);
            this.sample = spl;
            this.fireSampleHasChanged();
            this.firePreprocessorChange();
            if (this.isM_bStatusProcessing() && this._threadProcess != null) {
                this._threadProcess.setThreadTimer(System.currentTimeMillis());
                this._threadProcess.setThreadSample(this.sample);
                String dir = this.sample.getDirectoryPath();
                dir = String.valueOf(dir) + System.getProperty("file.separator");
                this._threadProcess.setThreadSampleDirectory(dir);
                this._threadProcess.setThreadSampleName(this.sample.getDirectoryName());
            }
        }
        return bnewsample;
    }

    public boolean isM_applyDarkCorrection() {
        return this.applyDarkCorrection;
    }

    public void setM_applyDarkCorrection(boolean darkCorrection) {
        if (this.applyDarkCorrection != darkCorrection) {
            this.applyDarkCorrection = darkCorrection;
            if (darkCorrection) {
                this.logMessage.setM_Message("Dark correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Dark correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyDistCorrection() {
        return this.applyDistCorrection;
    }

    public void setM_applyDistCorrection(boolean distCorrection) {
        if (this.applyDistCorrection != distCorrection) {
            this.applyDistCorrection = distCorrection;
            if (distCorrection) {
                this.logMessage.setM_Message("Spatial distortion will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Spatial distortion will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyFloodCorrection() {
        return this.applyFloodCorrection;
    }

    public void setM_applyFloodCorrection(boolean floodCorrection) {
        if (this.applyFloodCorrection != floodCorrection) {
            this.applyFloodCorrection = floodCorrection;
            if (floodCorrection) {
                this.logMessage.setM_Message("Flood correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Flood correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public String getM_darkStem() {
        return this.darkStem;
    }

    public void setM_darkStem(String file) {
        if (file != null && !file.equals(this.getM_darkStem())) {
            this.darkStem = file;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_darkFile() {
        return this.darkFile;
    }

    public void setM_darkFile(String file) {
        if (file != null && !file.equals(this.darkFile)) {
            this.darkFile = file;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_distFile() {
        return this.distFile;
    }

    public void setM_distFile(String file) {
        if (file != null && !file.equals(this.getM_distFile())) {
            this.distFile = file;
            this.logMessage.setM_Message("Spatial Distortion file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setOtherOptions(String spdOptions) {
        this.otherOptions = spdOptions;
    }

    public String getM_floodFile() {
        return this.floodFile;
    }

    public void setM_floodFile(String file) {
        if (file != null && !file.equals(this.getM_floodFile())) {
            this.floodFile = file;
            this.logMessage.setM_Message("Flood file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setCompress(boolean compressOriginal, boolean compressCorrected, String cmd) {
        this.setZipCmd(cmd);
        this.zipCorrectedFiles = compressCorrected;
        this.zipOriginalfiles = compressOriginal;
    }

    public String getM_mode() {
        return this.m_mode;
    }

    public void setM_mode(String mode) {
        if (mode != null && !mode.equals(this.m_mode)) {
            this.m_mode = mode;
            if (this.m_mode.compareTo("OFF") == 0) {
                this.setM_modeImage("images/disconnected.gif");
                this.setM_modeText("Offline");
            } else {
                this.setM_modeImage("images/connected.gif");
                this.setM_modeText("Online");
            }
            this.logMessage.setM_Message("Preprocessor mode is " + this.getM_modeText());
            this.logMessage.setM_Type(1);
            Activator.log("Preprocessor mode is : " + this.getM_modeText());
            if (this.isOnLine()) {
                this.startUpdatExperimentDataThread();
            }
            this.firePreprocessorModeChange();
        }
    }

    public String getSpdMode() {
        return this.spdMode;
    }

    public void setSpdMode(String mode) {
        this.spdMode = mode;
    }

    private void setSpdServer(String name) {
        this.spdServer = name;
    }

    public void set_cor_ext(String corrExt) {
        this.corExt = corrExt;
    }

    public String get_cor_ext() {
        return this.corExt;
    }

    public String getPredictableCorrectedExtension() {
        String predictableExtension = "cor";
        if (!this.corExt.trim().equals("")) {
            predictableExtension = this.corExt;
        }
        if (this.isZipCorrectedFiles()) {
            predictableExtension = String.valueOf(predictableExtension) + ".gz";
        }
        return predictableExtension;
    }

    public void set_src_ext(String corrExt) {
        this.srcExt = corrExt;
    }

    public String get_src_ext() {
        if (this.srcExt == null) {
            this.srcExt = "";
        }
        return this.srcExt;
    }

    public void set_clearCommand(boolean bClear) {
        this.clearCommandOption = bClear;
    }

    public boolean get_clearOption() {
        return this.clearCommandOption;
    }

    public String get_inp_const() {
        return this.inpConst;
    }

    public String get_dark_const() {
        return this.dark_const;
    }

    public void set_dark_const(String darkconst) {
        this.dark_const = darkconst;
    }

    public String get_dark_ext() {
        return this.darkExt;
    }

    public void set_dark_ext(String _dark_ext) {
        this.darkExt = _dark_ext;
    }

    public void set_inp_const(String inpconst) {
        this.inpConst = inpconst;
    }

    public String get_inp_exp() {
        return this.inpExp;
    }

    public void set_inp_exp(String inp_exp) {
        this.inpExp = inp_exp;
    }

    public String get_inp_factor() {
        return this.inpFactor;
    }

    public void set_inp_factor(String inpfactor) {
        this.inpFactor = inpfactor;
    }

    public String get_save_dark() {
        return this.saveDark;
    }

    public void set_save_dark(String savedark) {
        this.saveDark = savedark;
    }

    public String get_extDist() {
        return this.extDist;
    }

    public void set_extDist(String dist) {
        this.extDist = dist;
    }

    public String get_extFlood() {
        return this.extFlood;
    }

    public void set_extFlood(String flood) {
        this.extFlood = flood;
    }

    public String getM_modeImage() {
        return this.modeImage;
    }

    private void setM_modeImage(String image) {
        this.modeImage = image;
    }

    public String getM_modeText() {
        return this.modeText;
    }

    private void setM_modeText(String text) {
        this.modeText = text;
    }

    public PreprocessorMessage getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(PreprocessorMessage msg) {
        this.logMessage = msg;
        this.firePreprocessorNewMessage();
    }

    private boolean checkSizeOnLine(String[] filesToProcessOnLine) {
        this.bSizeIsOk = true;
        if (this.applyDarkCorrection && this.darkFile != null && !this.darkFile.equals("")) {
            try {
                this.bSizeIsOk = this.checkSize(new FabioFile(this.darkFile));
            }
            catch (FabioFileException e) {
                this.bSizeIsOk = false;
                if (!this.isOnLine()) {
                    FableUtils.excMsg((Object)this, (String)"An error occured while comparing image dimension", (Throwable)e);
                }
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
            }
        } else if (this.bSizeIsOk && this.applyFloodCorrection && this.floodFile != null && !this.floodFile.equals("")) {
            try {
                if (this.sample.getFabioFiles().size() < 1) {
                    this.sample.addFabioFiles(filesToProcessOnLine);
                }
                FabioFile fabio = new FabioFile(this.floodFile);
                this.bSizeIsOk = this.checkSize(fabio);
            }
            catch (FabioFileException e) {
                this.bSizeIsOk = false;
                FableUtils.excMsg((Object)this, (String)"An error occured while comparing image dimension", (Throwable)e);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
            }
        }
        return this.bSizeIsOk;
    }

    public void setCorrectionType(String data) {
        if (data != null) {
            this.typeoutfile = data;
        }
    }

    public void setDataValueOffset(String text) {
        if (text != null) {
            this.dvo = text;
        }
    }

    public void dispose() {
        if (this.updateThread != null && this.updateThread.isAlive()) {
            this.updateThread.stopListeningToDb();
        }
        Activator.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        if (event.getProperty().equals("pref_mode")) {
            this.setM_mode(prefs.getString("pref_mode"));
        } else if (event.getProperty().equals("pref_cmd_spd")) {
            this.setCommand(prefs.getString("pref_cmd_spd"));
        } else if (event.getProperty().equals("pref_spd_mode")) {
            if (event.getNewValue().equals("server")) {
                this.setSpdMode("server");
            } else {
                this.setSpdMode("OFF");
            }
        }
    }

    public boolean compareSizeOfTwoFiles(FabioFile fabio1, FabioFile fabioDarkOrFloodFile) {
        boolean sizeOk = true;
        try {
            String dim_1 = fabio1.getValue("Dim_1").replaceAll("\\p{Space}", "");
            String dim_2 = fabio1.getValue("Dim_2").replaceAll("\\p{Space}", "");
            String reffileDim1 = fabioDarkOrFloodFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
            String reffileDim2 = fabioDarkOrFloodFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
            if (!dim_1.equals(reffileDim1) || !dim_2.equals(reffileDim2)) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR :File " + fabio1.getFileName() + "(Dim_1=" + dim_1 + ",Dim_2=" + dim_2 + ")  and " + this.fileOfComparison + "(Dim_1=" + reffileDim1 + ",Dim_2=" + reffileDim2 + ") don't have the same dimensions." + " This file will not be processed", 0));
                fabio1.setFlag(false);
                ++this.notValidCounter;
                sizeOk = false;
            } else {
                fabio1.setFlag(true);
                sizeOk = true;
            }
        }
        catch (FabioFileException e) {
            sizeOk = true;
            FableUtils.excMsg((Object)this, (String)("SpdView.checkSize:" + e.getMessage()), (Throwable)e);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
        }
        return sizeOk;
    }

    public boolean checkSize(final FabioFile file) {
        this.bSizeIsOk = true;
        this.fileOfComparison = file.getFileName();
        Vector<Sample> spls = this.get_Samples();
        int n = 0;
        while (spls != null && n < spls.size()) {
            final Sample sp = spls.elementAt(n);
            this.notValidCounter = 0;
            if (sp != null && sp.getFilteredfiles() != null) {
                int indice = 0;
                while (indice < sp.getFilteredfiles().size() && indice < 1) {
                    final FabioFile sampleFile = (FabioFile)sp.getFilteredfiles().elementAt(indice);
                    final String sampleFilename = sampleFile.getFileName();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                Preprocessor.this.reffileDim1 = file.getValue("Dim_1").replaceAll("\\p{Space}", "");
                                Preprocessor.this.reffileDim2 = file.getValue("Dim_2").replaceAll("\\p{Space}", "");
                                String dim_1 = sampleFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
                                String dim_2 = sampleFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
                                if (!dim_1.equals(Preprocessor.this.reffileDim1) || !dim_2.equals(Preprocessor.this.reffileDim2)) {
                                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR " + sp.getDirectoryName() + ":File " + sampleFilename + "(Dim_1=" + dim_1 + ",Dim_2=" + dim_2 + ")  and " + Preprocessor.this.fileOfComparison + "(Dim_1=" + Preprocessor.this.reffileDim1 + ",Dim_2=" + Preprocessor.this.reffileDim2 + ") don't have the same dimensions." + " This file will not be processed", 0));
                                    sampleFile.setFlag(false);
                                    Preprocessor preprocessor = Preprocessor.this;
                                    preprocessor.notValidCounter = preprocessor.notValidCounter + 1;
                                    Preprocessor.this.bSizeIsOk = false;
                                } else {
                                    sampleFile.setFlag(true);
                                    Preprocessor.this.bSizeIsOk = true;
                                }
                            }
                            catch (FabioFileException e) {
                                Preprocessor.this.bSizeIsOk = true;
                                FableUtils.excMsg((Object)this, (String)("SpdView.checkSize:" + e.getMessage()), (Throwable)e);
                                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
                            }
                        }
                    });
                    ++indice;
                }
                sp.setValide(this.notValidCounter == 0);
            }
            ++n;
        }
        return this.bSizeIsOk;
    }

    private void initJob() {
        this.jobToCheckSize = new Job("CheckSize"){

            protected IStatus run(IProgressMonitor monitor) {
                Vector<Sample> spls = Preprocessor.this.get_Samples();
                int n = 0;
                while (spls != null && n < spls.size()) {
                    final Sample sp = spls.elementAt(n);
                    Preprocessor.this.notValidCounter = 0;
                    if (sp != null && sp.hasFile()) {
                        monitor.beginTask("Compare size of images between " + sp.getDirectoryName() + " and " + Preprocessor.this.fileOfComparison, 1);
                        int indice = 0;
                        while (indice < 1) {
                            if (monitor.isCanceled()) {
                                monitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            final FabioFile sampleFile = (FabioFile)sp.getFilteredfiles().elementAt(indice);
                            final String sampleFilename = sampleFile.getFileName();
                            monitor.subTask(sampleFilename);
                            if (monitor.isCanceled()) {
                                monitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        String dim_1 = sampleFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
                                        String dim_2 = sampleFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
                                        if (!dim_1.equals(Preprocessor.this.reffileDim1) || !dim_2.equals(Preprocessor.this.reffileDim2)) {
                                            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR " + sp.getDirectoryName() + ":File " + sampleFilename + "(Dim_1=" + dim_1 + ",Dim_2=" + dim_2 + ")  and " + Preprocessor.this.fileOfComparison + "(Dim_1=" + Preprocessor.this.reffileDim1 + ",Dim_2=" + Preprocessor.this.reffileDim2 + ") don't have the same dimensions." + " This file will not be processed", 0));
                                            sampleFile.setFlag(false);
                                            Preprocessor preprocessor = Preprocessor.this;
                                            preprocessor.notValidCounter = preprocessor.notValidCounter + 1;
                                            Preprocessor.this.bSizeIsOk = false;
                                        } else {
                                            sampleFile.setFlag(true);
                                            Preprocessor.this.bSizeIsOk = true;
                                        }
                                    }
                                    catch (FabioFileException e) {
                                        Preprocessor.this.bSizeIsOk = true;
                                        FableUtils.excMsg((Object)this, (String)("SpdView.checkSize:" + e.getMessage()), (Throwable)e);
                                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
                                    }
                                }
                            });
                            if (monitor.isCanceled()) {
                                monitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            monitor.worked(1);
                            ++indice;
                        }
                    }
                    sp.setValide(Preprocessor.this.notValidCounter == 0);
                    ++n;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
    }

    public boolean isSizeCheckedOk() {
        return this.bSizeIsOk;
    }

    public static String getFileNameOfCorrectedFile(String file, String correctedExtension) {
        String correctedFiles;
        int index = file.lastIndexOf(".");
        if (correctedExtension.equals("")) {
            if (ToolBox.getFileType((String)file).equals("cor")) {
                index = 0;
            }
            correctedFiles = index > 0 && index + 1 < file.length() ? file.substring(0, index + 1) : String.valueOf(file) + ".";
            correctedFiles = String.valueOf(correctedFiles) + "cor";
        } else {
            correctedFiles = String.valueOf(file) + correctedExtension;
        }
        return correctedFiles;
    }

    private void createUpdateExperimentThread() {
        this.updateThread = new RetrieveExperimentFromDb();
    }

    private void startUpdatExperimentDataThread() {
        if (this.updateThread == null) {
            this.createUpdateExperimentThread();
            this.updateThread.start();
        } else {
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            RetrieveExperimentFromDb retrieveExperimentFromDb = this.updateThread;
            synchronized (retrieveExperimentFromDb) {
                this.updateThread.notifyAll();
            }
        }
        catch (Exception i) {
            FableUtils.excMsg((Object)this, (String)"An error occured while trying to restart processing", (Throwable)i);
            System.out.println("An exception has been thrown while trying to wake up updateThread: " + i.getMessage());
        }
    }

    public void compressFiles(String files) {
        block6: {
            String zipCommand = String.valueOf(preprocessor.getZipCmd()) + " " + files;
            this.setLogMessage(new PreprocessorMessage(zipCommand, 1));
            if (System.getProperty("os.name").toLowerCase().contains("window")) {
                zipCommand = "cmd /C " + zipCommand;
            }
            try {
                Process zipCorrectedImages = Runtime.getRuntime().exec(zipCommand);
                StreamReaderThread outThread = new StreamReaderThread(zipCorrectedImages.getInputStream());
                StreamReaderThread errThread = new StreamReaderThread(zipCorrectedImages.getErrorStream());
                outThread.start();
                errThread.start();
                try {
                    zipCorrectedImages.waitFor();
                    outThread.join();
                    errThread.join();
                    if (zipCorrectedImages.waitFor() == 0) {
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Compression finished", 1));
                        Activator.log(String.valueOf(zipCommand) + " finished");
                        break block6;
                    }
                    Activator.log("ERROR:" + zipCommand + " has not finished properly :  " + zipCorrectedImages.waitFor(), 4, null);
                    this.setLogMessage(new PreprocessorMessage("ERROR:" + zipCommand + " has not finished properly :  " + zipCorrectedImages.waitFor(), 0));
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)(String.valueOf(zipCommand) + " has not finished properly :  "), (Throwable)e);
                }
            }
            catch (IOException e1) {
                FableUtils.excMsg((Object)this, (String)(String.valueOf(zipCommand) + " has not finished properly :  "), (Throwable)e1);
            }
        }
    }

    private String[] getAllFilesInDirectory(String currentDirectory, String stem, String extension) {
        String regularExpression = String.valueOf(stem) + "(\\d+)*\\.edf";
        String[] listAllOriginalImagesInDir = ToolBox.getFileNamesByEntireRegex((String)currentDirectory, (String)regularExpression, (boolean)true);
        return listAllOriginalImagesInDir;
    }

    private String[] getAllFilesProcessedInADirectory(String currentDirectory, String stem, String flagForNewFiles) {
        String ProcessedFileRegex = String.valueOf(stem) + "(\\d+)*\\.(\\w+)?" + flagForNewFiles;
        String[] listImagesProcessed = ToolBox.getFileNamesByEntireRegex((String)currentDirectory, (String)ProcessedFileRegex, (boolean)true);
        return listImagesProcessed;
    }

    public String[] getNewFilesOnLine(String directory, String name, long threadTimer, String flagForNewFiles) {
        String sampleRegex = String.valueOf(name) + "(\\d+)*\\.edf";
        String[] newFiles = null;
        String[] listImagesProcessed = this.getAllFilesProcessedInADirectory(directory, name, flagForNewFiles);
        String[] listAllOriginalImagesInDir = this.processAll ? this.getAllFilesInDirectory(directory, name, "edf") : ToolBox.getFilesByEntireRegexAndTime((String)directory, (String)sampleRegex, (boolean)true, (long)threadTimer);
        if (listAllOriginalImagesInDir != null && listAllOriginalImagesInDir.length > 0) {
            int max_length = listAllOriginalImagesInDir.length;
            int i = 0;
            while (i < listImagesProcessed.length) {
                int j = 0;
                boolean bfound = false;
                while (!bfound && j < max_length) {
                    int len1 = listAllOriginalImagesInDir[j].split("\\.").length;
                    int len2 = listImagesProcessed[i].split("\\.").length;
                    if (len1 == 2 && len2 == 2) {
                        String myFileProcessed;
                        String myOriginalFile = listAllOriginalImagesInDir[j].split("\\.")[0];
                        if (myOriginalFile.compareTo(myFileProcessed = listImagesProcessed[i].split("\\.")[0]) == 0) {
                            if (max_length > 1) {
                                String temp = listAllOriginalImagesInDir[max_length - 1];
                                listAllOriginalImagesInDir[max_length - 1] = listAllOriginalImagesInDir[j];
                                listAllOriginalImagesInDir[j] = temp;
                            }
                            bfound = true;
                            --max_length;
                            continue;
                        }
                        ++j;
                        continue;
                    }
                    Activator.log("Error while getting new Files in preprocesor ; getNewFiles ;  listAllOriginalImagesInDir[j]=" + listAllOriginalImagesInDir[j] + " listImagesProcessed[i]=" + listImagesProcessed[i], 4, null);
                    if (max_length > 1) {
                        String temp = listAllOriginalImagesInDir[max_length - 1];
                        listAllOriginalImagesInDir[max_length - 1] = listAllOriginalImagesInDir[j];
                        listAllOriginalImagesInDir[j] = temp;
                    }
                    --max_length;
                }
                ++i;
            }
            newFiles = new String[max_length];
            int n = 0;
            while (n < max_length) {
                newFiles[n] = String.valueOf(directory) + listAllOriginalImagesInDir[n];
                Activator.log("New file detected :" + newFiles[n]);
                ++n;
            }
            if (this.sample != null) {
                try {
                    this.sample.updatefabioFiles(newFiles);
                    if (newFiles.length > 0 && !this.checkSizeOnLine(newFiles)) {
                        newFiles = this.sample.getFabioFilesToProcess(true);
                        this.sample.getFabioFiles().removeAllElements();
                    }
                }
                catch (FabioFileException fabioFileException) {}
            }
            if (newFiles != null) {
                ToolBox.quicksort((String[])newFiles, (int)0, (int)newFiles.length);
            }
        }
        return newFiles;
    }

    class ProcessThread
    extends Thread {
        private Boolean applyDark;
        private Boolean applyFlood;
        private Boolean applySpatial;
        private String markNewFileFlag;
        private boolean stopProcessing;
        private boolean onLineMode;
        private long threadTimer;
        private String threadSampleDirectory;
        private Sample threadSample;
        private String threadSampleName;
        private List<Process> process = new ArrayList<Process>();
        private int nFilesToProcess = 0;

        public ProcessThread(Sample newsample, boolean doDark, boolean doFlood, boolean doDist, String mode) {
            this.threadSample = newsample;
            this.threadSampleDirectory = newsample.getDirectoryPath();
            char sep = this.threadSampleDirectory.contains("\\") ? (char)'\\' : '/';
            this.threadSampleDirectory = String.valueOf(this.threadSampleDirectory) + sep;
            this.applyDark = doDark;
            this.applyFlood = doFlood;
            this.applySpatial = doDist;
            this.stopProcessing = false;
            this.threadSampleName = newsample.getDirectoryName();
            this.onLineMode = !mode.equals("OFF");
            this.markNewFileFlag = Preprocessor.getDefault().getPredictableCorrectedExtension();
        }

        public long getThreadTimer() {
            return this.threadTimer;
        }

        public void setThreadTimer(long threadTimer) {
            this.threadTimer = threadTimer;
        }

        public String getThreadSampleDirectory() {
            return this.threadSampleDirectory;
        }

        public void setThreadSampleDirectory(String threadSampleDirectory) {
            this.threadSampleDirectory = threadSampleDirectory;
        }

        public Sample getThreadSample() {
            return this.threadSample;
        }

        public void setThreadSample(Sample threadSample) {
            this.threadSample = threadSample;
        }

        public String getThreadSampleName() {
            return this.threadSampleName;
        }

        public void setThreadSampleName(String threadSampleName) {
            this.threadSampleName = threadSampleName;
        }

        public void run() {
            this.threadTimer = System.currentTimeMillis();
            Activator.log("Preprocessor Thread start for " + this.toString());
            if (this.onLineMode) {
                Activator.log("Waiting for new files in " + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in " + this.threadSampleName + ".... ", 1));
            }
            if (Preprocessor.this.isOnLine()) {
                this.processOnLine();
            } else {
                this.processOffline();
            }
        }

        private void processOffline() {
            if (!this.stopProcessing) {
                Object[] files = null;
                if (preprocessor.getM_mode().equals("OFF")) {
                    files = this.threadSample.getFabioFilesToProcess(true);
                }
                if (files != null && files.length != 0) {
                    numberImages += files.length;
                    this.setNFilesToProcess(files.length);
                } else {
                    numberImages += 0;
                }
                int i = 0;
                if ((this.applyDark.booleanValue() || this.applyFlood.booleanValue() || this.applySpatial.booleanValue()) && files != null && !files.equals("")) {
                    if (Preprocessor.this.spdMode.equals("server")) {
                        this.sendCommandToServer(preprocessor.getCommand(), (String[])files);
                    } else {
                        this.buildCommand(preprocessor.getCommand(), files);
                    }
                }
                if (this.stopProcessing && i - 1 < files.length) {
                    Integer rest = files.length - i;
                    Activator.log("Process has been stopped. Number of files to treat : " + rest.toString());
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process has been stopped. Number of files to treat : " + rest.toString(), 1));
                }
                --Preprocessor.this.processWorked;
                if (Preprocessor.this.processWorked == 0) {
                    this.stopProcessing = true;
                }
            }
            this.interrupt();
            Activator.log("Process ends for " + this.threadSampleName);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process ends for " + this.threadSampleName, 1));
            if (numberImages == 0) {
                ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
                ProcessingView.getDefault().updateDirectory();
            }
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }

        private void processOnLine() {
            while (!this.stopProcessing && Preprocessor.this.isOnLine()) {
                Object[] files = null;
                files = this.getNewFiles(this.markNewFileFlag);
                Preprocessor.this.sample.setFiles((String[])files);
                if (files != null && files.length != 0) {
                    numberImages = files.length;
                    this.setNFilesToProcess(numberImages);
                } else {
                    numberImages = 0;
                }
                if ((this.applyDark.booleanValue() || this.applyFlood.booleanValue() || this.applySpatial.booleanValue()) && files != null && !files.equals("")) {
                    if (Preprocessor.this.spdMode.equals("server")) {
                        this.sendCommandToServer(preprocessor.getCommand(), (String[])files);
                    } else {
                        this.buildCommand(preprocessor.getCommand(), files);
                    }
                }
                Activator.log("Waiting for new files in sample:" + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in sample: " + this.threadSampleName + ".... ", 1));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)"Sleeping thread waiting for files interrupted", (Throwable)e);
                }
            }
            this.interrupt();
            Activator.log("Process ends for " + this.threadSampleName);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process ends for " + this.threadSampleName, 1));
            ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }

        private void importSpdServer() {
            if (Preprocessor.this.spdProxy == null) {
                try {
                    Preprocessor.this.spdProxy = new DeviceProxy(Preprocessor.this.spdServer);
                    Preprocessor.this.spdProxy.set_rpc_protocol(1);
                    Preprocessor.this.spdProxy.set_timeout_millis(60000);
                }
                catch (DevFailed e) {
                    FableUtils.excMsg((Object)this, (String)("Error importing device " + Preprocessor.this.spdServer), (Throwable)e);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR importing device " + Preprocessor.this.spdServer, 0));
                }
            }
        }

        private void sendCommandToServer(String command, String[] files) {
            String[] s_arr;
            DeviceData in;
            if (Preprocessor.this.spdProxy == null) {
                this.importSpdServer();
            }
            String[] commands = command.split("\\s+");
            int i = 0;
            while (i < commands.length) {
                try {
                    in = new DeviceData();
                    s_arr = new String[]{commands[i]};
                    in.insert(s_arr);
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", in);
                }
                catch (DevFailed e) {
                    FableUtils.excMsg((Object)this, (String)("Error sending command " + commands[i] + " to spd server"), (Throwable)e);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending command " + commands[i] + " to spd server", 0));
                }
                ++i;
            }
            i = 0;
            while (i < files.length) {
                try {
                    in = new DeviceData();
                    s_arr = new String[]{files[i]};
                    in.insert(s_arr);
                    long before = System.currentTimeMillis();
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", in);
                    long elapsed = System.currentTimeMillis() - before;
                    Preprocessor.incrementImagesCorrected();
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Processed file " + files[i] + " took " + elapsed + " ms", 1));
                }
                catch (DevFailed e) {
                    FableUtils.excMsg((Object)this, (String)("Error  sending file " + files[i] + " to spd server"), (Throwable)e);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending file " + files[i] + " to spd server", 0));
                }
                ++i;
            }
        }

        public String[] getNewFiles(String flagForNewFiles) {
            String[] newFiles = null;
            newFiles = Preprocessor.this.getNewFilesOnLine(this.threadSampleDirectory, this.threadSampleName, this.threadTimer, flagForNewFiles);
            Preprocessor.this.updateGUIOnLineMode();
            return newFiles;
        }

        public void notifyEnd() {
            this.stopProcessing = true;
            if (this.process != null) {
                int i = 0;
                while (i < this.process.size()) {
                    ++i;
                }
            }
        }

        private void buildCommand(String myCommand, Object[] files) {
            String file = "";
            int numberOfFiles = 1;
            int maxNumber = 100 > files.length ? files.length : 100;
            String filesToProcess = "";
            int i = 0;
            while (!this.stopProcessing && files != null && i < files.length) {
                file = (String)files[i];
                filesToProcess = String.valueOf(filesToProcess) + " " + ToolBox.addQuotesForSpacesInName((String)file, (String)"[\\\\/]", (String)System.getProperty("file.separator"));
                int j = i + 1;
                int len = filesToProcess.length();
                if (j < files.length) {
                    len += ((String)files[j]).length();
                }
                if (numberOfFiles == maxNumber || files.length - i == 1) {
                    String cmd = String.valueOf(myCommand) + filesToProcess;
                    this.executeCommand(cmd);
                    numberOfFiles = 1;
                    filesToProcess = "";
                } else {
                    ++numberOfFiles;
                }
                ++i;
            }
        }

        private void executeCommand(String myCommand) {
            Runtime runtime = Runtime.getRuntime();
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(myCommand, 1));
            try {
                Process currentProcess = runtime.exec(myCommand);
                this.process.add(currentProcess);
                StreamReaderThread outThread = new StreamReaderThread(currentProcess.getInputStream());
                StreamReaderThread errThread = new StreamReaderThread(currentProcess.getErrorStream());
                outThread.start();
                errThread.start();
                currentProcess.waitFor();
                outThread.join();
                errThread.join();
                if (currentProcess.waitFor() == 0) {
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process finished for command " + myCommand, 1));
                } else {
                    Activator.log("Process for command : " + myCommand + " has not finished properly :  " + currentProcess.waitFor(), 4, null);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Command has not finished properly:" + myCommand, 0));
                }
            }
            catch (InterruptedException e) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while waiting for the process to finish (Interrupted exception)", 0));
                FableUtils.excMsg((Object)this, (String)("An Interrupted exception occured while trying to execute command ( processCmd) on file " + Preprocessor.this.currentCorrectedFileName), (Throwable)e);
            }
            catch (IOException e) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while trying to execute command (IOException exception) : " + e.getMessage(), 0));
                FableUtils.excMsg((Object)this, (String)("An Error occured while trying to execute command (IOException exception launched in processCmd) on file " + Preprocessor.this.currentCorrectedFileName), (Throwable)e);
            }
        }

        public String getInfo() {
            Date timer = new Date(this.threadTimer);
            String myString = "Thread preprocessor for sample: " + this.threadSampleName;
            myString = String.valueOf(myString) + "\n";
            myString = String.valueOf(myString) + "Thread time begin:" + timer.toString();
            myString = this.onLineMode ? String.valueOf(myString) + "Thread preprocessor mode is On Line. \n" : String.valueOf(myString) + "Thread Preprocessor mode is Off Line. \n : ";
            myString = String.valueOf(myString) + " \n";
            if (this.applyDark.booleanValue()) {
                myString = String.valueOf(myString) + " Dark subtraction will be made.\n ";
            }
            if (this.applySpatial.booleanValue()) {
                myString = String.valueOf(myString) + " Spatial distortion correction will be made.\n ";
            }
            if (this.applyFlood.booleanValue()) {
                myString = String.valueOf(myString) + " Flood correction  will be made.\n ";
            }
            return myString;
        }

        public void setNFilesToProcess(int nFilesToProcess) {
            this.nFilesToProcess = nFilesToProcess;
        }

        public int getNFilesToProcess() {
            return this.nFilesToProcess;
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            int index = 0;
            try {
                while ((this.outputMessage = outputread.readLine()) != null) {
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(this.outputMessage, 1));
                    index = this.outputMessage.indexOf("Correcting") + 1;
                    if (index > 0) {
                        Preprocessor.incrementImagesCorrected();
                        if ((index += new String("Correcting").length()) >= this.outputMessage.length()) continue;
                        Preprocessor.this.currentCorrectedFileName = this.outputMessage.substring(index);
                        if (!Preprocessor.this.zipOriginalfiles) continue;
                        Preprocessor.this.compressFiles(Preprocessor.this.currentCorrectedFileName);
                        continue;
                    }
                    index = this.outputMessage.indexOf("Saving corrected image to file") + 1;
                    if (index <= 0 || (index += new String("Saving corrected image to file").length()) >= this.outputMessage.length()) continue;
                    String correctedFileName = this.outputMessage.substring(index);
                    if (!Preprocessor.this.zipCorrectedFiles) continue;
                    Preprocessor.this.compressFiles(correctedFileName);
                }
            }
            catch (IOException e) {
                FableUtils.excMsg((Object)this, (String)("An error occured " + Preprocessor.this._threadProcess.threadSampleName + " " + e.getMessage()), (Throwable)e);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured " + Preprocessor.this._threadProcess.threadSampleName + " " + e.getMessage(), 0));
            }
        }
    }
}

