/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.preferences;

import fable.framework.toolbox.ToolBox;
import fable.preprocessor.Activator;
import fable.preprocessor.toolBox.Toolbox;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;

public class SpdPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static SpdPreferenceInitializer defaultPref = null;

    public void initializeDefaultPreferences() {
        IEclipsePreferences defaults = new DefaultScope().getNode("fable.preprocessor");
        try {
            Bundle bundle = Platform.getBundle((String)"fable.preprocessor");
            Path path = new Path("/");
            URL spdURL = FileLocator.resolve((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
            String preprocessorPath = spdURL.getPath();
            preprocessorPath = preprocessorPath.substring(0, preprocessorPath.lastIndexOf("fable.preprocessor"));
            String os = System.getProperty("os.name");
            if (os.equalsIgnoreCase("linux")) {
                if (System.getProperty("os.arch").toLowerCase().equals("i386")) {
                    if (preprocessorPath.startsWith("file:")) {
                        String program = "spd_1.2.0/bin/linux/spd";
                        if (Toolbox.isSpdNew()) {
                            program = "spd_1.2.0/bin/linux/new/spd";
                        }
                        preprocessorPath = String.valueOf(preprocessorPath.replaceFirst("file:", "")) + program;
                    } else {
                        String program = "spd/bin/linux/spd";
                        if (Toolbox.isSpdNew()) {
                            program = "spd/bin/linux/new/spd";
                        }
                        preprocessorPath = String.valueOf(preprocessorPath) + program;
                    }
                } else if (preprocessorPath.startsWith("file:")) {
                    String program = "spd_1.2.0/bin/linux64/spd";
                    if (Toolbox.isSpdNew()) {
                        program = "spd_1.2.0/bin/linux64/new/spd";
                    }
                    preprocessorPath = String.valueOf(preprocessorPath.replaceFirst("file:", "")) + program;
                } else {
                    String program = "spd/bin/linux64/spd";
                    if (Toolbox.isSpdNew()) {
                        program = "spd/bin/linux64/new/spd";
                    }
                    preprocessorPath = String.valueOf(preprocessorPath) + program;
                }
            } else if (os.toLowerCase().contains("windows")) {
                if (preprocessorPath.startsWith("file:")) {
                    Activator.log("Preprocessor Path from initializer" + preprocessorPath);
                    preprocessorPath = String.valueOf(preprocessorPath.replaceFirst("file:", "")) + "spd_1.2.0\\bin\\win32\\spd.exe";
                } else {
                    Activator.log("Preprocessor Path from initializer" + preprocessorPath);
                    preprocessorPath = String.valueOf(preprocessorPath.substring(1)) + "spd\\bin\\win32\\spd.exe";
                }
            }
            defaults.put("pref_cmd_spd", preprocessorPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        defaults.putBoolean("pref_auto_dark", true);
        defaults.putBoolean("pref_auto_dist", true);
        defaults.putBoolean("pref_auto_flood", true);
        defaults.put("pref_dark_file", "");
        defaults.put("pref_flood_file", "");
        defaults.put("pref_dist_file", "");
        defaults.put("pref_mode", "OFF");
        defaults.put("pref_ext_COR_SELECT", "Default");
        defaults.put("pref_ext_dark", "Dark");
        defaults.put("pref_spd_mode", "standalone");
        defaults.put("pref_spd_server", "taco:test/spd/1");
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.setDefault("pref_auto_dark", true);
        prefs.setDefault("pref_auto_dist", true);
        prefs.setDefault("pref_auto_flood", true);
        prefs.setDefault("pref_dark_file", "");
        prefs.setDefault("pref_flood_file", "");
        prefs.setDefault("pref_dist_file", "");
        prefs.setDefault("pref_mode", "OFF");
        prefs.setDefault("pref_ext_COR_SELECT", "Default");
        prefs.setDefault("pref_ext_dark", "Dark");
        prefs.setDefault("pref_spd_mode", "standalone");
        prefs.setDefault("pref_spd_server", "taco:test/spd/1");
        prefs.setDefault("pref_dark_getFileMode", "darkHeaderRadio");
        prefs.setDefault("pref_dist_getFileMode", "distHeaderRadio");
        prefs.setDefault("pref_flood_getFileMode", "floodHeaderRadio");
        prefs.setDefault("pref_zipCorrected", true);
        prefs.setDefault("pref_zipOriginal", false);
        String defaultzip = "";
        if (ToolBox.isOsLinux()) {
            defaultzip = "/usr/bin/gzip";
        }
        prefs.setDefault("pref_zip_program", defaultzip);
        prefs.setDefault("pref_type", "type_float");
        prefs.setDefault("pref_dvo", 10);
    }
}

