/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.preferences;

import fable.preprocessor.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceCommand
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CMD_SPD = "pref_cmd_spd";
    public static final String SPD_MODE = "pref_spd_mode";
    public static final String SPD_SERVER = "pref_spd_server";
    public static final String PREPROCESSOR_MODE_ONOFF = "pref_mode";
    private FileFieldEditor spdCommand;
    private StringFieldEditor spdServer;
    private RadioGroupFieldEditor runMode;
    private RadioGroupFieldEditor spdMode;
    private FileFieldEditor cmdGrainspotter;
    private IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private List<FieldEditor> fieldsEditors;

    public PreferenceCommand() {
        super(1);
        this.setPreferenceStore(this.preferences);
        this.fieldsEditors = new ArrayList<FieldEditor>();
    }

    protected void createFieldEditors() {
        final Composite parent = this.getFieldEditorParent();
        GridLayout innerLayout = new GridLayout();
        GridData gridData0 = new GridData(1808);
        gridData0.grabExcessHorizontalSpace = true;
        innerLayout.numColumns = 1;
        parent.setLayout((Layout)innerLayout);
        parent.setLayoutData((Object)gridData0);
        GridData gridData_cmd = new GridData(768);
        gridData_cmd.horizontalAlignment = 4;
        gridData_cmd.grabExcessHorizontalSpace = true;
        this.spdCommand = new FileFieldEditor(CMD_SPD, "Command", parent);
        this.spdCommand.setValidateStrategy(1);
        this.addField((FieldEditor)this.spdCommand);
        this.fieldsEditors.add((FieldEditor)this.spdCommand);
        this.spdServer = new StringFieldEditor(SPD_SERVER, "Spd device server", parent);
        this.addField((FieldEditor)this.spdServer);
        this.fieldsEditors.add((FieldEditor)this.spdServer);
        this.spdMode = new RadioGroupFieldEditor(SPD_MODE, "Spd mode", 2, (String[][])new String[][]{{"Command line", "OFF"}, {"Device server", "server"}}, parent, true);
        this.addField((FieldEditor)this.spdMode);
        this.fieldsEditors.add((FieldEditor)this.spdMode);
        this.spdMode.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String server_mode = (String)event.getNewValue();
                if (server_mode.equals("server")) {
                    Control radio = PreferenceCommand.this.runMode.getRadioBoxControl(parent).getChildren()[0];
                    ((Button)radio).setSelection(true);
                }
            }
        });
        this.runMode = new RadioGroupFieldEditor(PREPROCESSOR_MODE_ONOFF, "Run mode", 2, (String[][])new String[][]{{"On line", "ON"}, {"Off Line", "OFF"}}, parent, true);
        this.addField((FieldEditor)this.runMode);
        this.fieldsEditors.add((FieldEditor)this.runMode);
        this.setErrorMessageForAllFields(this.fieldsEditors);
    }

    public boolean isValid() {
        boolean bIsvalid = super.isValid();
        if (!bIsvalid) {
            this.getErrorMessage();
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean okToLeave() {
        return super.okToLeave();
    }

    protected void performDefaults() {
        this.cmdGrainspotter.loadDefault();
        super.performDefaults();
    }

    private void setErrorMessageForAllFields(List<FieldEditor> listFieldEditors) {
        for (FieldEditor currentField : listFieldEditors) {
            StringFieldEditor editor;
            if (currentField instanceof StringFieldEditor) {
                editor = (StringFieldEditor)currentField;
                editor.setErrorMessage(String.valueOf(editor.getLabelText()) + " " + editor.getErrorMessage());
                continue;
            }
            if (!(currentField instanceof FileFieldEditor)) continue;
            editor = (FileFieldEditor)currentField;
            editor.setErrorMessage(String.valueOf(editor.getLabelText()) + " :" + editor.getErrorMessage().toLowerCase());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (((FieldEditor)event.getSource()).getPreferenceName().equals(SPD_MODE) && !event.getNewValue().equals(event.getOldValue()) && event.getNewValue().equals("server")) {
            this.preferences.setValue(PREPROCESSOR_MODE_ONOFF, "ON");
            this.runMode.load();
        }
    }

    public void init(IWorkbench workbench) {
    }
}

