/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.actions;

import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OnOfflineAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "fable.preprocessor.actions.OnOfflineAction";
    private static boolean online;
    ListenerPreprocessorChange_ToolBar ListenPreprocessorChanges = new ListenerPreprocessorChange_ToolBar();

    public OnOfflineAction() {
        this.setId(ID);
        this.setActionDefinitionId(ID);
        if (Preprocessor.getDefault().isOnLine()) {
            this.setText("On line mode");
            this.setToolTipText("Switch to Offline mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/onLineMode.gif"));
        } else {
            this.setText("Off line mode");
            this.setToolTipText("Switch to Online mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
        }
    }

    public void run() {
        this.runCommand();
    }

    private void runCommand() {
        if (online) {
            Preprocessor.getDefault().setM_mode("OFF");
            online = false;
        } else {
            Preprocessor.getDefault().setM_mode("ON");
            online = true;
        }
    }

    private void switchMode(boolean bModeOnLine) {
        if (bModeOnLine) {
            this.setToolTipText("Switch to Online mode");
            this.setText("Off line mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/onLineMode.gif"));
            online = false;
        } else {
            this.setToolTipText("Switch to Offline mode");
            this.setText("On line mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
            online = true;
        }
    }

    public void dispose() {
        Preprocessor.getDefault().removePreprocessorListener(this.ListenPreprocessorChanges);
    }

    public void init(IWorkbenchWindow arg0) {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)Preprocessor.getDefault());
        online = prefs.getString("pref_mode").equals("ON");
        Preprocessor.getDefault().addPreprocessorListener(this.ListenPreprocessorChanges);
        if (online) {
            this.setText("On line mode");
            this.setToolTipText("Switch to offline mode.");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/onLineMode.gif"));
        } else {
            this.setText("Off line mode");
            this.setToolTipText("Switch to online mode.");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
        }
        this.setChecked(online);
    }

    public void run(IAction arg0) {
        if (arg0.getId().equals(ID)) {
            if (online) {
                arg0.setText("Off line mode");
                arg0.setToolTipText("Switch to online mode.");
                arg0.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
            } else {
                arg0.setText("On line mode");
                arg0.setToolTipText("Switch to offline mode.");
                arg0.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/onLineMode.gif"));
            }
        }
        this.runCommand();
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    class ListenerPreprocessorChange_ToolBar
    implements IPreprocessorListener {
        ListenerPreprocessorChange_ToolBar() {
        }

        public void preprocessorModeChange(PreprocessorEvent pe) {
            OnOfflineAction.this.switchMode(!((Preprocessor)pe.getSource()).getM_mode().equals("ON"));
        }

        public void preprocessorChanged(PreprocessorEvent pe) {
        }

        public void preprocessorNewMessage(PreprocessorEvent pe) {
        }

        public void preprocessorStateChange(PreprocessorEvent pe) {
        }

        public void preprocessorNewSample(PreprocessorEvent pe) {
        }

        public void preprocessorNewImages(PreprocessorEvent pe) {
        }
    }
}

