/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.views;

import fable.framework.toolbox.FableUtils;
import fable.transformation.Activator;
import fable.transformation.actions.AddUnitCellPeaksAction;
import fable.transformation.actions.ComputeHistProbAction;
import fable.transformation.actions.ComputeTthEtaAction;
import fable.transformation.actions.ComputegveAction;
import fable.transformation.actions.OpenParameterFile;
import fable.transformation.actions.SaveFltAction;
import fable.transformation.actions.SaveGveAction;
import fable.transformation.actions.fitAction;
import fable.transformation.object.Transform;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ParamView
extends ViewPart
implements IPropertyChangeListener,
ISaveablePart {
    public static final String ID = "fable.transformation.views.paramview";
    Transform transform;
    private IMemento memento = null;
    public String currentPathParam;
    private Composite mainComposite;
    private IPropertyChangeListener preferencesListener;
    private Action saveAction;
    private Action applyParameters;
    private Action restoreValues;
    private ImageDescriptor apply_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/check.gif");
    private ImageDescriptor save_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/saveoptions.gif");
    private ImageDescriptor revert_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/undo.gif");
    protected boolean dirty = false;
    private OpenParameterFile openParameters;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("PARS_FILE_PATH", this.currentPathParam);
    }

    public void createPartControl(Composite parent) {
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_parameters_file")) {
                    ParamView.this.loadfileParameter(Activator.getDefault().getPreferenceStore().getString("pref_parameters_file"));
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        ScrolledComposite sc = new ScrolledComposite(parent, 512);
        this.mainComposite = new Composite((Composite)sc, 20);
        this.mainComposite.setLayout((Layout)new GridLayout(3, false));
        this.transform = Transform.getTransformer();
        this.transform.editParameters();
        this.transform.addPropertyChangeListener(this);
        if (this.memento != null) {
            this.currentPathParam = this.memento.getString("PARS_FILE_PATH");
        }
        if (this.transform.getpars() != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
            Set entryS = map.entrySet();
            Iterator it = entryS.iterator();
            int textlimit = 30;
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String key = (String)e.getKey();
                Label label = new Label(this.mainComposite, 0);
                String help = this.transform.getparsHelp().get((String)e.getKey());
                label.setToolTipText(help);
                label.setText((String)e.getKey());
                Text txt = new Text(this.mainComposite, 2048);
                GridData gdText = new GridData(16, 0x1000000, false, false);
                gdText.widthHint = textlimit * 6;
                txt.setLayoutData((Object)gdText);
                txt.setData((Object)key);
                txt.setData(key, e.getValue());
                txt.setData("restore", e.getValue());
                txt.setText(e.getValue().toString());
                txt.setToolTipText(help);
                txt.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        ParamView.this.firePropertyChange(257);
                    }
                });
                if (this.transform.getPossVary().get(key) != null) {
                    Button btnCheck = new Button(this.mainComposite, 32);
                    btnCheck.setToolTipText("Possible vary for : " + key);
                    btnCheck.setSelection(this.transform.getPossVary().get(key).booleanValue());
                    btnCheck.setData((Object)((String)e.getKey()));
                    btnCheck.setData("restore", (Object)this.transform.getPossVary().get(key));
                    btnCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    continue;
                }
                new Label(this.mainComposite, 0);
            }
        }
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalSpan = 3;
        sc.setContent((Control)this.mainComposite);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(this.mainComposite.computeSize(0, -1));
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", (IAction)new ComputeTthEtaAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", (IAction)new AddUnitCellPeaksAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeHistProbAction", (IAction)new ComputeHistProbAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", (IAction)new ComputegveAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.fitAction", (IAction)new fitAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.saveGve", (IAction)new SaveGveAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.savefilteredPeaksAction", (IAction)new SaveFltAction());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openParameters);
        manager.add((IAction)this.saveAction);
        manager.add((IAction)this.applyParameters);
        manager.add((IAction)this.restoreValues);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openParameters);
        manager.add((IAction)this.applyParameters);
        manager.add((IAction)this.saveAction);
        manager.add((IAction)this.restoreValues);
    }

    private void makeActions() {
        this.openParameters = new OpenParameterFile();
        this.saveAction = new Action(){

            public void run() {
                ParamView.this.saveParameters();
            }
        };
        this.applyParameters = new Action(){

            public void run() {
                ParamView.this.applyParameters();
            }
        };
        this.saveAction.setText("Save parameters");
        this.saveAction.setToolTipText("Save parameters in a file (*.par, *.pars, *.prm)");
        this.saveAction.setImageDescriptor(this.save_imageDescr);
        this.applyParameters.setText("Apply parameters");
        this.applyParameters.setToolTipText("Apply parameters and compute again.  \nNew parameters are not saved in the file automatically.");
        this.applyParameters.setImageDescriptor(this.apply_imageDescr);
        this.restoreValues = new Action(){

            public void run() {
                ParamView.this.restoreValues();
            }
        };
        this.restoreValues.setText("Restore values ");
        this.restoreValues.setToolTipText("Restore last applied values ");
        this.restoreValues.setImageDescriptor(this.revert_imageDescr);
    }

    private void loadfileParameter(String sFile) {
        String name = FableUtils.getShortName((String)sFile);
        if (name == null || name.length() == 0) {
            name = "Parameters";
        }
        this.setPartName(name);
        this.setTitleToolTip(sFile);
        this.transform.loadFileParameters(sFile);
        this.transform.editParameters();
    }

    public void setFocus() {
    }

    public boolean applyParameters() {
        boolean bok = false;
        Vector<String> vars = new Vector<String>(1);
        Control[] element = this.mainComposite.getChildren();
        if (Transform.getTransformer().getpars() != null) {
            HashMap<String, Object> map = this.transform.getpars();
            int i = 0;
            while (i < element.length) {
                Button btn;
                if (element[i] instanceof Text) {
                    Text txt = (Text)element[i];
                    if (txt.getData() != null) {
                        map.put((String)txt.getData(), new String(txt.getText()));
                    }
                } else if (element[i] instanceof Button && (btn = (Button)element[i]).getData() != null && btn.getSelection()) {
                    vars.add((String)btn.getData());
                }
                ++i;
            }
            bok = Transform.getTransformer().set_parameters(vars.toArray(), map);
        }
        return bok;
    }

    private void restoreValues() {
        Control[] element = this.mainComposite.getChildren();
        boolean found = false;
        if (Transform.getTransformer().getpars() != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
            Set entryS = map.entrySet();
            Iterator it = entryS.iterator();
            while (it.hasNext()) {
                found = false;
                Map.Entry e = it.next();
                int i = 0;
                while (!found && i < element.length) {
                    Button btn;
                    if (element[i] instanceof Text) {
                        Text txt = (Text)element[i];
                        if (txt.getData((String)e.getKey()) != null) {
                            found = true;
                            txt.setText(txt.getData("restore").toString());
                        }
                    } else if (element[i] instanceof Button && ((btn = (Button)element[i]).getStyle() & 0x20) == 32) {
                        btn.setSelection(((Boolean)btn.getData("restore")).booleanValue());
                    }
                    ++i;
                }
            }
        }
    }

    private void updateFields() {
        if (!this.mainComposite.isDisposed()) {
            Control[] element = this.mainComposite.getChildren();
            boolean found = false;
            if (Transform.getTransformer().getpars() != null) {
                TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
                Set entryS = map.entrySet();
                Iterator it = entryS.iterator();
                while (it.hasNext()) {
                    found = false;
                    Map.Entry e = it.next();
                    int i = 0;
                    while (!found && i < element.length) {
                        String key;
                        Text txt;
                        if (element[i] instanceof Text && (txt = (Text)element[i]).getData(key = (String)e.getKey()) != null) {
                            found = true;
                            txt.setData((Object)key);
                            txt.setData(key, e.getValue());
                            txt.setData("restore", e.getValue());
                            txt.setText(e.getValue().toString());
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void saveParameters() {
        if (this.applyParameters()) {
            FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            String[] filterExt = new String[]{"*.par", "*.*"};
            String[] filterNames = new String[]{"parameter files (*.par)", "All Files (*.*)"};
            fileDlg.setFilterExtensions(filterExt);
            fileDlg.setFilterNames(filterNames);
            fileDlg.setText("Save parameters in an existing ini file or enter a new file name");
            String file = fileDlg.open();
            if (file != null) {
                File myFile = new File(file);
                boolean confirm = true;
                confirm = myFile.exists() ? FableUtils.confirmMsg((Object)((Object)this), (String)(String.valueOf(file) + " already exists. \nDo you want to overwrite it ?")) : true;
                if (confirm) {
                    file = String.valueOf(fileDlg.getFilterPath()) + System.getProperty("file.separator") + fileDlg.getFileName();
                    Transform.getTransformer().saveParameters(file);
                    String name = FableUtils.getShortName((String)file);
                    if (name == null || name.length() == 0) {
                        name = "Parameters";
                    }
                    this.setPartName(name);
                    this.setTitleToolTip(file);
                }
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save parameters error", (String)"Fable transform application couldn't get values in field and/or update transform.py");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void dispose() {
        this.transform.removePropertyChangeListener(this);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
    }

    public void removePropertyListener(IPropertyListener l) {
        super.removePropertyListener(l);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("refresh")) {
            this.updateFields();
            String name = FableUtils.getShortName((String)this.transform.getParamFileName());
            if (name == null || name.length() == 0) {
                name = "Parameters";
            }
            this.setPartName(name);
            this.setTitleToolTip(this.transform.getParamFileName());
        } else if (event.getProperty().equals("currentProjectPath")) {
            this.currentPathParam = (String)event.getNewValue();
        }
    }
}

