/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.internal.databinding.beans.ListenerSupport;
import org.eclipse.core.runtime.Assert;

public class JavaBeanObservableSet
extends ObservableSet
implements IBeanObservable {
    private final Object object;
    private PropertyChangeListener collectionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableSet.this.updating) {
                JavaBeanObservableSet.this.getRealm().exec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        HashSet<Object> newElements = new HashSet<Object>(Arrays.asList(JavaBeanObservableSet.access$1(1.access$0(this.this$1))));
                        HashSet<Object> addedElements = new HashSet<Object>(newElements);
                        HashSet<E> removedElements = new HashSet<E>(JavaBeanObservableSet.access$2(1.access$0(this.this$1)));
                        removedElements.removeAll(newElements);
                        addedElements.removeAll(JavaBeanObservableSet.access$2(1.access$0(this.this$1)));
                        JavaBeanObservableSet.access$3(1.access$0(this.this$1), newElements);
                        JavaBeanObservableSet.access$4(1.access$0(this.this$1), Diffs.createSetDiff(addedElements, removedElements));
                    }
                });
            }
        }

        static /* synthetic */ JavaBeanObservableSet access$0(1 var0) {
            return var0.JavaBeanObservableSet.this;
        }
    };
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private ListenerSupport collectionListenSupport;
    private boolean attachListeners;

    public JavaBeanObservableSet(Realm realm, Object object, PropertyDescriptor descriptor, Class elementType) {
        this(realm, object, descriptor, elementType, true);
    }

    public JavaBeanObservableSet(Realm realm, Object object, PropertyDescriptor descriptor, Class elementType, boolean attachListeners) {
        super(realm, new HashSet(), (Object)elementType);
        this.object = object;
        this.descriptor = descriptor;
        this.attachListeners = attachListeners;
        if (attachListeners) {
            this.collectionListenSupport = new ListenerSupport(this.collectionListener, descriptor.getName());
        }
        this.wrappedSet.addAll(Arrays.asList(this.getValues()));
    }

    protected void firstListenerAdded() {
        if (this.attachListeners) {
            this.collectionListenSupport.hookListener(this.object);
        }
    }

    protected void lastListenerRemoved() {
        if (this.collectionListenSupport != null) {
            this.collectionListenSupport.dispose();
        }
    }

    private Object primGetValues() {
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Assert.isTrue((boolean)false, (String)"Could not read collection values");
        return null;
    }

    private Object[] getValues() {
        Object[] values = null;
        Object result = this.primGetValues();
        if (this.descriptor.getPropertyType().isArray()) {
            values = (Object[])result;
        } else {
            Collection list = (Collection)result;
            if (list != null) {
                values = list.toArray();
            }
        }
        if (values == null) {
            values = new Object[]{};
        }
        return values;
    }

    private void setValues() {
        if (this.descriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.descriptor.getPropertyType().getComponentType();
            Object[] newArray = (Object[])Array.newInstance(componentType, this.wrappedSet.size());
            this.wrappedSet.toArray(newArray);
            this.primSetValues(newArray);
        } else {
            this.primSetValues(new HashSet(this.wrappedSet));
        }
    }

    public boolean add(Object o) {
        this.getterCalled();
        this.updating = true;
        try {
            boolean added = this.wrappedSet.add(o);
            if (added) {
                this.setValues();
                this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), (Set)Collections.EMPTY_SET));
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean remove(Object o) {
        this.getterCalled();
        this.updating = true;
        try {
            boolean removed = this.wrappedSet.remove(o);
            if (removed) {
                this.setValues();
                this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, Collections.singleton(o)));
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean addAll(Collection c) {
        this.getterCalled();
        this.updating = true;
        try {
            boolean changed;
            HashSet additions = new HashSet();
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!this.wrappedSet.add(element)) continue;
                additions.add(element);
            }
            boolean bl = changed = !additions.isEmpty();
            if (changed) {
                this.setValues();
                this.fireSetChange(Diffs.createSetDiff(additions, (Set)Collections.EMPTY_SET));
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean removeAll(Collection c) {
        this.getterCalled();
        this.updating = true;
        try {
            boolean changed;
            HashSet removals = new HashSet();
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!this.wrappedSet.remove(element)) continue;
                removals.add(element);
            }
            boolean bl = changed = !removals.isEmpty();
            if (changed) {
                this.setValues();
                this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removals));
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean retainAll(Collection c) {
        this.getterCalled();
        this.updating = true;
        try {
            boolean changed;
            HashSet removals = new HashSet();
            Iterator iterator = this.wrappedSet.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (c.contains(element)) continue;
                iterator.remove();
                removals.add(element);
            }
            boolean bl = changed = !removals.isEmpty();
            if (changed) {
                this.setValues();
                this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removals));
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.updating = false;
        }
    }

    public void clear() {
        this.getterCalled();
        if (this.wrappedSet.isEmpty()) {
            return;
        }
        this.updating = true;
        try {
            HashSet removals = new HashSet(this.wrappedSet);
            this.wrappedSet.clear();
            this.setValues();
            this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removals));
        }
        finally {
            this.updating = false;
        }
    }

    private void primSetValues(Object newValue) {
        Exception ex = null;
        try {
            Method writeMethod = this.descriptor.getWriteMethod();
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(this.object, newValue);
            return;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new BindingException("Could not write collection values", (Throwable)ex);
    }

    public Object getObserved() {
        return this.object;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.descriptor;
    }

    static /* synthetic */ Object[] access$1(JavaBeanObservableSet javaBeanObservableSet) {
        return javaBeanObservableSet.getValues();
    }

    static /* synthetic */ Set access$2(JavaBeanObservableSet javaBeanObservableSet) {
        return javaBeanObservableSet.wrappedSet;
    }

    static /* synthetic */ void access$3(JavaBeanObservableSet javaBeanObservableSet, Set set) {
        javaBeanObservableSet.wrappedSet = set;
    }

    static /* synthetic */ void access$4(JavaBeanObservableSet javaBeanObservableSet, SetDiff setDiff) {
        javaBeanObservableSet.fireSetChange(setDiff);
    }
}

