/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceAttribute {
    AttributeValue_3 attrval = new AttributeValue_3();

    private void buildAttributeValueObject(String string) {
        this.attrval.name = string;
        this.attrval.quality = AttrQuality.ATTR_VALID;
        this.attrval.time = new TimeVal();
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        try {
            this.attrval.value = ApiUtil.get_orb().create_any();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        this.attrval.time.tv_sec = (int)(l / 1000L);
        this.attrval.time.tv_usec = (int)(l - (long)(this.attrval.time.tv_sec * 1000)) * 1000;
        this.attrval.time.tv_nsec = 0;
        this.attrval.err_list = null;
    }

    public DeviceAttribute(AttributeValue_3 attributeValue_3) {
        this.attrval = attributeValue_3;
    }

    public DeviceAttribute(AttributeValue attributeValue) {
        this.attrval.value = attributeValue.value;
        this.attrval.name = attributeValue.name;
        this.attrval.quality = attributeValue.quality;
        this.attrval.time = attributeValue.time;
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = attributeValue.dim_x;
        this.attrval.r_dim.dim_y = attributeValue.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public DeviceAttribute(String string) {
        this.buildAttributeValueObject(string);
    }

    public DeviceAttribute(String string, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
    }

    public DeviceAttribute(String string, boolean bl) {
        this.buildAttributeValueObject(string);
        this.insert(bl);
    }

    public DeviceAttribute(String string, boolean[] blArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(blArray, n, n2);
    }

    public DeviceAttribute(String string, byte by) {
        this.buildAttributeValueObject(string);
        this.insert_uc(by);
    }

    public DeviceAttribute(String string, byte[] byArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert_uc(byArray, n, n2);
    }

    public DeviceAttribute(String string, short s) {
        this.buildAttributeValueObject(string);
        this.insert(s);
    }

    public DeviceAttribute(String string, short[] sArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(sArray, n, n2);
    }

    public DeviceAttribute(String string, int n) {
        this.buildAttributeValueObject(string);
        this.insert(n);
    }

    public DeviceAttribute(String string, int[] nArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(nArray, n, n2);
    }

    public DeviceAttribute(String string, float f) {
        this.buildAttributeValueObject(string);
        this.insert(f);
    }

    public DeviceAttribute(String string, float[] fArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(fArray, n, n2);
    }

    public DeviceAttribute(String string, double d) {
        this.buildAttributeValueObject(string);
        this.insert(d);
    }

    public DeviceAttribute(String string, double[] dArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(dArray, n, n2);
    }

    public DeviceAttribute(String string, String string2) {
        this.buildAttributeValueObject(string);
        this.insert(string2);
    }

    public DeviceAttribute(String string, String[] stringArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(stringArray, n, n2);
    }

    public boolean hasFailed() {
        return this.attrval.err_list != null && this.attrval.err_list.length > 0;
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public void setAttributeValue(AttributeValue_3 attributeValue_3) {
        this.attrval = attributeValue_3;
    }

    public void setAttributeValue(AttributeValue attributeValue) {
        this.attrval.value = attributeValue.value;
        this.attrval.name = attributeValue.name;
        this.attrval.quality = attributeValue.quality;
        this.attrval.time = attributeValue.time;
        this.attrval.r_dim.dim_x = attributeValue.dim_x;
        this.attrval.r_dim.dim_y = attributeValue.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public void insert(boolean bl) {
        boolean[] blArray = new boolean[]{bl};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarBooleanArrayHelper.insert(this.attrval.value, blArray);
    }

    public void insert(boolean[] blArray) {
        this.attrval.r_dim.dim_x = blArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarBooleanArrayHelper.insert(this.attrval.value, blArray);
    }

    public void insert(boolean[] blArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarBooleanArrayHelper.insert(this.attrval.value, blArray);
    }

    public void insert_uc(byte by) {
        byte[] byArray = new byte[1];
        this.attrval.r_dim.dim_x = 1;
        byArray[0] = by;
        this.attrval.r_dim.dim_y = 0;
        DevVarCharArrayHelper.insert(this.attrval.value, byArray);
    }

    public void insert_uc(short s) {
        byte[] byArray = new byte[]{(byte)(s & 0xFF)};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarCharArrayHelper.insert(this.attrval.value, byArray);
    }

    public void insert_uc(short[] sArray, int n, int n2) {
        byte[] byArray = new byte[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            byArray[i] = (byte)(sArray[i] & 0xFF);
        }
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarCharArrayHelper.insert(this.attrval.value, byArray);
    }

    public void insert_uc(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[byArray.length];
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarCharArrayHelper.insert(this.attrval.value, byArray);
    }

    public void insert(short s) {
        short[] sArray = new short[]{s};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert(short[] sArray) {
        this.attrval.r_dim.dim_x = sArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert(short[] sArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(short s) {
        short[] sArray = new short[]{s};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(int n) {
        short[] sArray = new short[]{(short)(n & 0xFFFF)};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(short[] sArray) {
        this.attrval.r_dim.dim_x = sArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)(nArray[i] & 0xFFFF);
        }
        this.attrval.r_dim.dim_x = nArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(short[] sArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert_us(int[] nArray, int n, int n2) {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)(nArray[i] & 0xFFFF);
        }
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarUShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert(int n) {
        int[] nArray = new int[]{n};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarLongArrayHelper.insert(this.attrval.value, nArray);
    }

    public void insert(int[] nArray) {
        this.attrval.r_dim.dim_x = nArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarLongArrayHelper.insert(this.attrval.value, nArray);
    }

    public void insert(int[] nArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarLongArrayHelper.insert(this.attrval.value, nArray);
    }

    public void insert(float f) {
        float[] fArray = new float[]{f};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarFloatArrayHelper.insert(this.attrval.value, fArray);
    }

    public void insert(float[] fArray) {
        this.attrval.r_dim.dim_x = fArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarFloatArrayHelper.insert(this.attrval.value, fArray);
    }

    public void insert(float[] fArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarFloatArrayHelper.insert(this.attrval.value, fArray);
    }

    public void insert(double d) {
        double[] dArray = new double[]{d};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarDoubleArrayHelper.insert(this.attrval.value, dArray);
    }

    public void insert(double[] dArray) {
        this.attrval.r_dim.dim_x = dArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarDoubleArrayHelper.insert(this.attrval.value, dArray);
    }

    public void insert(double[] dArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarDoubleArrayHelper.insert(this.attrval.value, dArray);
    }

    public void insert(String string) {
        String[] stringArray = new String[]{string};
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        DevVarStringArrayHelper.insert(this.attrval.value, stringArray);
    }

    public void insert(String[] stringArray) {
        this.attrval.r_dim.dim_x = stringArray.length;
        this.attrval.r_dim.dim_y = 0;
        DevVarStringArrayHelper.insert(this.attrval.value, stringArray);
    }

    public void insert(String[] stringArray, int n, int n2) {
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
        DevVarStringArrayHelper.insert(this.attrval.value, stringArray);
    }

    private void manageExceptions(String string) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attrubute quality factor is INVALID", "DeviceAttribute." + string + "()");
        }
    }

    public boolean extractBoolean() throws DevFailed {
        this.manageExceptions("extractBoolean");
        boolean[] blArray = this.extractBooleanArray();
        return blArray[0];
    }

    public boolean[] extractBooleanArray() throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        return DevVarBooleanArrayHelper.extract(this.attrval.value);
    }

    public short extractUChar() throws DevFailed {
        this.manageExceptions("extractUChar");
        short[] sArray = this.extractUCharArray();
        return sArray[0];
    }

    public short[] extractUCharArray() throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        byte[] byArray = DevVarCharArrayHelper.extract(this.attrval.value);
        short[] sArray = new short[byArray.length];
        int n = 255;
        for (int i = 0; i < byArray.length; ++i) {
            sArray[i] = (short)(n & byArray[i]);
        }
        return sArray;
    }

    public short extractShort() throws DevFailed {
        this.manageExceptions("xtractShort()");
        short[] sArray = this.extractShortArray();
        return sArray[0];
    }

    public short[] extractShortArray() throws DevFailed {
        this.manageExceptions("extractShortArray");
        return DevVarShortArrayHelper.extract(this.attrval.value);
    }

    public int extractUShort() throws DevFailed {
        this.manageExceptions("extractUShort");
        int[] nArray = this.extractUShortArray();
        return nArray[0];
    }

    public int[] extractUShortArray() throws DevFailed {
        this.manageExceptions("extractUShortArray");
        short[] sArray = DevVarUShortArrayHelper.extract(this.attrval.value);
        int[] nArray = new int[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            nArray[i] = 0xFFFF & sArray[i];
        }
        return nArray;
    }

    public int extractLong() throws DevFailed {
        this.manageExceptions("extractLong");
        int[] nArray = this.extractLongArray();
        return nArray[0];
    }

    public int[] extractLongArray() throws DevFailed {
        this.manageExceptions("extractLongArray");
        return DevVarLongArrayHelper.extract(this.attrval.value);
    }

    public float extractFloat() throws DevFailed {
        this.manageExceptions("extractFloat");
        float[] fArray = this.extractFloatArray();
        return fArray[0];
    }

    public float[] extractFloatArray() throws DevFailed {
        this.manageExceptions("extractFloatArray");
        return DevVarFloatArrayHelper.extract(this.attrval.value);
    }

    public double extractDouble() throws DevFailed {
        this.manageExceptions("extractDouble");
        double[] dArray = this.extractDoubleArray();
        return dArray[0];
    }

    public double[] extractDoubleArray() throws DevFailed {
        this.manageExceptions("extractDoubleArray");
        return DevVarDoubleArrayHelper.extract(this.attrval.value);
    }

    public DevState extractState() throws DevFailed {
        this.manageExceptions("extractState");
        return DevStateHelper.extract(this.attrval.value);
    }

    public String extractString() throws DevFailed {
        this.manageExceptions("extractString");
        String[] stringArray = this.extractStringArray();
        return stringArray[0];
    }

    public String[] extractStringArray() throws DevFailed {
        this.manageExceptions("extractStringArray");
        return DevVarStringArrayHelper.extract(this.attrval.value);
    }

    public AttrQuality getQuality() throws DevFailed {
        this.manageExceptions("getQuality");
        return this.attrval.quality;
    }

    public TimeVal getTimeVal() throws DevFailed {
        this.manageExceptions("getTimeVal");
        return this.attrval.time;
    }

    public long getTimeValSec() throws DevFailed {
        this.manageExceptions("getTimeValSec");
        return this.attrval.time.tv_sec;
    }

    public long getTimeValMillisSec() throws DevFailed {
        this.manageExceptions("getTimeValMillisSec");
        return (long)this.attrval.time.tv_sec * 1000L + (long)this.attrval.time.tv_usec / 1000L;
    }

    public String getName() throws DevFailed {
        return this.attrval.name;
    }

    private int DIM_MINI(int n) {
        return n == 0 ? 1 : n;
    }

    public int getNbRead() throws DevFailed {
        this.manageExceptions("getNbRead");
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() throws DevFailed {
        this.manageExceptions("getNbWritten");
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getDimX() throws DevFailed {
        this.manageExceptions("getDimX");
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        this.manageExceptions("getDimY");
        return this.attrval.r_dim.dim_y;
    }

    public int getWrittenDimX() throws DevFailed {
        this.manageExceptions("getWrittenDimX");
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() throws DevFailed {
        this.manageExceptions("getWrittenDimY");
        return this.attrval.w_dim.dim_y;
    }

    public AttributeValue getAttributeValueObject_2() {
        AttributeValue attributeValue = new AttributeValue();
        attributeValue.value = this.attrval.value;
        attributeValue.name = this.attrval.name;
        attributeValue.quality = this.attrval.quality;
        attributeValue.time = this.attrval.time;
        attributeValue.dim_x = this.attrval.r_dim.dim_x;
        attributeValue.dim_y = this.attrval.r_dim.dim_y;
        return attributeValue;
    }

    public AttributeValue_3 getAttributeValueObject_3() {
        return this.attrval;
    }

    public long getTime() throws DevFailed {
        this.manageExceptions("getTime");
        return (long)this.attrval.time.tv_sec * 1000L + (long)(this.attrval.time.tv_usec / 1000);
    }

    public int getType() throws DevFailed {
        int n = -1;
        try {
            TypeCode typeCode = this.attrval.value.type();
            if (typeCode.kind().value() == 17) {
                return 19;
            }
            TypeCode typeCode2 = typeCode.content_type();
            TypeCode typeCode3 = typeCode2.content_type();
            TCKind tCKind = typeCode3.kind();
            switch (tCKind.value()) {
                case 1: {
                    n = 0;
                    break;
                }
                case 8: {
                    n = 1;
                    break;
                }
                case 9: {
                    n = 21;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 6;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 7;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 5;
                    break;
                }
                case 18: {
                    n = 8;
                }
            }
        }
        catch (BadKind badKind) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        return n;
    }
}

