/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;

public class DbDevice {
    private Database dbase;
    private String devname;

    public DbDevice(String string) throws DevFailed {
        TangoUrl tangoUrl = new TangoUrl(string);
        if (!tangoUrl.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + string + " do not use database", "DbDevice.DbDevice()");
        }
        this.dbase = ApiUtil.get_db_obj();
        this.devname = new String(string);
    }

    public DbDevice(String string, String string2, String string3) throws DevFailed {
        this.dbase = string2 == null || string3 == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(string2, string3);
        this.devname = new String(string);
    }

    public DeviceInfo get_info() throws DevFailed {
        return this.dbase.get_device_info(this.devname);
    }

    public DbDevImportInfo import_device() throws DevFailed {
        return this.dbase.import_device(this.devname);
    }

    public void export_device(DbDevExportInfo dbDevExportInfo) throws DevFailed {
        this.dbase.export_device(dbDevExportInfo);
    }

    public void unexport_device() throws DevFailed {
        this.dbase.unexport_device(this.devname);
    }

    public void add_device(DbDevInfo dbDevInfo) throws DevFailed {
        this.dbase.add_device(dbDevInfo);
    }

    public void delete_device() throws DevFailed {
        this.dbase.delete_device(this.devname);
    }

    public void put_alias(String string) throws DevFailed {
        this.dbase.put_device_alias(this.devname, string);
    }

    public String get_alias() throws DevFailed {
        if (this.devname.indexOf("/") < 0) {
            this.devname = ApiUtil.get_db_obj().get_alias_device(this.devname);
        }
        String string = this.dbase.get_device_alias(this.devname);
        return string;
    }

    public String[] get_property_list(String string) throws DevFailed {
        return this.dbase.get_device_property_list(this.devname, string);
    }

    public DbDatum[] get_property(String[] stringArray) throws DevFailed {
        return this.dbase.get_device_property(this.devname, stringArray);
    }

    public DbDatum get_property(String string) throws DevFailed {
        return this.dbase.get_device_property(this.devname, string);
    }

    public DbDatum[] get_property(DbDatum[] dbDatumArray) throws DevFailed {
        return this.dbase.get_device_property(this.devname, dbDatumArray);
    }

    public void put_property(DbDatum[] dbDatumArray) throws DevFailed {
        this.dbase.put_device_property(this.devname, dbDatumArray);
    }

    public void delete_property(String[] stringArray) throws DevFailed {
        this.dbase.delete_device_property(this.devname, stringArray);
    }

    public void delete_property(String string) throws DevFailed {
        this.dbase.delete_device_property(this.devname, string);
    }

    public void delete_property(DbDatum[] dbDatumArray) throws DevFailed {
        this.dbase.delete_device_property(this.devname, dbDatumArray);
    }

    public void put_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        this.dbase.put_device_attribute_property(this.devname, dbAttributeArray);
    }

    public void put_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        this.dbase.put_device_attribute_property(this.devname, dbAttribute);
    }

    public void delete_attribute_property(String string, String[] stringArray) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, string, stringArray);
    }

    public void delete_attribute_property(String string, String string2) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, string, string2);
    }

    public void delete_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, dbAttribute);
    }

    public void delete_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        this.dbase.delete_device_attribute_property(this.devname, dbAttributeArray);
    }

    public DbAttribute[] get_attribute_property(String[] stringArray) throws DevFailed {
        return this.dbase.get_device_attribute_property(this.devname, stringArray);
    }

    public DbAttribute get_attribute_property(String string) throws DevFailed {
        return this.dbase.get_device_attribute_property(this.devname, string);
    }

    public void delete_attribute(String string) throws DevFailed {
        this.dbase.delete_device_attribute(this.devname, string);
    }

    public String name() {
        return this.devname;
    }
}

