/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.views;

import fable.framework.toolbox.Activator;
import fable.framework.toolbox.JLChartMemoryUsage;
import fable.framework.toolbox.SWTUtils;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class MemoryUsageView
extends ViewPart {
    public static final String ID = "fable.framework.views.memoryusageview";
    private Preferences prefs = null;
    Composite awtComposite = null;
    private Frame frame = null;
    private static JLChartMemoryUsage panel = null;
    private int interval = 1000;
    private int maxAge = 60000;
    private boolean showMax = true;
    private boolean showLegend = true;
    protected Action showMaxAction;
    protected Action showLegendAction;
    protected Action setIntervalAction;
    protected Action setMaxAgeAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.makeActions();
    }

    public void createPartControl(Composite parent) {
        try {
            this.contributeToActionBars();
            this.awtComposite = new Composite(parent, 0x1000000);
            this.frame = SWT_AWT.new_Frame((Composite)this.awtComposite);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JApplet applet = new JApplet();
                        applet.setFocusCycleRoot(false);
                        MemoryUsageView.this.frame.add(applet);
                        Container contentPane = applet.getRootPane().getContentPane();
                        panel = new JLChartMemoryUsage();
                        contentPane.add(panel);
                        MemoryUsageView.this.prefs = Activator.getDefault().getPluginPreferences();
                        MemoryUsageView.this.showLegend = MemoryUsageView.this.prefs.getBoolean("muShowLegendPreference");
                        panel.setShowLegend(MemoryUsageView.this.showLegend);
                        MemoryUsageView.this.showMax = MemoryUsageView.this.prefs.getBoolean("muShowMaxPreference");
                        panel.setShowMax(MemoryUsageView.this.showMax);
                        MemoryUsageView.this.interval = MemoryUsageView.this.prefs.getInt("muIntervalPreference");
                        panel.setInterval(MemoryUsageView.this.interval);
                        MemoryUsageView.this.interval = panel.getInterval();
                        MemoryUsageView.this.maxAge = MemoryUsageView.this.prefs.getInt("muMaxAgePreference");
                        panel.setMaxAge(MemoryUsageView.this.maxAge);
                        MemoryUsageView.this.maxAge = panel.getMaxAge();
                        panel.start();
                    }
                    catch (Throwable t) {
                        SWTUtils.errMsgAsync("Unable to create MemoryUsageView:\n" + t + "\n" + t.getMessage());
                        t.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable t) {
            SWTUtils.errMsgAsync("Unable to create MemoryUsageView:\n" + t + "\n" + t.getMessage());
            t.printStackTrace();
        }
    }

    public void setFocus() {
        if (this.awtComposite != null) {
            this.awtComposite.setFocus();
        }
    }

    public void dispose() {
        if (panel != null) {
            panel.stop();
        }
        if (this.frame != null) {
            if (panel != null) {
                this.frame.remove(panel);
            }
            this.frame = null;
        }
        panel = null;
        if (this.awtComposite != null && !this.awtComposite.isDisposed()) {
            this.awtComposite.dispose();
            this.awtComposite = null;
        }
        super.dispose();
    }

    protected void makeActions() {
        this.showMaxAction = new Action(){

            public void run() {
                if (panel != null) {
                    panel.toggleMax();
                }
            }
        };
        this.showMaxAction.setText("Toggle Max Memory");
        this.showMaxAction.setToolTipText("Toggle showing maxium memory available");
        this.showLegendAction = new Action(){

            public void run() {
                if (panel != null) {
                    MemoryUsageView.this.showLegend = !MemoryUsageView.this.showLegend;
                    panel.setShowLegend(MemoryUsageView.this.showLegend);
                }
            }
        };
        this.showLegendAction.setText("Toggle Legend");
        this.showLegendAction.setToolTipText("Toggle legend.");
        this.setIntervalAction = new Action(){

            public void run() {
                if (panel == null) {
                    return;
                }
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Input", "Enter update interval in ms:", String.valueOf(MemoryUsageView.this.interval), null);
                int rc = dialog.open();
                if (rc == 0) {
                    String stringVal = dialog.getValue();
                    try {
                        int newVal = Integer.parseInt(stringVal);
                        if (panel != null && newVal > 0) {
                            panel.setInterval(newVal);
                            MemoryUsageView.this.interval = panel.getInterval();
                        }
                    }
                    catch (Exception ex) {
                        SWTUtils.excMsgAsync(Display.getCurrent().getActiveShell(), "Invalid value", ex);
                    }
                }
            }
        };
        this.setIntervalAction.setText("Set Interval");
        this.setIntervalAction.setToolTipText("Set the update interval in ms.");
        this.setMaxAgeAction = new Action(){

            public void run() {
                if (panel == null) {
                    return;
                }
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Input", "Enter the maximum age in ms:", String.valueOf(MemoryUsageView.this.maxAge), null);
                int rc = dialog.open();
                if (rc == 0) {
                    String stringVal = dialog.getValue();
                    try {
                        int newVal = Integer.parseInt(stringVal);
                        if (panel != null && newVal > 0) {
                            panel.setMaxAge(newVal);
                            MemoryUsageView.this.maxAge = panel.getMaxAge();
                        }
                    }
                    catch (Exception ex) {
                        SWTUtils.excMsgAsync(Display.getCurrent().getActiveShell(), "Invalid value", ex);
                    }
                }
            }
        };
        this.setMaxAgeAction.setText("Set Max Age");
        this.setMaxAgeAction.setToolTipText("Set the update interval in ms.");
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showLegendAction);
        manager.add((IAction)this.showMaxAction);
        manager.add((IAction)this.setIntervalAction);
        manager.add((IAction)this.setMaxAgeAction);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }
}

